/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates.eglx.jtopen;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.Environment;

public class CommonUtilities {
    public static Function createProxyFunction(Function function) {
        Function proxy = (Function)function.clone();
        proxy.setName(CommonUtilities.createProxyFunctionName(proxy));
        FunctionParameter conn = JavaTemplate.factory.createFunctionParameter();
        conn.setIsNullable(true);
        conn.setParameterKind(ParameterKind.PARM_IN);
        conn.setName("ezeIBMiConn");
        try {
            conn.setType((Type)Environment.getCurrentEnv().find("egl:eglx.jtopen.IBMiConnection"));
        }
        catch (Exception exception) {}
        proxy.addParameter(conn);
        return proxy;
    }

    public static String createProxyFunctionName(Function function) {
        return "eze_" + function.getName() + "_IBMiProxy";
    }

    public static Set<String> getGeneratedHelpers(Context ctx) {
        HashSet generatedHelpers = (HashSet)ctx.getAttribute(ctx.getClass(), "ibmiGeneratedHelpers");
        if (generatedHelpers == null) {
            generatedHelpers = new HashSet();
            ctx.putAttribute(ctx.getClass(), "ibmiGeneratedHelpers", generatedHelpers);
        }
        return generatedHelpers;
    }
}

