/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.debug.core.PreferenceUtil;
import org.eclipse.edt.debug.core.java.filters.FilterStepType;
import org.eclipse.edt.debug.core.java.filters.ITypeFilterCategory;
import org.eclipse.edt.debug.core.java.filters.TypeFilterUtil;
import org.eclipse.edt.debug.internal.ui.java.EGLJavaMessages;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class EGLJavaDebugPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] STEP_COMBO_CHOICES = new String[]{EGLJavaMessages.FilterStepIntoLabel, EGLJavaMessages.FilterStepReturnLabel};
    private Button enableFilters;
    private TableModel[] tableInput;
    private CheckboxTableViewer tableViewer;
    private List<Control> filterControls;

    protected Control createContents(Composite parent) {
        this.filterControls = new ArrayList<Control>();
        Composite composite = this.createComposite(parent, 1);
        Label l = new Label(composite, 64);
        l.setText(EGLJavaMessages.PreferencePageMessage);
        l.setLayoutData((Object)new GridData(768));
        PreferenceLinkArea link = new PreferenceLinkArea(composite, 0, "org.eclipse.jdt.debug.ui.JavaDebugPreferencePage", EGLJavaMessages.JavaPreferencePageLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        link.getControl().setFont(composite.getFont());
        new Label(composite, 64);
        Group group = EGLJavaDebugPreferencePage.createGroup((Composite)composite, (int)1);
        group.setText(EGLJavaMessages.TypeFiltersGroupLabel);
        Composite groupComposite = this.createComposite((Composite)group, 1);
        l = new Label(groupComposite, 64);
        l.setText(EGLJavaMessages.TypeFiltersDescription);
        l.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        link = new PreferenceLinkArea(groupComposite, 0, "org.eclipse.jdt.debug.ui.JavaStepFilterPreferencePage", EGLJavaMessages.JavaFilterPreferencePageLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        link.getControl().setFont(composite.getFont());
        new Label(groupComposite, 64);
        this.enableFilters = new Button(groupComposite, 32);
        this.enableFilters.setText(EGLJavaMessages.TypeFiltersEnableButtonLabel);
        this.enableFilters.setLayoutData((Object)new GridData(768));
        this.enableFilters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLJavaDebugPreferencePage.this.initFilterEnablement();
            }
        });
        this.tableViewer = this.createTableViewer(groupComposite);
        this.filterControls.add((Control)this.tableViewer.getTable());
        l = new Label(groupComposite, 64);
        l.setText(EGLJavaMessages.TypeFilterDescriptionLabel);
        l.setLayoutData((Object)new GridData(768));
        this.filterControls.add((Control)l);
        final Text desc = new Text(groupComposite, 2634);
        GridData gd = new GridData(1808);
        gd.minimumHeight = this.convertHeightInCharsToPixels(2);
        desc.setLayoutData((Object)gd);
        this.filterControls.add((Control)desc);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                String text = "";
                ISelection sel = event.getSelection();
                if (sel instanceof StructuredSelection && (element = ((StructuredSelection)sel).getFirstElement()) instanceof TableModel) {
                    text = ((TableModel)element).category.getDescription();
                }
                desc.setText(text);
            }
        });
        this.initializeValues();
        this.initFilterEnablement();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.edt.debug.ui.eglJavaPrefs");
        return composite;
    }

    private TableModel[] createTableInput() {
        ITypeFilterCategory[] categories = TypeFilterUtil.INSTANCE.getTypeFilterCategories();
        ArrayList<TableModel> items = new ArrayList<TableModel>(categories.length);
        ITypeFilterCategory[] iTypeFilterCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeFilterCategory category = iTypeFilterCategoryArray[n2];
            if (category.isVisible()) {
                items.add(new TableModel(category));
            }
            ++n2;
        }
        return items.toArray(new TableModel[items.size()]);
    }

    private CheckboxTableViewer createTableViewer(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayoutData((Object)new GridData(768));
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)tableComp, (int)2052);
        Table table = viewer.getTable();
        table.setLayoutData((Object)new GridData(768));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn categoryColumn = new TableViewerColumn((TableViewer)viewer, 0);
        categoryColumn.getColumn().setText(EGLJavaMessages.TypeFiltersCategoryColumn);
        categoryColumn.getColumn().setResizable(true);
        categoryColumn.getColumn().setMoveable(false);
        TableViewerColumn stepTypeColumn = new TableViewerColumn((TableViewer)viewer, 0);
        stepTypeColumn.getColumn().setText(EGLJavaMessages.TypeFiltersBehaviorColumn);
        stepTypeColumn.getColumn().setResizable(true);
        stepTypeColumn.getColumn().setMoveable(false);
        stepTypeColumn.setEditingSupport((org.eclipse.jface.viewers.EditingSupport)new EditingSupport((TableViewer)viewer));
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
        viewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        layout.setColumnData((Widget)categoryColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, true));
        layout.setColumnData((Widget)stepTypeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, true));
        return viewer;
    }

    private void initFilterEnablement() {
        boolean state = this.enableFilters.getSelection();
        for (Control c : this.filterControls) {
            c.setEnabled(state);
        }
    }

    protected void initializeValues() {
        super.initializeValues();
        this.enableFilters.setSelection(PreferenceUtil.getBoolean((String)"org.eclipse.edt.debug.core.typeFiltersEnabled", (boolean)true));
        this.tableInput = this.createTableInput();
        this.tableViewer.setInput((Object)this.tableInput);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.enableFilters.setSelection(PreferenceUtil.getDefaultBoolean((String)"org.eclipse.edt.debug.core.typeFiltersEnabled", (boolean)true));
        TableModel[] tableModelArray = this.tableInput;
        int n = this.tableInput.length;
        int n2 = 0;
        while (n2 < n) {
            TableModel m = tableModelArray[n2];
            m.applyDefault();
            ++n2;
        }
        this.tableViewer.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        PreferenceUtil.setBoolean((String)"org.eclipse.edt.debug.core.typeFiltersEnabled", (boolean)this.enableFilters.getSelection());
        TableModel[] tableModelArray = this.tableInput;
        int n = this.tableInput.length;
        int n2 = 0;
        while (n2 < n) {
            TableModel m = tableModelArray[n2];
            m.save();
            ++n2;
        }
        StringBuilder enablementBuf = new StringBuilder(100);
        StringBuilder stepTypeBuf = new StringBuilder(100);
        ITypeFilterCategory[] iTypeFilterCategoryArray = TypeFilterUtil.INSTANCE.getTypeFilterCategories();
        int n3 = iTypeFilterCategoryArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ITypeFilterCategory category = iTypeFilterCategoryArray[n4];
            if (enablementBuf.length() > 0) {
                enablementBuf.append(',');
            }
            enablementBuf.append(category.getId());
            enablementBuf.append('=');
            enablementBuf.append(Boolean.toString(category.isEnabled()));
            if (stepTypeBuf.length() > 0) {
                stepTypeBuf.append(',');
            }
            stepTypeBuf.append(category.getId());
            stepTypeBuf.append('=');
            stepTypeBuf.append(category.getStepType(null).toString());
            ++n4;
        }
        PreferenceUtil.setString((String)"org.eclipse.edt.debug.core.typeFilterEnablement", (String)enablementBuf.toString());
        PreferenceUtil.setString((String)"org.eclipse.edt.debug.core.typeFilterStepTypes", (String)stepTypeBuf.toString());
        PreferenceUtil.savePreferences();
        return super.performOk();
    }

    private static class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            TableModel model = (TableModel)event.getElement();
            model.enabled = event.getChecked();
        }
    }

    private static class CheckStateProvider
    implements ICheckStateProvider {
        private CheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            return ((TableModel)element).enabled;
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    private static class EditingSupport
    extends org.eclipse.jface.viewers.EditingSupport {
        private ComboBoxCellEditor cellEditor;

        public EditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new ComboBoxCellEditor((Composite)viewer.getTable(), STEP_COMBO_CHOICES);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            switch (((TableModel)element).type) {
                default: {
                    return 0;
                }
                case STEP_RETURN: 
            }
            return 1;
        }

        protected void setValue(Object element, Object value) {
            switch ((Integer)value) {
                default: {
                    ((TableModel)element).type = FilterStepType.STEP_INTO;
                    break;
                }
                case 1: {
                    ((TableModel)element).type = FilterStepType.STEP_RETURN;
                }
            }
            this.getViewer().update(element, null);
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            TableModel model = (TableModel)element;
            switch (columnIndex) {
                case 0: {
                    return model.category.getName();
                }
                case 1: {
                    switch (model.type) {
                        case STEP_RETURN: {
                            return EGLJavaMessages.FilterStepReturnLabel;
                        }
                    }
                    return EGLJavaMessages.FilterStepIntoLabel;
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private static class TableModel {
        final ITypeFilterCategory category;
        boolean enabled;
        FilterStepType type;

        public TableModel(ITypeFilterCategory category) {
            this.category = category;
            this.enabled = category.isEnabled();
            this.type = category.getStepType(null);
        }

        void save() {
            this.category.setEnabled(this.enabled);
            this.category.setStepType(this.type);
        }

        void applyDefault() {
            this.enabled = this.category.getDefaultEnablement();
            this.type = this.category.getDefaultStepType();
        }
    }
}

