/*******************************************************************************
 * Copyright © 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.compiler;

import java.util.List;
import java.util.Map;

import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.internal.core.lookup.ExternalTypePartManager;
import org.eclipse.edt.compiler.internal.core.lookup.EnumerationManager;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemLibraryManager;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public interface ISystemEnvironment extends IBindingEnvironment {
	void clearParts();
	Map<String, List<ObjectStore>> getStores();
	IEnvironment getIREnvironment();
	EnumerationManager getEnumerationManager();
	SystemLibraryManager getSystemLibraryManager();
	ExternalTypePartManager getExternalTypePartsManager();
	AnnotationTypeManager getAnnotationTypeManager();
}
