/*******************************************************************************
 * Copyright © 2011, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/*
 * Updated on Tue May 27 10:54:14 EDT 2008
 */
package org.eclipse.edt.compiler.core.ast;

/**
 * Generated by tools/org.eclipse.edt.compiler.core.ast.VisitorGenerator
 */
public interface IASTVisitor {

	boolean visit(AddStatement addStatement);
	void endVisit(AddStatement addStatement);
	
	boolean visit(AnnotationExpression annotationExpression);
	void endVisit(AnnotationExpression annotationExpression);
	
	boolean visit(ArrayAccess arrayAccess);
	void endVisit(ArrayAccess arrayAccess);
	
	boolean visit(ArrayLiteral arrayLiteral);
	void endVisit(ArrayLiteral arrayLiteral);
	
	boolean visit(ArrayType arrayType);
	void endVisit(ArrayType arrayType);
	
	boolean visit(AsExpression asExpression);
	void endVisit(AsExpression asExpression);
	
	boolean visit(Assignment assignment);
	void endVisit(Assignment assignment);
	
	boolean visit(AssignmentStatement assignmentStatement);
	void endVisit(AssignmentStatement assignmentStatement);
	
	boolean visit(BinaryExpression binaryExpression);
	void endVisit(BinaryExpression binaryExpression);
	
	boolean visit(BooleanLiteral booleanLiteral);
	void endVisit(BooleanLiteral booleanLiteral);
	
	boolean visit(BytesLiteral bytesLiteral);
	void endVisit(BytesLiteral bytesLiteral);
	
	boolean visit(CallStatement callStatement);
	void endVisit(CallStatement callStatement);
	
	boolean visit(CallbackTarget callbackTarget);
	void endVisit(CallbackTarget callbackTarget);

	boolean visit(CallReturns callReturns);
	void endVisit(CallReturns callReturns);

	boolean visit(CallSynchronizationValues callSync);
	void endVisit(CallSynchronizationValues callsync);

	boolean visit(CaseStatement caseStatement);
	void endVisit(CaseStatement caseStatement);
	
	boolean visit(CharLiteral charLiteral);
	void endVisit(CharLiteral charLiteral);
	
	boolean visit(ClassDataDeclaration classDataDeclaration);
	void endVisit(ClassDataDeclaration classDataDeclaration);
	
	boolean visit(CloseStatement closeStatement);
	void endVisit(CloseStatement closeStatement);
	
	boolean visit(ConstantFormField constantFormField);
	void endVisit(ConstantFormField constantFormField);
	
	boolean visit(Constructor constructor);
	void endVisit(Constructor constructor);
	
	boolean visit(ContinueStatement continueStatement);
	void endVisit(ContinueStatement continueStatement);
	
	boolean visit(ConverseStatement converseStatement);
	void endVisit(ConverseStatement converseStatement);
	
	boolean visit(DataItem dataItem);
	void endVisit(DataItem dataItem);
	
	boolean visit(DataTable dataTable);
	void endVisit(DataTable dataTable);
	
	boolean visit(DBCharLiteral dBCharLiteral);
	void endVisit(DBCharLiteral dBCharLiteral);
	
	boolean visit(DecimalLiteral decimalLiteral);
	void endVisit(DecimalLiteral decimalLiteral);
	
	boolean visit(Delegate delegate);
	void endVisit(Delegate delegate);
	
	boolean visit(DeleteStatement deleteStatement);
	void endVisit(DeleteStatement deleteStatement);
	
	boolean visit(DisplayStatement displayStatement);
	void endVisit(DisplayStatement displayStatement);
	
	boolean visit(EGLClass EGLClass);
	void endVisit(EGLClass EGLClass);

	boolean visit(ElseBlock elseBlock);
	void endVisit(ElseBlock elseBlock);
	
	boolean visit(EmptyStatement emptyStatement);
	void endVisit(EmptyStatement emptyStatement);
	
	boolean visit(Enumeration enumeration);
	void endVisit(Enumeration enumeration);
	
	boolean visit(EnumerationField enumerationField);
	void endVisit(EnumerationField enumerationField);
	
	boolean visit(ExecuteStatement executeStatement);
	void endVisit(ExecuteStatement executeStatement);
	
	boolean visit(ExitStatement exitStatement);
	void endVisit(ExitStatement exitStatement);
	
	boolean visit(ExternalType externalType);
	void endVisit(ExternalType externalType);
	
	boolean visit(FieldAccess fieldAccess);
	void endVisit(FieldAccess fieldAccess);
	
	boolean visit(File file);
	void endVisit(File file);
	
	boolean visit(FloatLiteral floatLiteral);
	void endVisit(FloatLiteral floatLiteral);
	
	boolean visit(ForEachStatement forEachStatement);
	void endVisit(ForEachStatement forEachStatement);
	
	boolean visit(ForExpressionClause forExpressionClause);
	void endVisit(ForExpressionClause forExpressionClause);
	
	boolean visit(FormGroup formGroup);
	void endVisit(FormGroup formGroup);
	
	boolean visit(ForStatement forStatement);
	void endVisit(ForStatement forStatement);
	
	boolean visit(ForUpdateClause forUpdateClause);
	void endVisit(ForUpdateClause forUpdateClause);
	
	boolean visit(ForwardStatement forwardStatement);
	void endVisit(ForwardStatement forwardStatement);
	
	boolean visit(FreeSQLStatement freeSQLStatement);
	void endVisit(FreeSQLStatement freeSQLStatement);
	
	boolean visit(FromExpressionClause fromExpressionClause);
	void endVisit(FromExpressionClause fromExpressionClause);
	
	boolean visit(FromOrToExpressionClause fromOrToExpressionClause);
	void endVisit(FromOrToExpressionClause fromOrToExpressionClause);
	
	boolean visit(FunctionDataDeclaration functionDataDeclaration);
	void endVisit(FunctionDataDeclaration functionDataDeclaration);
	
	boolean visit(FunctionInvocation functionInvocation);
	void endVisit(FunctionInvocation functionInvocation);
	
	boolean visit(FunctionInvocationStatement functionInvocationStatement);
	void endVisit(FunctionInvocationStatement functionInvocationStatement);
	
	boolean visit(FunctionParameter functionParameter);
	void endVisit(FunctionParameter functionParameter);
	
	boolean visit(GetByKeyStatement getByKeyStatement);
	void endVisit(GetByKeyStatement getByKeyStatement);
	
	boolean visit(GetByPositionStatement getByPositionStatement);
	void endVisit(GetByPositionStatement getByPositionStatement);
	
	boolean visit(GotoStatement gotoStatement);
	void endVisit(GotoStatement gotoStatement);
	
	boolean visit(Handler handler);
	void endVisit(Handler handler);
	
	boolean visit(HexLiteral hexLiteral);
	void endVisit(HexLiteral hexLiteral);
	
	boolean visit(ImportDeclaration importDeclaration);
	void endVisit(ImportDeclaration importDeclaration);
	
	boolean visit(IfStatement ifStatement);
	void endVisit(IfStatement ifStatement);
	
	boolean visit(InExpression inExpression);
	void endVisit(InExpression inExpression);
	
	boolean visit(InlineDLIStatement inlineDLIStatement);
	void endVisit(InlineDLIStatement inlineDLIStatement);
	
	boolean visit(InlineSQLStatement inlineSQLStatement);
	void endVisit(InlineSQLStatement inlineSQLStatement);
	
	boolean visit(IntegerLiteral integerLiteral);
	void endVisit(IntegerLiteral integerLiteral);
	
	boolean visit(Interface interfaceNode);
	void endVisit(Interface interfaceNode);
	
	boolean visit(IntoClause intoClause);
	void endVisit(IntoClause intoClause);
	
	boolean visit(IsAExpression isAExpression);
	void endVisit(IsAExpression isAExpression);
	
	boolean visit(IsNotExpression isNotExpression);
	void endVisit(IsNotExpression isNotExpression);
	
	boolean visit(LabelStatement labelStatement);
	void endVisit(LabelStatement labelStatement);
	
	boolean visit(Library library);
	void endVisit(Library library);
	
	boolean visit(LikeMatchesExpression likeMatchesExpression);
	void endVisit(LikeMatchesExpression likeMatchesExpression);
	
	boolean visit(MBCharLiteral mBCharLiteral);
	void endVisit(MBCharLiteral mBCharLiteral);
	
	boolean visit(MoveStatement moveStatement);
	void endVisit(MoveStatement moveStatement);
	
	boolean visit(NameType nameType);
	void endVisit(NameType nameType);
	
	boolean visit(NestedForm nestedForm);
	void endVisit(NestedForm nestedForm);
	
	boolean visit(NestedFunction nestedFunction);
	void endVisit(NestedFunction nestedFunction);
	
	boolean visit(NewExpression newExpression);
	void endVisit(NewExpression newExpression);
	
	boolean visit(NullLiteral nullLiteral);
	void endVisit(NullLiteral nullLiteral);
	
	boolean visit(NullableType nullableType);
	void endVisit(NullableType nullableType);
	
	boolean visit(NoCursorClause noCursorClause);
	void endVisit(NoCursorClause noCursorClause);
	
	boolean visit(ObjectExpression objectExpression);
	void endVisit(ObjectExpression objectExpression);
	
	boolean visit(ObjectExpressionEntry objectExpressionEntry);
	void endVisit(ObjectExpressionEntry objectExpressionEntry);
	
	boolean visit(OnEventBlock onEventBlock);
	void endVisit(OnEventBlock onEventBlock);
	
	boolean visit(OnExceptionBlock onExceptionBlock);
	void endVisit(OnExceptionBlock onExceptionBlock);
	
	boolean visit(OpenStatement openStatement);
	void endVisit(OpenStatement openStatement);
	
	boolean visit(OpenUIStatement openUIStatement);
	void endVisit(OpenUIStatement openUIStatement);
	
	boolean visit(OtherwiseClause otherwiseClause);
	void endVisit(OtherwiseClause otherwiseClause);
	
	boolean visit(PackageDeclaration packageDeclaration);
	void endVisit(PackageDeclaration packageDeclaration);
	
	boolean visit(ParenthesizedExpression parenthesizedExpression);
	void endVisit(ParenthesizedExpression parenthesizedExpression);
	
	boolean visit(PassingClause passingClause);
	void endVisit(PassingClause passingClause);
	
	boolean visit(PrepareStatement prepareStatement);
	void endVisit(PrepareStatement prepareStatement);
	
	boolean visit(PrimitiveType primitiveType);
	void endVisit(PrimitiveType primitiveType);
	
	boolean visit(PrintStatement printStatement);
	void endVisit(PrintStatement printStatement);
	
	boolean visit(Program program);
	void endVisit(Program program);
	
	boolean visit(ProgramParameter programParameter);
	void endVisit(ProgramParameter programParameter);
	
	boolean visit(Record record);
	void endVisit(Record record);
	
	boolean visit(ReplaceStatement replaceStatement);
	void endVisit(ReplaceStatement replaceStatement);
	
	boolean visit(ReturnsDeclaration returnsDeclaration);
	void endVisit(ReturnsDeclaration returnsDeclaration);
	
	boolean visit(ReturningToInvocationTargetClause returningToInvocationTargetClause);
	void endVisit(ReturningToInvocationTargetClause returningToInvocationTargetClause);
	
	boolean visit(ReturningToNameClause returningToNameClause);
	void endVisit(ReturningToNameClause returningToNameClause);
	
	boolean visit(ReturnStatement returnStatement);
	void endVisit(ReturnStatement returnStatement);
	
	boolean visit(Service service);
	void endVisit(Service service);
	
	boolean visit(ServiceReference serviceReference);
	void endVisit(ServiceReference serviceReference);
	
	boolean visit(SetStatement setStatement);
	void endVisit(SetStatement setStatement);
	
	boolean visit(SetValuesExpression setValuesExpression);
	void endVisit(SetValuesExpression setValuesExpression);
	
	boolean visit(SetValuesStatement setValuesStatement);
	void endVisit(SetValuesStatement setValuesStatement);
	
	boolean visit(SettingsBlock settingsBlock);
	void endVisit(SettingsBlock settingsBlock);
	
	boolean visit(ShowStatement showStatement);
	void endVisit(ShowStatement showStatement);
	
	boolean visit(SimpleName simpleName);
	void endVisit(SimpleName simpleName);
	
	boolean visit(SingleRowClause singleRowClause);
	void endVisit(SingleRowClause singleRowClause);
	
	boolean visit(StringLiteral stringLiteral);
	void endVisit(StringLiteral stringLiteral);
	
	boolean visit(StructureItem structureItem);
	void endVisit(StructureItem structureItem);
	
	boolean visit(SQLLiteral sQLLiteral);
	void endVisit(SQLLiteral sQLLiteral);
	
	boolean visit(SubstringAccess substringAccess);
	void endVisit(SubstringAccess substringAccess);
	
	boolean visit(SuperExpression superExpression);
	void endVisit(SuperExpression superExpression);
	
	boolean visit(TernaryExpression ternaryExpression);
	void endVisit(TernaryExpression ternaryExpression);
	
	boolean visit(ThisExpression thisExpression);
	void endVisit(ThisExpression thisExpression);
	
	boolean visit(ThrowStatement throwStatement);
	void endVisit(ThrowStatement throwStatement);
	
	boolean visit(TopLevelForm topLevelForm);
	void endVisit(TopLevelForm topLevelForm);
	
	boolean visit(TopLevelFunction topLevelFunction);
	void endVisit(TopLevelFunction topLevelFunction);
	
	boolean visit(TransferStatement transferStatement);
	void endVisit(TransferStatement transferStatement);
	
	boolean visit(TryStatement tryStatement);
	void endVisit(TryStatement tryStatement);
	
	boolean visit(TypeLiteralExpression typeLiteralExpression);
	void endVisit(TypeLiteralExpression typeLiteralExpression);
	
	boolean visit(QualifiedName qualifiedName);
	void endVisit(QualifiedName qualifiedName);
	
	boolean visit(UnaryExpression unaryExpression);
	void endVisit(UnaryExpression unaryExpression);
	
	boolean visit(UsingClause usingClause);
	void endVisit(UsingClause usingClause);
	
	boolean visit(UsingKeysClause usingKeysClause);
	void endVisit(UsingKeysClause usingKeysClause);
	
	boolean visit(UseStatement useStatement);
	void endVisit(UseStatement useStatement);
	
	boolean visit(UsingPCBClause usingPCBClause);
	void endVisit(UsingPCBClause usingPCBClause);
	
	boolean visit(VariableFormField variableFormField);
	void endVisit(VariableFormField variableFormField);
	
	boolean visit(WhenClause whenClause);
	void endVisit(WhenClause whenClause);
	
	boolean visit(WhileStatement whileStatement);
	void endVisit(WhileStatement whileStatement);
	
	boolean visit(WithExpressionClause withIDClause);
	void endVisit(WithExpressionClause withIDClause);

	boolean visit(WithIDClause withIDClause);
	void endVisit(WithIDClause withIDClause);
	
	boolean visit(WithInlineDLIClause withInlineDLIClause);
	void endVisit(WithInlineDLIClause withInlineDLIClause);
	
	boolean visit(WithInlineSQLClause withInlineSQLClause);
	void endVisit(WithInlineSQLClause withInlineSQLClause);
}
