/*******************************************************************************
 * Copyright © 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/* The following code was generated by JFlex 1.4.1 on 7/27/12 9:25 AM */

package org.eclipse.edt.ide.core.internal.errors;
import java.io.IOException;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 7/27/12 9:25 AM from the specification file
 * <tt>error.flex</tt>
 */
public class ErrorLexer implements IErrorLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int DLI = 6;
  public static final int DLI_QUOTED_ID = 7;
  public static final int SQLDELIMITEDID = 3;
  public static final int STRING = 1;
  public static final int BLOCKCOMMENT = 5;
  public static final int DLI_DBL_QUOTED_ID = 8;
  public static final int SQL = 2;
  public static final int YYINITIAL = 0;
  public static final int SQLSTRING = 4;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\3\1\1\1\0\1\3\1\2\16\5\4\0\1\3\1\55"+
    "\1\50\1\51\1\4\1\67\1\62\1\76\1\53\1\54\1\22\1\13"+
    "\1\56\1\23\1\11\1\21\1\16\5\6\1\47\3\6\1\60\1\57"+
    "\1\64\1\61\1\65\1\66\1\73\1\24\1\25\1\20\1\33\1\12"+
    "\1\14\1\40\1\43\1\7\1\4\1\46\1\30\1\36\1\34\1\27"+
    "\1\37\1\45\1\41\1\26\1\32\1\31\1\42\1\44\1\17\1\35"+
    "\1\4\1\70\1\75\1\71\1\0\1\4\1\0\1\24\1\77\1\20"+
    "\1\33\1\12\1\15\1\40\1\43\1\10\1\4\1\46\1\30\1\36"+
    "\1\100\1\27\1\37\1\45\1\101\1\26\1\102\1\31\1\42\1\44"+
    "\1\17\1\35\1\4\1\52\1\63\1\72\1\74\41\5\2\0\4\4"+
    "\4\0\1\4\2\0\1\5\7\0\1\4\4\0\1\4\5\0\27\4"+
    "\1\0\37\4\1\0\u013f\4\31\0\162\4\4\0\14\4\16\0\5\4"+
    "\11\0\1\4\21\0\130\5\5\0\23\5\12\0\1\4\13\0\1\4"+
    "\1\0\3\4\1\0\1\4\1\0\24\4\1\0\54\4\1\0\46\4"+
    "\1\0\5\4\4\0\202\4\1\0\4\5\3\0\105\4\1\0\46\4"+
    "\2\0\2\4\6\0\20\4\41\0\46\4\2\0\1\4\7\0\47\4"+
    "\11\0\21\5\1\0\27\5\1\0\3\5\1\0\1\5\1\0\2\5"+
    "\1\0\1\5\13\0\33\4\5\0\3\4\15\0\4\5\14\0\6\5"+
    "\13\0\32\4\5\0\13\4\16\5\7\0\12\5\4\0\2\4\1\5"+
    "\143\4\1\0\1\4\10\5\1\0\6\5\2\4\2\5\1\0\4\5"+
    "\2\4\12\5\3\4\2\0\1\4\17\0\1\5\1\4\1\5\36\4"+
    "\33\5\2\0\3\4\60\0\46\4\13\5\1\4\u014f\0\3\5\66\4"+
    "\2\0\1\5\1\4\20\5\2\0\1\4\4\5\3\0\12\4\2\5"+
    "\2\0\12\5\21\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\1\4\3\0\4\4\2\0\1\5\1\4\7\5"+
    "\2\0\2\5\2\0\3\5\11\0\1\5\4\0\2\4\1\0\3\4"+
    "\2\5\2\0\12\5\4\4\15\0\3\5\1\0\6\4\4\0\2\4"+
    "\2\0\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4"+
    "\2\0\1\5\1\0\5\5\4\0\2\5\2\0\3\5\13\0\4\4"+
    "\1\0\1\4\7\0\14\5\3\4\14\0\3\5\1\0\11\4\1\0"+
    "\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0"+
    "\1\5\1\4\10\5\1\0\3\5\1\0\3\5\2\0\1\4\17\0"+
    "\2\4\2\5\2\0\12\5\1\0\1\4\17\0\3\5\1\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4"+
    "\2\0\1\5\1\4\6\5\3\0\2\5\2\0\3\5\10\0\2\5"+
    "\4\0\2\4\1\0\3\4\4\0\12\5\1\0\1\4\20\0\1\5"+
    "\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4\1\0"+
    "\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0\10\4\1\0"+
    "\3\4\4\0\5\5\3\0\3\5\1\0\4\5\11\0\1\5\17\0"+
    "\11\5\11\0\1\4\7\0\3\5\1\0\10\4\1\0\3\4\1\0"+
    "\27\4\1\0\12\4\1\0\5\4\4\0\7\5\1\0\3\5\1\0"+
    "\4\5\7\0\2\5\11\0\2\4\4\0\12\5\22\0\2\5\1\0"+
    "\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4\2\0"+
    "\1\5\1\4\7\5\1\0\3\5\1\0\4\5\7\0\2\5\7\0"+
    "\1\4\1\0\2\4\4\0\12\5\22\0\2\5\1\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\20\4\4\0\6\5\2\0\3\5\1\0"+
    "\4\5\11\0\1\5\10\0\2\4\4\0\12\5\22\0\2\5\1\0"+
    "\22\4\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4\3\0"+
    "\1\5\4\0\6\5\1\0\1\5\1\0\10\5\22\0\2\5\15\0"+
    "\60\4\1\5\2\4\7\5\4\0\10\4\10\5\1\0\12\5\47\0"+
    "\2\4\1\0\1\4\2\0\2\4\1\0\1\4\2\0\1\4\6\0"+
    "\4\4\1\0\7\4\1\0\3\4\1\0\1\4\1\0\1\4\2\0"+
    "\2\4\1\0\4\4\1\5\2\4\6\5\1\0\2\5\1\4\2\0"+
    "\5\4\1\0\1\4\1\0\6\5\2\0\12\5\2\0\2\4\42\0"+
    "\1\4\27\0\2\5\6\0\12\5\13\0\1\5\1\0\1\5\1\0"+
    "\1\5\4\0\2\5\10\4\1\0\42\4\6\0\24\5\1\0\2\5"+
    "\4\4\4\0\10\5\1\0\44\5\11\0\1\5\71\0\42\4\1\0"+
    "\5\4\1\0\2\4\1\0\7\5\3\0\4\5\6\0\12\5\6\0"+
    "\6\4\4\5\106\0\46\4\12\0\51\4\7\0\132\4\5\0\104\4"+
    "\5\0\122\4\6\0\7\4\1\0\77\4\1\0\1\4\1\0\4\4"+
    "\2\0\7\4\1\0\1\4\1\0\4\4\2\0\47\4\1\0\1\4"+
    "\1\0\4\4\2\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4"+
    "\1\0\1\4\1\0\4\4\2\0\7\4\1\0\7\4\1\0\27\4"+
    "\1\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\47\4"+
    "\1\0\23\4\16\0\11\5\56\0\125\4\14\0\u026c\4\2\0\10\4"+
    "\12\0\32\4\5\0\113\4\3\0\3\4\17\0\15\4\1\0\4\4"+
    "\3\5\13\0\22\4\3\5\13\0\22\4\2\5\14\0\15\4\1\0"+
    "\3\4\1\0\2\5\14\0\64\4\40\5\3\0\1\4\3\0\2\4"+
    "\1\5\2\0\12\5\41\0\3\5\2\0\12\5\6\0\130\4\10\0"+
    "\51\4\1\5\126\0\35\4\3\0\14\5\4\0\14\5\12\0\12\5"+
    "\36\4\2\0\5\4\u038b\0\154\4\224\0\234\4\4\0\132\4\6\0"+
    "\26\4\2\0\6\4\2\0\46\4\2\0\6\4\2\0\10\4\1\0"+
    "\1\4\1\0\1\4\1\0\1\4\1\0\37\4\2\0\65\4\1\0"+
    "\7\4\1\0\1\4\3\0\3\4\1\0\7\4\3\0\4\4\2\0"+
    "\6\4\4\0\15\4\5\0\3\4\1\0\7\4\17\0\4\5\32\0"+
    "\5\5\20\0\2\4\23\0\1\4\13\0\4\5\6\0\6\5\1\0"+
    "\1\4\15\0\1\4\40\0\22\4\36\0\15\5\4\0\1\5\3\0"+
    "\6\5\27\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4\3\0"+
    "\5\4\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4\1\0"+
    "\3\4\1\0\7\4\3\0\3\4\5\0\5\4\26\0\44\4\u0e81\0"+
    "\3\4\31\0\11\4\6\5\1\0\5\4\2\0\5\4\4\0\126\4"+
    "\2\0\2\5\2\0\3\4\1\0\137\4\5\0\50\4\4\0\136\4"+
    "\21\0\30\4\70\0\20\4\u0200\0\u19b6\4\112\0\u51a6\4\132\0\u048d\4"+
    "\u0773\0\u2ba4\4\u215c\0\u012e\4\2\0\73\4\225\0\7\4\14\0\5\4"+
    "\5\0\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4"+
    "\1\0\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4"+
    "\2\0\66\4\50\0\15\4\3\0\20\5\20\0\4\5\17\0\2\4"+
    "\30\0\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5"+
    "\4\0\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4"+
    "\12\0\132\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4"+
    "\3\0\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\1\0\1\2\2\0\2\2\2\0\1\3\1\1"+
    "\1\4\1\5\1\4\1\6\1\4\1\7\1\4\1\5"+
    "\2\4\1\10\1\11\1\12\17\4\1\13\1\3\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\2\2\37\1\40\1\41\4\2\1\42"+
    "\1\43\1\44\1\2\2\45\1\46\1\2\1\47\2\2"+
    "\1\50\1\51\1\52\2\53\1\54\1\55\1\56\1\57"+
    "\1\60\1\0\1\61\1\62\1\63\1\64\1\65\7\4"+
    "\1\66\5\4\1\0\6\4\1\1\1\67\1\70\1\71"+
    "\1\72\1\73\1\4\1\74\5\4\1\75\14\4\1\76"+
    "\5\4\1\77\24\4\2\0\1\100\1\101\1\102\1\103"+
    "\1\104\1\105\1\76\1\106\1\107\1\110\1\111\1\112"+
    "\1\113\1\114\1\115\1\116\1\117\1\120\1\121\1\122"+
    "\1\123\1\2\1\124\1\125\1\126\1\61\1\0\1\127"+
    "\2\4\1\130\10\4\1\131\4\4\1\132\4\4\1\133"+
    "\1\134\5\4\2\1\2\0\1\135\1\4\1\136\1\137"+
    "\1\104\1\130\7\4\1\140\10\4\1\141\7\4\1\142"+
    "\1\4\1\143\2\4\1\144\7\4\1\145\1\4\1\146"+
    "\10\4\1\147\13\4\2\0\1\150\1\151\1\152\1\153"+
    "\1\154\1\2\3\4\1\155\3\4\1\156\3\4\1\157"+
    "\7\4\1\160\4\4\1\161\1\162\1\163\1\164\6\4"+
    "\1\165\15\4\1\166\4\4\1\167\2\4\1\170\2\4"+
    "\1\171\1\4\1\172\6\4\1\173\1\4\1\174\1\4"+
    "\1\175\7\4\1\176\6\4\1\177\1\200\1\4\1\201"+
    "\2\0\1\202\1\4\1\203\11\4\1\204\1\4\1\205"+
    "\1\206\6\4\1\207\2\4\1\210\3\4\1\211\5\4"+
    "\1\212\1\213\11\4\1\214\1\215\2\4\1\216\13\4"+
    "\1\217\13\4\1\220\2\0\1\221\1\222\1\223\2\4"+
    "\1\224\4\4\1\225\16\4\1\226\3\4\1\227\1\230"+
    "\5\4\1\231\3\4\1\232\5\4\1\233\12\4\1\234"+
    "\1\4\1\235\4\4\1\0\3\4\1\236\1\237\3\4"+
    "\1\240\2\4\1\241\1\4\1\242\3\4\1\243\3\4"+
    "\1\244\3\4\1\245\1\246\4\4\1\247\1\250\5\4"+
    "\1\251\1\252\1\253\1\254\1\4\1\255\2\4\1\256"+
    "\1\257\1\260\1\261\1\4\1\0\1\4\1\262\3\4"+
    "\1\263\2\4\1\264\1\4\1\265\1\266\1\267\5\4"+
    "\1\270\1\4\1\271\2\4\1\272\1\273\1\4\1\274"+
    "\1\275\1\276\2\4\1\0\1\277\3\4\1\300\1\301"+
    "\2\4\1\302\1\4\1\303\1\4\1\304\1\4\1\305"+
    "\1\306\1\307\1\4\1\0\1\310\3\4\1\311\4\4"+
    "\1\0\1\4\1\312\1\313\1\314\1\315\1\316\1\4"+
    "\1\0\1\317\1\4\1\0\1\320\1\0\1\321";

  private static int [] zzUnpackAction() {
    int [] result = new int[667];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0367\0\u03aa\0\u03ed"+
    "\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u057f\0\u05c2\0\u0605"+
    "\0\u0648\0\u068b\0\u06ce\0\u0711\0\u0754\0\u0797\0\u07da\0\u081d"+
    "\0\u0860\0\u08a3\0\u08e6\0\u0929\0\u096c\0\u09af\0\u09f2\0\u025b"+
    "\0\u0a35\0\u025b\0\u025b\0\u025b\0\u0a78\0\u025b\0\u025b\0\u0abb"+
    "\0\u0afe\0\u0b41\0\u0b84\0\u0bc7\0\u0c0a\0\u0c4d\0\u0c90\0\u025b"+
    "\0\u025b\0\u025b\0\u025b\0\u025b\0\u0cd3\0\u025b\0\u0d16\0\u025b"+
    "\0\u0d59\0\u025b\0\u0d9c\0\u0ddf\0\u0e22\0\u025b\0\u025b\0\u025b"+
    "\0\u0e65\0\u025b\0\u0ea8\0\u0eeb\0\u0f2e\0\u0f71\0\u0fb4\0\u0ff7"+
    "\0\u025b\0\u025b\0\u025b\0\u025b\0\u103a\0\u0f71\0\u0eeb\0\u025b"+
    "\0\u025b\0\u107d\0\u10c0\0\u025b\0\u025b\0\u02e1\0\u1103\0\u1146"+
    "\0\u1189\0\u11cc\0\u120f\0\u1252\0\u1295\0\u12d8\0\u131b\0\u025b"+
    "\0\u135e\0\u13a1\0\u13e4\0\u1427\0\u146a\0\u14ad\0\u14f0\0\u1533"+
    "\0\u1576\0\u15b9\0\u15fc\0\u163f\0\u1682\0\u16c5\0\u025b\0\u1708"+
    "\0\u025b\0\u025b\0\u174b\0\u02e1\0\u178e\0\u17d1\0\u1814\0\u1857"+
    "\0\u189a\0\u18dd\0\u1920\0\u1963\0\u19a6\0\u19e9\0\u1a2c\0\u1a6f"+
    "\0\u1ab2\0\u1af5\0\u1b38\0\u1b7b\0\u1bbe\0\u1c01\0\u02e1\0\u1c44"+
    "\0\u1c87\0\u1cca\0\u1d0d\0\u1d50\0\u02e1\0\u1d93\0\u1dd6\0\u1e19"+
    "\0\u1e5c\0\u1e9f\0\u1ee2\0\u1f25\0\u1f68\0\u1fab\0\u1fee\0\u2031"+
    "\0\u2074\0\u20b7\0\u20fa\0\u213d\0\u2180\0\u21c3\0\u2206\0\u2249"+
    "\0\u228c\0\u22cf\0\u2312\0\u025b\0\u2355\0\u025b\0\u025b\0\u025b"+
    "\0\u025b\0\u025b\0\u025b\0\u2398\0\u025b\0\u23db\0\u241e\0\u025b"+
    "\0\u025b\0\u025b\0\u025b\0\u025b\0\u025b\0\u025b\0\u025b\0\u025b"+
    "\0\u2461\0\u025b\0\u025b\0\u025b\0\u24a4\0\u24a4\0\u02e1\0\u24e7"+
    "\0\u252a\0\u256d\0\u25b0\0\u25f3\0\u2636\0\u2679\0\u26bc\0\u26ff"+
    "\0\u2742\0\u2785\0\u02e1\0\u27c8\0\u280b\0\u284e\0\u2891\0\u28d4"+
    "\0\u2917\0\u295a\0\u299d\0\u29e0\0\u14ad\0\u2a23\0\u2a66\0\u2aa9"+
    "\0\u2aec\0\u2b2f\0\u2b72\0\u025b\0\u2bb5\0\u16c5\0\u2bf8\0\u025b"+
    "\0\u2c3b\0\u02e1\0\u02e1\0\u02e1\0\u02e1\0\u2c7e\0\u2cc1\0\u2d04"+
    "\0\u2d47\0\u2d8a\0\u2dcd\0\u2e10\0\u02e1\0\u2e53\0\u2e96\0\u2ed9"+
    "\0\u2f1c\0\u2f5f\0\u2fa2\0\u2fe5\0\u3028\0\u02e1\0\u306b\0\u30ae"+
    "\0\u30f1\0\u3134\0\u3177\0\u31ba\0\u31fd\0\u02e1\0\u3240\0\u02e1"+
    "\0\u3283\0\u32c6\0\u02e1\0\u3309\0\u334c\0\u338f\0\u33d2\0\u3415"+
    "\0\u3458\0\u349b\0\u02e1\0\u34de\0\u02e1\0\u3521\0\u3564\0\u35a7"+
    "\0\u35ea\0\u362d\0\u3670\0\u36b3\0\u36f6\0\u02e1\0\u3739\0\u377c"+
    "\0\u37bf\0\u3802\0\u3845\0\u3888\0\u38cb\0\u390e\0\u3951\0\u3994"+
    "\0\u39d7\0\u3a1a\0\u3a5d\0\u025b\0\u025b\0\u025b\0\u3aa0\0\u025b"+
    "\0\u3ae3\0\u3b26\0\u3b69\0\u3bac\0\u02e1\0\u3bef\0\u3c32\0\u3c75"+
    "\0\u02e1\0\u3cb8\0\u3cfb\0\u3d3e\0\u02e1\0\u3d81\0\u3dc4\0\u3e07"+
    "\0\u3e4a\0\u3e8d\0\u3ed0\0\u3f13\0\u3f56\0\u3f99\0\u3fdc\0\u401f"+
    "\0\u4062\0\u02e1\0\u025b\0\u02e1\0\u02e1\0\u40a5\0\u40e8\0\u412b"+
    "\0\u416e\0\u41b1\0\u41f4\0\u02e1\0\u4237\0\u427a\0\u42bd\0\u4300"+
    "\0\u4343\0\u4386\0\u43c9\0\u440c\0\u444f\0\u4492\0\u44d5\0\u4518"+
    "\0\u455b\0\u02e1\0\u459e\0\u45e1\0\u4624\0\u4667\0\u46aa\0\u46ed"+
    "\0\u4730\0\u02e1\0\u4773\0\u47b6\0\u02e1\0\u47f9\0\u02e1\0\u483c"+
    "\0\u487f\0\u48c2\0\u4905\0\u4948\0\u498b\0\u02e1\0\u49ce\0\u02e1"+
    "\0\u4a11\0\u02e1\0\u4a54\0\u4a97\0\u4ada\0\u4b1d\0\u4b60\0\u4ba3"+
    "\0\u4be6\0\u02e1\0\u4c29\0\u4c6c\0\u4caf\0\u4cf2\0\u4d35\0\u4d78"+
    "\0\u02e1\0\u4dbb\0\u4dfe\0\u02e1\0\u4e41\0\u4e84\0\u025b\0\u4ec7"+
    "\0\u02e1\0\u4f0a\0\u4f4d\0\u4f90\0\u4fd3\0\u5016\0\u5059\0\u509c"+
    "\0\u50df\0\u5122\0\u02e1\0\u5165\0\u02e1\0\u02e1\0\u51a8\0\u51eb"+
    "\0\u522e\0\u5271\0\u52b4\0\u52f7\0\u533a\0\u537d\0\u53c0\0\u02e1"+
    "\0\u5403\0\u5446\0\u5489\0\u02e1\0\u54cc\0\u550f\0\u5552\0\u5595"+
    "\0\u55d8\0\u02e1\0\u02e1\0\u561b\0\u565e\0\u56a1\0\u56e4\0\u5727"+
    "\0\u576a\0\u57ad\0\u57f0\0\u5833\0\u02e1\0\u5876\0\u58b9\0\u58fc"+
    "\0\u02e1\0\u593f\0\u5982\0\u59c5\0\u5a08\0\u5a4b\0\u5a8e\0\u5ad1"+
    "\0\u5b14\0\u5b57\0\u5b9a\0\u5bdd\0\u02e1\0\u5c20\0\u5c63\0\u5ca6"+
    "\0\u5ce9\0\u5d2c\0\u5d6f\0\u5db2\0\u5df5\0\u5e38\0\u5e7b\0\u5ebe"+
    "\0\u02e1\0\u5f01\0\u5f44\0\u025b\0\u025b\0\u02e1\0\u5f87\0\u5fca"+
    "\0\u02e1\0\u600d\0\u6050\0\u6093\0\u60d6\0\u02e1\0\u6119\0\u615c"+
    "\0\u619f\0\u61e2\0\u6225\0\u6268\0\u62ab\0\u62ee\0\u6331\0\u6374"+
    "\0\u63b7\0\u63fa\0\u643d\0\u6480\0\u02e1\0\u64c3\0\u6506\0\u6549"+
    "\0\u02e1\0\u02e1\0\u658c\0\u65cf\0\u6612\0\u6655\0\u6698\0\u02e1"+
    "\0\u66db\0\u671e\0\u6761\0\u02e1\0\u67a4\0\u67e7\0\u682a\0\u686d"+
    "\0\u68b0\0\u02e1\0\u68f3\0\u6936\0\u6979\0\u69bc\0\u69ff\0\u6a42"+
    "\0\u6a85\0\u6ac8\0\u6b0b\0\u6b4e\0\u02e1\0\u6b91\0\u6bd4\0\u6c17"+
    "\0\u6c5a\0\u6c9d\0\u6ce0\0\u6d23\0\u6d66\0\u6da9\0\u6dec\0\u02e1"+
    "\0\u02e1\0\u6e2f\0\u6e72\0\u6eb5\0\u02e1\0\u6ef8\0\u6f3b\0\u02e1"+
    "\0\u6f7e\0\u02e1\0\u6fc1\0\u7004\0\u7047\0\u02e1\0\u708a\0\u70cd"+
    "\0\u7110\0\u02e1\0\u7153\0\u7196\0\u71d9\0\u02e1\0\u02e1\0\u721c"+
    "\0\u725f\0\u72a2\0\u72e5\0\u02e1\0\u02e1\0\u7328\0\u736b\0\u73ae"+
    "\0\u73f1\0\u7434\0\u02e1\0\u02e1\0\u02e1\0\u02e1\0\u7477\0\u02e1"+
    "\0\u74ba\0\u74fd\0\u02e1\0\u02e1\0\u02e1\0\u02e1\0\u7540\0\u7583"+
    "\0\u75c6\0\u02e1\0\u7609\0\u764c\0\u768f\0\u02e1\0\u76d2\0\u7715"+
    "\0\u02e1\0\u7758\0\u02e1\0\u02e1\0\u02e1\0\u779b\0\u77de\0\u7821"+
    "\0\u7864\0\u78a7\0\u02e1\0\u78ea\0\u02e1\0\u792d\0\u7970\0\u02e1"+
    "\0\u02e1\0\u79b3\0\u02e1\0\u02e1\0\u02e1\0\u79f6\0\u7a39\0\u7a7c"+
    "\0\u02e1\0\u7abf\0\u7b02\0\u7b45\0\u02e1\0\u02e1\0\u7b88\0\u7bcb"+
    "\0\u02e1\0\u7c0e\0\u02e1\0\u7c51\0\u02e1\0\u7c94\0\u02e1\0\u02e1"+
    "\0\u02e1\0\u7cd7\0\u7d1a\0\u02e1\0\u7d5d\0\u7da0\0\u7de3\0\u02e1"+
    "\0\u7e26\0\u7e69\0\u7eac\0\u7eef\0\u7f32\0\u7f75\0\u02e1\0\u02e1"+
    "\0\u02e1\0\u02e1\0\u02e1\0\u7fb8\0\u7ffb\0\u02e1\0\u803e\0\u8081"+
    "\0\u02e1\0\u80c4\0\u025b";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[667];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\12\3\13\1\14\1\12\1\15\2\16\1\17\1\20"+
    "\1\21\2\22\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\14\1\42\1\43\1\44\1\45\1\14\1\46"+
    "\1\47\2\14\1\15\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\73\1\74"+
    "\2\12\1\32\1\41\1\45\1\37\1\75\1\76\1\77"+
    "\45\75\1\100\24\75\1\101\5\75\1\102\3\103\1\104"+
    "\2\102\2\104\1\102\1\104\1\102\2\104\1\102\2\104"+
    "\2\102\1\105\23\104\1\102\1\106\21\102\1\107\3\102"+
    "\1\110\4\104\1\111\1\112\1\113\45\111\1\114\32\111"+
    "\1\115\1\112\1\113\73\115\1\116\4\115\22\117\1\120"+
    "\60\117\1\102\3\103\1\104\2\102\2\104\1\102\1\104"+
    "\1\102\2\104\1\102\2\104\3\102\23\104\1\102\1\121"+
    "\21\102\1\122\3\102\1\123\4\104\1\115\1\124\1\125"+
    "\73\115\1\126\4\115\1\111\1\124\1\125\45\111\1\127"+
    "\32\111\104\0\3\13\103\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\6\0\1\15\1\130"+
    "\1\131\1\132\1\133\1\0\1\134\1\135\1\15\30\0"+
    "\1\15\37\0\5\14\1\0\1\14\1\0\2\136\3\14"+
    "\3\0\2\14\1\137\5\14\1\140\1\14\1\141\11\14"+
    "\27\0\1\14\1\140\2\14\6\0\1\132\7\0\1\132"+
    "\30\0\1\132\37\0\5\14\1\0\1\14\1\0\3\14"+
    "\1\142\1\14\3\0\2\14\1\143\1\14\1\144\3\14"+
    "\1\145\1\14\1\146\1\14\1\147\7\14\27\0\1\14"+
    "\1\145\2\14\61\0\1\150\25\0\3\14\2\151\1\0"+
    "\1\14\1\0\5\14\3\0\3\14\1\152\1\153\1\154"+
    "\7\14\1\155\6\14\27\0\2\14\1\155\1\14\6\0"+
    "\1\15\1\130\1\131\1\132\1\133\1\0\1\134\1\135"+
    "\1\15\1\156\27\0\1\15\37\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\3\14\1\157\20\14\1\50\26\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\3\14\1\160"+
    "\1\14\3\0\1\161\2\14\1\162\1\163\1\164\16\14"+
    "\1\50\26\0\4\14\21\0\1\165\1\166\36\0\1\167"+
    "\43\0\1\170\36\0\1\171\102\0\1\172\25\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\14\1\173\1\174"+
    "\1\14\1\175\2\14\1\176\1\177\13\14\27\0\1\173"+
    "\1\177\2\14\4\0\3\14\2\200\1\0\1\14\1\0"+
    "\5\14\3\0\3\14\1\201\5\14\1\202\12\14\27\0"+
    "\4\14\4\0\3\14\2\203\1\0\1\204\1\0\4\14"+
    "\1\205\3\0\5\14\1\206\1\207\3\14\1\210\4\14"+
    "\1\211\1\14\1\212\2\14\27\0\3\14\1\207\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\5\14\1\213"+
    "\1\214\1\14\1\215\2\14\1\216\1\14\1\217\6\14"+
    "\27\0\1\14\1\215\1\217\1\214\4\0\3\14\2\220"+
    "\1\0\1\14\1\0\5\14\3\0\1\221\23\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\3\14\1\160"+
    "\1\14\3\0\2\14\1\222\10\14\1\223\1\14\1\224"+
    "\6\14\27\0\2\14\1\224\1\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\3\14\1\225\5\14\1\226"+
    "\3\14\1\227\1\14\1\230\4\14\27\0\2\14\1\227"+
    "\1\14\4\0\3\14\2\231\1\0\1\232\1\0\3\14"+
    "\1\160\1\14\3\0\1\233\23\14\1\50\26\0\4\14"+
    "\4\0\5\14\1\0\1\234\1\0\5\14\3\0\3\14"+
    "\1\235\1\14\1\236\16\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\3\14\1\160\1\14\3\0\3\14"+
    "\1\237\20\14\1\50\26\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\1\240\14\14\1\241\6\14"+
    "\27\0\2\14\1\241\1\14\4\0\5\14\1\0\1\242"+
    "\1\0\5\14\3\0\3\14\1\243\20\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\244\1\0\5\14\3\0\5\14"+
    "\1\245\16\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\246\2\14\1\247\20\14\27\0"+
    "\4\14\4\0\3\14\2\250\1\0\1\14\1\0\5\14"+
    "\3\0\17\14\1\251\4\14\27\0\4\14\26\0\1\252"+
    "\4\0\1\253\130\0\1\254\101\0\1\255\103\0\1\256"+
    "\102\0\1\257\1\260\101\0\1\261\1\0\1\262\100\0"+
    "\1\263\2\0\1\264\77\0\1\265\3\0\1\266\75\0"+
    "\1\267\103\0\1\270\21\0\1\75\2\0\45\75\1\0"+
    "\24\75\1\0\5\75\1\0\1\76\116\0\1\271\32\0"+
    "\1\272\24\0\1\273\1\274\1\275\1\276\1\277\1\300"+
    "\1\0\3\103\103\0\5\104\1\0\1\104\1\0\5\104"+
    "\3\0\24\104\27\0\4\104\23\0\1\301\57\0\1\111"+
    "\2\0\45\111\1\0\32\111\1\0\1\112\151\0\1\302"+
    "\32\0\1\115\2\0\73\115\1\0\4\115\76\0\1\303"+
    "\4\0\22\117\1\0\60\117\21\0\1\304\62\0\1\124"+
    "\107\0\1\132\3\0\1\133\1\0\1\134\1\135\1\132"+
    "\30\0\1\132\41\0\1\305\4\0\1\306\2\0\1\305"+
    "\4\0\1\306\23\0\1\305\37\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\307\23\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\2\14\1\310"+
    "\1\311\2\14\1\312\4\14\1\313\10\14\27\0\3\14"+
    "\1\312\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\13\14\1\314\10\14\27\0\4\14\4\0\3\14\2\315"+
    "\1\0\1\316\1\0\5\14\3\0\6\14\1\317\15\14"+
    "\27\0\3\14\1\317\4\0\5\14\1\0\1\14\1\0"+
    "\4\14\1\320\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\2\14\1\321\21\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\5\14\1\322\1\14\1\323\14\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\1\14"+
    "\1\324\22\14\27\0\1\324\3\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\4\14\1\325\17\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\326\1\0\5\14\3\0"+
    "\15\14\1\327\6\14\27\0\2\14\1\327\1\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\15\14\1\330"+
    "\6\14\27\0\2\14\1\330\1\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\3\14\1\331\20\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\10\14\1\332\13\14\27\0\1\14\1\332\2\14\4\0"+
    "\5\14\1\0\1\333\1\0\5\14\3\0\3\14\1\334"+
    "\20\14\27\0\4\14\6\0\1\335\3\0\1\335\1\0"+
    "\3\335\1\0\1\335\3\0\2\335\5\0\1\335\13\0"+
    "\1\335\27\0\1\335\7\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\15\14\1\336\6\14\27\0\2\14\1\336"+
    "\1\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\24\14\1\50\26\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\2\14\1\337\1\14\1\340\17\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\10\14\1\341\13\14\27\0\1\14\1\341\2\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\3\14"+
    "\1\342\20\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\15\14\1\343\6\14\27\0\2\14"+
    "\1\343\1\14\1\165\1\344\1\345\100\165\22\346\1\347"+
    "\60\346\61\0\1\350\25\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\2\14\1\351\21\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\352"+
    "\17\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\7\14\1\353\14\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\7\14\1\354"+
    "\1\14\1\355\12\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\10\14\1\356\3\14\1\357"+
    "\7\14\27\0\1\14\1\356\2\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\3\14\1\360\20\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\6\14\1\361\1\14\1\362\2\14\1\363\10\14\27\0"+
    "\1\14\1\362\1\14\1\361\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\10\14\1\364\13\14\27\0\1\14"+
    "\1\364\2\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\6\14\1\365\6\14\1\366\6\14\27\0\2\14"+
    "\1\366\1\365\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\15\14\1\367\6\14\27\0\2\14\1\367\1\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\13\14"+
    "\1\370\10\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\371\14\14\1\372\6\14\27\0"+
    "\2\14\1\372\1\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\1\373\23\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\3\14\1\374\20\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\4\14\1\375\17\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\376\15\14"+
    "\27\0\3\14\1\376\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\17\14\1\377\4\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\u0100\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u0101\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\1\14\1\u0102\22\14\27\0\1\u0102\3\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\1\14"+
    "\1\u0103\1\u0104\21\14\27\0\1\u0103\3\14\4\0\3\14"+
    "\2\u0105\1\0\1\u0106\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\7\14\1\u0107\14\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\4\14\1\u0108\17\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\13\14\1\u0109\10\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\1\u010a\10\14\1\u010b\12\14"+
    "\27\0\4\14\4\0\3\14\2\u010c\1\0\1\14\1\0"+
    "\5\14\3\0\15\14\1\u010d\6\14\27\0\2\14\1\u010d"+
    "\1\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\2\14\1\u010e\21\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\4\14\1\u010f\3\0\4\14\1\u0110\17\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\6\14\1\u0111\15\14\27\0\3\14\1\u0111\4\0"+
    "\5\14\1\0\1\14\1\0\3\14\1\u0112\1\14\3\0"+
    "\20\14\1\u0113\3\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\4\14\1\u0114\3\0\6\14\1\u0115\15\14"+
    "\27\0\3\14\1\u0115\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\4\14\1\u0116\5\14\1\u0117\11\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\16\14\1\u0118\5\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\4\14\1\u0119\3\0\2\14\1\u011a\21\14"+
    "\27\0\4\14\4\0\3\14\2\u011b\1\0\1\u011c\1\0"+
    "\5\14\3\0\3\14\1\u011d\20\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\6\14\1\u011e"+
    "\15\14\27\0\3\14\1\u011e\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\6\14\1\u011f\15\14\27\0\3\14"+
    "\1\u011f\4\0\5\14\1\0\1\14\1\0\4\14\1\u0120"+
    "\3\0\4\14\1\u0121\1\14\1\u0122\4\14\1\u0123\10\14"+
    "\27\0\3\14\1\u0122\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\10\14\1\u0124\13\14\27\0\1\14\1\u0124"+
    "\2\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\10\14\1\u0125\13\14\27\0\1\14\1\u0125\2\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\u0126"+
    "\17\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\6\14\1\u0127\15\14\27\0\3\14\1\u0127"+
    "\4\0\3\14\2\u0128\1\0\1\u0129\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\45\0\1\u012a\65\0\1\u012b\133\0"+
    "\1\u012c\102\0\1\u012d\102\0\1\u012e\3\0\1\u012f\76\0"+
    "\1\u0130\21\0\1\301\1\102\1\u0131\100\301\6\0\1\305"+
    "\7\0\1\305\30\0\1\305\37\0\5\14\1\0\1\u0132"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\5\14\1\u0133\16\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\u0134\1\0\5\14"+
    "\3\0\3\14\1\u0135\20\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\u0136\23\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\3\14\1\u0137\1\u0138\17\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\u0139\15\14"+
    "\27\0\3\14\1\u0139\4\0\5\14\1\0\1\14\1\0"+
    "\4\14\1\u013a\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\u013b\1\0\5\14\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\1\u013c"+
    "\23\14\27\0\4\14\4\0\5\14\1\0\1\u013d\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\12\14\1\u013e\11\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u013f\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\4\14\1\u0140\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\4\14\1\u0141\17\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\2\14\1\u0142\21\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\u0143\1\0\5\14\3\0\5\14\1\u0144\4\14"+
    "\1\u0145\5\14\1\u0146\3\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\u0147\23\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\4\14\1\u0148"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\u0149"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\12\14\1\u014a\11\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\24\14\11\0\1\u014b\15\0\4\14\4\0\5\14"+
    "\1\0\1\u014c\1\0\5\14\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\4\14"+
    "\1\u014d\17\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\2\14\1\u014e\3\14\1\u014f\7\14"+
    "\1\u0150\5\14\27\0\3\14\1\u014f\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\2\14\1\u0151\21\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\15\14\1\u0152\6\14\27\0\2\14\1\u0152\1\14\1\0"+
    "\1\344\101\0\21\346\1\344\1\347\60\346\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\3\14\1\u0153\20\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\7\14\1\u0154\14\14\27\0\4\14\4\0\3\14"+
    "\2\u0155\1\0\1\14\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\4\14\1\u0156\17\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\u0157\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\1\u0158\23\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\3\14\1\u0159\20\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\14\14\1\u015a\7\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\16\14\1\u015b\5\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\3\14\1\u015c\20\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\u015d\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\4\14\1\u015e\3\0\6\14\1\u015f\15\14\27\0"+
    "\3\14\1\u015f\4\0\3\14\2\u0160\1\0\1\14\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\4\14\1\u0161\17\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\20\14\1\u0162\3\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\10\14\1\u0163\13\14\27\0"+
    "\1\14\1\u0163\2\14\4\0\5\14\1\0\1\u0164\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\3\14\1\u0165\1\14\3\0\16\14\1\u0166"+
    "\5\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\10\14\1\u0167\13\14\27\0\1\14\1\u0167"+
    "\2\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\15\14\1\u0168\6\14\27\0\2\14\1\u0168\1\14\4\0"+
    "\5\14\1\0\1\u0169\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\6\14\1\u016a\15\14\27\0\3\14\1\u016a\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\10\14\1\u016b\13\14"+
    "\27\0\1\14\1\u016b\2\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\u016c\23\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\u016d\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\10\14\1\u016e\13\14\27\0\1\14\1\u016e\2\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\2\14\1\u016f"+
    "\21\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\3\14\1\u0170\20\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\13\14\1\u0171"+
    "\10\14\27\0\4\14\4\0\3\14\2\u0172\1\0\1\14"+
    "\1\0\5\14\3\0\15\14\1\u0173\6\14\27\0\2\14"+
    "\1\u0173\1\14\4\0\5\14\1\0\1\u0174\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\u0175\23\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\6\14\1\u0176"+
    "\15\14\27\0\3\14\1\u0176\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\5\14\1\u0177\16\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\4\14"+
    "\1\u0178\17\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\14\1\u0179\22\14\27\0\1\u0179"+
    "\3\14\4\0\5\14\1\0\1\u017a\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\22\14\1\u017b\1\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\2\14\1\u017c"+
    "\21\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\10\14\1\u017d\5\14\1\u017e\5\14\27\0"+
    "\1\14\1\u017d\2\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\13\14\1\u017f\2\14\1\u0180\5\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\14\14\1\u0181\7\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\3\14\1\u0182\20\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\3\14\1\u0183\20\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\1\u0184\23\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\5\14"+
    "\1\u0185\16\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\4\14\1\u0186\17\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\5\14"+
    "\1\u0187\16\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\7\14\1\u0188\14\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\7\14"+
    "\1\u0189\14\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\17\14\1\u018a\4\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\4\14"+
    "\1\u018b\17\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\10\14\1\u018c\13\14\27\0\1\14"+
    "\1\u018c\2\14\30\0\1\u018d\61\0\2\u018e\153\0\1\u018f"+
    "\22\0\1\102\105\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\15\14\1\u0190\6\14\27\0\2\14\1\u0190\1\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\6\14"+
    "\1\u0191\15\14\27\0\3\14\1\u0191\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\15\14\1\u0192\6\14\27\0"+
    "\2\14\1\u0192\1\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\15\14\1\u0193\6\14\27\0\2\14\1\u0193"+
    "\1\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\15\14\1\u0194\6\14\27\0\2\14\1\u0194\1\14\4\0"+
    "\5\14\1\0\1\u0195\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\5\14\1\u0196\16\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\10\14\1\u0197\4\14\1\u0198"+
    "\6\14\27\0\1\14\1\u0197\1\u0198\1\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\13\14\1\u0199\10\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\u019a\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\7\14\1\u019b\14\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\4\14"+
    "\1\u019c\17\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\7\14\1\u019d\14\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\6\14"+
    "\1\u019e\15\14\27\0\3\14\1\u019e\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\1\u019f\23\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\13\14"+
    "\1\u01a0\10\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\14\14\1\u01a1\7\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\1\u01a2"+
    "\23\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\6\14\1\355\15\14\27\0\3\14\1\355"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\6\14"+
    "\1\u01a3\15\14\27\0\3\14\1\u01a3\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\2\14\1\u01a4\21\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\6\14\1\u01a5\15\14\27\0\3\14\1\u01a5\4\0\3\14"+
    "\2\u01a6\1\0\1\14\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u01a7\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\u01a8\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\u01a9\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\u01aa"+
    "\17\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\10\14\1\u0147\13\14\27\0\1\14\1\u0147"+
    "\2\14\4\0\5\14\1\0\1\u01ab\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\2\14\1\u01ac\21\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\12\14\1\u01ad"+
    "\11\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\2\14\1\u01ae\21\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\u01af"+
    "\17\14\27\0\4\14\4\0\3\14\2\u01b0\1\0\1\14"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\4\14\1\u01b1\17\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\15\14\1\u01b2\6\14\27\0\2\14\1\u01b2\1\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\22\14"+
    "\1\u01b3\1\14\27\0\4\14\4\0\3\14\2\u01b4\1\0"+
    "\1\14\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\10\14\1\u01b5"+
    "\13\14\27\0\1\14\1\u01b5\2\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\4\14\1\u01b6\17\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\5\14\1\u01b7\16\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\15\14\1\u01b8\6\14\27\0"+
    "\2\14\1\u01b8\1\14\4\0\5\14\1\0\1\14\1\0"+
    "\4\14\1\u01b9\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\u01ba\1\0\5\14\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\5\14"+
    "\1\u01bb\16\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\u01bc\23\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\u01bd"+
    "\17\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\14\14\1\u01be\7\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\6\14\1\u01bf"+
    "\15\14\27\0\3\14\1\u01bf\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\2\14\1\u01c0\21\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\20\14"+
    "\1\u01c1\3\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\4\14\1\u01c2\17\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\12\14"+
    "\1\u01c3\11\14\27\0\4\14\4\0\5\14\1\0\1\u01c4"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\u01c5\5\14"+
    "\1\u01c6\7\14\27\0\3\14\1\u01c5\4\0\3\14\2\u01c7"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\u01c8\15\14"+
    "\27\0\3\14\1\u01c8\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\15\14\1\u01c9\6\14\27\0\2\14\1\u01c9"+
    "\1\14\4\0\5\14\1\0\1\u01ca\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\1\u01cb\23\14\27\0\4\14\4\0\3\14"+
    "\2\u01cc\1\0\1\14\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\6\14\1\u01cd\15\14\27\0\3\14\1\u01cd\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\u01ce\23\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\1\u01cf\23\14\27\0\4\14\4\0\3\14\2\u01d0\1\0"+
    "\1\14\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\15\14\1\u01d1"+
    "\6\14\27\0\2\14\1\u01d1\1\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\15\14\1\u01d2\6\14\27\0"+
    "\2\14\1\u01d2\1\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\6\14\1\u01d3\15\14\27\0\3\14\1\u01d3"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\15\14"+
    "\1\u01d4\6\14\27\0\2\14\1\u01d4\1\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\u01d5\23\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\10\14\1\u01d6\13\14\27\0\1\14\1\u01d6\2\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\u01d7"+
    "\17\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\16\14\1\u01d8\5\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\u01d9\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\1\0\3\u01da\14\0\1\u01db\31\0\1\u01dc\31\0"+
    "\3\u018e\46\0\1\u01dd\34\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\6\14\1\u01de\15\14\27\0\3\14\1\u01de"+
    "\4\0\5\14\1\0\1\14\1\0\2\u01df\3\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\u01e0\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\6\14\1\u01e1\15\14\27\0"+
    "\3\14\1\u01e1\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\12\14\1\u01e2\11\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\u01e3\15\14"+
    "\27\0\3\14\1\u01e3\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\7\14\1\u01e4\14\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\10\14\1\u01e5"+
    "\13\14\27\0\1\14\1\u01e5\2\14\4\0\5\14\1\0"+
    "\1\u01e6\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\15\14\1\u01e7"+
    "\6\14\27\0\2\14\1\u01e7\1\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\1\u01e8\23\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\4\14\1\u01e9\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\7\14\1\u01ea\14\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\15\14\1\u01eb"+
    "\6\14\27\0\2\14\1\u01eb\1\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\15\14\1\u01ec\6\14\27\0"+
    "\2\14\1\u01ec\1\14\4\0\3\14\2\u01ed\1\0\1\14"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\21\14\1\u01ee\2\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\15\14\1\u01ef\6\14\27\0\2\14\1\u01ef\1\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\10\14"+
    "\1\u01f0\13\14\27\0\1\14\1\u01f0\2\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\15\14\1\u01f1\6\14"+
    "\27\0\2\14\1\u01f1\1\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\10\14\1\u01f2\13\14\27\0\1\14"+
    "\1\u01f2\2\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\5\14\1\u01f3\16\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\u01f4\23\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u01f5\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\3\14\2\u01f6\1\0\1\14"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\u01f7\1\0\5\14\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\4\14\1\u01f8\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\4\14\1\u01f9\17\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\4\14\1\u01fa\3\0\24\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\14\14\1\u01ac\7\14\27\0\4\14\4\0\3\14"+
    "\2\u0155\1\0\1\14\1\0\2\u01fb\3\14\3\0\24\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\4\14\1\u01fc\17\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\20\14\1\u01fd\3\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\u01fe\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\10\14\1\u01ff\13\14\27\0\1\14"+
    "\1\u01ff\2\14\4\0\3\14\2\u0200\1\0\1\14\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\15\14\1\u0201\6\14\27\0"+
    "\2\14\1\u0201\1\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\13\14\1\u0202\6\14\1\u0203\1\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u0204\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\2\u0205\3\14\3\0\1\u0206\23\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\1\u0207\23\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\1\u0208\23\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\12\14\1\u0209\11\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u020a\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\1\u020b\23\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\u020c\15\14"+
    "\27\0\3\14\1\u020c\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\1\u020d\23\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\2\14\1\u020e\21\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\15\14\1\355\6\14\27\0\2\14\1\355\1\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\14\14"+
    "\1\u020f\7\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\10\14\1\u0210\13\14\27\0\1\14"+
    "\1\u0210\2\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\6\14\1\u0211\15\14\27\0\3\14\1\u0211\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\15\14\1\u0212"+
    "\6\14\27\0\2\14\1\u0212\1\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\3\14\1\u0213\20\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\1\u0214\23\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\7\14\1\u0215\14\14\27\0\4\14"+
    "\4\0\3\14\2\u0216\1\0\1\14\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\10\14\1\u0217\13\14\27\0\1\14\1\u0217"+
    "\2\14\4\0\5\14\1\0\1\14\1\0\4\14\1\u0218"+
    "\3\0\24\14\27\0\4\14\4\0\3\14\2\u0219\1\0"+
    "\1\14\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\u021a\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\23\14\1\u021b\27\0\4\14\1\0\3\u01da\46\0\1\u01dc"+
    "\57\0\1\u021c\57\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\1\u021d\23\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\10\14\1\u021e\13\14\27\0"+
    "\1\14\1\u021e\2\14\4\0\5\14\1\0\1\u021f\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\u0220\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\2\14\1\u0221"+
    "\21\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\1\u0222\23\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\u0223\23\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\2\14\1\u0224\21\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\17\14\1\u0225\4\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\1\u0226\23\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\3\14\1\u0227\20\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\7\14"+
    "\1\u0228\14\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\3\14\1\u0229\20\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\4\14"+
    "\1\u022a\17\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\5\14\1\u022b\16\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\5\14"+
    "\1\u022c\16\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\2\14\1\u022d\21\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\6\14"+
    "\1\u022e\15\14\27\0\3\14\1\u022e\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\6\14\1\u022f\15\14\27\0"+
    "\3\14\1\u022f\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\10\14\1\355\13\14\27\0\1\14\1\355\2\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\6\14"+
    "\1\u0230\15\14\27\0\3\14\1\u0230\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\15\14\1\u0231\6\14\27\0"+
    "\2\14\1\u0231\1\14\4\0\5\14\1\0\1\u0232\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\4\14\1\153\17\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\4\14\1\u0233\17\14\27\0\4\14\4\0\3\14\2\u0234"+
    "\1\0\1\14\1\0\5\14\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\13\14"+
    "\1\u0235\10\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\6\14\1\u0236\15\14\27\0\3\14"+
    "\1\u0236\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\11\14\1\u0237\12\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\4\14\1\u0238\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\u0239\1\0\5\14\3\0\24\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\u023a\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\4\14\1\u023b\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\11\14\1\u023c"+
    "\12\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\4\14\1\u023d\17\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\u023e\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\6\14\1\u023f\15\14\27\0\3\14\1\u023f\4\0\5\14"+
    "\1\0\1\u0240\1\0\5\14\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\1\14"+
    "\1\u0241\22\14\27\0\1\u0241\3\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\3\14\1\u0242\20\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u0243\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\14\14\1\u0244\7\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\u0245\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u0246\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\5\14\1\u0247\16\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\12\14\1\u0248"+
    "\11\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\16\14\1\u0249\5\14\27\0\4\14\4\0"+
    "\3\14\2\u024a\1\0\1\14\1\0\5\14\3\0\2\14"+
    "\1\u024b\21\14\27\0\4\14\4\0\5\14\1\0\1\u024c"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\u024d\15\14"+
    "\27\0\3\14\1\u024d\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\15\14\1\u024e\6\14\27\0\2\14\1\u024e"+
    "\1\14\4\0\5\14\1\0\1\14\1\0\2\14\1\u024f"+
    "\2\14\3\0\24\14\27\0\4\14\34\0\1\u0250\43\0"+
    "\1\u0250\6\0\5\14\1\0\1\14\1\0\4\14\1\u0251"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\6\14\1\u0252\15\14\27\0\3\14"+
    "\1\u0252\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\10\14\1\u0253\13\14\27\0\1\14\1\u0253\2\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\u0254"+
    "\17\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\6\14\1\u0255\15\14\27\0\3\14\1\u0255"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\2\14"+
    "\1\u0256\21\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\6\14\1\u0257\15\14\27\0\3\14"+
    "\1\u0257\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\5\14\1\u0258\16\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\10\14\1\u0259\13\14\27\0"+
    "\1\14\1\u0259\2\14\4\0\5\14\1\0\1\14\1\0"+
    "\4\14\1\u025a\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\u025b\1\0\5\14\3\0\24\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\u025c\1\0\5\14\3\0\24\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\u025d\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\3\14\2\u025e\1\0"+
    "\1\14\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\3\14\1\u025f"+
    "\20\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\1\u0260\23\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\2\14\1\u0261\21\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\6\14\1\u0262\15\14\27\0\3\14\1\u0262\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\1\14\1\u0263"+
    "\22\14\27\0\1\u0263\3\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\11\14\1\u0264\12\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\15\14"+
    "\1\u0265\6\14\27\0\2\14\1\u0265\1\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\6\14\1\u0266\15\14"+
    "\27\0\3\14\1\u0266\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\10\14\1\u0267\13\14\27\0\1\14\1\u0267"+
    "\2\14\4\0\5\14\1\0\1\u0268\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\12\14\1\u0269\11\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\4\14\1\u026a"+
    "\17\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\15\14\1\u026b\6\14\27\0\2\14\1\u026b"+
    "\1\14\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\2\14\1\u026c\21\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\u026d\1\0\5\14\3\0\24\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\10\14\1\u026e"+
    "\13\14\27\0\1\14\1\u026e\2\14\4\0\5\14\1\0"+
    "\1\14\1\0\4\14\1\u026f\3\0\24\14\27\0\4\14"+
    "\33\0\1\u0270\53\0\5\14\1\0\1\u0271\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\6\14\1\u0272\15\14\27\0\3\14"+
    "\1\u0272\4\0\5\14\1\0\1\14\1\0\5\14\3\0"+
    "\6\14\1\u0273\15\14\27\0\3\14\1\u0273\4\0\3\14"+
    "\2\u0274\1\0\1\14\1\0\5\14\3\0\24\14\27\0"+
    "\4\14\4\0\5\14\1\0\1\u0275\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\13\14\1\u0276\10\14\27\0\4\14\4\0"+
    "\5\14\1\0\1\14\1\0\5\14\3\0\6\14\1\u0277"+
    "\15\14\27\0\3\14\1\u0277\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\3\14\1\u0278\20\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\20\14"+
    "\1\u0279\3\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\1\14\1\u027a\22\14\27\0\1\u027a"+
    "\3\14\4\0\5\14\1\0\1\u027b\1\0\5\14\3\0"+
    "\24\14\27\0\4\14\4\0\3\14\2\u027c\1\0\1\14"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\2\14\1\u027d\21\14"+
    "\27\0\4\14\4\0\3\14\2\u027e\1\0\1\14\1\0"+
    "\5\14\3\0\24\14\27\0\4\14\4\0\5\14\1\0"+
    "\1\14\1\0\5\14\3\0\6\14\1\u027f\15\14\27\0"+
    "\3\14\1\u027f\4\0\5\14\1\0\1\u0280\1\0\5\14"+
    "\3\0\24\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\14\14\1\u0281\7\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\3\14"+
    "\1\u0282\20\14\27\0\4\14\7\0\2\u0283\76\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\2\14\1\u0284\21\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\11\14\1\u0285\12\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\3\14\1\u0286\20\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\3\14\1\u0287\20\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\10\14\1\u0288\13\14"+
    "\27\0\1\14\1\u0288\2\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\4\14\1\u0289\17\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\3\14"+
    "\1\u028a\20\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\3\14\1\u028b\20\14\27\0\4\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\12\14"+
    "\1\u028c\11\14\27\0\4\14\32\0\1\u028d\47\0\1\u028d"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\13\14"+
    "\1\u028e\10\14\27\0\4\14\4\0\5\14\1\0\1\14"+
    "\1\0\5\14\3\0\10\14\1\u028f\13\14\27\0\1\14"+
    "\1\u028f\2\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\15\14\1\u0290\6\14\27\0\2\14\1\u0290\1\14"+
    "\4\0\5\14\1\0\1\u0291\1\0\5\14\3\0\24\14"+
    "\27\0\4\14\4\0\5\14\1\0\1\14\1\0\5\14"+
    "\3\0\10\14\1\u0292\13\14\27\0\1\14\1\u0292\2\14"+
    "\4\0\5\14\1\0\1\14\1\0\5\14\3\0\10\14"+
    "\1\u0293\13\14\27\0\1\14\1\u0293\2\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\13\14\1\u0294\10\14"+
    "\27\0\4\14\7\0\2\u0295\76\0\5\14\1\0\1\u0296"+
    "\1\0\5\14\3\0\24\14\27\0\4\14\4\0\5\14"+
    "\1\0\1\14\1\0\5\14\3\0\1\u0297\23\14\27\0"+
    "\4\14\27\0\1\u0298\57\0\5\14\1\0\1\14\1\0"+
    "\5\14\3\0\6\14\1\u0299\15\14\27\0\3\14\1\u0299"+
    "\34\0\1\u029a\43\0\1\u029a\3\0\3\u029a\46\0\1\u029b"+
    "\30\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[33031];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\1\0\1\1\2\0\2\1\2\0\1\11\35\1"+
    "\1\11\1\1\3\11\1\1\2\11\10\1\5\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\3\1\3\11\1\1"+
    "\1\11\6\1\4\11\3\1\2\11\1\1\1\0\2\11"+
    "\12\1\1\11\5\1\1\0\10\1\1\11\1\1\2\11"+
    "\57\1\2\0\1\11\1\1\6\11\1\1\1\11\2\1"+
    "\11\11\1\1\3\11\1\1\1\0\35\1\1\11\1\1"+
    "\2\0\1\11\101\1\2\0\3\11\1\1\1\11\32\1"+
    "\1\11\101\1\2\0\1\11\112\1\2\0\2\11\76\1"+
    "\1\0\63\1\1\0\37\1\1\0\22\1\1\0\11\1"+
    "\1\0\7\1\1\0\2\1\1\0\1\1\1\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[667];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
	protected StringBuffer string = new StringBuffer();
	protected int curOffset = 0;
	protected boolean isSQLCondition;
        
	public TerminalNode next() {
		try {
			int type = yylex();
			TerminalNode result;
			if(type == ErrorNodeTypes.STRING || type == ErrorNodeTypes.SQLSTMTLIT || type == ErrorNodeTypes.INLINE_DLI) {
				result = new TerminalNode(type, string.toString(), yyline, yycolumn, curOffset); 
				curOffset += string.length();
			}
			else {
				result =  new TerminalNode(type, yytext(), yyline, yycolumn, curOffset);
				curOffset += yylength();
			}
			return result;
		} catch (IOException e) {
			// Should never happen
			e.printStackTrace();
			return null;
		}
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ErrorLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ErrorLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1814) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 98: 
          { return ErrorNodeTypes.USE;
          }
        case 210: break;
        case 38: 
          { yybegin(SQL); string.append('\"');
          }
        case 211: break;
        case 45: 
          { yybegin(DLI); string.append('\"');
          }
        case 212: break;
        case 59: 
          { return ErrorNodeTypes.MINUSEQ;
          }
        case 213: break;
        case 8: 
          { return ErrorNodeTypes.DIV;
          }
        case 214: break;
        case 79: 
          { string.append("\\\'");
          }
        case 215: break;
        case 170: 
          { return ErrorNodeTypes.PASSING;
          }
        case 216: break;
        case 191: 
          { return ErrorNodeTypes.INTERFACE;
          }
        case 217: break;
        case 84: 
          { string.append("\"\"");
          }
        case 218: break;
        case 193: 
          { return ErrorNodeTypes.FORMGROUP;
          }
        case 219: break;
        case 107: 
          { return ErrorNodeTypes.RIGHTSHIFTLOGICAL;
          }
        case 220: break;
        case 5: 
          { return ErrorNodeTypes.INTEGER;
          }
        case 221: break;
        case 186: 
          { return ErrorNodeTypes.DELEGATE;
          }
        case 222: break;
        case 43: 
          { yybegin(DLI); string.append(yytext());
          }
        case 223: break;
        case 173: 
          { return ErrorNodeTypes.PROGRAM;
          }
        case 224: break;
        case 39: 
          { yybegin(SQL); string.append('\'');
          }
        case 225: break;
        case 44: 
          { yybegin(DLI); string.append('\'');
          }
        case 226: break;
        case 86: 
          { yybegin(YYINITIAL); string.append(yytext()); return ErrorNodeTypes.WS;
          }
        case 227: break;
        case 114: 
          { return ErrorNodeTypes.XOREQ;
          }
        case 228: break;
        case 30: 
          { return ErrorNodeTypes.NEGATE;
          }
        case 229: break;
        case 165: 
          { return ErrorNodeTypes.ONEVENT;
          }
        case 230: break;
        case 185: 
          { return ErrorNodeTypes.TRANSFER;
          }
        case 231: break;
        case 64: 
          { return ErrorNodeTypes.NE;
          }
        case 232: break;
        case 14: 
          { return ErrorNodeTypes.RPAREN;
          }
        case 233: break;
        case 200: 
          { return ErrorNodeTypes.IMPLEMENTS;
          }
        case 234: break;
        case 149: 
          { return ErrorNodeTypes.ESCAPE;
          }
        case 235: break;
        case 25: 
          { return ErrorNodeTypes.MODULO;
          }
        case 236: break;
        case 70: 
          { return ErrorNodeTypes.LE;
          }
        case 237: break;
        case 6: 
          { return ErrorNodeTypes.DOT;
          }
        case 238: break;
        case 150: 
          { return ErrorNodeTypes.BYNAME;
          }
        case 239: break;
        case 7: 
          { return ErrorNodeTypes.PLUS;
          }
        case 240: break;
        case 169: 
          { return ErrorNodeTypes.PACKAGE;
          }
        case 241: break;
        case 101: 
          { return ErrorNodeTypes.NEW;
          }
        case 242: break;
        case 89: 
          { return ErrorNodeTypes.END;
          }
        case 243: break;
        case 160: 
          { return ErrorNodeTypes.FOREACH;
          }
        case 244: break;
        case 118: 
          { return ErrorNodeTypes.SHOW;
          }
        case 245: break;
        case 126: 
          { return ErrorNodeTypes.GOTO;
          }
        case 246: break;
        case 145: 
          { yybegin(SQL); isSQLCondition = false; string.setLength(0); string.append(yytext());
          }
        case 247: break;
        case 74: 
          { return ErrorNodeTypes.NULLCONCAT;
          }
        case 248: break;
        case 162: 
          { return ErrorNodeTypes.FREESQL;
          }
        case 249: break;
        case 187: 
          { return ErrorNodeTypes.DATAITEM;
          }
        case 250: break;
        case 34: 
          { yybegin(SQLDELIMITEDID); string.append('\"');
          }
        case 251: break;
        case 139: 
          { return ErrorNodeTypes.STACK;
          }
        case 252: break;
        case 117: 
          { return ErrorNodeTypes.BIND;
          }
        case 253: break;
        case 19: 
          { return ErrorNodeTypes.ASSIGN;
          }
        case 254: break;
        case 205: 
          { return ErrorNodeTypes.ONEXCEPTION;
          }
        case 255: break;
        case 82: 
          { string.append("\\r");
          }
        case 256: break;
        case 15: 
          { return ErrorNodeTypes.BANG;
          }
        case 257: break;
        case 156: 
          { return ErrorNodeTypes.RECORD;
          }
        case 258: break;
        case 105: 
          { return ErrorNodeTypes.LEFTSHIFTEQ;
          }
        case 259: break;
        case 174: 
          { return ErrorNodeTypes.RETURNS;
          }
        case 260: break;
        case 63: 
          { return ErrorNodeTypes.TO;
          }
        case 261: break;
        case 57: 
          { return ErrorNodeTypes.TIMESTIMES;
          }
        case 262: break;
        case 122: 
          { return ErrorNodeTypes.THIS;
          }
        case 263: break;
        case 125: 
          { return ErrorNodeTypes.MOVE;
          }
        case 264: break;
        case 144: 
          { return ErrorNodeTypes.WHILE;
          }
        case 265: break;
        case 172: 
          { return ErrorNodeTypes.PREPARE;
          }
        case 266: break;
        case 68: 
          { return ErrorNodeTypes.AND;
          }
        case 267: break;
        case 13: 
          { return ErrorNodeTypes.LPAREN;
          }
        case 268: break;
        case 102: 
          { return ErrorNodeTypes.NOT;
          }
        case 269: break;
        case 27: 
          { return ErrorNodeTypes.RBRACKET;
          }
        case 270: break;
        case 166: 
          { return ErrorNodeTypes.LIBRARY;
          }
        case 271: break;
        case 181: 
          { return ErrorNodeTypes.CONTINUE;
          }
        case 272: break;
        case 189: 
          { return ErrorNodeTypes.PREVIOUS;
          }
        case 273: break;
        case 132: 
          { return ErrorNodeTypes.EMBED;
          }
        case 274: break;
        case 73: 
          { return ErrorNodeTypes.RIGHTSHIFTARITHMETIC;
          }
        case 275: break;
        case 184: 
          { return ErrorNodeTypes.USINGPCB;
          }
        case 276: break;
        case 58: 
          { return ErrorNodeTypes.TIMESEQ;
          }
        case 277: break;
        case 26: 
          { return ErrorNodeTypes.LBRACKET;
          }
        case 278: break;
        case 21: 
          { return ErrorNodeTypes.BITOR;
          }
        case 279: break;
        case 88: 
          { return ErrorNodeTypes.PRIMITIVE;
          }
        case 280: break;
        case 81: 
          { string.append("\\n");
          }
        case 281: break;
        case 95: 
          { return ErrorNodeTypes.ADD;
          }
        case 282: break;
        case 109: 
          { return ErrorNodeTypes.INTO;
          }
        case 283: break;
        case 199: 
          { return ErrorNodeTypes.RETURNING;
          }
        case 284: break;
        case 1: 
          { return ErrorNodeTypes.WS;
          }
        case 285: break;
        case 111: 
          { return ErrorNodeTypes.ELSE;
          }
        case 286: break;
        case 93: 
          { return ErrorNodeTypes.TIMESTIMESEQ;
          }
        case 287: break;
        case 143: 
          { return ErrorNodeTypes.PRINT;
          }
        case 288: break;
        case 206: 
          { return ErrorNodeTypes.TRANSACTION;
          }
        case 289: break;
        case 153: 
          { return ErrorNodeTypes.OPENUI;
          }
        case 290: break;
        case 85: 
          { string.append("\'\'");
          }
        case 291: break;
        case 31: 
          { yybegin(YYINITIAL); string.append(yytext()); return ErrorNodeTypes.ERRORSTRING;
          }
        case 292: break;
        case 137: 
          { return ErrorNodeTypes.CHARPRIMITIVE;
          }
        case 293: break;
        case 194: 
          { return ErrorNodeTypes.SINGLEROW;
          }
        case 294: break;
        case 135: 
          { return ErrorNodeTypes.CONST;
          }
        case 295: break;
        case 152: 
          { return ErrorNodeTypes.STATIC;
          }
        case 296: break;
        case 146: 
          { yybegin(DLI); string.setLength(0); string.append(yytext());
          }
        case 297: break;
        case 23: 
          { return ErrorNodeTypes.GT;
          }
        case 298: break;
        case 97: 
          { return ErrorNodeTypes.OUT;
          }
        case 299: break;
        case 142: 
          { return ErrorNodeTypes.THROW;
          }
        case 300: break;
        case 131: 
          { return ErrorNodeTypes.INOUT;
          }
        case 301: break;
        case 54: 
          { return ErrorNodeTypes.PLUSEQ;
          }
        case 302: break;
        case 3: 
          { return ErrorNodeTypes.error;
          }
        case 303: break;
        case 141: 
          { return ErrorNodeTypes.USING;
          }
        case 304: break;
        case 96: 
          { return ErrorNodeTypes.SET;
          }
        case 305: break;
        case 56: 
          { return ErrorNodeTypes.DIVEQ;
          }
        case 306: break;
        case 121: 
          { return ErrorNodeTypes.TYPE;
          }
        case 307: break;
        case 9: 
          { return ErrorNodeTypes.TIMES;
          }
        case 308: break;
        case 164: 
          { return ErrorNodeTypes.SERVICE;
          }
        case 309: break;
        case 29: 
          { return ErrorNodeTypes.AT;
          }
        case 310: break;
        case 78: 
          { string.append("\\\\");
          }
        case 311: break;
        case 18: 
          { return ErrorNodeTypes.COLON;
          }
        case 312: break;
        case 52: 
          { return ErrorNodeTypes.IS;
          }
        case 313: break;
        case 179: 
          { return ErrorNodeTypes.EGLCLASS;
          }
        case 314: break;
        case 209: 
          { yybegin(SQL); isSQLCondition = true; string.setLength(0); string.append(yytext());
          }
        case 315: break;
        case 192: 
          { return ErrorNodeTypes.FORUPDATE;
          }
        case 316: break;
        case 33: 
          { string.append("\\");
          }
        case 317: break;
        case 207: 
          { return ErrorNodeTypes.EXTERNALTYPE;
          }
        case 318: break;
        case 62: 
          { return ErrorNodeTypes.OR;
          }
        case 319: break;
        case 183: 
          { return ErrorNodeTypes.ABSOLUTE;
          }
        case 320: break;
        case 2: 
          { string.append(yytext());
          }
        case 321: break;
        case 71: 
          { return ErrorNodeTypes.LEFTSHIFT;
          }
        case 322: break;
        case 116: 
          { return ErrorNodeTypes.CALL;
          }
        case 323: break;
        case 51: 
          { return ErrorNodeTypes.IF;
          }
        case 324: break;
        case 115: 
          { return ErrorNodeTypes.CASE;
          }
        case 325: break;
        case 148: 
          { return ErrorNodeTypes.IMPORT;
          }
        case 326: break;
        case 123: 
          { return ErrorNodeTypes.NEXT;
          }
        case 327: break;
        case 159: 
          { return ErrorNodeTypes.EXTENDS;
          }
        case 328: break;
        case 60: 
          { return ErrorNodeTypes.AS;
          }
        case 329: break;
        case 171: 
          { return ErrorNodeTypes.PRIVATE;
          }
        case 330: break;
        case 138: 
          { return ErrorNodeTypes.SUPER;
          }
        case 331: break;
        case 61: 
          { return ErrorNodeTypes.BY;
          }
        case 332: break;
        case 48: 
          { return ErrorNodeTypes.DECIMALLIT;
          }
        case 333: break;
        case 40: 
          { yybegin(DLI_DBL_QUOTED_ID); string.append('\"');
          }
        case 334: break;
        case 154: 
          { return ErrorNodeTypes.UPDATE;
          }
        case 335: break;
        case 112: 
          { return ErrorNodeTypes.FORM;
          }
        case 336: break;
        case 92: 
          { return ErrorNodeTypes.XOR;
          }
        case 337: break;
        case 76: 
          { string.append("\\f");
          }
        case 338: break;
        case 130: 
          { return ErrorNodeTypes.RIGHTSHIFTLOGICALEQ;
          }
        case 339: break;
        case 75: 
          { return ErrorNodeTypes.MODULOEQ;
          }
        case 340: break;
        case 28: 
          { return ErrorNodeTypes.RCURLY;
          }
        case 341: break;
        case 94: 
          { return ErrorNodeTypes.ALL;
          }
        case 342: break;
        case 17: 
          { return ErrorNodeTypes.SEMI;
          }
        case 343: break;
        case 100: 
          { return ErrorNodeTypes.TRY;
          }
        case 344: break;
        case 83: 
          { string.append("\\t");
          }
        case 345: break;
        case 91: 
          { return ErrorNodeTypes.BYTESLIT;
          }
        case 346: break;
        case 196: 
          { return ErrorNodeTypes.USINGKEYS;
          }
        case 347: break;
        case 106: 
          { return ErrorNodeTypes.RIGHTSHIFTARITHMETICEQ;
          }
        case 348: break;
        case 72: 
          { return ErrorNodeTypes.GE;
          }
        case 349: break;
        case 190: 
          { return ErrorNodeTypes.RELATIVE;
          }
        case 350: break;
        case 55: 
          { yybegin(BLOCKCOMMENT); string.setLength(0); string.append(yytext());
          }
        case 351: break;
        case 41: 
          { yybegin(YYINITIAL); string.append(yytext()); return ErrorNodeTypes.INLINE_DLI;
          }
        case 352: break;
        case 136: 
          { return ErrorNodeTypes.CLOSE;
          }
        case 353: break;
        case 47: 
          { return ErrorNodeTypes.SMALLINTLIT;
          }
        case 354: break;
        case 202: 
          { return ErrorNodeTypes.ENUMERATION;
          }
        case 355: break;
        case 87: 
          { return ErrorNodeTypes.ISA;
          }
        case 356: break;
        case 66: 
          { return ErrorNodeTypes.EQ;
          }
        case 357: break;
        case 90: 
          { return ErrorNodeTypes.FOR;
          }
        case 358: break;
        case 4: 
          { return ErrorNodeTypes.ID;
          }
        case 359: break;
        case 104: 
          { return ErrorNodeTypes.CONCATEQ;
          }
        case 360: break;
        case 195: 
          { return ErrorNodeTypes.OTHERWISE;
          }
        case 361: break;
        case 69: 
          { return ErrorNodeTypes.BITOREQ;
          }
        case 362: break;
        case 163: 
          { return ErrorNodeTypes.CURRENT;
          }
        case 363: break;
        case 134: 
          { return ErrorNodeTypes.FIRST;
          }
        case 364: break;
        case 161: 
          { return ErrorNodeTypes.FORWARD;
          }
        case 365: break;
        case 80: 
          { string.append("\\b");
          }
        case 366: break;
        case 155: 
          { return ErrorNodeTypes.DELETE;
          }
        case 367: break;
        case 10: 
          { return ErrorNodeTypes.MINUS;
          }
        case 368: break;
        case 203: 
          { return ErrorNodeTypes.CONSTRUCTOR;
          }
        case 369: break;
        case 67: 
          { return ErrorNodeTypes.BITANDEQ;
          }
        case 370: break;
        case 42: 
          { yybegin(DLI_QUOTED_ID); string.append('\'');
          }
        case 371: break;
        case 175: 
          { return ErrorNodeTypes.REPLACE;
          }
        case 372: break;
        case 113: 
          { return ErrorNodeTypes.FROM;
          }
        case 373: break;
        case 124: 
          { return ErrorNodeTypes.NULL;
          }
        case 374: break;
        case 24: 
          { return ErrorNodeTypes.QUESTION;
          }
        case 375: break;
        case 204: 
          { return ErrorNodeTypes.SQLNULLABLE;
          }
        case 376: break;
        case 65: 
          { return ErrorNodeTypes.CONCAT;
          }
        case 377: break;
        case 16: 
          { return ErrorNodeTypes.COMMA;
          }
        case 378: break;
        case 133: 
          { return ErrorNodeTypes.FIELD;
          }
        case 379: break;
        case 208: 
          { return ErrorNodeTypes.WITHV60COMPAT;
          }
        case 380: break;
        case 147: 
          { return ErrorNodeTypes.INSERT;
          }
        case 381: break;
        case 120: 
          { return ErrorNodeTypes.LAST;
          }
        case 382: break;
        case 12: 
          { return ErrorNodeTypes.LCURLY;
          }
        case 383: break;
        case 119: 
          { return ErrorNodeTypes.OPEN;
          }
        case 384: break;
        case 127: 
          { return ErrorNodeTypes.HOLD;
          }
        case 385: break;
        case 32: 
          { yybegin(YYINITIAL); string.append('\"'); return ErrorNodeTypes.STRING;
          }
        case 386: break;
        case 46: 
          { return ErrorNodeTypes.BIGINTLIT;
          }
        case 387: break;
        case 182: 
          { return ErrorNodeTypes.CONVERSE;
          }
        case 388: break;
        case 129: 
          { return ErrorNodeTypes.WHEN;
          }
        case 389: break;
        case 36: 
          { yybegin(SQLSTRING); string.append('\'');
          }
        case 390: break;
        case 158: 
          { return ErrorNodeTypes.EXECUTE;
          }
        case 391: break;
        case 49: 
          { return ErrorNodeTypes.FLOATLIT;
          }
        case 392: break;
        case 177: 
          { return ErrorNodeTypes.HANDLER;
          }
        case 393: break;
        case 167: 
          { return ErrorNodeTypes.DISPLAY;
          }
        case 394: break;
        case 110: 
          { return ErrorNodeTypes.EXIT;
          }
        case 395: break;
        case 103: 
          { return ErrorNodeTypes.GET;
          }
        case 396: break;
        case 180: 
          { return ErrorNodeTypes.FUNCTION;
          }
        case 397: break;
        case 20: 
          { return ErrorNodeTypes.BITAND;
          }
        case 398: break;
        case 140: 
          { return ErrorNodeTypes.LABEL;
          }
        case 399: break;
        case 176: 
          { return ErrorNodeTypes.RUNUNIT;
          }
        case 400: break;
        case 108: 
          { return ErrorNodeTypes.NULLCONCATEQ;
          }
        case 401: break;
        case 168: 
          { return ErrorNodeTypes.NUMERICPRIMITIVE;
          }
        case 402: break;
        case 22: 
          { return ErrorNodeTypes.LT;
          }
        case 403: break;
        case 151: 
          { return ErrorNodeTypes.SCROLL;
          }
        case 404: break;
        case 11: 
          { yybegin(STRING); string.setLength(0); string.append('\"');
          }
        case 405: break;
        case 128: 
          { return ErrorNodeTypes.WITH;
          }
        case 406: break;
        case 50: 
          { return ErrorNodeTypes.SMALLFLOATLIT;
          }
        case 407: break;
        case 53: 
          { return ErrorNodeTypes.IN;
          }
        case 408: break;
        case 99: 
          { return ErrorNodeTypes.URL;
          }
        case 409: break;
        case 157: 
          { return ErrorNodeTypes.RETURN;
          }
        case 410: break;
        case 198: 
          { return ErrorNodeTypes.DATATABLE;
          }
        case 411: break;
        case 201: 
          { return ErrorNodeTypes.BYPOSITION;
          }
        case 412: break;
        case 77: 
          { string.append("\\\"");
          }
        case 413: break;
        case 37: 
          { yybegin(SQL); string.append(yytext());
          }
        case 414: break;
        case 178: 
          { return ErrorNodeTypes.INPARENT;
          }
        case 415: break;
        case 35: 
          { yybegin(YYINITIAL); string.append(yytext()); return isSQLCondition ? ErrorNodeTypes.SQLCONDITION : ErrorNodeTypes.SQLSTMTLIT;
          }
        case 416: break;
        case 188: 
          { return ErrorNodeTypes.NOCURSOR;
          }
        case 417: break;
        case 197: 
          { return ErrorNodeTypes.DECREMENT;
          }
        case 418: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              { 	if(yystate() == SQL || yystate() == SQLDELIMITEDID || yystate() == SQLSTRING) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERRORSQLSTMTLIT;
	}
	else if(yystate() == STRING) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERRORSTRING;
	}
	else if(yystate() == BLOCKCOMMENT) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERRORBLOCKCOMMENT;
	}
	else if(yystate() == DLI || yystate() == DLI_QUOTED_ID || yystate() == DLI_DBL_QUOTED_ID) {
		yybegin(YYINITIAL);
		return ErrorNodeTypes.ERROR_INLINE_DLI;
	}
	else {
		return ErrorNodeTypes.EOF;
	}
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
