/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.List;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class EGLClassTemplate
extends JavaTemplate {
    public void preGenClassBody(EGLClass part, Context ctx) {
        ctx.invoke("preGenUsedParts", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenFields", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenConstructors", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenFunctions", (Type)part, new Object[]{ctx});
    }

    public void preGenUsedParts(EGLClass part, Context ctx) {
        for (Part item : IRUtils.getReferencedPartsFor((Part)part)) {
            ctx.invoke("preGenUsedPart", (Type)part, new Object[]{ctx, item});
        }
    }

    public void preGenUsedPart(EGLClass part, Context ctx, Part arg) {
        ctx.invoke("preGen", (Type)arg, new Object[]{ctx});
    }

    public void preGenFields(EGLClass part, Context ctx) {
        for (Field field : part.getFields()) {
            ctx.invoke("preGenField", (Type)part, new Object[]{ctx, field});
        }
    }

    public void preGenField(EGLClass part, Context ctx, Field arg) {
        ctx.invoke("preGen", (EObject)arg, new Object[]{ctx});
    }

    public void preGenConstructors(EGLClass part, Context ctx) {
        for (Constructor constructor : part.getConstructors()) {
            ctx.invoke("preGenConstructor", (Type)part, new Object[]{ctx, constructor});
        }
    }

    public void preGenConstructor(EGLClass part, Context ctx, Constructor arg) {
        ctx.invoke("preGen", (EObject)arg, new Object[]{ctx});
    }

    public void preGenFunctions(EGLClass part, Context ctx) {
        for (Function function : part.getFunctions()) {
            ctx.invoke("preGenFunction", (Type)part, new Object[]{ctx, function});
        }
    }

    public void preGenFunction(EGLClass part, Context ctx, Function arg) {
        ctx.invoke("preGen", (EObject)arg, new Object[]{ctx});
    }

    public void genClassHeader(EGLClass part, Context ctx, TabbedWriter out) {
        out.print("public class ");
        ctx.invoke("genClassName", (Type)part, new Object[]{ctx, out});
        out.print(" extends ");
        ctx.invoke("genSuperClass", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genImplements", (Type)part, new Object[]{ctx, out});
        out.println(" {");
        ctx.invoke("genSerialVersionUID", (Type)part, new Object[]{ctx, out});
    }

    public void genImplements(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genClassBody(EGLClass part, Context ctx, TabbedWriter out) {
        String file = IRUtils.getQualifiedFileName((EObject)part);
        ctx.setCurrentFile(file);
        if (ctx.getSmapFiles().indexOf(file) < 0) {
            ctx.getSmapFiles().add(file);
        }
        ctx.invoke("genFields", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genLibraries", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genConstructors", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genInitializeMethods", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genGetterSetters", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genLibraryAccessMethods", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genFunctions", (Type)part, new Object[]{ctx, out});
    }

    public void genFields(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genField", (Type)part, new Object[]{ctx, out, field});
            ctx.writeSmapLine();
        }
        boolean needConstraints = false;
        for (Field field : part.getFields()) {
            if (!(field.getType() instanceof ParameterizedType)) continue;
            needConstraints = true;
            break;
        }
        if (needConstraints) {
            out.println("private static java.util.HashMap<String, TypeConstraints> ezeTypeConstraints = new java.util.HashMap<String, TypeConstraints>();");
            out.println("static {");
            for (Field field : part.getFields()) {
                if (!(field.getType() instanceof ParameterizedType)) continue;
                out.print("ezeTypeConstraints.put(\"");
                ctx.invoke("genName", (EObject)field, new Object[]{ctx, out});
                out.print("\", new TypeConstraints(");
                ctx.invoke("genRuntimeConstraint", field.getType(), new Object[]{ctx, out});
                out.println("));");
            }
            out.println("}");
        }
    }

    public void genField(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        ctx.invoke("genDeclaration", (EObject)arg, new Object[]{ctx, out});
    }

    public void genLibraries(EGLClass part, Context ctx, TabbedWriter out) {
        List libraries = (List)ctx.getAttribute(ctx.getClass(), "partLibrariesUsed");
        for (Library library : libraries) {
            ctx.invoke("genLibrary", (Type)part, new Object[]{ctx, out, library});
            ctx.writeSmapLine();
        }
    }

    public void genLibrary(EGLClass part, Context ctx, TabbedWriter out, Library arg) {
        out.print("public ");
        ctx.invoke("genRuntimeTypeName", (Type)arg, new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
        out.println(" eze_Lib_" + arg.getFullyQualifiedName().replace('.', '_') + ";");
    }

    public void genConstructors(EGLClass part, Context ctx, TabbedWriter out) {
        ctx.invokeSuper((Template)this, "genConstructor", (Type)part, new Object[]{ctx, out});
        for (Constructor constructor : part.getConstructors()) {
            ctx.invoke("genConstructor", (Type)part, new Object[]{ctx, out, constructor});
            ctx.writeSmapLine();
        }
    }

    public void genConstructor(EGLClass part, Context ctx, TabbedWriter out, Constructor arg) {
        ctx.invoke("genDeclaration", (EObject)arg, new Object[]{ctx, out});
    }

    public void genInitializeMethods(EGLClass part, Context ctx, TabbedWriter out) {
        out.println("public void ezeInitialize() {");
        ctx.invoke("genInitializeMethodBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genInitializeMethodBody(EGLClass part, Context ctx, TabbedWriter out) {
        List fields = part.getFields();
        if (fields.size() > 0) {
            Annotation annotation;
            boolean hasInit = false;
            boolean hasNoInit = false;
            for (Field field : fields) {
                if (field instanceof ConstantField) continue;
                if (field.getInitializerStatements() == null) {
                    hasNoInit = true;
                    continue;
                }
                hasInit = true;
            }
            if (hasNoInit && hasInit && (annotation = part.getAnnotation("EGL_Location")) != null && annotation.getValue("line") != null) {
                ctx.getSmapData().append("" + annotation.getValue("line"));
                if (ctx.getCurrentFile() != null) {
                    if (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) < 0) {
                        ctx.getSmapFiles().add(ctx.getCurrentFile());
                    }
                    ctx.getSmapData().append("#" + (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) + 1) + ":");
                } else {
                    ctx.getSmapData().append("#1:");
                }
                ctx.getSmapData().append(out.getLineNumber() + "\n");
            }
        }
        for (Field field : fields) {
            if (field.getInitializerStatements() != null) continue;
            ctx.invoke("genInitializeMethod", (Type)part, new Object[]{ctx, out, field});
        }
        for (Field field : fields) {
            if (field.getInitializerStatements() == null) continue;
            if (field instanceof ConstantField) {
                ctx.invoke("genInitializeMethod", (Type)part, new Object[]{ctx, out, field});
                continue;
            }
            ctx.genSmapEnd((Element)field, out);
            ctx.invoke("genInitializeMethod", (Type)part, new Object[]{ctx, out, field});
            ctx.writeSmapLine();
        }
    }

    public void genInitializeMethod(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        if (!(arg instanceof ConstantField)) {
            ctx.invoke("genInitializeStatement", (EObject)arg, new Object[]{ctx, out});
        }
    }

    public void genGetterSetters(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genGetterSetter", (Type)part, new Object[]{ctx, out, field});
            ctx.writeSmapLine();
        }
    }

    public void genGetterSetter(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
    }

    public void genLibraryAccessMethods(EGLClass part, Context ctx, TabbedWriter out) {
        List libraries = (List)ctx.getAttribute(ctx.getClass(), "partLibrariesUsed");
        for (Library library : libraries) {
            ctx.invoke("genLibraryAccessMethod", (Type)part, new Object[]{ctx, out, library});
            ctx.writeSmapLine();
        }
    }

    public void genLibraryAccessMethod(EGLClass part, Context ctx, TabbedWriter out, Library arg) {
        out.print("public ");
        ctx.invoke("genRuntimeTypeName", (Type)arg, new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
        out.println(" eze_Lib_" + arg.getFullyQualifiedName().replace('.', '_') + "() {");
        out.println("if (eze_Lib_" + arg.getFullyQualifiedName().replace('.', '_') + " == null) {");
        out.print("eze_Lib_" + arg.getFullyQualifiedName().replace('.', '_') + " = (");
        ctx.invoke("genRuntimeTypeName", (Type)arg, new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
        out.print(")org.eclipse.edt.javart.Runtime.getRunUnit().loadLibrary(\"");
        if (ctx.mapsToNativeType((Type)arg)) {
            out.print(ctx.getNativeMapping(arg.getFullyQualifiedName()));
        } else {
            out.print(CommonUtilities.fullClassAlias((Part)arg));
        }
        out.println("\");");
        out.println("}");
        out.println("return eze_Lib_" + arg.getFullyQualifiedName().replace('.', '_') + ";");
        out.println("}");
    }

    public void genFunctions(EGLClass part, Context ctx, TabbedWriter out) {
        for (Function function : part.getFunctions()) {
            ctx.invoke("genFunction", (Type)part, new Object[]{ctx, out, function});
            ctx.writeSmapLine();
        }
    }

    public void genFunction(EGLClass part, Context ctx, TabbedWriter out, Function arg) {
        ctx.invoke("genDeclaration", (EObject)arg, new Object[]{ctx, out});
    }

    public void genAdditionalConstructorParams(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genAdditionalSuperConstructorArgs(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genDeclaration(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genSuperClass(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public Integer genFieldTypeClassName(EGLClass part, Context ctx, TabbedWriter out, Integer arrayDimensions) {
        ctx.invoke("genRuntimeTypeName", (Type)part, new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
        return arrayDimensions;
    }
}

