/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.gen.CommonUtilities;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayLiteral;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BooleanLiteral;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.CallStatement;
import org.eclipse.edt.mof.egl.CaseStatement;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.ContinueStatement;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.DelegateInvocation;
import org.eclipse.edt.mof.egl.ExitStatement;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.ForEachStatement;
import org.eclipse.edt.mof.egl.ForStatement;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionInvocation;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionStatement;
import org.eclipse.edt.mof.egl.IfStatement;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.NewExpression;
import org.eclipse.edt.mof.egl.OpenUIStatement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartName;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.ReturnStatement;
import org.eclipse.edt.mof.egl.SetValuesExpression;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.WhileStatement;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.impl.EObjectImpl;

public class ReorganizeCode
extends AbstractVisitor {
    public static final IrFactory factory = IrFactory.INSTANCE;
    EglContext ctx;
    Container currentStatementContainer;
    boolean processedStatement = false;
    boolean inLocalVariableDeclaration = false;

    public List<StatementBlock> reorgCode(Statement statement, EglContext ctx) {
        Annotation annot = statement.getAnnotation("EGL_Location");
        if (annot != null) {
            ctx.setLastStatementLocation(annot);
        }
        this.ctx = ctx;
        this.currentStatementContainer = statement.getContainer();
        this.disallowRevisit();
        this.allowParentTracking();
        this.setReturnData(null);
        statement.accept((EVisitor)this);
        return (List)this.getReturnData();
    }

    private StatementBlock verify(int index) {
        StatementBlock block;
        List<Object> blockArray;
        if (this.getReturnData() == null) {
            blockArray = new ArrayList();
            blockArray.add(null);
            blockArray.add(null);
            this.setReturnData(blockArray);
        } else {
            blockArray = (List)this.getReturnData();
        }
        if (blockArray.get(index) == null) {
            block = factory.createStatementBlock();
            block.setContainer(this.currentStatementContainer);
            blockArray.set(index, block);
        }
        block = (StatementBlock)blockArray.get(index);
        return block;
    }

    public boolean visit(EObject object) {
        return true;
    }

    public boolean visit(Field object) {
        return !(object.getContainer() instanceof Part) || object.getContainer().equals(this.currentStatementContainer);
    }

    public boolean visit(Function object) {
        return false;
    }

    public boolean visit(Type object) {
        return false;
    }

    public boolean visit(Operation object) {
        return false;
    }

    public boolean visit(Statement object) {
        if (this.processedStatement && !this.inLocalVariableDeclaration) {
            return false;
        }
        if (this.ctx.getAttribute(object, "statementHasBeenReorganized") != null) {
            return false;
        }
        if (this.inLocalVariableDeclaration) {
            this.ctx.putAttribute(object, "statementHasBeenReorganized", Boolean.TRUE);
        }
        this.processedStatement = true;
        return true;
    }

    public boolean visit(LocalVariableDeclarationStatement object) {
        this.inLocalVariableDeclaration = true;
        return true;
    }

    public boolean visit(Assignment object) {
        if (object.getLHS().getType() instanceof ArrayType && object.getRHS() instanceof ArrayLiteral && ((Boolean)this.ctx.invoke("isAssignmentArrayMatchingWanted", object.getLHS().getType(), new Object[]{this.ctx})).booleanValue()) {
            List entries = ((ArrayLiteral)object.getRHS()).getEntries();
            if (entries != null && entries.size() == 0) {
                IntegerLiteral integerLiteral = factory.createIntegerLiteral();
                integerLiteral.setType((Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.EInt"));
                if (object.getAnnotation("EGL_Location") != null) {
                    integerLiteral.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                integerLiteral.setValue("0");
                NewExpression newExpression = factory.createNewExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    newExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                newExpression.getArguments().add(integerLiteral);
                newExpression.setId(object.getLHS().getType().getTypeSignature());
                object.setRHS((Expression)newExpression);
            } else {
                this.processArrayLiteral(object.getLHS().getType(), (ArrayLiteral)object.getRHS());
            }
        }
        if (object.getLHS().getType() != null && object.getLHS().getType().getClassifier() != null && object.getLHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue() && object.getOperator() != null && object.getOperator().equals("::=") && ((Boolean)this.ctx.invoke("isListReorganizationWanted", object.getLHS().getType(), new Object[]{this.ctx, object})).booleanValue()) {
            QualifiedFunctionInvocation invocation = factory.createQualifiedFunctionInvocation();
            if (object.getAnnotation("EGL_Location") != null) {
                invocation.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            if (object.getRHS().getType() != null && object.getRHS().getType().getClassifier() != null && object.getRHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue()) {
                invocation.setId("appendAll");
            } else {
                invocation.setId("appendElement");
            }
            invocation.setQualifier((Expression)object.getLHS());
            invocation.getArguments().add(object.getRHS());
            object.setRHS((Expression)invocation);
            object.setOperator("=");
        }
        if (!object.getOperator().equals("=") && object.getOperator().indexOf("=") >= 0 && (object.getLHS().isNullable() || object.getRHS().isNullable() || ((Boolean)this.ctx.invoke("isAssignmentBreakupWanted", object.getLHS().getType(), new Object[]{this.ctx, object})).booleanValue())) {
            BinaryExpression binExp = factory.createBinaryExpression();
            binExp.setLHS((Expression)object.getLHS());
            binExp.setRHS(object.getRHS());
            binExp.setOperator(object.getOperator().substring(0, object.getOperator().indexOf("=")));
            object.setRHS((Expression)binExp);
            object.setOperator("=");
        }
        return true;
    }

    private void processArrayLiteral(Type type, ArrayLiteral object) {
        List entries = object.getEntries();
        if (entries != null) {
            while (type instanceof ArrayType) {
                type = ((ArrayType)type).getElementType();
            }
            int i = 0;
            while (i < entries.size()) {
                Expression element = (Expression)entries.get(i);
                if (element instanceof ArrayLiteral) {
                    this.processArrayLiteral(type, (ArrayLiteral)element);
                } else {
                    entries.set(i, IRUtils.makeExprCompatibleToType((Expression)element, (Type)type));
                }
                ++i;
            }
        }
    }

    public boolean visit(ReturnStatement object) {
        this.ctx.putAttribute(object.getContainer(), "functionHasReturnStatement", new Boolean(true));
        if (object.getExpression() == null) {
            if (object.getContainer() instanceof Function && ((Function)object.getContainer()).getType() != null) {
                String temporary = this.ctx.nextTempName();
                LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                localDeclaration.setContainer(this.currentStatementContainer);
                DeclarationExpression declarationExpression = factory.createDeclarationExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                Field field = factory.createField();
                field.setName(temporary);
                field.setType(((Function)object.getContainer()).getType());
                field.setIsNullable(((Function)object.getContainer()).isNullable());
                MemberName nameExpression = factory.createMemberName();
                if (object.getAnnotation("EGL_Location") != null) {
                    nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                nameExpression.setMember((Member)field);
                nameExpression.setId(field.getCaseSensitiveName());
                declarationExpression.getFields().add(field);
                localDeclaration.setExpression(declarationExpression);
                this.verify(0).getStatements().add(localDeclaration);
                object.setExpression((Expression)nameExpression);
            }
        } else {
            if (((Boolean)this.ctx.invoke("isAssignmentArrayMatchingWanted", object.getExpression().getType(), new Object[]{this.ctx})).booleanValue() && object.getContainer() instanceof Function && ((Function)object.getContainer()).getType() != null && object.getExpression() instanceof ArrayLiteral) {
                this.processArrayLiteral(((Function)object.getContainer()).getType(), (ArrayLiteral)object.getExpression());
            }
            if (object.getExpression().getType() != null && CommonUtilities.hasSideEffects(object.getExpression(), this.ctx)) {
                String temporary = this.ctx.nextTempName();
                LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                localDeclaration.setContainer(this.currentStatementContainer);
                DeclarationExpression declarationExpression = factory.createDeclarationExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                Field field = factory.createField();
                field.setName(temporary);
                field.setType(object.getExpression().getType());
                field.setIsNullable(object.getExpression().isNullable());
                MemberName nameExpression = factory.createMemberName();
                if (object.getAnnotation("EGL_Location") != null) {
                    nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                nameExpression.setMember((Member)field);
                nameExpression.setId(field.getCaseSensitiveName());
                AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatement.setContainer(this.currentStatementContainer);
                Assignment assignment = factory.createAssignment();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatement.setAssignment(assignment);
                assignment.setLHS((LHSExpr)nameExpression);
                assignment.setRHS(object.getExpression());
                StatementBlock declarationBlock = factory.createStatementBlock();
                declarationBlock.setContainer(this.currentStatementContainer);
                declarationBlock.getStatements().add(assignmentStatement);
                field.setInitializerStatements(declarationBlock);
                field.setHasSetValuesBlock(Boolean.valueOf(true));
                declarationExpression.getFields().add(field);
                localDeclaration.setExpression(declarationExpression);
                this.verify(0).getStatements().add(localDeclaration);
                object.setExpression((Expression)nameExpression);
            }
        }
        return false;
    }

    public boolean visit(CallStatement object) {
        if (object.getInvocationTarget() instanceof MemberAccess && ((MemberAccess)object.getInvocationTarget()).getMember() instanceof Function && ((Boolean)this.ctx.invoke("isStatementRequiringWrappedParameters", (EObject)object, new Object[]{this.ctx})).booleanValue()) {
            Function serviceInterfaceFunction = (Function)((MemberAccess)object.getInvocationTarget()).getMember();
            FunctionInvocation invocation = factory.createFunctionInvocation();
            invocation.setTarget((Member)serviceInterfaceFunction);
            invocation.setId(serviceInterfaceFunction.getCaseSensitiveName());
            invocation.getArguments().addAll(object.getArguments());
            this.processInvocation((InvocationExpression)invocation);
        }
        return true;
    }

    public boolean visit(CaseStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(ForStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(ForEachStatement object) {
        ReorganizeLabel reorganizeLabel;
        if (CommonUtilities.hasSideEffects(object.getDataSource(), this.ctx)) {
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getDataSource().getType());
            field.setIsNullable(object.getDataSource().isNullable());
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getCaseSensitiveName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS(object.getDataSource());
            StatementBlock declarationBlock = factory.createStatementBlock();
            declarationBlock.setContainer(this.currentStatementContainer);
            declarationBlock.getStatements().add(assignmentStatement);
            field.setInitializerStatements(declarationBlock);
            field.setHasSetValuesBlock(Boolean.valueOf(true));
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            this.verify(0).getStatements().add(localDeclaration);
            object.setDataSource((Expression)nameExpression);
        }
        if ((reorganizeLabel = new ReorganizeLabel()).reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(OpenUIStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(WhileStatement object) {
        ReorganizeLabel reorganizeLabel;
        if (CommonUtilities.hasSideEffects(object.getCondition(), this.ctx)) {
            UnaryExpression unaryExpression = factory.createUnaryExpression();
            unaryExpression.setOperator("!");
            unaryExpression.setExpression(object.getCondition());
            IfStatement ifStatement = factory.createIfStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                ifStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            ifStatement.setContainer(this.currentStatementContainer);
            ifStatement.setCondition((Expression)unaryExpression);
            StatementBlock statementBlock = factory.createStatementBlock();
            statementBlock.setContainer(ifStatement.getContainer());
            ExitStatement exitStatement = factory.createExitStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                exitStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            exitStatement.setContainer(statementBlock.getContainer());
            exitStatement.setExitStatementType(Integer.valueOf(4));
            statementBlock.getStatements().add(exitStatement);
            ifStatement.setTrueBranch((Statement)statementBlock);
            BooleanLiteral booleanLiteral = factory.createBooleanLiteral();
            booleanLiteral.setBooleanValue(Boolean.valueOf(true));
            object.setCondition((Expression)booleanLiteral);
            ((StatementBlock)object.getBody()).getStatements().add(0, ifStatement);
        }
        if ((reorganizeLabel = new ReorganizeLabel()).reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(IfStatement object) {
        ReorganizeLabel reorganizeLabel;
        if (CommonUtilities.hasSideEffects(object.getCondition(), this.ctx)) {
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getCondition().getType());
            field.setIsNullable(object.getCondition().isNullable());
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getCaseSensitiveName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS(object.getCondition());
            StatementBlock declarationBlock = factory.createStatementBlock();
            declarationBlock.setContainer(this.currentStatementContainer);
            declarationBlock.getStatements().add(assignmentStatement);
            field.setInitializerStatements(declarationBlock);
            field.setHasSetValuesBlock(Boolean.valueOf(true));
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            this.verify(0).getStatements().add(localDeclaration);
            object.setCondition((Expression)nameExpression);
        }
        if ((reorganizeLabel = new ReorganizeLabel()).reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        if (object.getFalseBranch() != null && !(object.getFalseBranch() instanceof StatementBlock)) {
            StatementBlock block = factory.createStatementBlock();
            block.setContainer(this.currentStatementContainer);
            block.getStatements().add(object.getFalseBranch());
            object.setFalseBranch((Statement)block);
        }
        return false;
    }

    public boolean visit(BinaryExpression object) {
        if (object.getLHS().getType() != null && object.getLHS().getType().getClassifier() != null && object.getLHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue() && object.getOperator() != null && object.getOperator().equals("::")) {
            if (((Boolean)this.ctx.invoke("isListReorganizationWanted", object.getLHS().getType(), new Object[]{this.ctx, object})).booleanValue()) {
                String temporary = this.ctx.nextTempName();
                LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                localDeclaration.setContainer(this.currentStatementContainer);
                DeclarationExpression declarationExpression = factory.createDeclarationExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                ArrayTypeScanner arrayTypeScanner1 = new ArrayTypeScanner();
                Field field = factory.createField();
                field.setName(temporary);
                field.setType((Type)arrayTypeScanner1.scan(object.getLHS()));
                field.setIsNullable(true);
                declarationExpression.getFields().add(field);
                localDeclaration.setExpression(declarationExpression);
                this.verify(0).getStatements().add(localDeclaration);
                NewExpression newExpression = factory.createNewExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    newExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                newExpression.setId(field.getType().getTypeSignature());
                MemberName nameExpression = factory.createMemberName();
                if (object.getAnnotation("EGL_Location") != null) {
                    nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                nameExpression.setMember((Member)field);
                nameExpression.setId(field.getCaseSensitiveName());
                AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatement.setContainer(this.currentStatementContainer);
                Assignment assignment = factory.createAssignment();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatement.setAssignment(assignment);
                assignment.setLHS((LHSExpr)nameExpression);
                assignment.setRHS((Expression)newExpression);
                this.verify(0).getStatements().add(assignmentStatement);
                if (object.getLHS() instanceof BinaryExpression) {
                    String temporaryBin = this.ctx.nextTempName();
                    LocalVariableDeclarationStatement localDeclarationBin = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclarationBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclarationBin.setContainer(this.currentStatementContainer);
                    DeclarationExpression declarationExpressionBin = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    ArrayTypeScanner arrayTypeScanner2 = new ArrayTypeScanner();
                    Field fieldBin = factory.createField();
                    fieldBin.setName(temporaryBin);
                    fieldBin.setType((Type)arrayTypeScanner2.scan(object.getLHS()));
                    fieldBin.setIsNullable(true);
                    declarationExpressionBin.getFields().add(fieldBin);
                    localDeclarationBin.setExpression(declarationExpressionBin);
                    this.verify(0).getStatements().add(localDeclarationBin);
                    MemberName nameExpressionBin = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpressionBin.setMember((Member)fieldBin);
                    nameExpressionBin.setId(fieldBin.getCaseSensitiveName());
                    AssignmentStatement assignmentStatementBin = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatementBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatementBin.setContainer(this.currentStatementContainer);
                    Assignment assignmentBin = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatementBin.setAssignment(assignmentBin);
                    assignmentBin.setLHS((LHSExpr)nameExpressionBin);
                    assignmentBin.setRHS(object.getLHS());
                    this.verify(0).getStatements().add(assignmentStatementBin);
                    object.setLHS((Expression)nameExpressionBin);
                }
                QualifiedFunctionInvocation invocationCopy = factory.createQualifiedFunctionInvocation();
                if (object.getAnnotation("EGL_Location") != null) {
                    invocationCopy.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                invocationCopy.setId("appendAll");
                invocationCopy.setQualifier((Expression)nameExpression);
                invocationCopy.getArguments().add(object.getLHS());
                FunctionStatement functionStatementCopy = factory.createFunctionStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    functionStatementCopy.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                functionStatementCopy.setExpr((Expression)invocationCopy);
                this.verify(0).getStatements().add(functionStatementCopy);
                if (object.getRHS() instanceof BinaryExpression) {
                    String temporaryBin = this.ctx.nextTempName();
                    LocalVariableDeclarationStatement localDeclarationBin = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclarationBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclarationBin.setContainer(this.currentStatementContainer);
                    DeclarationExpression declarationExpressionBin = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    ArrayTypeScanner arrayTypeScanner2 = new ArrayTypeScanner();
                    Field fieldBin = factory.createField();
                    fieldBin.setName(temporaryBin);
                    fieldBin.setType((Type)arrayTypeScanner2.scan(object.getRHS()));
                    fieldBin.setIsNullable(true);
                    declarationExpressionBin.getFields().add(fieldBin);
                    localDeclarationBin.setExpression(declarationExpressionBin);
                    this.verify(0).getStatements().add(localDeclarationBin);
                    MemberName nameExpressionBin = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpressionBin.setMember((Member)fieldBin);
                    nameExpressionBin.setId(fieldBin.getCaseSensitiveName());
                    AssignmentStatement assignmentStatementBin = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatementBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatementBin.setContainer(this.currentStatementContainer);
                    Assignment assignmentBin = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatementBin.setAssignment(assignmentBin);
                    assignmentBin.setLHS((LHSExpr)nameExpressionBin);
                    assignmentBin.setRHS(object.getRHS());
                    this.verify(0).getStatements().add(assignmentStatementBin);
                    QualifiedFunctionInvocation invocationBin = factory.createQualifiedFunctionInvocation();
                    if (object.getAnnotation("EGL_Location") != null) {
                        invocationBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    if (object.getRHS().getType() != null && object.getRHS().getType().getClassifier() != null && object.getRHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue()) {
                        invocationBin.setId("appendAll");
                    } else {
                        invocationBin.setId("appendElement");
                    }
                    invocationBin.setQualifier((Expression)nameExpression);
                    invocationBin.getArguments().add(nameExpressionBin);
                    FunctionStatement functionStatementBin = factory.createFunctionStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        functionStatementBin.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    functionStatementBin.setExpr((Expression)invocationBin);
                    this.verify(0).getStatements().add(functionStatementBin);
                    object.setRHS((Expression)nameExpressionBin);
                } else {
                    QualifiedFunctionInvocation invocation = factory.createQualifiedFunctionInvocation();
                    if (object.getAnnotation("EGL_Location") != null) {
                        invocation.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    if (object.getRHS().getType() != null && object.getRHS().getType().getClassifier() != null && object.getRHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue()) {
                        invocation.setId("appendAll");
                    } else {
                        invocation.setId("appendElement");
                    }
                    invocation.setQualifier((Expression)nameExpression);
                    invocation.getArguments().add(object.getRHS());
                    FunctionStatement functionStatement = factory.createFunctionStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        functionStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    functionStatement.setExpr((Expression)invocation);
                    this.verify(0).getStatements().add(functionStatement);
                }
                if (this.getParent() instanceof List) {
                    ((List)this.getParent()).set(this.getParentSlotIndex(), nameExpression);
                } else {
                    ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)nameExpression);
                }
            }
        } else if (object.getRHS().getType() != null && object.getRHS().getType().getClassifier() != null && object.getRHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue() && object.getOperator() != null && object.getOperator().equals("::") && ((Boolean)this.ctx.invoke("isListReorganizationWanted", object.getRHS().getType(), new Object[]{this.ctx, object})).booleanValue()) {
            Assignment assignmentBin;
            AssignmentStatement assignmentStatementBin;
            MemberName nameExpressionBin;
            Field fieldBin;
            ArrayTypeScanner arrayTypeScanner2;
            DeclarationExpression declarationExpressionBin;
            LocalVariableDeclarationStatement localDeclarationBin;
            String temporaryBin;
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            ArrayTypeScanner arrayTypeScanner1 = new ArrayTypeScanner();
            Field field = factory.createField();
            field.setName(temporary);
            field.setType((Type)arrayTypeScanner1.scan(object.getRHS()));
            field.setIsNullable(true);
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            this.verify(0).getStatements().add(localDeclaration);
            NewExpression newExpression = factory.createNewExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                newExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            newExpression.setId(field.getType().getTypeSignature());
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getCaseSensitiveName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS((Expression)newExpression);
            this.verify(0).getStatements().add(assignmentStatement);
            if (object.getLHS() instanceof BinaryExpression) {
                temporaryBin = this.ctx.nextTempName();
                localDeclarationBin = factory.createLocalVariableDeclarationStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    localDeclarationBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                localDeclarationBin.setContainer(this.currentStatementContainer);
                declarationExpressionBin = factory.createDeclarationExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    declarationExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                arrayTypeScanner2 = new ArrayTypeScanner();
                fieldBin = factory.createField();
                fieldBin.setName(temporaryBin);
                fieldBin.setType((Type)arrayTypeScanner2.scan(object.getLHS()));
                fieldBin.setIsNullable(true);
                declarationExpressionBin.getFields().add(fieldBin);
                localDeclarationBin.setExpression(declarationExpressionBin);
                this.verify(0).getStatements().add(localDeclarationBin);
                nameExpressionBin = factory.createMemberName();
                if (object.getAnnotation("EGL_Location") != null) {
                    nameExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                nameExpressionBin.setMember((Member)fieldBin);
                nameExpressionBin.setId(fieldBin.getCaseSensitiveName());
                assignmentStatementBin = factory.createAssignmentStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignmentStatementBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatementBin.setContainer(this.currentStatementContainer);
                assignmentBin = factory.createAssignment();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignmentBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatementBin.setAssignment(assignmentBin);
                assignmentBin.setLHS((LHSExpr)nameExpressionBin);
                assignmentBin.setRHS(object.getLHS());
                this.verify(0).getStatements().add(assignmentStatementBin);
                QualifiedFunctionInvocation invocationBin = factory.createQualifiedFunctionInvocation();
                if (object.getAnnotation("EGL_Location") != null) {
                    invocationBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                if (object.getLHS().getType() != null && object.getLHS().getType().getClassifier() != null && object.getLHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue()) {
                    invocationBin.setId("appendAll");
                } else {
                    invocationBin.setId("appendElement");
                }
                invocationBin.setQualifier((Expression)nameExpression);
                invocationBin.getArguments().add(nameExpressionBin);
                FunctionStatement functionStatementBin = factory.createFunctionStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    functionStatementBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                functionStatementBin.setExpr((Expression)invocationBin);
                this.verify(0).getStatements().add(functionStatementBin);
                object.setLHS((Expression)nameExpressionBin);
            } else {
                QualifiedFunctionInvocation invocation = factory.createQualifiedFunctionInvocation();
                if (object.getAnnotation("EGL_Location") != null) {
                    invocation.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                if (object.getLHS().getType() != null && object.getLHS().getType().getClassifier() != null && object.getLHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue()) {
                    invocation.setId("appendAll");
                } else {
                    invocation.setId("appendElement");
                }
                invocation.setQualifier((Expression)nameExpression);
                invocation.getArguments().add(object.getLHS());
                FunctionStatement functionStatement = factory.createFunctionStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    functionStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                functionStatement.setExpr((Expression)invocation);
                this.verify(0).getStatements().add(functionStatement);
            }
            if (object.getRHS() instanceof BinaryExpression) {
                temporaryBin = this.ctx.nextTempName();
                localDeclarationBin = factory.createLocalVariableDeclarationStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    localDeclarationBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                localDeclarationBin.setContainer(this.currentStatementContainer);
                declarationExpressionBin = factory.createDeclarationExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    declarationExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                arrayTypeScanner2 = new ArrayTypeScanner();
                fieldBin = factory.createField();
                fieldBin.setName(temporaryBin);
                fieldBin.setType((Type)arrayTypeScanner2.scan(object.getRHS()));
                fieldBin.setIsNullable(true);
                declarationExpressionBin.getFields().add(fieldBin);
                localDeclarationBin.setExpression(declarationExpressionBin);
                this.verify(0).getStatements().add(localDeclarationBin);
                nameExpressionBin = factory.createMemberName();
                if (object.getAnnotation("EGL_Location") != null) {
                    nameExpressionBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                nameExpressionBin.setMember((Member)fieldBin);
                nameExpressionBin.setId(fieldBin.getCaseSensitiveName());
                assignmentStatementBin = factory.createAssignmentStatement();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignmentStatementBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatementBin.setContainer(this.currentStatementContainer);
                assignmentBin = factory.createAssignment();
                if (object.getAnnotation("EGL_Location") != null) {
                    assignmentBin.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                assignmentStatementBin.setAssignment(assignmentBin);
                assignmentBin.setLHS((LHSExpr)nameExpressionBin);
                assignmentBin.setRHS(object.getRHS());
                this.verify(0).getStatements().add(assignmentStatementBin);
                object.setRHS((Expression)nameExpressionBin);
            }
            QualifiedFunctionInvocation invocationCopy = factory.createQualifiedFunctionInvocation();
            if (object.getAnnotation("EGL_Location") != null) {
                invocationCopy.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            invocationCopy.setId("appendAll");
            invocationCopy.setQualifier((Expression)nameExpression);
            invocationCopy.getArguments().add(object.getRHS());
            FunctionStatement functionStatementCopy = factory.createFunctionStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                functionStatementCopy.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            functionStatementCopy.setExpr((Expression)invocationCopy);
            this.verify(0).getStatements().add(functionStatementCopy);
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), nameExpression);
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)nameExpression);
            }
        }
        return true;
    }

    public boolean visit(SetValuesExpression object) {
        boolean hasSideEffects = CommonUtilities.hasSideEffects(object.getTarget(), this.ctx);
        if (hasSideEffects) {
            String temporary = this.ctx.nextLogicallyNotNullableTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getType());
            field.setIsNullable(true);
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            this.verify(0).getStatements().add(0, localDeclaration);
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getCaseSensitiveName());
            declarationExpression = ((LocalVariableDeclarationStatement)object.getSettings().getStatements().get(0)).getExpression();
            MemberName tempExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                tempExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            tempExpression.setMember((Member)declarationExpression.getFields().get(0));
            tempExpression.setId(((Field)declarationExpression.getFields().get(0)).getCaseSensitiveName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS((Expression)tempExpression);
            object.getSettings().getStatements().add(assignmentStatement);
            this.verify(0).getStatements().add(1, object.getSettings());
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), nameExpression);
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)nameExpression);
            }
        } else {
            this.verify(1).getStatements().add(object.getSettings());
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), object.getTarget());
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)object.getTarget());
            }
        }
        return false;
    }

    public boolean visit(QualifiedFunctionInvocation object) {
        this.processInvocation((InvocationExpression)object);
        if ((object.getId().equalsIgnoreCase("appendElement") || object.getId().equalsIgnoreCase("insertElement") || object.getId().equalsIgnoreCase("setElement")) && object.getQualifier().getType() instanceof ArrayType && ((Boolean)this.ctx.invoke("isAssignmentArrayMatchingWanted", object.getQualifier().getType(), new Object[]{this.ctx})).booleanValue()) {
            int i = 0;
            while (i < object.getArguments().size()) {
                if (object.getArguments().get(i) instanceof ArrayLiteral) {
                    this.processArrayLiteral(object.getQualifier().getType(), (ArrayLiteral)object.getArguments().get(i));
                }
                ++i;
            }
        }
        if ((object.getId().equalsIgnoreCase("decimals") || object.getId().equalsIgnoreCase("precision")) && object.getQualifier() instanceof PartName && ((PartName)object.getQualifier()).getId().equalsIgnoreCase("MathLib") && object.getArguments().size() == 1 && !(object.getArguments().get(0) instanceof BoxingExpression) && ((Boolean)this.ctx.invoke("isMathLibDecimalBoxingWanted", ((Expression)object.getArguments().get(0)).getType(), new Object[]{this.ctx})).booleanValue()) {
            BoxingExpression boxingExpression = factory.createBoxingExpression();
            boxingExpression.setExpr((Expression)object.getArguments().get(0));
            object.getArguments().set(0, boxingExpression);
        }
        if (object.getId().equalsIgnoreCase("format") && object.getQualifier() instanceof PartName && ((PartName)object.getQualifier()).getId().equalsIgnoreCase("StringLib") && object.getArguments().size() == 2 && !(object.getArguments().get(0) instanceof BoxingExpression) && ((Boolean)this.ctx.invoke("isStringLibFormatBoxingWanted", ((Expression)object.getArguments().get(0)).getType(), new Object[]{this.ctx})).booleanValue()) {
            BoxingExpression boxingExpression = factory.createBoxingExpression();
            boxingExpression.setExpr((Expression)object.getArguments().get(0));
            object.getArguments().set(0, boxingExpression);
        }
        return true;
    }

    public boolean visit(FunctionInvocation object) {
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    public boolean visit(DelegateInvocation object) {
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    private void processInvocation(InvocationExpression object) {
        int i = 0;
        while (i < object.getArguments().size()) {
            if (((FunctionParameter)object.getTarget().getParameters().get(i)).getType() instanceof ArrayType && object.getArguments().get(i) instanceof ArrayLiteral && ((Boolean)this.ctx.invoke("isAssignmentArrayMatchingWanted", ((Expression)object.getArguments().get(i)).getType(), new Object[]{this.ctx})).booleanValue()) {
                this.processArrayLiteral(((FunctionParameter)object.getTarget().getParameters().get(i)).getType(), (ArrayLiteral)object.getArguments().get(i));
            }
            ++i;
        }
        boolean altered = false;
        boolean[] argumentToBeAltered = new boolean[object.getTarget().getParameters().size()];
        int i2 = 0;
        while (i2 < object.getTarget().getParameters().size()) {
            if (CommonUtilities.isArgumentToBeAltered((FunctionParameter)object.getTarget().getParameters().get(i2), (Expression)object.getArguments().get(i2), this.ctx)) {
                altered = true;
                argumentToBeAltered[i2] = true;
            }
            ++i2;
        }
        if (!altered) {
            return;
        }
        i2 = 0;
        while (i2 < object.getTarget().getParameters().size()) {
            FunctionParameter parameter = (FunctionParameter)object.getTarget().getParameters().get(i2);
            if (argumentToBeAltered[i2]) {
                StatementBlock declarationBlock;
                Assignment assignment;
                AssignmentStatement assignmentStatement;
                MemberName nameExpression;
                Field field;
                DeclarationExpression declarationExpression;
                LocalVariableDeclarationStatement localDeclaration;
                String temporary;
                if (parameter.getParameterKind() == ParameterKind.PARM_IN) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getCaseSensitiveName());
                    assignmentStatement = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setContainer(this.currentStatementContainer);
                    assignment = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setAssignment(assignment);
                    assignment.setLHS((LHSExpr)nameExpression);
                    assignment.setRHS((Expression)object.getArguments().get(i2));
                    declarationBlock = factory.createStatementBlock();
                    declarationBlock.setContainer(this.currentStatementContainer);
                    declarationBlock.getStatements().add(assignmentStatement);
                    field.setInitializerStatements(declarationBlock);
                    field.setHasSetValuesBlock(Boolean.valueOf(true));
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_IN);
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    this.verify(0).getStatements().add(localDeclaration);
                    object.getArguments().set(i2, nameExpression);
                } else if (parameter.getParameterKind() == ParameterKind.PARM_INOUT) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_INOUT);
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getCaseSensitiveName());
                    assignmentStatement = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setContainer(this.currentStatementContainer);
                    assignment = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setAssignment(assignment);
                    assignment.setLHS((LHSExpr)nameExpression);
                    assignment.setRHS((Expression)object.getArguments().get(i2));
                    declarationBlock = factory.createStatementBlock();
                    declarationBlock.setContainer(this.currentStatementContainer);
                    declarationBlock.getStatements().add(assignmentStatement);
                    field.setInitializerStatements(declarationBlock);
                    field.setHasSetValuesBlock(Boolean.valueOf(true));
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    this.verify(0).getStatements().add(localDeclaration);
                    if (object.getArguments().get(i2) instanceof LHSExpr) {
                        assignmentStatement = factory.createAssignmentStatement();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setContainer(this.currentStatementContainer);
                        assignment = factory.createAssignment();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setAssignment(assignment);
                        assignment.setLHS((LHSExpr)object.getArguments().get(i2));
                        assignment.setRHS((Expression)nameExpression);
                        this.verify(1).getStatements().add(assignmentStatement);
                    }
                    object.getArguments().set(i2, nameExpression);
                } else if (parameter.getParameterKind() == ParameterKind.PARM_OUT) {
                    String temporaryWork = this.ctx.nextTempName();
                    LocalVariableDeclarationStatement localDeclarationWork = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclarationWork.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclarationWork.setContainer(this.currentStatementContainer);
                    DeclarationExpression declarationExpressionWork = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpressionWork.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    Field fieldWork = factory.createField();
                    fieldWork.setName(temporaryWork);
                    fieldWork.setType(parameter.getType());
                    fieldWork.setIsNullable(((Expression)object.getArguments().get(i2)).isNullable());
                    MemberName nameExpressionWork = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpressionWork.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpressionWork.setMember((Member)fieldWork);
                    nameExpressionWork.setId(fieldWork.getCaseSensitiveName());
                    declarationExpressionWork.getFields().add(fieldWork);
                    localDeclarationWork.setExpression(declarationExpressionWork);
                    this.verify(0).getStatements().add(localDeclarationWork);
                    String temporary2 = this.ctx.nextTempName();
                    LocalVariableDeclarationStatement localDeclaration2 = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration2.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration2.setContainer(this.currentStatementContainer);
                    DeclarationExpression declarationExpression2 = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression2.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    Field field2 = factory.createField();
                    field2.setName(temporary2);
                    field2.setType(parameter.getType());
                    field2.setIsNullable(parameter.isNullable());
                    this.ctx.putAttribute(field2, "functionArgumentTemporaryVariable", ParameterKind.PARM_OUT);
                    MemberName nameExpression2 = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression2.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression2.setMember((Member)field2);
                    nameExpression2.setId(field2.getCaseSensitiveName());
                    AssignmentStatement assignmentStatement2 = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatement2.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement2.setContainer(this.currentStatementContainer);
                    Assignment assignment2 = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignment2.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement2.setAssignment(assignment2);
                    assignment2.setLHS((LHSExpr)nameExpression2);
                    assignment2.setRHS((Expression)nameExpressionWork);
                    StatementBlock declarationBlock2 = factory.createStatementBlock();
                    declarationBlock2.setContainer(this.currentStatementContainer);
                    declarationBlock2.getStatements().add(assignmentStatement2);
                    field2.setInitializerStatements(declarationBlock2);
                    field2.setHasSetValuesBlock(Boolean.valueOf(true));
                    declarationExpression2.getFields().add(field2);
                    localDeclaration2.setExpression(declarationExpression2);
                    this.verify(0).getStatements().add(localDeclaration2);
                    if (object.getArguments().get(i2) instanceof LHSExpr) {
                        assignmentStatement2 = factory.createAssignmentStatement();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignmentStatement2.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement2.setContainer(this.currentStatementContainer);
                        assignment2 = factory.createAssignment();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignment2.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement2.setAssignment(assignment2);
                        assignment2.setLHS((LHSExpr)object.getArguments().get(i2));
                        assignment2.setRHS((Expression)nameExpression2);
                        this.verify(1).getStatements().add(assignmentStatement2);
                    }
                    object.getArguments().set(i2, nameExpression2);
                }
            }
            ++i2;
        }
    }

    public class ArrayTypeScanner
    extends AbstractVisitor {
        private ArrayType arrType;

        public ArrayType scan(Expression expr) {
            this.disallowRevisit();
            expr.accept((EVisitor)this);
            return this.arrType;
        }

        public ArrayType getArrayType() {
            return this.arrType;
        }

        public boolean visit(EObject obj) {
            return false;
        }

        public boolean visit(QualifiedFunctionInvocation inv) {
            if (this.arrType == null) {
                if (inv.getType() instanceof ArrayType) {
                    this.arrType = (ArrayType)inv.getType();
                } else if (this.isList(inv.getType())) {
                    inv.getQualifier().accept((EVisitor)this);
                }
            }
            return false;
        }

        public boolean visit(Expression expr) {
            if (this.arrType == null && expr.getType() instanceof ArrayType) {
                this.arrType = (ArrayType)expr.getType();
            }
            return false;
        }

        public boolean visit(BinaryExpression binExp) {
            if (this.isArrayOrList(binExp.getLHS().getType())) {
                binExp.getLHS().accept((EVisitor)this);
            } else if (this.isArrayOrList(binExp.getRHS().getType())) {
                binExp.getRHS().accept((EVisitor)this);
            }
            return false;
        }

        private boolean isArrayOrList(Type type) {
            return type instanceof ArrayType || this.isList(type);
        }

        private boolean isList(Type type) {
            return type != null && type.equals(TypeUtils.Type_LIST) != false;
        }
    }

    public class ReorganizeLabel
    extends AbstractVisitor {
        EglContext ctx;
        boolean needsLabel;
        boolean processed;
        int labelType;

        public boolean reorgLabel(Statement statement, EglContext ctx) {
            this.ctx = ctx;
            this.disallowRevisit();
            this.allowParentTracking();
            statement.accept((EVisitor)this);
            return this.needsLabel;
        }

        public boolean visit(EObject object) {
            return true;
        }

        public boolean visit(Function object) {
            return false;
        }

        public boolean visit(Type object) {
            return false;
        }

        public boolean visit(Operation object) {
            return false;
        }

        public boolean visit(ContinueStatement object) {
            if (object.getLabel() == null || object.getLabel().length() <= 0) {
                if (object.getContinueType() == 1 && this.labelType == 2) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 2 && this.labelType == 3) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 3 && this.labelType == 5) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 4 && this.labelType == 6) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 0) {
                    this.needsLabel = true;
                }
            }
            return false;
        }

        public boolean visit(ExitStatement object) {
            if (object.getLabel() == null || object.getLabel().length() <= 0) {
                if (object.getExitStatementType() == 1 && this.labelType == 1) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 3 && this.labelType == 2) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 5 && this.labelType == 3) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 2 && this.labelType == 4) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 6 && this.labelType == 5) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 4 && this.labelType == 6) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() != 9 && object.getExitStatementType() != 7 && object.getExitStatementType() != 9 && object.getExitStatementType() == 0) {
                    this.needsLabel = true;
                }
            }
            return false;
        }

        public boolean visit(CaseStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 1;
                return true;
            }
            return this.labelType != 1;
        }

        public boolean visit(ForStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 2;
                return true;
            }
            return this.labelType != 2;
        }

        public boolean visit(ForEachStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 3;
                return true;
            }
            return this.labelType != 3;
        }

        public boolean visit(IfStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 4;
                return true;
            }
            return this.labelType != 4;
        }

        public boolean visit(OpenUIStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 5;
                return true;
            }
            return this.labelType != 5;
        }

        public boolean visit(WhileStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 6;
                return true;
            }
            return this.labelType != 6;
        }

        public boolean visit(Statement object) {
            return true;
        }
    }
}

