/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.errors.EGLPartialParser;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.editor.EGLContentAssistInvocationContext;
import org.eclipse.edt.ide.ui.editor.IEGLCompletionProposalComputer;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;

public class EGLCompletionProposalComputer
implements IEGLCompletionProposalComputer {
    private static final long EGL_CODE_ASSIST_TIMEOUT = Long.getLong("org.eclipse.edt.ide.ui.codeAssistTimeout", 5000L);
    private String fErrorMessage;
    private final IProgressMonitor fTimeoutProgressMonitor;
    private EGLPartialParser parser = new EGLPartialParser();

    public EGLPartialParser getParser() {
        return this.parser;
    }

    public EGLCompletionProposalComputer() {
        this.fTimeoutProgressMonitor = this.createTimeoutProgressMonitor(EGL_CODE_ASSIST_TIMEOUT);
    }

    protected int guessContextInformationPosition(EGLContentAssistInvocationContext context) {
        return context.getInvocationOffset();
    }

    @Override
    public List computeContextInformation(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List computeCompletionProposals(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    private IProgressMonitor createTimeoutProgressMonitor(final long timeout) {
        return new IProgressMonitor(){
            private long fEndTime;

            public void beginTask(String name, int totalWork) {
                this.fEndTime = System.currentTimeMillis() + timeout;
            }

            public boolean isCanceled() {
                return this.fEndTime <= System.currentTimeMillis();
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        };
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    protected boolean inNativeFunction(EGLContentAssistInvocationContext ctx) {
        IEGLDocument document = (IEGLDocument)ctx.getDocument();
        Node node = EGLModelUtility.getNestedPartNode(document, ctx.getInvocationOffset());
        while (node != null) {
            Library library;
            if (node instanceof Library && (library = (Library)node).hasSubType() && NameUtile.equals((String)library.getSubType().getIdentifier(), (String)NameUtile.getAsName((String)"NativeLibrary"))) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    protected String getPrefix(ITextViewer viewer, int documentOffset) {
        EGLDocument document = (EGLDocument)viewer.getDocument();
        Node node = document.getNewModelNodeAtOffset(documentOffset);
        while (node != null && !(node instanceof Part)) {
            node = node.getParent();
        }
        int previousPartOffset = 0;
        if (node != null) {
            int currentPartOffset = node.getOffset();
            node = document.getNewModelNodeAtOffset(currentPartOffset == 0 ? 0 : currentPartOffset - 1);
            while (node != null && !(node instanceof Part)) {
                node = node.getParent();
            }
            if (node != null) {
                previousPartOffset = node.getOffset();
            }
        }
        String partialSource = "";
        try {
            partialSource = document.get(previousPartOffset, documentOffset - previousPartOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return partialSource;
    }

    protected String getPrefix(List prefixNodes) {
        List strippedPrefix = this.stripInitialWhitespaces(prefixNodes);
        StringBuffer buffer = new StringBuffer();
        for (ParseNode node : strippedPrefix) {
            buffer.append(this.getText(node));
        }
        return buffer.length() == 0 ? "" : buffer.toString();
    }

    private List stripInitialWhitespaces(List prefixNodes) {
        int i = 0;
        while (i < prefixNodes.size()) {
            ParseNode node = (ParseNode)prefixNodes.get(i);
            if (!node.isWhiteSpace()) {
                return prefixNodes.subList(i, prefixNodes.size());
            }
            ++i;
        }
        return new ArrayList();
    }

    private String getText(ParseNode node) {
        if (node.isTerminal()) {
            switch (((TerminalNode)node).terminalType) {
                case 7: {
                    return "#sql{}";
                }
            }
        }
        return node.getText();
    }
}

