/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.BitSet;
import org.eclipse.edt.ide.core.internal.errors.ErrorGrammar;

public class EGLContextBoundaryUtility {
    private static final EGLContextBoundaryUtility INSTANCE = new EGLContextBoundaryUtility();
    private ErrorGrammar grammar = ErrorGrammar.getInstance();
    private BitSet boundaryStatesSet;

    public static EGLContextBoundaryUtility getInstance() {
        return INSTANCE;
    }

    public boolean isBoundaryState(int state) {
        short[] nonterminalCandidates = this.grammar.getNonTerminalCandidates(state);
        int i = 0;
        while (i < nonterminalCandidates.length) {
            if (this.getBoundarySet().get(nonterminalCandidates[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private BitSet getBoundarySet() {
        if (this.boundaryStatesSet == null) {
            this.initBoundaryStatesSet();
        }
        return this.boundaryStatesSet;
    }

    private void initBoundaryStatesSet() {
        this.boundaryStatesSet = new BitSet(500);
        this.boundaryStatesSet.set(31);
        this.boundaryStatesSet.set(59);
        this.boundaryStatesSet.set(42);
        this.boundaryStatesSet.set(60);
        this.boundaryStatesSet.set(78);
        this.boundaryStatesSet.set(77);
        this.boundaryStatesSet.set(35);
        this.boundaryStatesSet.set(67);
        this.boundaryStatesSet.set(14);
        this.boundaryStatesSet.set(76);
        this.boundaryStatesSet.set(66);
        this.boundaryStatesSet.set(36);
        this.boundaryStatesSet.set(20);
        this.boundaryStatesSet.set(38);
        this.boundaryStatesSet.set(49);
        this.boundaryStatesSet.set(5);
        this.boundaryStatesSet.set(80);
        this.boundaryStatesSet.set(18);
        this.boundaryStatesSet.set(25);
        this.boundaryStatesSet.set(19);
        this.boundaryStatesSet.set(34);
        this.boundaryStatesSet.set(24);
        this.boundaryStatesSet.set(44);
        this.boundaryStatesSet.set(21);
        this.boundaryStatesSet.set(58);
        this.boundaryStatesSet.set(56);
        this.boundaryStatesSet.set(26);
        this.boundaryStatesSet.set(65);
        this.boundaryStatesSet.set(72);
        this.boundaryStatesSet.set(71);
        this.boundaryStatesSet.set(50);
        this.boundaryStatesSet.set(54);
    }
}

