/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.awt.Point;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLProposalContextInformation;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PatternType;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public abstract class EGLAbstractProposalHandler {
    protected static final String PROPOSAL_PART_REFERENCE_STRING = "{0}/{1}/{2} ({3})";
    protected static final String PROPOSAL_VARIABLE_DOT_STRING = "{0} ({1})";
    static final String[] EGLPERSISTENCE = new String[]{"eglx", "persistence"};
    static final String[] EGLLANG = new String[]{"eglx", "lang"};
    private int documentOffset;
    private String prefix;
    protected IEditorPart editor;
    protected ITextViewer viewer;

    public EGLAbstractProposalHandler(ITextViewer viewer, int documentOffset, String prefix) {
        this(viewer, documentOffset, prefix, null);
    }

    public EGLAbstractProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor) {
        this.viewer = viewer;
        this.documentOffset = documentOffset;
        this.prefix = prefix;
        this.editor = editor;
        if (editor != null) {
            IFileEditorInput cfr_ignored_0 = (IFileEditorInput)editor.getEditorInput();
        }
    }

    public IEGLSearchScope createProjectSearchScope() {
        IFileEditorInput editorInput = (IFileEditorInput)this.editor.getEditorInput();
        return this.createSearchScope((IResource)editorInput.getFile().getProject());
    }

    private IEGLSearchScope createSearchScope(IResource resource) {
        IEGLElement[] elements = new IEGLElement[]{EGLCore.create((IResource)resource)};
        return SearchEngine.createEGLSearchScope((IEGLElement[])elements);
    }

    public int getDocumentOffset() {
        return this.documentOffset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ITextViewer getViewer() {
        return this.viewer;
    }

    protected Node getPart() {
        IEGLDocument document = (IEGLDocument)this.getViewer().getDocument();
        return EGLModelUtility.getPartNode(document, this.getDocumentOffset());
    }

    protected Point getFirstParmSelection(String replacementString) {
        int cursorPosition = replacementString.indexOf(40);
        int selectionLength = replacementString.indexOf(44);
        int closedParenOffset = replacementString.indexOf(41);
        if ((selectionLength = selectionLength > 0 ? selectionLength - cursorPosition - 1 : closedParenOffset - cursorPosition - 1) == 0) {
            cursorPosition = replacementString.length() - 1;
        }
        if (cursorPosition > 0) {
            return new Point(cursorPosition + 1, selectionLength);
        }
        return new Point(replacementString.length(), selectionLength);
    }

    protected boolean containsProperty(final String propertyString, List propertyBlockList) {
        if (propertyBlockList != null) {
            for (SettingsBlock propertyBlock : propertyBlockList) {
                final boolean[] foundMatch = new boolean[1];
                Iterator pIter = propertyBlock.getSettings().iterator();
                while (pIter.hasNext() && !foundMatch[0]) {
                    ((Node)pIter.next()).accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(Assignment assignment) {
                            foundMatch[0] = assignment.getLeftHandSide().getCanonicalString().equalsIgnoreCase(propertyString);
                            return false;
                        }

                        public boolean visit(SetValuesExpression setValuesExpression) {
                            setValuesExpression.getExpression().accept((IASTVisitor)this);
                            return false;
                        }

                        public boolean visit(AnnotationExpression annotationExpression) {
                            foundMatch[0] = annotationExpression.getName().getCanonicalName().equalsIgnoreCase(propertyString);
                            return false;
                        }

                        public boolean visit(SimpleName name) {
                            foundMatch[0] = name.getCanonicalName().equalsIgnoreCase(propertyString);
                            return false;
                        }
                    });
                }
                if (!foundMatch[0]) continue;
                return true;
            }
        }
        return false;
    }

    public String getPartReferenceAdditionalInformation(String packageName, PartDeclarationInfo part, String partTypeString) {
        String extension = "egl";
        if (part.isBinary()) {
            extension = ".eglxml";
        }
        if (packageName.trim().length() > 0) {
            return MessageFormat.format(PROPOSAL_PART_REFERENCE_STRING, part.getProject(), part.getFolder(), String.valueOf(packageName) + "/" + part.getFileName() + "." + extension, partTypeString);
        }
        return MessageFormat.format(PROPOSAL_PART_REFERENCE_STRING, part.getProject(), part.getFolder(), String.valueOf(part.getFileName()) + "." + extension, partTypeString);
    }

    protected static String getTypeString(Type type) {
        if (type == null) {
            return "";
        }
        if (type instanceof ArrayType) {
            return String.valueOf(EGLAbstractProposalHandler.getTypeString(((ArrayType)type).getElementType())) + "[]";
        }
        if (type instanceof FixedPrecisionType) {
            FixedPrecisionType fpType = (FixedPrecisionType)type;
            String len = fpType.getLength() == null ? "0" : fpType.getLength().toString();
            String dec = fpType.getDecimals() == null ? "0" : fpType.getDecimals().toString();
            return String.valueOf(EGLAbstractProposalHandler.getTypeString((Type)fpType.getClassifier())) + "(" + len + ", " + dec + ")";
        }
        if (type instanceof PatternType) {
            PatternType pType = (PatternType)type;
            String pattern = pType.getPattern() == null ? "" : pType.getPattern();
            return String.valueOf(EGLAbstractProposalHandler.getTypeString((Type)pType.getClassifier())) + "(\"" + pattern + "\")";
        }
        if (type instanceof SequenceType) {
            SequenceType spType = (SequenceType)type;
            String len = spType.getLength() == null ? "0" : spType.getLength().toString();
            return String.valueOf(EGLAbstractProposalHandler.getTypeString((Type)spType.getClassifier())) + "(" + len + ")";
        }
        return EGLAbstractProposalHandler.getNameFromElement((Element)type);
    }

    protected static String getNameFromElement(Element elem) {
        if (elem == null) {
            return "";
        }
        if (elem instanceof NamedElement) {
            return ((NamedElement)elem).getCaseSensitiveName();
        }
        return "";
    }

    protected String getAdditionalInfo(Type type) {
        return EGLAbstractProposalHandler.getTypeString(type);
    }

    protected String getAdditionalInfo(Member mbr) {
        if (mbr != null) {
            return this.getAdditionalInfo(mbr.getType());
        }
        return "";
    }

    public List getProposals(String[] strings, String additionalInfo) {
        return this.getProposals(strings, additionalInfo, 50, 0, "");
    }

    public List getProposals(String[] strings, String additionalInfo, int relevance, String img_src) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < strings.length) {
            if (strings[i].toUpperCase().startsWith(this.getPrefix().toUpperCase())) {
                proposals.add(new EGLCompletionProposal(this.viewer, null, strings[i], additionalInfo, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), 0, relevance, strings[i].length(), img_src));
            }
            ++i;
        }
        return proposals;
    }

    public List getProposals(String[] strings, String additionalInfo, int relevance, int postSelectionLength, String img_src) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < strings.length) {
            if (strings[i].toUpperCase().startsWith(this.getPrefix().toUpperCase())) {
                proposals.add(new EGLCompletionProposal(this.viewer, null, strings[i], additionalInfo, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), strings[i].length() - postSelectionLength, relevance, postSelectionLength, img_src));
            }
            ++i;
        }
        return proposals;
    }

    protected String getPackageName(PartDeclarationInfo part) {
        String packageName = part.getPackageName() == null || part.getPackageName().length() == 0 ? UINlsStrings.OpenPartDialog_DefaultPackage : part.getPackageName();
        return packageName;
    }

    protected EGLCompletionProposal createPartProposal(PartDeclarationInfo part, String partTypeName) {
        return this.createPartProposal(part, partTypeName, false);
    }

    protected EGLCompletionProposal createPartProposal(PartDeclarationInfo part, String partTypeName, boolean quoted) {
        String packageName = this.getPackageName(part);
        String displayString = this.buildDisplayName(part, partTypeName, packageName);
        boolean hasImportForPartWithADifferentPackage = this.hasImportForPartWithADifferentPackage(part.getPackageName(), part.getPartName());
        String proposalString = this.getProposalString(part, hasImportForPartWithADifferentPackage);
        if (quoted) {
            proposalString = "\"" + proposalString + "\"";
        }
        String importPackageName = null;
        String importPartName = null;
        if (part.getPackageName().length() > 0 && !hasImportForPartWithADifferentPackage) {
            importPackageName = part.getPackageName();
            importPartName = part.getPartName();
        }
        EGLCompletionProposal eglCompletionProposal = new EGLCompletionProposal(this.viewer, displayString, proposalString, this.getPartReferenceAdditionalInformation(part.getPackageName(), part, partTypeName), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), this.getPartTypeImgKeyStr(partTypeName));
        eglCompletionProposal.setImportPackageName(importPackageName);
        eglCompletionProposal.setImportPartName(importPartName);
        return eglCompletionProposal;
    }

    protected String getPartTypeImgKeyStr(String partType) {
        String partTypeImgStr = "";
        if ("record" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.record_obj.gif";
        } else if ("handler" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.handler_obj.gif";
        } else if ("interface" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.int_obj.gif";
        } else if ("delegate" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.delgat_obj.gif";
        } else if ("externalType" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.exttyp_obj.gif";
        } else if ("service" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.svc_obj.gif";
        } else if ("enumeration" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.enum_obj.gif";
        } else if ("program" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.prgm_obj.gif";
        } else if ("library" == partType) {
            partTypeImgStr = "org.eclipse.edt.ide.ui.libry_obj.gif";
        }
        return partTypeImgStr;
    }

    private boolean hasImportForPartWithADifferentPackage(final String packageName, final String partName) {
        IEGLDocument document = (IEGLDocument)((EGLEditor)this.editor).getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        File newModelEGLFile = document.getNewModelEGLFile();
        final boolean[] result = new boolean[1];
        newModelEGLFile.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(File file) {
                return true;
            }

            public boolean visit(ImportDeclaration importDeclaration) {
                Name name;
                if (!importDeclaration.isOnDemand() && (name = importDeclaration.getName()).isQualifiedName()) {
                    Name qualifier = ((QualifiedName)name).getQualifier();
                    if (name.getIdentifier().equalsIgnoreCase(partName) && !qualifier.getCanonicalName().equalsIgnoreCase(packageName)) {
                        result[0] = true;
                    }
                }
                return false;
            }
        });
        return result[0];
    }

    private String buildDisplayName(PartDeclarationInfo part, String partTypeName, String packageName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(part.getPartName());
        buffer.append(" - ");
        buffer.append(packageName);
        buffer.append(" (");
        buffer.append(partTypeName);
        buffer.append(")");
        return buffer.toString();
    }

    protected String getPackageName(Part part) {
        String packageName = part.getCaseSensitivePackageName();
        if (packageName != null && packageName.length() != 0) {
            return packageName;
        }
        return UINlsStrings.OpenPartDialog_DefaultPackage;
    }

    protected String getProposalString(PartDeclarationInfo part, boolean includePackageName) {
        return includePackageName ? String.valueOf(part.getPackageName()) + "." + part.getPartName() : part.getPartName();
    }

    protected String getDisplayString(FunctionMember functionBinding) {
        return this.getDisplayString(functionBinding, functionBinding.getParameters().size());
    }

    protected boolean isPrivateMember(Member mbr) {
        return mbr != null && mbr.getAccessKind() == AccessKind.ACC_PRIVATE;
    }

    protected String getDisplayString(FunctionMember function, int numberOfParameters) {
        StringBuffer buffer = new StringBuffer(function.getCaseSensitiveName());
        buffer.append("(");
        int i = 1;
        for (FunctionParameter parm : function.getParameters()) {
            buffer.append(parm.getCaseSensitiveName());
            buffer.append(" ");
            buffer.append(EGLAbstractProposalHandler.getTypeString(parm.getType()));
            if (i < numberOfParameters) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(")");
        Type returnType = function.getReturnType();
        if (returnType != null) {
            buffer.append(" : ");
            buffer.append(EGLAbstractProposalHandler.getTypeString(returnType));
        }
        buffer.append(" - " + EGLAbstractProposalHandler.getNameFromElement((Element)function.getContainer()));
        return buffer.toString();
    }

    protected List createFunctionInvocationProposals(FunctionMember function, String additionalInformation, int relevance, boolean addPrefix) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        String prefix = "";
        if (addPrefix) {
            prefix = String.valueOf(EGLAbstractProposalHandler.getNameFromElement((Element)function.getContainer())) + ".";
        }
        String upToParensString = String.valueOf(prefix) + function.getCaseSensitiveName();
        int numberOfArgs = function.getParameters().size();
        String displayString = this.getDisplayString(function, numberOfArgs);
        String replaceString = String.valueOf(upToParensString) + "(" + this.getParmString(function, numberOfArgs) + ")";
        int selectionLength = numberOfArgs > 0 ? ((IBinding)function.getParameters().get(0)).getName().length() : 0;
        int cursorPosition = numberOfArgs > 0 ? upToParensString.length() + 1 : replaceString.length();
        String imgStr = function.getAccessKind() == AccessKind.ACC_PRIVATE ? "org.eclipse.edt.ide.ui.private_funct_obj.gif" : "org.eclipse.edt.ide.ui.funct_obj.gif";
        EGLCompletionProposal completionProposal = new EGLCompletionProposal(this.viewer, displayString, replaceString, additionalInformation, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), cursorPosition, relevance, selectionLength, imgStr);
        EGLProposalContextInformation contextInformation = new EGLProposalContextInformation(completionProposal, this.getDocumentOffset() - this.getPrefix().length() + upToParensString.length() + 1, replaceString, this.getParameterListString(function.getParameters()));
        completionProposal.setContextInformation(contextInformation);
        proposals.add(completionProposal);
        return proposals;
    }

    protected String getPartTypeString(ITypeBinding typeBinding) {
        if (typeBinding != null) {
            switch (typeBinding.getKind()) {
                case 7: {
                    return "record";
                }
                case 11: {
                    return "library";
                }
                case 2: {
                    return UINlsStrings.CAProposal_Array;
                }
                case 21: {
                    return "dictionary";
                }
                case 14: {
                    return "service";
                }
                case 15: {
                    return "interface";
                }
            }
            return typeBinding.getPackageQualifiedName();
        }
        return "";
    }

    protected boolean isNewExpression() {
        Node node = ((IEGLDocument)this.getViewer().getDocument()).getNewModelNodeAtOffset(this.getDocumentOffset());
        while (node != null) {
            if (node instanceof NewExpression) {
                return true;
            }
            if (node instanceof FunctionDataDeclaration) {
                return false;
            }
            if (node instanceof ClassDataDeclaration) {
                return false;
            }
            node = node.getParent();
        }
        return false;
    }

    protected String getParmString(FunctionMember function) {
        return this.getParmString(function, function.getParameters().size());
    }

    protected String getParmString(FunctionMember function, int numberOfParms) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (FunctionParameter parm : function.getParameters()) {
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(parm.getCaseSensitiveName());
        }
        return buffer.toString();
    }

    protected int getFirstParmLength(FunctionMember function) {
        List parameters = function.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            return ((FunctionParameter)parameters.get(0)).getName().length();
        }
        return 0;
    }

    protected String getParameterListString(List<FunctionParameter> parameters) {
        StringBuffer parameterListSB = new StringBuffer();
        boolean first = true;
        for (FunctionParameter parm : parameters) {
            if (!first) {
                parameterListSB.append(", ");
            }
            first = false;
            parameterListSB.append(this.toString(parm));
        }
        return parameterListSB.toString();
    }

    protected String toString(FunctionParameter parm) {
        StringBuffer sb = new StringBuffer();
        sb.append(parm.getCaseSensitiveName());
        sb.append(" ");
        Type type = parm.getType();
        sb.append(EGLAbstractProposalHandler.getTypeString(type));
        if (parm.getParameterKind() == ParameterKind.PARM_IN) {
            sb.append(" ");
            sb.append("in");
        } else if (parm.getParameterKind() == ParameterKind.PARM_OUT) {
            sb.append(" ");
            sb.append("out");
        } else if (parm.getParameterKind() == ParameterKind.PARM_INOUT) {
            sb.append(" ");
            sb.append("inOut");
        }
        return sb.toString();
    }

    protected int getLParenOffsetAfter(int offset) {
        int ch = 32;
        try {
            while (ch != 40) {
                ch = this.getViewer().getDocument().getChar(offset++);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        return offset - 1;
    }
}

