/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.jface.text.ITextViewer;

public class EGLDeclarationProposalHandler
extends EGLAbstractProposalHandler {
    public static final int INTEGER_DATAITEM = 1;
    public static final int NUMERIC_DATAITEM = 2;
    public static final int STRING_DATAITEMS = 3;
    public static final int NUMERIC_STRING_DATAITEMS = 4;
    public static final int ALL_DATAITEMS = 5;
    public static int BASIC_RECORD = 1;
    public static int ENTITY_RECORD = 2;
    public static int EXCEPTION = 4096;
    public static int ALL_RECORDS = ENTITY_RECORD | EXCEPTION;
    private Node functionContainerPart;
    private Node functionPart;
    private boolean parens;

    private static boolean isDataSourceType(Type type) {
        String name = EGLDeclarationProposalHandler.getTypeString(type);
        return name.equalsIgnoreCase("DataSource") || name.equalsIgnoreCase("SQLDataSource") || name.equalsIgnoreCase("SQLResultSet") || name.equalsIgnoreCase("ScrollableDataSource");
    }

    private static boolean isSqlStatement(Type type) {
        return EGLDeclarationProposalHandler.getTypeString(type).equalsIgnoreCase("SQLStatement");
    }

    private static boolean isSqlString(Type type) {
        return TypeUtils.Type_STRING.equals((Type)type.getClassifier());
    }

    public EGLDeclarationProposalHandler(ITextViewer viewer, int documentOffset, String prefix, Node boundNode) {
        super(viewer, documentOffset, prefix);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionPart = boundNode;
                this.functionContainerPart = boundNode.getParent();
            } else if (boundNode instanceof Part) {
                this.functionContainerPart = boundNode;
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals(boolean parens, boolean constants) {
        return this.getProposals(null, parens, constants);
    }

    public List getProposals(Node boundNode) {
        return this.getProposals(boundNode, false, true);
    }

    public List getProposals(Node node, boolean parens, boolean constants) {
        this.parens = parens;
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterProposals(false));
        proposals.addAll(this.getContainerVariableProposals(constants, false));
        proposals.addAll(this.getVariableProposals(constants, false));
        if (node != null) {
            proposals.addAll(this.getExceptionDeclarationProposals(node));
        }
        return proposals;
    }

    public List getRecordProposals(int recordTypes) {
        return this.getRecordProposals(recordTypes, false);
    }

    public List getRecordProposals(int recordTypes, boolean allowArray) {
        return this.getRecordProposals(recordTypes, allowArray, false);
    }

    public List getRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getRecordProposals(recordTypes, allowArray, quoted, false);
    }

    public List getRecordProposals(int recordTypes, boolean allowArray, boolean quoted, boolean parens) {
        return this.getRecordProposals(recordTypes, null, allowArray, quoted, parens);
    }

    public List getRecordProposals(int recordTypes, Node node, boolean allowArray, boolean quoted, boolean parens) {
        this.parens = parens;
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterRecordProposals(recordTypes, allowArray, quoted));
        proposals.addAll(this.getContainerVariableRecordProposals(recordTypes, allowArray, quoted));
        proposals.addAll(this.getVariableRecordProposals(recordTypes, allowArray, quoted));
        if (node != null) {
            proposals.addAll(this.getExceptionDeclarationProposals(node));
        }
        return proposals;
    }

    public List getDataItemProposals(int integerType) {
        return this.getDataItemProposals(integerType, true);
    }

    public List getDataItemProposals(int integerType, boolean constants) {
        return this.getDataItemProposals(integerType, constants, false);
    }

    public List getDataItemProposals(int integerType, boolean constants, boolean parens) {
        this.parens = parens;
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterDataItemProposals(integerType));
        proposals.addAll(this.getContainerVariableDataItemProposals(integerType, constants));
        proposals.addAll(this.getVariableDataItemProposals(integerType, constants));
        return proposals;
    }

    public List getServiceProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new ServiceTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new ServiceTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getDataSourceProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new DataSourceTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new DataSourceTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getSQLStatementProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new SQLStatementTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new SQLStatementTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getSQLStringProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new SQLStringTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new SQLStringTypeDataBindingFilter(), false, false));
        return proposals;
    }

    private List getAllRecordProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterProposals(new RecordTypeDataBindingFilter(), false));
        proposals.addAll(this.getVariableProposals(new RecordTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new RecordTypeDataBindingFilter(), false, false));
        return proposals;
    }

    private List getAllHandlerProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new HandlerTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new HandlerTypeDataBindingFilter(), false, false));
        return proposals;
    }

    private List getAllExternalTypeProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new SQLActionTargetsExternalTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new SQLActionTargetsExternalTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getSQLActioniTargets() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getAllRecordProposals());
        proposals.addAll(this.getAllHandlerProposals());
        proposals.addAll(this.getAllExternalTypeProposals());
        return proposals;
    }

    private List getVariableDataItemProposals(int dataItemType, boolean includeConstants) {
        return this.getVariableProposals(new DataItemTypeDataBindingFilter(dataItemType), includeConstants, false);
    }

    private List getContainerVariableDataItemProposals(int dataItemType, boolean includeConstants) {
        return this.getContainerVariableProposals(new DataItemTypeDataBindingFilter(dataItemType), includeConstants, false);
    }

    private List getParameterDataItemProposals(int dataItemType) {
        return this.getParameterProposals(new DataItemTypeDataBindingFilter(dataItemType), false);
    }

    private List getContainerParameterDataItemProposals(int dataItemType) {
        return this.getContainerVariableProposals(new DataItemTypeDataBindingFilter(dataItemType), true, false);
    }

    private List getContainerParameterRecordProposals(int recordType, boolean allowArray, boolean quoted) {
        return this.getContainerVariableProposals(new RecordSubtypeDataBindingFilter(recordType, allowArray), true, quoted);
    }

    private List getVariableRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getVariableProposals(new RecordSubtypeDataBindingFilter(recordTypes, allowArray), false, quoted);
    }

    private List getParameterProposals(boolean quoted) {
        return this.getParameterProposals(new DefaultDataBindingFilter(), quoted);
    }

    private List getParameterProposals(IDataBindingFilter dataBindingFilter, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionPart != null) {
            FunctionMember function = (FunctionMember)((NestedFunction)this.functionPart).getName().resolveMember();
            for (FunctionParameter parm : function.getParameters()) {
                if (!parm.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses((Member)parm) || !this.precondition((Member)parm)) continue;
                String proposalString = this.getProposalString(parm.getCaseSensitiveName());
                proposals.add(this.createDeclarationProposal((Member)parm, proposalString, 50, quoted, true));
            }
        }
        return proposals;
    }

    private List getParameterRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getParameterProposals(new RecordSubtypeDataBindingFilter(recordTypes, allowArray), quoted);
    }

    public List getProgramParameterRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        this.parens = false;
        ArrayList proposals = new ArrayList();
        if (this.functionContainerPart instanceof Program) {
            proposals.addAll(this.getContainerParameterRecordProposals(recordTypes, allowArray, quoted));
        }
        return proposals;
    }

    private String getProposalString(String string) {
        if (this.parens) {
            return "(" + string + ")";
        }
        return string;
    }

    private List getContainerVariableProposals(boolean includeConstants, boolean quoted) {
        return this.getContainerVariableProposals(new DefaultDataBindingFilter(), includeConstants, quoted);
    }

    private List getContainerVariableProposals(IDataBindingFilter dataBindingFilter, boolean includeConstants, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionContainerPart != null) {
            org.eclipse.edt.mof.egl.Part part = (org.eclipse.edt.mof.egl.Part)((Part)this.functionContainerPart).getName().resolveType();
            List fields = BindingUtil.getAllFields((Type)part);
            for (Field field : fields) {
                if (!field.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses((Member)field) || !this.precondition((Member)field) || !includeConstants && field instanceof ConstantField) continue;
                String proposalString = this.getProposalString(field.getCaseSensitiveName());
                proposals.add(this.createDeclarationProposal((Member)field, proposalString, 50, quoted, false));
            }
        }
        return proposals;
    }

    private List getContainerVariableRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getContainerVariableProposals(new RecordSubtypeDataBindingFilter(recordTypes, allowArray), false, quoted);
    }

    private List getVariableProposals(boolean includeConstants, boolean quoted) {
        return this.getVariableProposals(new DefaultDataBindingFilter(), includeConstants, quoted);
    }

    private List getVariableProposals(IDataBindingFilter dataBindingFilter, boolean includeConstants, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionPart != null) {
            Stack blocks = new Stack();
            blocks.push(new ArrayList());
            List statements = ((NestedFunction)this.functionPart).getStmts();
            this.addDeclarations(statements, blocks);
            Iterator iter = blocks.iterator();
            while (iter.hasNext()) {
                for (Field field : (List)iter.next()) {
                    if (!field.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses((Member)field) || !this.precondition((Member)field) || !includeConstants && field instanceof ConstantField) continue;
                    String proposalString = this.getProposalString(field.getCaseSensitiveName());
                    proposals.add(this.createDeclarationProposal((Member)field, proposalString, 50, quoted, true));
                }
            }
        }
        return proposals;
    }

    private List getExceptionDeclarationProposals(Node node) {
        return this.getExceptionDeclarationProposals(node, new DefaultDataBindingFilter());
    }

    private List getExceptionDeclarationProposals(Node node, IDataBindingFilter dataBindingFilter) {
        Field field;
        Name exceptionName;
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        OnExceptionBlock onExceptionBlock = this.getOnExceptionBlock(node);
        if (onExceptionBlock != null && (exceptionName = onExceptionBlock.getExceptionName()) != null && exceptionName.getCanonicalName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) && (field = (Field)exceptionName.resolveMember()).getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) && dataBindingFilter.dataBindingPasses((Member)field) && this.precondition((Member)field)) {
            String proposalString = this.getProposalString(field.getCaseSensitiveName());
            proposals.add(this.createDeclarationProposal((Member)field, proposalString, 50, false, true));
        }
        return proposals;
    }

    private OnExceptionBlock getOnExceptionBlock(Node node) {
        final OnExceptionBlock[] onExceptionBlock = new OnExceptionBlock[1];
        while (node != null) {
            node.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(OnExceptionBlock onExceptionBlk) {
                    onExceptionBlock[0] = onExceptionBlk;
                    return false;
                }
            });
            node = node.getParent();
        }
        return onExceptionBlock[0];
    }

    private boolean addDeclarations(List statements, final Stack blocks) {
        boolean done = false;
        Statement lastStatement = null;
        Iterator iter = statements.iterator();
        while (iter.hasNext() && !done) {
            Statement nextStmt;
            Node next = (Node)iter.next();
            if (!(next instanceof Statement)) continue;
            lastStatement = nextStmt = (Statement)next;
            if (nextStmt.getOffset() > this.getDocumentOffset()) {
                done = true;
                continue;
            }
            if (nextStmt.canIncludeOtherStatements()) {
                Iterator blockIter = nextStmt.getStatementBlocks().iterator();
                while (blockIter.hasNext()) {
                    blocks.push(new ArrayList());
                    nextStmt.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(ForStatement forStatement) {
                            Field field;
                            if (forStatement.hasVariableDeclaration() && (field = (Field)forStatement.getVariableDeclarationName().resolveMember()) != null) {
                                ((List)blocks.peek()).add(field);
                            }
                            return false;
                        }
                    });
                    if (this.addDeclarations((List)blockIter.next(), blocks)) {
                        done = true;
                        continue;
                    }
                    blocks.pop();
                }
                continue;
            }
            nextStmt.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                    Iterator iter = functionDataDeclaration.getNames().iterator();
                    while (iter.hasNext()) {
                        Field field = (Field)((Name)iter.next()).resolveMember();
                        if (field == null) continue;
                        ((List)blocks.peek()).add(field);
                    }
                    return false;
                }
            });
        }
        if (!done && lastStatement != null && lastStatement.getOffset() + lastStatement.getLength() > this.getDocumentOffset()) {
            done = true;
        }
        return done;
    }

    private String getAdditionalInfo1(Member field) {
        if (field.getType() != null) {
            String type = EGLDeclarationProposalHandler.getTypeString(field.getType());
            if (field instanceof ProgramParameter) {
                return MessageFormat.format(UINlsStrings.CAProposal_ParameterDeclarationIn, type, EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
            }
            if (field instanceof FunctionParameter) {
                return MessageFormat.format(UINlsStrings.CAProposal_ParameterDeclaration, type);
            }
            if (field.getContainer() instanceof FunctionMember) {
                if (field instanceof ConstantField) {
                    return MessageFormat.format(UINlsStrings.CAProposal_ConstantDeclaration, type);
                }
                return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclaration, type);
            }
            if (field instanceof ConstantField) {
                return MessageFormat.format(UINlsStrings.CAProposal_ConstantDeclarationIn, type, EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
            }
            return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclarationIn, type, EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
        }
        if (this.functionContainerPart == null) {
            return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclaration, "");
        }
        return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclarationIn, "", EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
    }

    private EGLCompletionProposal createDeclarationProposal(Member field, String proposalString, int relevance, boolean quoted, boolean isLocalVariable) {
        String imgStr;
        if (quoted) {
            proposalString = "\"" + proposalString + "\"";
        }
        String string = imgStr = this.isPrivateMember(field) ? (imgStr = "org.eclipse.edt.ide.ui.private_co.gif") : "org.eclipse.edt.ide.ui.envvar_obj.gif";
        if (isLocalVariable) {
            imgStr = "org.eclipse.edt.ide.ui.localvariable_obj.gif";
        }
        String displayStr = isLocalVariable ? String.valueOf(field.getCaseSensitiveName()) + " : " + EGLDeclarationProposalHandler.getTypeString(field.getType()) : String.valueOf(field.getCaseSensitiveName()) + " : " + EGLDeclarationProposalHandler.getTypeString(field.getType()) + " - " + EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer());
        return new EGLCompletionProposal(this.viewer, displayStr, proposalString, this.getAdditionalInfo1(field), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), relevance, imgStr);
    }

    protected boolean precondition(Member member) {
        return true;
    }

    private static class DataItemTypeDataBindingFilter
    implements IDataBindingFilter {
        private int dataItemType;

        public DataItemTypeDataBindingFilter(int dataItemType) {
            this.dataItemType = dataItemType;
        }

        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            if (type != null && TypeUtils.isPrimitive((Type)(type = BindingUtil.getBaseType((Type)type)))) {
                switch (this.dataItemType) {
                    case 5: {
                        return true;
                    }
                    case 3: {
                        return TypeUtils.isTextType((Type)type);
                    }
                    case 2: {
                        return TypeUtils.isNumericType((Type)type);
                    }
                    case 4: {
                        return TypeUtils.isNumericType((Type)type) || TypeUtils.isTextType((Type)type);
                    }
                    case 1: {
                        return TypeUtils.isNumericTypeWithNoDecimals((Type)type);
                    }
                }
            }
            return false;
        }
    }

    private static class DataSourceTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(Member member) {
            return this.typePasses(member.getType());
        }

        private boolean typePasses(Type type) {
            if (type != null) {
                if (EGLDeclarationProposalHandler.isDataSourceType(type = BindingUtil.getBaseType((Type)type))) {
                    return true;
                }
                if (type instanceof ExternalType) {
                    List extendTypes = ((ExternalType)type).getSuperTypes();
                    for (StructPart extendType : extendTypes) {
                        if (!this.typePasses((Type)extendType)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class DefaultDataBindingFilter
    implements IDataBindingFilter {
        private DefaultDataBindingFilter() {
        }

        @Override
        public boolean dataBindingPasses(Member member) {
            return true;
        }
    }

    private static class HandlerTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            return type != null && (type = BindingUtil.getBaseType((Type)type)) instanceof Handler;
        }
    }

    private static interface IDataBindingFilter {
        public boolean dataBindingPasses(Member var1);
    }

    private static class RecordSubtypeDataBindingFilter
    implements IDataBindingFilter {
        private int recordTypes;
        private boolean allowArray;

        public RecordSubtypeDataBindingFilter(int recordTypes, boolean allowArray) {
            this.recordTypes = recordTypes;
            this.allowArray = allowArray;
        }

        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            if (type != null) {
                if (this.allowArray) {
                    type = BindingUtil.getBaseType((Type)type);
                }
                if ((ENTITY_RECORD & this.recordTypes) == ENTITY_RECORD && type.getAnnotation("eglx.persistence.Entity") != null) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class RecordTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            return type != null && (type = BindingUtil.getBaseType((Type)type)) instanceof Record;
        }
    }

    private static class SQLActionTargetsExternalTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            return type != null && (type = BindingUtil.getBaseType((Type)type)) instanceof ExternalType && !EGLDeclarationProposalHandler.isDataSourceType(type) && !EGLDeclarationProposalHandler.isSqlStatement(type);
        }
    }

    private static class SQLStatementTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            return type != null && EGLDeclarationProposalHandler.isSqlStatement(type = BindingUtil.getBaseType((Type)type));
        }
    }

    private static class SQLStringTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            return type != null && EGLDeclarationProposalHandler.isSqlString(type = BindingUtil.getBaseType((Type)type));
        }
    }

    private static class ServiceTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(Member member) {
            Type type = member.getType();
            return type != null && ((type = BindingUtil.getBaseType((Type)type)) instanceof Service || type instanceof Interface);
        }
    }
}

