/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLFunctionMemberSearchProposalHandler
extends EGLAbstractProposalHandler {
    Node functionContainerPart;

    public EGLFunctionMemberSearchProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, boolean mustHaveReturnCode, Node boundNode) {
        super(viewer, documentOffset, prefix, editor);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionContainerPart = boundNode.getParent();
            } else if (boundNode instanceof org.eclipse.edt.compiler.core.ast.Part) {
                this.functionContainerPart = boundNode;
            }
            boundNode = boundNode.getParent();
        }
    }

    protected List createProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getNestedFunctionProposals());
        return proposals;
    }

    private List getNestedFunctionProposals() {
        ArrayList proposals = new ArrayList();
        if (this.functionContainerPart != null) {
            Part part = (Part)((org.eclipse.edt.compiler.core.ast.Part)this.functionContainerPart).getName().resolveType();
            List functions = BindingUtil.getAllFunctions((Type)part);
            for (Function function : functions) {
                String name = function.getName();
                if (!name.toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
                proposals.addAll(this.createFunctionInvocationProposals((FunctionMember)function, UINlsStrings.CAProposal_NestedFunction, 50, false));
            }
        }
        return proposals;
    }

    @Override
    protected String getProposalString(PartDeclarationInfo partDeclarationInfo, boolean includePackageName) {
        StringBuffer buffer = new StringBuffer(partDeclarationInfo.getPartName());
        buffer.append("(");
        buffer.append(")");
        return buffer.toString();
    }

    public List getProposals() {
        return this.createProposals();
    }
}

