/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.edt.compiler.internal.EGLNewPropertiesHandler;
import org.eclipse.edt.compiler.internal.EGLPropertyRule;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.ide.ui.internal.util.CapabilityFilterUtility;
import org.eclipse.jface.text.ITextViewer;

public class EGLPropertyNameProposalHandler
extends EGLAbstractProposalHandler {
    private boolean isAnnotationSetting;
    private boolean startFromAnnoHead;

    public EGLPropertyNameProposalHandler(ITextViewer viewer, int documentOffset, String prefix, boolean isAnnotationSetting, boolean startFromAnnoIcon) {
        super(viewer, documentOffset, prefix, null);
        this.isAnnotationSetting = isAnnotationSetting;
        this.startFromAnnoHead = startFromAnnoIcon;
    }

    public List getProposals(int location, List propertyBlockList) {
        Collection propertyRules = CapabilityFilterUtility.filterPropertyRules(EGLNewPropertiesHandler.getPropertyRules((int)location));
        return this.getProposals(location, propertyRules, propertyBlockList);
    }

    public List getProposals(Collection propertyRules, List propertyBlockList) {
        return this.getProposals(0, propertyRules, propertyBlockList);
    }

    public List getProposals(int location, Collection propertyRules, List propertyBlockList) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (propertyRules != null) {
            for (EGLPropertyRule propertyRule : propertyRules) {
                String propertyName = propertyRule.getName();
                if (!propertyName.toUpperCase().startsWith(this.getPrefix().toUpperCase()) || this.containsProperty(propertyName, propertyBlockList)) continue;
                proposals.add(this.createProposal(location, propertyRule));
            }
        }
        return proposals;
    }

    private EGLCompletionProposal createProposal(int location, EGLPropertyRule propertyRule) {
        int cursorPosition = 0;
        int selectionLength = 0;
        StringBuffer buffer = new StringBuffer();
        if (this.isAnnotationSetting && !this.startFromAnnoHead) {
            buffer.append("@");
        }
        buffer.append(propertyRule.getName());
        if (propertyRule.hasType(7) && !propertyRule.isValueless()) {
            buffer.append(" {");
            cursorPosition = buffer.length();
            buffer.append("}");
        }
        String img_src = this.isAnnotationSetting ? "org.eclipse.edt.ide.ui.annotation_obj.gif" : "org.eclipse.edt.ide.ui.envvar_obj.gif";
        return new EGLCompletionProposal(this.viewer, propertyRule.getName(), buffer.toString(), this.getAdditionalInfo(location, propertyRule.getName()), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), cursorPosition, 50, selectionLength, img_src);
    }

    private String getAdditionalInfo(int location, String propertyName) {
        if (location == 13) {
            if (propertyName.equalsIgnoreCase("helpGroup")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("validationBypassKeys")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("helpKey")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("pfKeyEquate")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("deleteAfterUse")) {
                return UINlsStrings.CAProposal_PropertyNameDataTables;
            }
            return UINlsStrings.CAProposal_PropertyName;
        }
        return UINlsStrings.CAProposal_PropertyName;
    }
}

