/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.EGLPropertyRule;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLDeclarationProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPartSearchProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLPropertyValueProposalHandler
extends EGLAbstractProposalHandler {
    public static final String NUMERIC_LITERAL = "numericLiteral";
    public static final String ALIAS_PROPOSAL = "runtimeName";
    public static final String SEGMENTS_LIST_PROPOSAL = "[line,column,length]";
    public static final String TCPIPLOCATION_LIST_PROPOSAL = "host:port";
    public static final String ROW_CONTENTS = "rowContents";
    public static final String SQL_CONDITION = "condition";
    private String prefix = "";
    boolean hasQuoteBegin;
    boolean hasQuoteEnd;
    private EGLAbstractReferenceCompletion referenceCompletion;
    private ParseStack parseStack;
    private Node boundNode;
    private org.eclipse.edt.mof.egl.Part part;

    public EGLPropertyValueProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, EGLAbstractReferenceCompletion referenceCompletion, ParseStack parseStack, Node boundNode) {
        super(viewer, documentOffset, prefix, editor);
        this.prefix = prefix;
        this.referenceCompletion = referenceCompletion;
        this.parseStack = parseStack;
        this.boundNode = boundNode;
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof Part) {
                this.part = (org.eclipse.edt.mof.egl.Part)((Part)boundNode).getName().resolveType();
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals(EGLPropertyRule propertyRule) {
        ArrayList proposals = new ArrayList();
        this.prepareGetProposals();
        proposals.addAll(this.handleProperty(propertyRule.getName(), this.viewer, this.getDocumentOffset(), propertyRule));
        return proposals;
    }

    private void prepareGetProposals() {
        try {
            String characterBeforeCursor = this.viewer.getDocument().get(this.getDocumentOffset() - 1, 1);
            this.hasQuoteBegin = characterBeforeCursor.equals("\"");
            String characterAfterCursor = this.viewer.getDocument().get(this.getDocumentOffset(), 1);
            this.hasQuoteEnd = characterAfterCursor.equals("\"");
        }
        catch (BadLocationException badLocationException) {
            this.hasQuoteEnd = false;
        }
    }

    public List getProposals(Annotation ann, String fieldName) {
        ArrayList proposals = new ArrayList();
        this.prepareGetProposals();
        if (fieldName == null) {
            proposals.addAll(this.handleProperty(ann.getEClass().getName(), this.viewer, this.getDocumentOffset(), new EGLPropertyRule((AnnotationType)ann.getEClass())));
        } else {
            proposals.addAll(this.handleProperty(fieldName, this.viewer, this.getDocumentOffset(), new EGLPropertyRule((AnnotationType)ann.getEClass(), fieldName)));
        }
        return proposals;
    }

    public List getProposals(Field field) {
        ArrayList proposals = new ArrayList();
        this.prepareGetProposals();
        proposals.addAll(this.handleProperty(field.getCaseSensitiveName(), this.viewer, this.getDocumentOffset(), new EGLPropertyRule(field)));
        return proposals;
    }

    private List handleProperty(String propertyName, ITextViewer viewer, int documentOffset, EGLPropertyRule rule) {
        ArrayList proposals = new ArrayList();
        if (propertyName.equalsIgnoreCase(rule.getName())) {
            if (rule.hasType(3)) {
                proposals.addAll(this.getIntegerValueProposals());
            }
            if (rule.hasType(10)) {
                proposals.addAll(this.getArrayOfProposals(propertyName));
            }
            if (rule.hasType(9)) {
                proposals.addAll(this.getArrayOfArraysProposals(propertyName));
            }
            if (rule.hasType(4)) {
                proposals.addAll(this.getLiteralValueProposals());
            }
            if (rule.hasType(0)) {
                proposals.addAll(this.getNameValueProposals(viewer, this.getDocumentOffset(), propertyName));
            }
            if (rule.hasType(1)) {
                proposals.addAll(this.getQuotedValueProposal(propertyName));
            }
            if (rule.hasType(2)) {
                proposals.addAll(this.getSpecificValueProposals(rule));
            }
            if (rule.hasType(8)) {
                proposals.addAll(this.getSqlValueProposal(propertyName));
            }
        }
        return proposals;
    }

    private List getIntegerValueProposals() {
        return this.referenceCompletion.createProposal(this.viewer, NUMERIC_LITERAL, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset(), 0);
    }

    private List getListValueProposal(String value, int selectionLength) {
        return this.getListValueProposal(value, 0, selectionLength);
    }

    private List getListValueProposal(String value, int offset, int selectionLength) {
        String openBracket = "[";
        String closeBracket = "]";
        String proposalString = String.valueOf(openBracket) + value + closeBracket;
        return this.referenceCompletion.createProposal(this.viewer, proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset(), openBracket.length() + offset, selectionLength);
    }

    private List getLiteralArrayValueProposals(String propertyName) {
        String value = "";
        if (propertyName.equalsIgnoreCase("contents")) {
            value = ROW_CONTENTS;
        }
        String openBrackets = "[[";
        String closeBrackets = "]]";
        String proposalString = String.valueOf(openBrackets) + value + closeBrackets;
        return this.referenceCompletion.createProposal(this.viewer, proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset(), openBrackets.length(), value.length());
    }

    private List getArrayOfProposals(String propertyName) {
        String value = "";
        String displayString = "";
        if (propertyName.equalsIgnoreCase("linkParms")) {
            displayString = "linkParameter";
            value = "@linkParameter {}";
        } else if (propertyName.equalsIgnoreCase("hierarchy")) {
            displayString = "relationship";
            value = "@relationship {}";
        }
        String openBracket = "[";
        String closeBracket = "]";
        String proposalString = String.valueOf(openBracket) + value + closeBracket;
        if (displayString.length() > 0) {
            return this.referenceCompletion.createProposal(this.viewer, displayString, proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset(), proposalString.length() - 2, 0);
        }
        return new ArrayList();
    }

    private List getArrayOfArraysProposals(String propertyName) {
        String value = "";
        int selectionLength = 0;
        String proposalString = "[" + value + "]";
        return this.referenceCompletion.createProposal(this.viewer, proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset(), 3, selectionLength);
    }

    private List getNameValueRecordNames(int documentOffset) {
        return new EGLPartSearchProposalHandler(this.viewer, this.getDocumentOffset(), this.prefix, this.editor).getProposals(8, "", new String[]{"BasicRecord"}, false);
    }

    private List getLiteralValueProposals() {
        List proposals = this.getQuotedValueProposal("");
        proposals.addAll(this.getIntegerValueProposals());
        return proposals;
    }

    private List getNameValueProposals(ITextViewer viewer, int documentOffset, String propertyName) {
        ArrayList proposals = new ArrayList();
        if (propertyName.equalsIgnoreCase("onConstructionFunction") || propertyName.equalsIgnoreCase("onPreRenderFunction") || propertyName.equalsIgnoreCase("onPostRenderFunction") || propertyName.equalsIgnoreCase("onValueChangeFunction")) {
            proposals.addAll(this.getNameValueFunctionProposals(this.getDocumentOffset()));
        } else if (propertyName.equalsIgnoreCase("redefines")) {
            proposals.addAll(this.getNameValueRedefinesProposals(this.getDocumentOffset()));
        } else if (propertyName.equalsIgnoreCase("selectFromListItem")) {
            proposals.addAll(this.getNameValueSelectFromListProposals(this.getDocumentOffset()));
        } else if (propertyName.equalsIgnoreCase("selectedRowItem")) {
            proposals.addAll(this.getNameValueSelectedRowItemProposals(this.getDocumentOffset()));
        } else if (propertyName.equalsIgnoreCase("selectedValueItem")) {
            proposals.addAll(this.getNameValueSelectedValueItemProposals(this.getDocumentOffset()));
        } else if (propertyName.equalsIgnoreCase("validationBypassFunctions")) {
            proposals.addAll(this.referenceCompletion.getListValueValidationBypassFunctionsProposals(viewer, this.getDocumentOffset(), this.prefix, true));
        } else if (propertyName.equalsIgnoreCase("validatorFunction")) {
            proposals.addAll(this.getNameValueValidatorFunctionProposals(this.getDocumentOffset()));
        } else if (propertyName.equalsIgnoreCase("numElementsItem") || propertyName.equalsIgnoreCase("msgField") || propertyName.equalsIgnoreCase("keyItem") || propertyName.equalsIgnoreCase("eventValueItem") || propertyName.equalsIgnoreCase("selectedIndexItem") || propertyName.equalsIgnoreCase("commandValueItem") || propertyName.equalsIgnoreCase("labelItem") || propertyName.equalsIgnoreCase("valueItem")) {
            proposals.addAll(this.getNameValueItemNames(viewer, this.getDocumentOffset(), null));
        } else if (propertyName.equalsIgnoreCase("lengthItem")) {
            proposals.addAll(this.getNameValueItemNames(viewer, this.getDocumentOffset(), null));
            proposals.addAll(this.getNameValueItemNames2(viewer, this.getDocumentOffset(), null));
        } else if (propertyName.equalsIgnoreCase("getOptionsRecord") || propertyName.equalsIgnoreCase("msgDescriptorRecord") || propertyName.equalsIgnoreCase("openOptionsRecord") || propertyName.equalsIgnoreCase("putOptionsRecord") || propertyName.equalsIgnoreCase("queueDescriptorRecord")) {
            proposals.addAll(this.getNameValueRecordNames(this.getDocumentOffset()));
        }
        return proposals;
    }

    private List getNamedValueHelpKeyProposals(int documentOffset, String proposalString) {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.referenceCompletion.createProposal(this.viewer, proposalString, this.prefix, UINlsStrings.CAProposal_KeyValue, this.getDocumentOffset(), proposalString.length() - 1, 1));
        return proposals;
    }

    private List getQuotedValueActionProposals(int documentOffset) {
        return new ArrayList();
    }

    private List getNameValueClassFieldNames(ITextViewer viewer, int documentOffset, String typeName) {
        ArrayList proposals = new ArrayList();
        List itemNames = this.referenceCompletion.getItemNames(viewer, this.getDocumentOffset(), typeName, false);
        for (String displayString : itemNames) {
            proposals.addAll(this.referenceCompletion.createProposal(viewer, displayString, displayString, this.prefix, UINlsStrings.CAProposal_ItemName, this.getDocumentOffset(), displayString.length(), 0));
        }
        return proposals;
    }

    private List getNameValueItemNames(ITextViewer viewer, int documentOffset, String typeName) {
        ArrayList proposals = new ArrayList();
        List itemNames = this.referenceCompletion.getItemNames(viewer, this.getDocumentOffset(), typeName);
        for (String displayString : itemNames) {
            proposals.addAll(this.referenceCompletion.createProposal(viewer, displayString, displayString, this.prefix, UINlsStrings.CAProposal_ItemName, this.getDocumentOffset(), displayString.length(), 0));
        }
        return proposals;
    }

    private List getNameValueItemNames2(ITextViewer viewer, int documentOffset, String typeName) {
        ArrayList proposals = new ArrayList();
        Node eglPart = this.referenceCompletion.getPart(viewer, documentOffset);
        List itemNames = this.referenceCompletion.getItemNames2(viewer, documentOffset, null, eglPart);
        for (String displayString : itemNames) {
            proposals.addAll(this.referenceCompletion.createProposal(viewer, displayString, displayString, this.prefix, UINlsStrings.CAProposal_Variable, this.getDocumentOffset(), displayString.length(), 0));
        }
        return proposals;
    }

    public List getQuotedValueProposal(String propertyName) {
        ArrayList proposals = new ArrayList();
        if (propertyName.equalsIgnoreCase("serviceName")) {
            proposals.addAll(this.getQuotedValueServiceNameProposals(this.getDocumentOffset()));
        } else {
            proposals.addAll(this.getQuotedValueProposal(this.getDocumentOffset()));
        }
        return proposals;
    }

    private Collection getQuotedValueUIRecordNameProposals(int documentOffset) {
        String[] types = new String[]{"VGUIRecord"};
        List proposals = new EGLPartSearchProposalHandler(this.viewer, this.getDocumentOffset(), this.prefix, this.editor).getProposals(8, "", types, false);
        if (proposals.size() == 0) {
            proposals.addAll(this.getQuotedValueProposal(this.getDocumentOffset()));
        }
        return proposals;
    }

    private Collection getQuotedValueServiceNameProposals(int documentOffset) {
        List proposals = new EGLPartSearchProposalHandler(this.viewer, this.getDocumentOffset(), this.prefix, this.editor).getProposals(1024, "", null, false);
        if (proposals.size() == 0) {
            proposals.addAll(this.getQuotedValueProposal(this.getDocumentOffset()));
        }
        return proposals;
    }

    private Collection getQuotedValueDebugImplProposals(int documentOffset) {
        return this.getQuotedValueServiceNameProposals(this.getDocumentOffset());
    }

    private Collection getQuotedValueTcpipLocationProposals() {
        StringBuffer buffer = new StringBuffer();
        int cursorPosition = buffer.toString().length();
        buffer.append(TCPIPLOCATION_LIST_PROPOSAL);
        return this.referenceCompletion.createProposal(this.viewer, TCPIPLOCATION_LIST_PROPOSAL, buffer.toString(), this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset(), cursorPosition, TCPIPLOCATION_LIST_PROPOSAL.length());
    }

    private List getQuotedValueProgramNameProposals(int documentOffset) {
        String[] types = new String[]{"VGWebTransaction"};
        List proposals = new EGLPartSearchProposalHandler(this.viewer, this.getDocumentOffset(), this.prefix, this.editor).getProposals(1, "", types, false);
        if (proposals.size() == 0) {
            proposals.addAll(this.getQuotedValueProposal(this.getDocumentOffset()));
        }
        return proposals;
    }

    private List createJSPProposal(IFile file) {
        return this.referenceCompletion.createProposal(this.viewer, "\"" + file.getName() + "\"", this.prefix, UINlsStrings.CAProposal_JSPFile, this.getDocumentOffset(), file.getName().length() + 2, 0);
    }

    private List getSpecificValueProposals(EGLPropertyRule rule) {
        ArrayList proposals = new ArrayList();
        int i = 0;
        while (i < rule.getSpecificValues().length) {
            String proposalString = rule.getSpecificValues()[i];
            if (proposalString.toLowerCase().startsWith(this.prefix.toLowerCase())) {
                proposals.addAll(this.referenceCompletion.createProposal(this.viewer, proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset()));
            }
            ++i;
        }
        return proposals;
    }

    private List getSqlValueProposal(String propertyName) {
        String value = "";
        String proposalString = "#sql{ " + value + " }";
        if (propertyName.equalsIgnoreCase("defaultSelectCondition")) {
            value = SQL_CONDITION;
            proposalString = "#sqlCondition{ " + value + " }";
        } else {
            proposalString = "#sql{  }";
        }
        return this.referenceCompletion.createProposal(this.viewer, proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.getDocumentOffset(), "#sqlCondition{".length() + 1, value.length());
    }

    private List getQuotedValueAliasProposal(int documentOffset) {
        StringBuffer buffer = new StringBuffer();
        int cursorPosition = buffer.toString().length();
        buffer.append(ALIAS_PROPOSAL);
        return this.referenceCompletion.createProposal(this.viewer, ALIAS_PROPOSAL, buffer.toString(), this.prefix, UINlsStrings.CAProposal_KeyValue, this.getDocumentOffset(), cursorPosition, ALIAS_PROPOSAL.length());
    }

    private List getNameValueValidatorFunctionProposals(int documentOffset) {
        ArrayList proposals = new ArrayList();
        if (this.part instanceof Handler || this.part instanceof Record) {
            proposals.addAll(new EGLPartSearchProposalHandler(this.viewer, this.getDocumentOffset(), this.prefix, this.editor).getProposals(128, "", new String[0], false));
        }
        if (proposals.size() == 0) {
            proposals.addAll(this.getNameValueFunctionProposals(this.getDocumentOffset()));
        }
        return proposals;
    }

    private List getNameValueRecordProposals(int documentOffset, int recordTypes) {
        return new EGLDeclarationProposalHandler(this.viewer, this.getDocumentOffset(), this.prefix, this.boundNode).getRecordProposals(recordTypes, false, false);
    }

    private List getNameValueRedefinesProposals(int documentOffset) {
        return this.getNameValueRecordProposals(this.getDocumentOffset(), EGLDeclarationProposalHandler.ALL_RECORDS);
    }

    private List getNameValueProposals(int documentOffset, List itemNames) {
        ArrayList proposals = new ArrayList();
        for (String displayString : itemNames) {
            proposals.addAll(this.referenceCompletion.createProposal(this.viewer, displayString, displayString, this.prefix, UINlsStrings.CAProposal_ItemName, this.getDocumentOffset(), displayString.length(), 0));
        }
        return proposals;
    }

    private List getNameValueSelectFromListProposals(int documentOffset) {
        List itemNames = this.referenceCompletion.getArrayItemNames(this.viewer, this.getDocumentOffset(), null);
        return this.getNameValueProposals(documentOffset, itemNames);
    }

    private List getNameValueSelectedValueItemProposals(int documentOffset) {
        List itemNames = this.referenceCompletion.getItemNames(this.viewer, this.getDocumentOffset(), null, false);
        return this.getNameValueProposals(documentOffset, itemNames);
    }

    private List getNameValueSelectedRowItemProposals(int documentOffset) {
        List itemNames = this.referenceCompletion.getItemNames(this.viewer, this.getDocumentOffset(), null, false);
        return this.getNameValueProposals(documentOffset, itemNames);
    }

    private List getNameValueVariableRecordProposals(int documentOffset, int recordType) {
        List proposals = new ArrayList();
        if (this.part instanceof Program) {
            proposals = new EGLDeclarationProposalHandler(this.viewer, this.getDocumentOffset(), this.prefix, this.boundNode).getRecordProposals(recordType, false, false);
        }
        return proposals;
    }

    private List getQuotedValueHelpMsgKeyProposals(int documentOffset, String displayString) {
        ArrayList proposals = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        buffer.append(displayString);
        int cursorPosition = this.hasQuoteEnd ? buffer.toString().length() - 1 : buffer.toString().length() - 2;
        proposals.addAll(this.referenceCompletion.createProposal(this.viewer, displayString, buffer.toString(), this.prefix, UINlsStrings.CAProposal_KeyValue, this.getDocumentOffset(), cursorPosition, 1));
        return proposals;
    }

    private List getQuotedValueHelpFormProposals(int documentOffset) {
        ArrayList proposals = new ArrayList();
        return proposals;
    }

    private List getNameValueFunctionProposals(int documentOffset) {
        ArrayList proposals = new ArrayList();
        List itemNames = this.referenceCompletion.getFunctionNames(this.viewer, this.getDocumentOffset());
        Iterator iter = itemNames.iterator();
        while (iter.hasNext()) {
            String displayString;
            String proposalString = displayString = (String)iter.next();
            proposals.addAll(this.referenceCompletion.createProposal(this.viewer, displayString, proposalString, this.prefix, UINlsStrings.CAProposal_NestedFunction, this.getDocumentOffset(), displayString.length(), 0));
        }
        return proposals;
    }

    private List getQuotedValueProposal(int documentOffset) {
        return this.referenceCompletion.createProposal(this.viewer, "\"\"", this.prefix, "", this.getDocumentOffset(), 1, 0);
    }
}

