/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLVariableDotProposalHandler
extends EGLAbstractProposalHandler {
    private Type qualifierType;
    private Expression qualifierExpression;
    private boolean isVariable;

    public EGLVariableDotProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, Type qualifierType, boolean isVariable, Expression qualifierExpression) {
        super(viewer, documentOffset, prefix, editor);
        this.qualifierType = qualifierType;
        this.qualifierExpression = qualifierExpression;
        this.isVariable = isVariable;
    }

    public List getProposals(List propertyBlockList) {
        return this.getProposals(true, propertyBlockList);
    }

    public List getProposals(boolean includeFunctions, List propertyBlockList) {
        return this.getProposals(includeFunctions, false, false, propertyBlockList);
    }

    public List getProposals(boolean includeFunctions, boolean addEquals, List propertyBlockList) {
        return this.getProposals(includeFunctions, addEquals, false, propertyBlockList);
    }

    public List getProposals(boolean includeFunctions, boolean addEquals, boolean includePrivateFields, List propertyBlockList) {
        ArrayList result = new ArrayList();
        if (this.qualifierType != null && this.qualifierType.getClassifier() != null) {
            result.addAll(this.getFieldProposals(BindingUtil.getAllFields((Type)this.qualifierType.getClassifier()), addEquals, includePrivateFields, propertyBlockList));
            if (includeFunctions) {
                result.addAll(this.getFunctionProposals(BindingUtil.getAllFunctions((Type)this.qualifierType.getClassifier()), UINlsStrings.bind((String)UINlsStrings.CAProposal_LibraryFunction, (Object)EGLVariableDotProposalHandler.getTypeString(this.qualifierType)), 50));
            }
            if (!this.isVariable) {
                return this.filterStaticMembers(result);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private List filterStaticMembers(List members) {
        ArrayList<Member> filteredList = new ArrayList<Member>();
        for (Member next : members) {
            if (!next.isStatic().booleanValue()) continue;
            filteredList.add(next);
        }
        return filteredList;
    }

    private List getFieldProposals(List<Field> fields, boolean addEquals, boolean includePrivateFields, List propertyBlockList, String ImgKeyStr) {
        ArrayList<EGLCompletionProposal> result = new ArrayList<EGLCompletionProposal>();
        String fieldImgKeyStr = ImgKeyStr == "" ? "org.eclipse.edt.ide.ui.envvar_obj.gif" : ImgKeyStr;
        for (Field field : fields) {
            String proposalString;
            if (!includePrivateFields && field.getAccessKind() == AccessKind.ACC_PRIVATE && !(this.qualifierExpression instanceof ThisExpression) || !(proposalString = field.getCaseSensitiveName()).toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
            String displayString = String.valueOf(proposalString) + " : " + EGLVariableDotProposalHandler.getTypeString(field.getType()) + " - " + EGLVariableDotProposalHandler.getNameFromElement((Element)field.getContainer());
            if (this.containsProperty(proposalString, propertyBlockList)) continue;
            if (addEquals) {
                proposalString = EGLVariableDotProposalHandler.needSetFunctionForTheField(field) ? String.valueOf(proposalString) + " ::= " : String.valueOf(proposalString) + " = ";
            }
            result.add(new EGLCompletionProposal(this.viewer, displayString, proposalString, this.getAdditionalInfo((Member)field), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), 49, fieldImgKeyStr));
        }
        return result;
    }

    private List getFieldProposals(List<Field> fields, boolean addEquals, boolean includePrivateFields, List propertyBlockList) {
        return this.getFieldProposals(fields, addEquals, includePrivateFields, propertyBlockList, "");
    }

    private List getFunctionProposals(List<Function> functions, String additionalInformation, int relevance) {
        ArrayList result = new ArrayList();
        for (Function function : functions) {
            if (function.getAccessKind() == AccessKind.ACC_PRIVATE || !function.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
            result.addAll(this.createFunctionInvocationProposals((FunctionMember)function, additionalInformation, relevance, false));
        }
        return result;
    }

    public static boolean needSetFunctionForTheField(Field field) {
        for (Annotation ann : field.getAnnotations()) {
            Object value;
            if (ann.getEClass() == null || !ann.getEClass().getName().equalsIgnoreCase("Property") && !ann.getEClass().getName().equalsIgnoreCase("EGLProperty") || (value = ann.getValue("setMethod")) == null || !value.equals("")) continue;
            return true;
        }
        return false;
    }
}

