/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.bidi.IBIDIProvider;
import org.eclipse.edt.ide.ui.editor.IEGLEditor;
import org.eclipse.edt.ide.ui.editor.IFoldingStructureProvider;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLSourceViewer;
import org.eclipse.edt.ide.ui.internal.editor.EGLSourceViewerConfiguration;
import org.eclipse.edt.ide.ui.internal.editor.EGLUIHelp;
import org.eclipse.edt.ide.ui.internal.editor.EditorErrorTickUpdater;
import org.eclipse.edt.ide.ui.internal.editor.EditorUtility;
import org.eclipse.edt.ide.ui.internal.editor.SourceViewerInformationControl;
import org.eclipse.edt.ide.ui.internal.editor.TextTools;
import org.eclipse.edt.ide.ui.internal.outline.ImportGroup;
import org.eclipse.edt.ide.ui.internal.outline.OutlineAdapterFactory;
import org.eclipse.edt.ide.ui.internal.outline.OutlineLabelProvider;
import org.eclipse.edt.ide.ui.internal.outline.OutlinePage;
import org.eclipse.edt.ide.ui.internal.preferences.ContentAssistPreference;
import org.eclipse.edt.ide.ui.internal.results.views.AbstractResultsViewPart;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EGLEditor
extends TextEditor
implements IEGLEditor {
    public static final String TOGGLE_PRESENTATION = "togglePresentation";
    public static final String FOLDING_TOGGLE_ID = "FoldingToggle";
    public static final String FOLDING_EXPANDALL_ID = "FoldingExpandAll";
    public static final String FOLDING_EXPAND_ID = "FoldingExpand";
    public static final String FOLDING_COLLAPSE_ID = "FoldingCollapse";
    public static final String RENAME_ID = "org.eclipse.jdt.ui.actions.Rename";
    public static final String MOVE_ID = "org.eclipse.jdt.ui.actions.Move";
    private static final String COMPILER_TASK_TAGS = "org.eclipse.jdt.core.compiler.taskTags";
    private OutlinePage fOutlinePage;
    protected String fOutlinerContextMenuID;
    private boolean disableRulerArea;
    protected HashMap nodesWithSavedErrors;
    protected HashMap nodesWithSavedWarnings;
    AbstractResultsViewPart sqlErrorView;
    protected TextTools tools;
    private IPropertyChangeListener fPropertyChangeListener;
    protected ISelectionChangedListener fSelectionChangedListener = new SelectionChangedListener();
    private int fIgnoreOutlinePageSelection = 0;
    private OutlineAdapterFactory factory;
    private ProjectionSupport fProjectionSupport;
    private IFoldingStructureProvider fFoldingStructureProvider;
    private IBIDIProvider fBIDIProvider;
    private ToggleFoldingRunner fFoldingRunner;
    private BracketInserter fBracketInserter = new BracketInserter();
    private EditorErrorTickUpdater fEGLEditorErrorTickUpdater;

    protected void handlePreferencePropertyChanged(PropertyChangeEvent event) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (COMPILER_TASK_TAGS.equals(event.getProperty()) && sourceViewer != null && this.affectsTextPresentation(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()))) {
            sourceViewer.invalidateTextPresentation();
        }
        if ("org.eclipse.jdt.ui.editor.showSegments".equals(event.getProperty()) && sourceViewer != null && this.affectsTextPresentation(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()))) {
            sourceViewer.invalidateTextPresentation();
        }
    }

    public EGLEditor() {
        this(false);
    }

    public EGLEditor(boolean disableRulerArea) {
        this.disableRulerArea = disableRulerArea;
        if (this.tools == null) {
            this.tools = new TextTools(EDTUIPlugin.getDefault().getPreferenceStore());
        }
        this.initializeKeyBindingScopes();
        this.fEGLEditorErrorTickUpdater = new EditorErrorTickUpdater(this);
    }

    protected void initializeEditor() {
        DocumentProvider documentProvider = (DocumentProvider)EGLUI.getDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)documentProvider);
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#EGLEditorContext");
        this.setRulerContextMenuId("#EGLRulerContext");
        this.setOutlinerContextMenuId("#EGLOutlinerContext");
        if (this.tools == null) {
            this.tools = new TextTools(EDTUIPlugin.getDefault().getPreferenceStore());
        }
        this.setPreferenceStore(this.createCombinedPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new EGLSourceViewerConfiguration(this.tools, (ITextEditor)this));
        this.factory = new OutlineAdapterFactory(null, this);
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return true;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        if (Locale.getDefault().toString().toLowerCase().indexOf("ar") != -1) {
            styles |= 0x2000000;
        }
        AdaptedSourceViewer sourceViewer = new AdaptedSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sourceViewer.getTextWidget(), IUIHelpConstants.EGL_EDITOR);
        if (sourceViewer != null && this.isFoldingEnabled()) {
            sourceViewer.prepareDelayedProjection();
        }
        AdaptedSourceViewer projectionViewer = sourceViewer;
        this.createFoldingSupport(projectionViewer);
        this.fFoldingStructureProvider = EDTUIPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
        if (this.fFoldingStructureProvider != null) {
            this.fFoldingStructureProvider.install((ITextEditor)this, projectionViewer);
        }
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    public void doSelectionChanged(SelectionChangedEvent event) {
        int nodeLength;
        int offset;
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IEGLDocument document = (IEGLDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            return;
        }
        if (selectedElement instanceof ImportGroup) {
            offset = ((ImportGroup)selectedElement).getOffset();
            nodeLength = ((ImportGroup)selectedElement).getLength();
        } else if (selectedElement instanceof ImportDeclaration || selectedElement instanceof PackageDeclaration) {
            offset = ((Node)selectedElement).getOffset();
            nodeLength = ((Node)selectedElement).getLength();
        } else {
            offset = ((Node)selectedElement).getOffset();
            nodeLength = ((Node)selectedElement).getLength();
        }
        try {
            this.editingScriptStarted();
            this.setSelection(offset, nodeLength);
            TreeViewer tv = (TreeViewer)event.getSource();
            ILabelProvider provider = (ILabelProvider)tv.getLabelProvider();
            IRegion region = ((OutlineLabelProvider)provider).getHighlightRange(selectedElement);
            if (region.getLength() != 0) {
                this.getSourceViewer().revealRange(region.getOffset(), region.getLength());
                this.getSourceViewer().setSelectedRange(region.getOffset(), region.getLength());
            }
        }
        finally {
            this.editingScriptEnded();
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IReconciler reconciler;
        ISourceViewer sourceViewer = this.getSourceViewer();
        EGLSourceViewer eglSourceViewer = null;
        if (sourceViewer instanceof EGLSourceViewer) {
            eglSourceViewer = (EGLSourceViewer)sourceViewer;
        }
        IPreferenceStore store = this.getPreferenceStore();
        if (eglSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.eclipse.jdt.ui.editor.showSegments"))) {
            eglSourceViewer.prepareDelayedProjection();
        }
        super.doSetInput(input);
        if (eglSourceViewer != null && eglSourceViewer.getReconciler() == null && (reconciler = this.getSourceViewerConfiguration().getReconciler((ISourceViewer)eglSourceViewer)) != null) {
            reconciler.install((ITextViewer)sourceViewer);
        }
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
        EditorUtility.populateNodeErrorWarningHashMaps(this);
        this.setOutlinePageInput(this.fOutlinePage, input);
    }

    protected void setOutlinePageInput(OutlinePage page, IEditorInput input) {
        if (page != null) {
            DocumentProvider provider = (DocumentProvider)this.getDocumentProvider();
            page.setInput((IEGLDocument)provider.getDocument(input));
        }
    }

    protected OutlinePage createOutlinePage() {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (doc instanceof IEGLDocument) {
            OutlinePage page = new OutlinePage((IEGLDocument)doc, this.fOutlinerContextMenuID, this);
            page.addSelectionChangedListener(this.fSelectionChangedListener);
            this.setOutlinePageInput(page, this.getEditorInput());
            this.fOutlinePage = page;
            return page;
        }
        return null;
    }

    public void outlinePageClosed() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.removeSelectionChangedListener(this.fSelectionChangedListener);
            this.fOutlinePage = null;
            this.resetHighlightRange();
        }
    }

    @Override
    public int getLineAtOffset(int offset) {
        try {
            EGLDocument document = (EGLDocument)this.getViewer().getDocument();
            return document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            EGLLogger.log((Object)this, e);
            return 0;
        }
    }

    public synchronized void editingScriptStarted() {
        ++this.fIgnoreOutlinePageSelection;
    }

    public synchronized void editingScriptEnded() {
        --this.fIgnoreOutlinePageSelection;
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("editor_folding_enabled");
    }

    public synchronized boolean isEditingScriptRunning() {
        return this.fIgnoreOutlinePageSelection > 0;
    }

    public void setSelection(int offset, int nodeLength) {
        StyledText textWidget = null;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            textWidget = sourceViewer.getTextWidget();
        }
        if (textWidget == null) {
            return;
        }
        try {
            if (offset < 0 || nodeLength < 0) {
                return;
            }
            try {
                textWidget.setRedraw(false);
                this.setHighlightRange(offset, nodeLength, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        finally {
            if (textWidget != null) {
                textWidget.setRedraw(true);
            }
        }
    }

    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.sqlErrorView != null) {
            this.sqlErrorView.closeMyViewerIfNecessary(this);
        }
        if (this.tools != null) {
            this.tools.dispose();
            this.tools = null;
        }
        if (this.fFoldingStructureProvider != null) {
            this.fFoldingStructureProvider.uninstall();
            this.fFoldingStructureProvider = null;
        }
        if (this.fBIDIProvider != null) {
            this.fBIDIProvider.uninstall();
            this.fBIDIProvider = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fPropertyChangeListener != null) {
            IPreferenceStore pref = this.getPreferenceStore();
            if (pref != null) {
                pref.removePropertyChangeListener(this.fPropertyChangeListener);
            }
            this.fPropertyChangeListener = null;
        }
        if (this.fEGLEditorErrorTickUpdater != null) {
            this.fEGLEditorErrorTickUpdater.dispose();
            this.fEGLEditorErrorTickUpdater = null;
        }
        super.dispose();
    }

    public OutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            return this.createOutlinePage();
        }
        return this.fOutlinePage;
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        stores.add(EDTUIPlugin.getDefault().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        stores.add(PlatformUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.edt.ide.ui.eglEditorScope"});
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuID = menuId;
    }

    public Object getAdapter(Class required) {
        Object adapter;
        IFile resource;
        IEGLElement element;
        IEditorInput editorInput;
        if (required == IEGLEditor.class || required == EGLEditor.class) {
            return this;
        }
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.getOutlinePage();
        }
        if (required == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (required == IShowInSource.class && (editorInput = this.getEditorInput()) instanceof IFileEditorInput && (element = EGLCore.create((IResource)(resource = ((IFileEditorInput)this.getEditorInput()).getFile()))) != null) {
            final StructuredSelection selection = new StructuredSelection((Object)element);
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext((Object)EGLEditor.this.getEditorInput(), (ISelection)selection);
                }
            };
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        if (required == IContextProvider.class) {
            return EGLUIHelp.getHelpContextProvider((IWorkbenchPart)this, IUIHelpConstants.EGL_EDITOR);
        }
        return super.getAdapter(required);
    }

    public StyledText getSourceViewerStyledText() {
        return this.getSourceViewer().getTextWidget();
    }

    public AbstractResultsViewPart getSqlErrorView() {
        return this.sqlErrorView;
    }

    @Override
    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void setSqlErrorView(AbstractResultsViewPart sqlErrorView) {
        this.sqlErrorView = sqlErrorView;
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    public void synchronizeOutlinePageSelection() {
        if (this.isEditingScriptRunning()) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null || this.fOutlinePage == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        int offset = this.getSourceViewer().getTextWidget().getSelection().x;
        IEGLDocument document = (IEGLDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (offset > 0) {
            --offset;
        }
        Node node = document.getNewModelNodeAtOffset(offset);
        this.factory = new OutlineAdapterFactory(null, this);
        while (node != null && !this.factory.isDisplayableElement(node)) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        int nodeEndOffset = node.getOffset() + node.getLength();
        if (offset + 1 > nodeEndOffset) {
            while ((node = node.getParent()) != null && !this.factory.isDisplayableElement(node)) {
            }
        }
        this.fOutlinePage.removeSelectionChangedListener(this.fSelectionChangedListener);
        this.fOutlinePage.select(node);
        this.fOutlinePage.addSelectionChangedListener(this.fSelectionChangedListener);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            IContentAssistant c;
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            String property = event.getProperty();
            if ("org.eclipse.jdt.ui.editor.tab.width".equals(property)) {
                Object value = event.getNewValue();
                if (value instanceof Integer) {
                    sourceViewer.getTextWidget().setTabs(((Integer)value).intValue());
                } else if (value instanceof String) {
                    sourceViewer.getTextWidget().setTabs(Integer.parseInt((String)value));
                }
                return;
            }
            if ("editor_folding_provider".equals(property) && sourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
                if (this.fFoldingStructureProvider != null) {
                    this.fFoldingStructureProvider.uninstall();
                }
                this.fFoldingStructureProvider = EDTUIPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
                if (this.fFoldingStructureProvider != null) {
                    this.fFoldingStructureProvider.install((ITextEditor)this, projectionViewer);
                }
            }
            if ("editor_folding_enabled".equals(property)) {
                if (sourceViewer instanceof ProjectionViewer) {
                    new ToggleFoldingRunner().runWhenNextVisible();
                }
                return;
            }
            if ("content_assist_autoactivation".equals(property)) {
                c = ((AdaptedSourceViewer)sourceViewer).getContentAssistant();
                if (c instanceof ContentAssistant) {
                    ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                }
                return;
            }
            if ("content_assist_autoactivation_delay".equals(property)) {
                c = ((AdaptedSourceViewer)sourceViewer).getContentAssistant();
                if (c instanceof ContentAssistant) {
                    ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                }
                return;
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.tools.affectsBehavior(event);
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public void setNodesWithSavedErrors(HashMap hashMap) {
        this.nodesWithSavedErrors = hashMap;
    }

    public HashMap getNodesWithSavedErrors() {
        return this.nodesWithSavedErrors;
    }

    public void setNodesWithSavedWarnings(HashMap hashMap) {
        this.nodesWithSavedWarnings = hashMap;
    }

    public HashMap getNodesWithSavedWarnings() {
        return this.nodesWithSavedWarnings;
    }

    public OutlineAdapterFactory getOutlineAdapterFactory() {
        return this.factory;
    }

    public OutlinePage primGetOutlinePage() {
        return this.fOutlinePage;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getVerticalRuler().getControl().setEnabled(!this.disableRulerArea);
        this.fBracketInserter.setCloseBracketsEnabled(true);
        this.fBracketInserter.setCloseStringsEnabled(true);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    private void createFoldingSupport(ProjectionViewer projectionViewer) {
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new SourceViewerInformationControl(shell);
            }
        });
        this.fProjectionSupport.install();
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fFoldingStructureProvider != null) {
                    this.fFoldingStructureProvider.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fFoldingStructureProvider != null) {
                    this.fFoldingStructureProvider.install((ITextEditor)this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isPrefQuickDiffAlwaysOn() {
        if (this.disableRulerArea) {
            return false;
        }
        return super.isPrefQuickDiffAlwaysOn();
    }

    public SourceViewerConfiguration getSourceViewerConfig() {
        return this.getSourceViewerConfiguration();
    }

    public IVerticalRuler getEditorVerticalRuler() {
        return super.getVerticalRuler();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.copy", ITextEditorActionConstants.SELECT_ALL);
        this.addAction(menu, "group.find", ITextEditorActionConstants.FIND);
        this.addAction(menu, "group.undo", ITextEditorActionConstants.REDO);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                try {
                    IContributionItem item = menu.find("org.eclipse.edt.ide.ui.file.sourceMenu");
                    if (item != null) {
                        menu.remove(item);
                    }
                }
                finally {
                    menu.removeMenuListener((IMenuListener)this);
                }
            }
        });
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"org.eclipse.edt.ide.ui.editorPreferences", "org.eclipse.edt.ide.ui.contentAssistPreferences", "org.eclipse.edt.ide.ui.foldingPreferences", "org.eclipse.edt.ide.ui.formatterPreferences", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.edt.ide.ui.organizeImportsPreferencePage", "org.eclipse.edt.ide.ui.sourceStylesPreferences", "org.eclipse.edt.ide.ui.templatePreferences", "org.eclipse.edt.ide.ui.ContentAssistAdvancedPreferences"};
    }

    class AdaptedSourceViewer
    extends EGLSourceViewer {
        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private final String CATEGORY = this.toString();
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
        private Stack fBracketLevelStack = new Stack();

        private BracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || EGLEditor.this.getInsertMode() != SMART_INSERT) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '{': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer sourceViewer = EGLEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                ITypedRegion partition;
                IRegion startLine = document.getLineInformationOfOffset(offset);
                IRegion endLine = document.getLineInformationOfOffset(offset + length);
                int scanOffset = startLine.getOffset();
                String leftOfSelection = document.get(scanOffset, offset - scanOffset);
                String rightOfSelection = document.get(offset, endLine.getOffset() + endLine.getLength() - offset - length);
                Symbol prevToken = new Symbol(0);
                Symbol nextToken = new Symbol(0);
                Lexer leftScanner = null;
                Lexer rightScanner = null;
                leftScanner = new Lexer((Reader)new StringReader(leftOfSelection));
                Symbol tmp = leftScanner.next_token();
                while (tmp.sym != 0) {
                    prevToken = tmp;
                    tmp = leftScanner.next_token();
                }
                String previous = prevToken.sym == 0 ? null : document.get(prevToken.left + scanOffset, offset - scanOffset - prevToken.left).trim();
                rightScanner = new Lexer((Reader)new StringReader(rightOfSelection));
                nextToken = rightScanner.next_token();
                String next = nextToken.sym == 0 || nextToken.sym == 72 || nextToken.sym == 67 ? null : document.get(offset + length + nextToken.left, nextToken.right - nextToken.left).trim();
                switch (event.character) {
                    case '(': {
                        if (this.fCloseBrackets && nextToken.sym != 54 && nextToken.sym != 97 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '{': {
                        if (this.fCloseBrackets && nextToken.sym != 58 && nextToken.sym != 97 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '[': {
                        if (this.fCloseBrackets && nextToken.sym != 97 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        if (!(!this.fCloseStrings || nextToken.sym == 97 || prevToken.sym == 97 || next != null && next.length() > 1 || previous != null && previous.length() > 1) && (previous == null || previous.length() != 1 || previous.charAt(0) != event.character)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (!"__dftl_partition_content_type".equals((partition = TextUtilities.getPartition((IDocument)document, (String)"___egl_partitioning", (int)offset, (boolean)true)).getType())) {
                    return;
                }
                if (!EGLEditor.this.validateEditorInputState()) {
                    return;
                }
                char character = event.character;
                char closingCharacter = EGLEditor.getPeerCharacter(character);
                StringBuffer buffer = new StringBuffer();
                buffer.append(character);
                buffer.append(closingCharacter);
                document.replace(offset, length, buffer.toString());
                BracketLevel level = new BracketLevel();
                this.fBracketLevelStack.push(level);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addLinkingListener((ILinkedModeListener)this);
                model.addGroup(group);
                model.forceInstall();
                level.fOffset = offset;
                level.fLength = 2;
                if (this.fBracketLevelStack.size() == 1) {
                    document.addPositionCategory(this.CATEGORY);
                    document.addPositionUpdater(this.fUpdater);
                }
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + 1, 1);
                document.addPosition(this.CATEGORY, level.fFirstPosition);
                document.addPosition(this.CATEGORY, level.fSecondPosition);
                level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                level.fUI.setSimpleMode(true);
                level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, EGLEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                level.fUI.enter();
                IRegion newSelection = level.fUI.getSelectedRegion();
                sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                event.doit = false;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                EGLLogger.log((Object)this, e);
            }
            catch (BadPositionCategoryException e) {
                e.printStackTrace();
                EGLLogger.log((Object)this, e);
            }
            catch (IOException e) {
                e.printStackTrace();
                EGLLogger.log((Object)this, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                EGLLogger.log((Object)this, e);
            }
        }

        public void left(LinkedModeModel environment, int flags) {
            final BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = EGLEditor.this.getSourceViewer();
            final IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                            try {
                                document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                                EGLLogger.log((Object)this, e);
                            }
                        }
                        if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                            document.removePositionUpdater(BracketInserter.this.fUpdater);
                            try {
                                document.removePositionCategory(BracketInserter.this.CATEGORY);
                            }
                            catch (BadPositionCategoryException e) {
                                e.printStackTrace();
                                EGLLogger.log((Object)this, e);
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    BracketLevel level = (BracketLevel)this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = EGLEditor.this.getSourceViewer().getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = EGLEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Control control;
            if (EGLEditor.this.primGetOutlinePage() != null && (control = EGLEditor.this.primGetOutlinePage().getControl()) != null && !control.isDisposed() && control.isFocusControl()) {
                EGLEditor.this.doSelectionChanged(event);
            }
        }
    }

    private final class ToggleFoldingRunner
    implements IPartListener2 {
        private IWorkbenchPage fPage;

        private ToggleFoldingRunner() {
        }

        private void toggleFolding() {
            ProjectionViewer pv;
            ISourceViewer sourceViewer = EGLEditor.this.getSourceViewer();
            if (sourceViewer instanceof ProjectionViewer && (pv = (ProjectionViewer)sourceViewer).isProjectionMode() != EGLEditor.this.isFoldingEnabled() && pv.canDoOperation(19)) {
                pv.doOperation(19);
            }
        }

        public void runWhenNextVisible() {
            IWorkbenchPage page;
            if (EGLEditor.this.fFoldingRunner != null) {
                EGLEditor.this.fFoldingRunner.cancel();
                return;
            }
            IWorkbenchPartSite site = EGLEditor.this.getSite();
            if (site != null && !(site instanceof MultiPageEditorSite) && !(page = site.getPage()).isPartVisible((IWorkbenchPart)EGLEditor.this)) {
                this.fPage = page;
                EGLEditor.this.fFoldingRunner = this;
                page.addPartListener((IPartListener2)this);
                return;
            }
            this.toggleFolding();
        }

        private void cancel() {
            if (this.fPage != null) {
                this.fPage.removePartListener((IPartListener2)this);
                this.fPage = null;
            }
            if (EGLEditor.this.fFoldingRunner == this) {
                EGLEditor.this.fFoldingRunner = null;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (EGLEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
                this.toggleFolding();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (EGLEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

