/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.externaltype.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.ui.internal.externaltype.conversion.javatype.JavaTypeConstants;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.JavaType;

public class ReflectionUtil {
    public static Class<?> getClass(ClassLoader urlLoader, String fullyQualifiedName) {
        try {
            return Class.forName(fullyQualifiedName, true, urlLoader);
        }
        catch (Throwable ee) {
            ee.printStackTrace();
            return null;
        }
    }

    public static void getInnerTypes(Class<?> clazz, Map<Class<?>, JavaType> toBeGenerated) {
        Class<?>[] innerClasses = clazz.getDeclaredClasses();
        if (innerClasses != null) {
            Class<?>[] classArray = innerClasses;
            int n = innerClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> inner = classArray[n2];
                if (Modifier.isPublic(inner.getModifiers())) {
                    JavaType javaType = new JavaType();
                    javaType.setSource(0);
                    ArrayList<Field> selectedFields = new ArrayList<Field>();
                    Field[] fieldArray = inner.getDeclaredFields();
                    int n3 = fieldArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Field field = fieldArray[n4];
                        if (Modifier.isPublic(field.getModifiers())) {
                            selectedFields.add(field);
                        }
                        ++n4;
                    }
                    javaType.setFields(selectedFields);
                    ArrayList selectedCons = new ArrayList();
                    Constructor<?>[] constructorArray = inner.getDeclaredConstructors();
                    int n5 = constructorArray.length;
                    n3 = 0;
                    while (n3 < n5) {
                        Constructor<?> constr = constructorArray[n3];
                        if (Modifier.isPublic(constr.getModifiers())) {
                            selectedCons.add(constr);
                        }
                        ++n3;
                    }
                    javaType.setConstructors(selectedCons);
                    ArrayList<Method> selectedMethods = new ArrayList<Method>();
                    Method[] methodArray = inner.getDeclaredMethods();
                    int n6 = methodArray.length;
                    n5 = 0;
                    while (n5 < n6) {
                        Method method = methodArray[n5];
                        if (Modifier.isPublic(method.getModifiers())) {
                            selectedMethods.add(method);
                        }
                        ++n5;
                    }
                    javaType.setMethods(selectedMethods);
                    toBeGenerated.put(inner, javaType);
                }
                ++n2;
            }
        }
    }

    public static Set<Class<?>> getAllSuperTypes(Class<?> clazz) {
        HashSet superTypes = new HashSet();
        Class<?> declaringClass = clazz;
        while (declaringClass != null && !declaringClass.equals(Object.class)) {
            Class<?>[] interfaces;
            Class<?> superClass = declaringClass.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class)) {
                superTypes.add(superClass);
            }
            Class<?>[] classArray = interfaces = declaringClass.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                superTypes.addAll(ReflectionUtil.getImplementedInterfaces(interfaceClass));
                ++n2;
            }
            declaringClass = declaringClass.getSuperclass();
        }
        return superTypes;
    }

    public static Set<Class<?>> getImplementedInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                interfaces.addAll(ReflectionUtil.getImplementedInterfaces(iface));
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static Set<Class<?>> getFieldReferencedTypes(List<Field> fields) {
        HashSet referenced = new HashSet();
        for (Field field : fields) {
            if (ReflectionUtil.isBuiltinEglType(field.getType())) continue;
            referenced.add(field.getType());
        }
        return referenced;
    }

    public static Set<Class<?>> getConReferencedTypes(List<Constructor<?>> constructors) {
        HashSet referenced = new HashSet();
        for (Constructor<?> constructor : constructors) {
            Class<?>[] paraTypes;
            Class<?>[] classArray = paraTypes = constructor.getParameterTypes();
            int n = paraTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> paraType = classArray[n2];
                if (!ReflectionUtil.isBuiltinEglType(paraType = ReflectionUtil.getComponentClass(paraType))) {
                    referenced.add(paraType);
                }
                ++n2;
            }
        }
        return referenced;
    }

    public static Set<Class<?>> getMethodReferencedTypes(List<Method> methods) {
        HashSet referenced = new HashSet();
        for (Method method : methods) {
            Class<?>[] paraTypes;
            Class<?>[] classArray = paraTypes = method.getParameterTypes();
            int n = paraTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> paraType = classArray[n2];
                if (!ReflectionUtil.isBuiltinEglType(paraType = ReflectionUtil.getComponentClass(paraType)) && !Object.class.equals(paraType)) {
                    referenced.add(paraType);
                }
                ++n2;
            }
            Class<?> returnType = ReflectionUtil.getComponentClass(method.getReturnType());
            if (Void.TYPE.equals(returnType) || Object.class.equals(returnType) || ReflectionUtil.isBuiltinEglType(returnType)) continue;
            referenced.add(returnType);
        }
        return referenced;
    }

    public static String getMethodLabel(Method method) {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append(method.getName());
        buffer.append('(');
        Class<?>[] paraTypes = method.getParameterTypes();
        int i = 0;
        while (i < paraTypes.length) {
            buffer.append(paraTypes[i].getSimpleName());
            if (i < paraTypes.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getConstructorLabel(Constructor<?> con) {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append(con.getDeclaringClass().getSimpleName());
        buffer.append('(');
        Class<?>[] paraTypes = con.getParameterTypes();
        int i = 0;
        while (i < paraTypes.length) {
            buffer.append(paraTypes[i].getSimpleName());
            if (i < paraTypes.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getJavaFieldLabel(Field field) {
        StringBuilder buffer = new StringBuilder(60);
        if (Modifier.isStatic(field.getModifiers())) {
            buffer.append("static ");
        }
        buffer.append(String.valueOf(field.getName()) + " " + ReflectionUtil.getTypeName(field.getType()));
        return buffer.toString();
    }

    public static String getFieldLabel(Field field) {
        StringBuilder buffer = new StringBuilder(60);
        if (Modifier.isStatic(field.getModifiers())) {
            buffer.append("static ");
        }
        boolean isEGLKeyWord = EGLNameValidator.isKeyword((String)field.getName());
        boolean isStartWithEze = field.getName().toLowerCase().startsWith("eze");
        if (isEGLKeyWord || isStartWithEze) {
            buffer.append("_");
        }
        buffer.append(String.valueOf(field.getName()) + " " + ReflectionUtil.getEGLTypeName(field.getType()));
        if (isStartWithEze) {
            buffer.append(' ');
            buffer.append("{externalName = \"" + field.getName() + "\"}");
        }
        return buffer.toString();
    }

    public static String getEGLTypeName(Class<?> paraType) {
        int dim = 0;
        while (paraType.isArray()) {
            ++dim;
            paraType = paraType.getComponentType();
        }
        String typeName = JavaTypeConstants.JavaToEglMapping.get(paraType.getName());
        if (typeName == null) {
            typeName = paraType.getSimpleName();
            if (!paraType.isPrimitive()) {
                typeName = String.valueOf(typeName) + "?";
            }
            if (paraType.getEnclosingClass() != null) {
                typeName = String.valueOf(paraType.getEnclosingClass().getSimpleName()) + "_" + typeName;
            }
        }
        boolean isEGLPart = JavaTypeConstants.EglPartNames.contains(paraType.getSimpleName().toLowerCase(Locale.ENGLISH));
        boolean isStartWithEze = typeName.toLowerCase().startsWith("eze");
        if (isEGLPart || isStartWithEze) {
            typeName = "_" + typeName;
        }
        while (dim > 0) {
            typeName = String.valueOf(typeName) + "[]";
            --dim;
        }
        return typeName;
    }

    public static String getTypeName(Class<?> paraType) {
        int dim = 0;
        while (paraType.isArray()) {
            ++dim;
            paraType = paraType.getComponentType();
        }
        String typeName = paraType.getSimpleName();
        while (dim > 0) {
            typeName = String.valueOf(typeName) + "[]";
            --dim;
        }
        return typeName;
    }

    public static boolean isBuiltinEglType(Class<?> paraType) {
        String typeName = JavaTypeConstants.JavaToEglMapping.get((paraType = ReflectionUtil.getComponentClass(paraType)).getName());
        return typeName != null;
    }

    public static Class<?> getComponentClass(Class<?> paraType) {
        Class<?> clazz = paraType;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static boolean isSkippedType(Class<?> paraType) {
        boolean skipped = false;
        if (paraType.isArray()) {
            return true;
        }
        if (Byte.TYPE.equals(paraType) || Byte.class.equals(paraType) || Character.TYPE.equals(paraType) || Character.class.equals(paraType)) {
            skipped = true;
        }
        return skipped;
    }
}

