/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.BytesLiteral;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CallSynchronizationValues;
import org.eclipse.edt.compiler.core.ast.CallbackTarget;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.ContinueStatement;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ElseBlock;
import org.eclipse.edt.compiler.core.ast.EmptyStatement;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FromExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.GotoStatement;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.InlineSQLStatement;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.IsNotExpression;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.MoveModifier;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Parameter;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.ReturningToInvocationTargetClause;
import org.eclipse.edt.compiler.core.ast.ReturningToNameClause;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.SQLLiteral;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SetValuesStatement;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.SingleRowClause;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.core.ast.ThrowStatement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.TypeLiteralExpression;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.ide.ui.internal.formatting.CodeFormatterConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterVisitor
extends AbstractASTPartVisitor {
    private static final char SPACECHAR = ' ';
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private Map fPreferenceSetting;
    private Scanner fScanner;
    private IDocument fDocument;
    private String fLineSeparator;
    private int fFormatOffset;
    private int fFormatLength;
    private int fIndentationLevel;
    private List fEdits;
    private Symbol fPrevToken;
    private Symbol fCurrToken;
    private boolean fIsFirstImportDeclaration = true;
    private boolean fGlobalAddSpace = true;
    private int fGlobalNumOfBlankLines = -1;
    private int fCurrentWrappingPolicy = 1;
    private int fCurrentColumn = 0;
    private LinkedList fPendingWrapEdits;
    private boolean fIsWrappingNecessary = false;
    private Stack fContextPath;
    private boolean fIndentNeeded = true;

    public CodeFormatterVisitor(Map preferenceSetting, IDocument document, int offset, int length, int initialIndentationLevel, String lineSeparator) {
        this.fPreferenceSetting = preferenceSetting;
        this.fDocument = document;
        this.fFormatOffset = offset;
        this.fFormatLength = length;
        this.fLineSeparator = lineSeparator;
        this.fIndentationLevel = initialIndentationLevel;
        this.fEdits = new ArrayList();
        this.fPendingWrapEdits = new LinkedList();
        this.fContextPath = new Stack();
        String strSource = document.get();
        this.fScanner = new Lexer((Reader)new BufferedReader(new StringReader(strSource)));
    }

    private void setGlobalFormattingSettings(int numOfBlankLines, boolean addSpace, int wrappingPolicy) {
        this.fGlobalNumOfBlankLines = numOfBlankLines;
        this.fGlobalAddSpace = addSpace;
        this.fCurrentWrappingPolicy = wrappingPolicy;
    }

    public TextEdit format(File fileAST) {
        fileAST.accept((IASTVisitor)this);
        return this.getFinalEdits();
    }

    public boolean visit(File file) {
        this.push2ContextPath((Node)file);
        this.fCurrToken = this.nextToken();
        this.fPrevToken = new Symbol(-1, 0, 0);
        return true;
    }

    private void endVisitNode(Node astNode) {
        this.popContextPath();
    }

    public void endVisit(File file) {
        this.endVisitNode((Node)file);
    }

    public void visitPart(Part part) {
        final int partEndOffset = part.getLength() + part.getOffset();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (((CodeFormatterVisitor)CodeFormatterVisitor.this).fCurrToken.right == partEndOffset) {
                    CodeFormatterVisitor.this.printToken(CodeFormatterVisitor.this.fPrevToken, CodeFormatterVisitor.this.fCurrToken, 0, false);
                } else {
                    CodeFormatterVisitor.this.printKeywordToken(CodeFormatterVisitor.this.fCurrToken, CodeFormatterVisitor.this.fEdits);
                }
            }
        };
        this.formatNode((Node)part, callbackFormatter, this.getIntPrefSetting("blankLines.beforePartDecl"), false);
    }

    private int getIntPrefSetting(String key) {
        return CodeFormatterConstants.getIntPreferenceSetting(this.fPreferenceSetting, key);
    }

    private boolean getBooleanPrefSetting(String key) {
        return CodeFormatterConstants.getBooleanPreferenceSetting(this.fPreferenceSetting, key);
    }

    private int getEnumPrefSetting(String key) {
        return CodeFormatterConstants.getEnumPreferenceSetting(this.fPreferenceSetting, key);
    }

    private String getIndentationStringPreference() {
        String indentationString = "";
        int tabPolicyChoice = this.getEnumPrefSetting("generalSettings.tabPolicy");
        switch (tabPolicyChoice) {
            case 0: {
                StringBuffer strBuf = new StringBuffer();
                int indentSpaceSize = this.getIntPrefSetting("generalSettings.indentationSize");
                int i = 0;
                while (i < indentSpaceSize) {
                    strBuf.append(SPACE);
                    ++i;
                }
                indentationString = strBuf.toString();
                break;
            }
            case 1: {
                indentationString = TAB;
            }
        }
        return indentationString;
    }

    private String getIndentationString() {
        StringBuffer strIndentationBuffer = new StringBuffer();
        int j = 0;
        while (j < this.fIndentationLevel) {
            strIndentationBuffer.append(this.getIndentationStringPreference());
            ++j;
        }
        return strIndentationBuffer.toString();
    }

    private void indent() {
        this.indent(1);
    }

    private void unindent() {
        this.unindent(1);
    }

    private void indent(int numOfIndents) {
        this.fIndentationLevel += numOfIndents;
    }

    private void unindent(int numOfIndents) {
        this.fIndentationLevel -= numOfIndents;
        if (this.fIndentationLevel < 0) {
            this.fIndentationLevel = 0;
        }
    }

    private void formatNode(Node astNode, ICallBackFormatter callbackFormatter, int numOfBlankLinesBeforeNode, boolean addSpaceBeforeNode) {
        this.formatNode(astNode, callbackFormatter, numOfBlankLinesBeforeNode, addSpaceBeforeNode, 1);
    }

    private void formatNode(Node astNode, ICallBackFormatter callbackFormatter, int numOfBlankLinesBeforeNode, boolean addSpaceBeforeNode, int wrappingPolicy) {
        int nodeStartOffset = astNode.getOffset();
        int nodeEndOffset = astNode.getLength() + nodeStartOffset;
        if (this.printStuffBeforeNode(nodeStartOffset, numOfBlankLinesBeforeNode, addSpaceBeforeNode, wrappingPolicy)) {
            while (this.fCurrToken.right != nodeEndOffset && this.fCurrToken.sym != 0) {
                this.fPrevToken = this.fCurrToken;
                this.fCurrToken = this.nextToken();
                callbackFormatter.format(this.fPrevToken, this.fCurrToken);
                this.fPrevToken = this.fCurrToken;
            }
        }
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                addSpace = prevToken.sym == 70 ? true : (currToken.sym == 60 ? CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements") : false);
                CodeFormatterVisitor.this.printToken(prevToken, currToken, -1, addSpace);
            }
        };
        this.formatNode((Node)packageDeclaration, callbackFormatter, this.getIntPrefSetting("blankLines.beforePkg"), false);
        return false;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        int numOfBlankLineBeforeImports = 0;
        if (this.fIsFirstImportDeclaration) {
            numOfBlankLineBeforeImports = this.getIntPrefSetting("blankLines.beforeImport");
        }
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                addSpace = prevToken.sym == 71 ? true : (currToken.sym == 60 ? CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements") : false);
                CodeFormatterVisitor.this.printToken(prevToken, currToken, -1, addSpace);
            }
        };
        this.formatNode((Node)importDeclaration, callbackFormatter, numOfBlankLineBeforeImports, false);
        this.fIsFirstImportDeclaration = false;
        return false;
    }

    public boolean visit(DataItem dataItem) {
        this.push2ContextPath((Node)dataItem);
        final CodeFormatterVisitor thisVisitor = this;
        final Type diTypeNode = dataItem.getType();
        final List settingsBlocks = dataItem.getSettingsBlocks();
        final SettingsBlock firstSettingsBlock = settingsBlocks != null && !settingsBlocks.isEmpty() ? (SettingsBlock)settingsBlocks.get(0) : null;
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                int numOfBlankLines = -1;
                if (currToken.left == diTypeNode.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    diTypeNode.accept((IASTVisitor)thisVisitor);
                } else if (firstSettingsBlock != null && currToken.left == firstSettingsBlock.getOffset()) {
                    boolean isFirstSettingsBlock = true;
                    for (SettingsBlock settingsBlock : settingsBlocks) {
                        CodeFormatterVisitor.this.setGlobalFormattingSettings(isFirstSettingsBlock ? CodeFormatterVisitor.this.getNumOfBlankLinesBeforeCurlyBrace() : 0, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
                        settingsBlock.accept((IASTVisitor)thisVisitor);
                        isFirstSettingsBlock = false;
                    }
                } else {
                    switch (prevToken.sym) {
                        case 94: {
                            addSpace = true;
                            break;
                        }
                        default: {
                            addSpace = false;
                        }
                    }
                    numOfBlankLines = currToken.sym == 72 ? 0 : -1;
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)dataItem, callbackFormatter, this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        this.popContextPath();
        return false;
    }

    private int getNumOfBlankLinesBeforeCurlyBrace() {
        int openCurlyPos = this.getEnumPrefSetting("braces.openCurlyPosition");
        int numOfBlankLinesBeforeCurly = -1;
        switch (openCurlyPos) {
            case 0: {
                numOfBlankLinesBeforeCurly = -1;
                break;
            }
            case 1: 
            case 2: {
                numOfBlankLinesBeforeCurly = 0;
            }
        }
        return numOfBlankLinesBeforeCurly;
    }

    public boolean visit(SettingsBlock settingsBlock) {
        this.push2ContextPath((Node)settingsBlock);
        List settings = settingsBlock.getSettings();
        int settingBlockWrappingPolicy = this.getEnumPrefSetting("lineWrapping.settingsBlock");
        int openCurlyPos = this.getEnumPrefSetting("braces.openCurlyPosition");
        if (openCurlyPos == 2) {
            this.indent();
        }
        this.printStuffBeforeToken(58, this.fGlobalNumOfBlankLines, this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"));
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        if (openCurlyPos == 0) {
            this.indent(numOfIndents4Wrapping);
        }
        boolean isFirstSetting = true;
        boolean indentFirstSetting = false;
        int settingsCnt = settings.size();
        if (settingsCnt == 1 && settingBlockWrappingPolicy != 0) {
            settingBlockWrappingPolicy = 1;
        }
        Iterator it = settings.iterator();
        while (it.hasNext()) {
            int blankLines = -1;
            if (!isFirstSetting) {
                this.printStuffBeforeToken(64, -1, this.getBooleanPrefSetting("whiteSpace.beforeComma.settings"));
            } else if (openCurlyPos != 0) {
                blankLines = 0;
                this.indent();
                indentFirstSetting = true;
            }
            boolean addSpaceBeforeSetting = isFirstSetting ? this.getBooleanPrefSetting("whiteSpace.afterLCurly.settings") : this.getBooleanPrefSetting("whiteSpace.afterComma.settings");
            Node settingNode = (Node)it.next();
            this.setGlobalFormattingSettings(blankLines, addSpaceBeforeSetting, settingBlockWrappingPolicy);
            settingNode.accept((IASTVisitor)this);
            isFirstSetting = false;
        }
        if (indentFirstSetting) {
            this.unindent();
        }
        if (openCurlyPos == 0) {
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(59, this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeRCurly.settings"));
        if (openCurlyPos == 2) {
            this.unindent();
        }
        this.popContextPath();
        return false;
    }

    public boolean visit(Assignment assignment) {
        this.push2ContextPath((Node)assignment);
        Expression lhsExpr = assignment.getLeftHandSide();
        lhsExpr.accept((IASTVisitor)this);
        int numOfBlankLines = -1;
        boolean addSpace = this.getBooleanPrefSetting("whiteSpace.beforeOperator.assignment");
        Assignment.Operator assignOp = assignment.getOperator();
        if (assignOp == Assignment.Operator.ASSIGN) {
            this.printStuffBeforeToken(62, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.TIMES) {
            this.printStuffBeforeToken(47, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.TIMESTIMES) {
            this.printStuffBeforeToken(49, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.DIVIDE) {
            this.printStuffBeforeToken(48, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.MODULO) {
            this.printStuffBeforeToken(52, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.PLUS) {
            this.printStuffBeforeToken(45, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.MINUS) {
            this.printStuffBeforeToken(46, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.OR) {
            this.printStuffBeforeToken(44, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.AND) {
            this.printStuffBeforeToken(43, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.XOR) {
            this.printStuffBeforeToken(53, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.CONCAT) {
            this.printStuffBeforeToken(50, numOfBlankLines, addSpace);
        } else if (assignOp == Assignment.Operator.NULLCONCAT) {
            this.printStuffBeforeToken(51, numOfBlankLines, addSpace);
        }
        Expression rhsExpr = assignment.getRightHandSide();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterOperator.assignment"), 1);
        rhsExpr.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(Delegate delegate) {
        this.push2ContextPath((Node)delegate);
        final CodeFormatterVisitor thisVisitor = this;
        final ReturnsDeclaration returnDecl = delegate.getReturnDeclaration();
        final List parameters = delegate.getParameters();
        final Parameter firstParameter = parameters != null && !parameters.isEmpty() ? (Parameter)parameters.get(0) : null;
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                int numOfBlankLines = -1;
                if (firstParameter != null && currToken.left == firstParameter.getOffset()) {
                    CodeFormatterVisitor.this.formatParameters(parameters, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterLParen.funcParms"));
                } else if (returnDecl != null && currToken.left == returnDecl.getOffset()) {
                    returnDecl.accept((IASTVisitor)thisVisitor);
                } else {
                    switch (prevToken.sym) {
                        case 81: 
                        case 94: {
                            addSpace = true;
                            break;
                        }
                        default: {
                            addSpace = false;
                        }
                    }
                    if (currToken.sym == 54) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLParen.funcParms");
                    } else if (currToken.sym == 55) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeRParen.funcParms");
                    }
                    numOfBlankLines = currToken.sym == 72 ? 0 : -1;
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)delegate, callbackFormatter, this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        this.popContextPath();
        return false;
    }

    public boolean visit(Record record) {
        this.push2ContextPath((Node)record);
        final CodeFormatterVisitor thisVisitor = this;
        final List structureContents = record.getStructureContents();
        final Node firstStructureContent = structureContents != null && !structureContents.isEmpty() ? (Node)structureContents.get(0) : null;
        final Name subTypeName = record.getSubType();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                if (firstStructureContent != null && currToken.left == firstStructureContent.getOffset()) {
                    CodeFormatterVisitor.this.indent();
                    CodeFormatterVisitor.this.formatStructureContents(structureContents);
                } else if (subTypeName != null && currToken.left == subTypeName.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    subTypeName.accept((IASTVisitor)thisVisitor);
                } else {
                    int numOfBlankLines = -1;
                    switch (prevToken.sym) {
                        case 73: 
                        case 94: {
                            addSpace = true;
                            break;
                        }
                        default: {
                            addSpace = false;
                        }
                    }
                    if (currToken.sym == 86) {
                        addSpace = true;
                    } else if (currToken.sym == 72) {
                        if (firstStructureContent != null) {
                            CodeFormatterVisitor.this.unindent();
                        }
                        numOfBlankLines = 0;
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)record, callbackFormatter, this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        this.popContextPath();
        return false;
    }

    public boolean visit(StructureItem structureItem) {
        this.push2ContextPath((Node)structureItem);
        int numOfBlankLines = this.fGlobalNumOfBlankLines;
        boolean addSpace = this.fGlobalAddSpace;
        int wrappingPolicy = this.fCurrentWrappingPolicy;
        Name name = structureItem.getName();
        if (name != null) {
            this.setGlobalFormattingSettings(numOfBlankLines, addSpace, wrappingPolicy);
            name.accept((IASTVisitor)this);
        }
        Type type = structureItem.getType();
        this.setGlobalFormattingSettings(-1, true, 1);
        type.accept((IASTVisitor)this);
        if (structureItem.hasSettingsBlock()) {
            SettingsBlock settingsBlock = structureItem.getSettingsBlock();
            this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
            settingsBlock.accept((IASTVisitor)this);
        }
        if (structureItem.hasInitializer()) {
            this.printStuffBeforeToken(62, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.assignment"));
            Expression initExpr = structureItem.getInitializer();
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterOperator.assignment"), this.getEnumPrefSetting("lineWrapping.initExpr"));
            int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
            this.indent(numOfIndents4Wrapping);
            initExpr.accept((IASTVisitor)this);
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(Handler handler) {
        this.push2ContextPath((Node)handler);
        final CodeFormatterVisitor thisVisitor = this;
        final List classContents = handler.getContents();
        final Node firstClassContent = classContents != null && !classContents.isEmpty() ? (Node)classContents.get(0) : null;
        final Name subTypeName = handler.getSubType();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                if (firstClassContent != null && currToken.left == firstClassContent.getOffset()) {
                    CodeFormatterVisitor.this.indent();
                    CodeFormatterVisitor.this.formatContents(classContents);
                } else if (subTypeName != null && currToken.left == subTypeName.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    subTypeName.accept((IASTVisitor)thisVisitor);
                } else {
                    int numOfBlankLines = -1;
                    switch (prevToken.sym) {
                        case 74: 
                        case 94: {
                            addSpace = true;
                            break;
                        }
                        default: {
                            addSpace = false;
                        }
                    }
                    if (currToken.sym == 86) {
                        addSpace = true;
                    } else if (currToken.sym == 72) {
                        if (firstClassContent != null) {
                            CodeFormatterVisitor.this.unindent();
                        }
                        numOfBlankLines = 0;
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)handler, callbackFormatter, this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        this.popContextPath();
        return false;
    }

    public boolean visit(Class eglClass) {
        List impls;
        this.push2ContextPath((Node)eglClass);
        if (eglClass.isPrivate()) {
            this.printStuffBeforeNode(eglClass.getOffset(), this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        }
        int numOfBlankLines = eglClass.isPrivate() ? -1 : this.getIntPrefSetting("blankLines.beforePartDecl");
        boolean addSpace = eglClass.isPrivate();
        this.printStuffBeforeToken(75, numOfBlankLines, addSpace);
        Name name = eglClass.getName();
        this.setGlobalFormattingSettings(-1, true, 1);
        name.accept((IASTVisitor)this);
        Name superType = eglClass.getExtends();
        if (superType != null) {
            this.printStuffBeforeToken(85, -1, true);
            this.setGlobalFormattingSettings(-1, true, 1);
            superType.accept((IASTVisitor)this);
        }
        if ((impls = eglClass.getImplementedInterfaces()) != null && !impls.isEmpty()) {
            this.printStuffBeforeToken(84, -1, true);
            this.setGlobalFormattingSettings(-1, true, 1);
            this.formatCommaSeparatedNodeList(impls, this.getBooleanPrefSetting("whiteSpace.beforeComma.implClause"), this.getBooleanPrefSetting("whiteSpace.afterComma.implClause"), this.getEnumPrefSetting("lineWrapping.implClause"));
        }
        if (eglClass.hasSubType()) {
            this.printStuffBeforeToken(86, -1, true);
            Name subTypeName = eglClass.getSubType();
            this.setGlobalFormattingSettings(-1, true, 1);
            subTypeName.accept((IASTVisitor)this);
        }
        this.indent();
        List clsContents = eglClass.getContents();
        this.formatContents(clsContents);
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(Program program) {
        this.push2ContextPath((Node)program);
        if (program.isPrivate()) {
            this.printStuffBeforeNode(program.getOffset(), this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        }
        int numOfBlankLines = program.isPrivate() ? -1 : this.getIntPrefSetting("blankLines.beforePartDecl");
        boolean addSpace = program.isPrivate();
        this.printStuffBeforeToken(76, numOfBlankLines, addSpace);
        Name name = program.getName();
        this.setGlobalFormattingSettings(-1, true, 1);
        name.accept((IASTVisitor)this);
        if (program.hasSubType()) {
            this.printStuffBeforeToken(86, -1, true);
            Name subTypeName = program.getSubType();
            this.setGlobalFormattingSettings(-1, true, 1);
            subTypeName.accept((IASTVisitor)this);
        }
        this.indent();
        List classContents = program.getContents();
        this.formatContents(classContents);
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(Service service) {
        this.push2ContextPath((Node)service);
        if (service.isPrivate()) {
            this.printStuffBeforeNode(service.getOffset(), this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        }
        int numOfBlankLines = service.isPrivate() ? -1 : this.getIntPrefSetting("blankLines.beforePartDecl");
        boolean addSpace = service.isPrivate();
        this.printStuffBeforeToken(79, numOfBlankLines, addSpace);
        Name name = service.getName();
        this.setGlobalFormattingSettings(-1, true, 1);
        name.accept((IASTVisitor)this);
        List impls = service.getImplementedInterfaces();
        if (impls != null && !impls.isEmpty()) {
            this.printStuffBeforeToken(84, -1, true);
            this.setGlobalFormattingSettings(-1, true, 1);
            this.formatCommaSeparatedNodeList(impls, this.getBooleanPrefSetting("whiteSpace.beforeComma.implClause"), this.getBooleanPrefSetting("whiteSpace.afterComma.implClause"), this.getEnumPrefSetting("lineWrapping.implClause"));
        }
        this.indent();
        List clsContents = service.getContents();
        this.formatContents(clsContents);
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(Interface interfaceNode) {
        this.push2ContextPath((Node)interfaceNode);
        if (interfaceNode.isPrivate()) {
            this.printStuffBeforeNode(interfaceNode.getOffset(), this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        }
        int numOfBlankLines = interfaceNode.isPrivate() ? -1 : this.getIntPrefSetting("blankLines.beforePartDecl");
        boolean addSpace = interfaceNode.isPrivate();
        this.printStuffBeforeToken(80, numOfBlankLines, addSpace);
        Name name = interfaceNode.getName();
        this.setGlobalFormattingSettings(-1, true, 1);
        name.accept((IASTVisitor)this);
        if (interfaceNode.hasSubType()) {
            this.printStuffBeforeToken(86, -1, true);
            Name subTypeName = interfaceNode.getSubType();
            this.setGlobalFormattingSettings(-1, true, 1);
            subTypeName.accept((IASTVisitor)this);
        }
        this.indent();
        this.fIndentNeeded = false;
        List interfaceContents = interfaceNode.getContents();
        this.formatContents(interfaceContents);
        this.fIndentNeeded = true;
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(ExternalType externalType) {
        this.push2ContextPath((Node)externalType);
        if (externalType.isPrivate()) {
            this.printStuffBeforeNode(externalType.getOffset(), this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        }
        int numOfBlankLines = externalType.isPrivate() ? -1 : this.getIntPrefSetting("blankLines.beforePartDecl");
        boolean addSpace = externalType.isPrivate();
        this.printStuffBeforeToken(82, numOfBlankLines, addSpace);
        Name name = externalType.getName();
        this.setGlobalFormattingSettings(-1, true, 1);
        name.accept((IASTVisitor)this);
        List extendedTypes = externalType.getExtendedTypes();
        if (extendedTypes != null && !extendedTypes.isEmpty()) {
            this.printStuffBeforeToken(85, -1, true);
            this.setGlobalFormattingSettings(-1, true, 1);
            this.formatCommaSeparatedNodeList(extendedTypes, this.getBooleanPrefSetting("whiteSpace.beforeComma.implClause"), this.getBooleanPrefSetting("whiteSpace.afterComma.implClause"), this.getEnumPrefSetting("lineWrapping.implClause"));
        }
        if (externalType.hasSubType()) {
            this.printStuffBeforeToken(86, -1, true);
            Name subTypeName = externalType.getSubType();
            this.setGlobalFormattingSettings(-1, true, 1);
            subTypeName.accept((IASTVisitor)this);
        }
        this.indent();
        this.fIndentNeeded = false;
        List externalTypeContents = externalType.getContents();
        this.formatContents(externalTypeContents);
        this.fIndentNeeded = true;
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(Constructor constructor) {
        this.push2ContextPath((Node)constructor);
        this.printStuffBeforeNode(constructor.getOffset(), this.getIntPrefSetting("blankLines.beforeNestedFunction"), false);
        this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.funcParms"));
        List params = constructor.getParameters();
        this.formatParameters(params, this.getBooleanPrefSetting("whiteSpace.afterLParen.funcParms"));
        this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.funcParms"));
        if (constructor.hasSettingsBlock()) {
            SettingsBlock settingsBlock = constructor.getSettingsBlock();
            this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
            settingsBlock.accept((IASTVisitor)this);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(Enumeration enumeration) {
        this.push2ContextPath((Node)enumeration);
        if (enumeration.isPrivate()) {
            this.printStuffBeforeNode(enumeration.getOffset(), this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        }
        int numOfBlankLines = enumeration.isPrivate() ? -1 : this.getIntPrefSetting("blankLines.beforePartDecl");
        boolean addSpace = enumeration.isPrivate();
        this.printStuffBeforeToken(83, numOfBlankLines, addSpace);
        Name name = enumeration.getName();
        this.setGlobalFormattingSettings(-1, true, 1);
        name.accept((IASTVisitor)this);
        if (enumeration.hasSettingsBlock()) {
            SettingsBlock settingsBlock = enumeration.getSettingsBlock();
            this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
            settingsBlock.accept((IASTVisitor)this);
        }
        this.indent();
        List fields = enumeration.getFields();
        this.formatCommaSeparatedNodeList(fields, this.getBooleanPrefSetting("whiteSpace.beforeComma.enumeration"), this.getBooleanPrefSetting("whiteSpace.afterComma.enumeration"), this.getEnumPrefSetting("lineWrapping.enumFields"));
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(EnumerationField enumerationField) {
        this.push2ContextPath((Node)enumerationField);
        Name name = enumerationField.getName();
        name.accept((IASTVisitor)this);
        if (enumerationField.hasConstantValue()) {
            this.printStuffBeforeToken(62, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.assignment"));
            Expression expr = enumerationField.getConstantValue();
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterOperator.assignment"), 1);
            expr.accept((IASTVisitor)this);
        }
        this.popContextPath();
        return false;
    }

    public boolean visit(Library library) {
        this.push2ContextPath((Node)library);
        final CodeFormatterVisitor thisVisitor = this;
        final List classContents = library.getContents();
        final Node firstClassContent = classContents != null && !classContents.isEmpty() ? (Node)classContents.get(0) : null;
        final Name subTypeName = library.getSubType();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                if (firstClassContent != null && currToken.left == firstClassContent.getOffset()) {
                    CodeFormatterVisitor.this.indent();
                    CodeFormatterVisitor.this.formatContents(classContents);
                } else if (subTypeName != null && currToken.left == subTypeName.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    subTypeName.accept((IASTVisitor)thisVisitor);
                } else {
                    int numOfBlankLines = -1;
                    switch (prevToken.sym) {
                        case 77: 
                        case 94: {
                            addSpace = true;
                            break;
                        }
                        default: {
                            addSpace = false;
                        }
                    }
                    if (currToken.sym == 86) {
                        addSpace = true;
                    } else if (currToken.sym == 72) {
                        if (firstClassContent != null) {
                            CodeFormatterVisitor.this.unindent();
                        }
                        numOfBlankLines = 0;
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)library, callbackFormatter, this.getIntPrefSetting("blankLines.beforePartDecl"), false);
        this.popContextPath();
        return false;
    }

    private void formatContents(List contents) {
        if (contents != null) {
            boolean isFirstContent = true;
            for (Node content : contents) {
                if (content instanceof SettingsBlock) {
                    this.setGlobalFormattingSettings(isFirstContent ? this.getNumOfBlankLinesBeforeCurlyBrace() : 0, this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
                }
                content.accept((IASTVisitor)this);
                isFirstContent = false;
            }
        }
    }

    private void formatStructureContents(List structureContents) {
        if (structureContents != null) {
            boolean isFirstContent = true;
            Iterator it = structureContents.iterator();
            while (it.hasNext()) {
                int levelIndex = 0;
                Node structureContent = (Node)it.next();
                if (structureContent instanceof SettingsBlock && isFirstContent) {
                    this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
                } else {
                    this.setGlobalFormattingSettings(0, false, 1);
                }
                structureContent.accept((IASTVisitor)this);
                this.unindent(levelIndex);
                isFirstContent = false;
            }
        }
    }

    public boolean visit(NestedFunction nestedFunction) {
        this.push2ContextPath((Node)nestedFunction);
        final CodeFormatterVisitor thisVisitor = this;
        final ReturnsDeclaration returnDecl = nestedFunction.getReturnDeclaration();
        final List parameters = nestedFunction.getFunctionParameters();
        final Parameter firstParameter = parameters != null && !parameters.isEmpty() ? (Parameter)parameters.get(0) : null;
        final List stmtsOrSettingsBlocks = nestedFunction.getStmts();
        final Node firstStmtOrSettingBlock = stmtsOrSettingsBlocks != null && !stmtsOrSettingsBlocks.isEmpty() ? (Node)stmtsOrSettingsBlocks.get(0) : null;
        final SettingsBlock settingsBlock = nestedFunction.isAbstract() && firstStmtOrSettingBlock != null && firstStmtOrSettingBlock instanceof SettingsBlock ? (SettingsBlock)firstStmtOrSettingBlock : null;
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (firstParameter != null && currToken.left == firstParameter.getOffset()) {
                    CodeFormatterVisitor.this.formatParameters(parameters, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterLParen.funcParms"));
                } else if (returnDecl != null && currToken.left == returnDecl.getOffset()) {
                    returnDecl.accept((IASTVisitor)thisVisitor);
                } else if (firstStmtOrSettingBlock != null && currToken.left == firstStmtOrSettingBlock.getOffset()) {
                    if (CodeFormatterVisitor.this.fIndentNeeded) {
                        CodeFormatterVisitor.this.indent();
                    }
                    CodeFormatterVisitor.this.formatStatements(stmtsOrSettingsBlocks);
                } else if (settingsBlock != null && currToken.left == settingsBlock.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(CodeFormatterVisitor.this.getNumOfBlankLinesBeforeCurlyBrace(), CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
                    settingsBlock.accept((IASTVisitor)thisVisitor);
                } else {
                    boolean addSpace = false;
                    int numOfBlankLines = -1;
                    switch (prevToken.sym) {
                        case 78: 
                        case 94: 
                        case 95: {
                            addSpace = true;
                            break;
                        }
                        default: {
                            addSpace = false;
                        }
                    }
                    if (currToken.sym == 54) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLParen.funcParms");
                    } else if (currToken.sym == 55) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeRParen.funcParms");
                    } else if (currToken.sym == 60) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                    }
                    if (currToken.sym == 72) {
                        if (firstStmtOrSettingBlock != null) {
                            CodeFormatterVisitor.this.unindent();
                        }
                        numOfBlankLines = 0;
                    } else {
                        numOfBlankLines = -1;
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)nestedFunction, callbackFormatter, this.getIntPrefSetting("blankLines.beforeNestedFunction"), false);
        this.popContextPath();
        return false;
    }

    private void formatStatements(List stmts) {
        if (stmts != null) {
            boolean isFirstStmt = true;
            for (Node stmt : stmts) {
                if (isFirstStmt && stmt instanceof SettingsBlock) {
                    this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
                } else {
                    this.setGlobalFormattingSettings(0, false, 1);
                }
                stmt.accept((IASTVisitor)this);
                isFirstStmt = false;
            }
        }
    }

    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        this.push2ContextPath((Node)functionDataDeclaration);
        boolean addSpace = this.fGlobalAddSpace;
        int numOfBlankLines = this.fGlobalNumOfBlankLines;
        if (functionDataDeclaration.isConstant()) {
            this.printStuffBeforeNode(functionDataDeclaration.getOffset(), numOfBlankLines, addSpace);
            addSpace = true;
            numOfBlankLines = -1;
        }
        List names = functionDataDeclaration.getNames();
        Type type = functionDataDeclaration.getType();
        SettingsBlock settingsBlock = functionDataDeclaration.getSettingsBlockOpt();
        Expression initExpr = functionDataDeclaration.getInitializer();
        this.setGlobalFormattingSettings(numOfBlankLines, addSpace, 1);
        this.formatCommaSeparatedNodeList(names, this.getBooleanPrefSetting("whiteSpace.beforeComma.dataDecl"), this.getBooleanPrefSetting("whiteSpace.afterComma.dataDecl"), this.getEnumPrefSetting("lineWrapping.varDelcaration"));
        this.setGlobalFormattingSettings(-1, true, 1);
        type.accept((IASTVisitor)this);
        if (functionDataDeclaration.isNullable()) {
            this.printStuffBeforeToken(42, -1, this.getBooleanPrefSetting("whiteSpace.beforeQuestion.nullableFields"));
        }
        if (settingsBlock != null) {
            this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
            settingsBlock.accept((IASTVisitor)this);
        }
        if (initExpr != null) {
            this.printStuffBeforeToken(62, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.assignment"));
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterOperator.assignment"), this.getEnumPrefSetting("lineWrapping.initExpr"));
            int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
            this.indent(numOfIndents4Wrapping);
            initExpr.accept((IASTVisitor)this);
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(AssignmentStatement assignmentStatement) {
        this.push2ContextPath((Node)assignmentStatement);
        Assignment assignment = assignmentStatement.getAssignment();
        assignment.accept((IASTVisitor)this);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        this.push2ContextPath((Node)functionInvocationStatement);
        FunctionInvocation funcInvoc = functionInvocationStatement.getFunctionInvocation();
        funcInvoc.accept((IASTVisitor)this);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(SetValuesStatement setValuesStatement) {
        this.push2ContextPath((Node)setValuesStatement);
        SetValuesExpression setValExpr = setValuesStatement.getSetValuesExpression();
        setValExpr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(CallStatement callStatement) {
        this.push2ContextPath((Node)callStatement);
        final CodeFormatterVisitor thisVisitor = this;
        final Expression expr = callStatement.getInvocationTarget();
        final Expression usingExpr = callStatement.getUsing();
        CallSynchronizationValues callSynValues = callStatement.getCallSynchronizationValues();
        final CallbackTarget callbackTgt = callSynValues != null ? callSynValues.getReturnTo() : null;
        final Expression callbackExpr = callbackTgt != null ? callbackTgt.getExpression() : null;
        final CallbackTarget errCallbackTgt = callSynValues != null ? callSynValues.getOnException() : null;
        final Expression errCallbackExpr = errCallbackTgt != null ? errCallbackTgt.getExpression() : null;
        final SettingsBlock settingsBlock = callStatement.getSettingsBlock();
        final List callParams = callStatement.getArguments();
        final Expression firstCallParm = callParams != null && !callParams.isEmpty() ? (Expression)callParams.get(0) : null;
        final int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (currToken.left == expr.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    expr.accept((IASTVisitor)thisVisitor);
                } else if (firstCallParm != null && currToken.left == firstCallParm.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterLParen.callStmt"), 1);
                    CodeFormatterVisitor.this.formatExpressions(callParams, CodeFormatterVisitor.this.getEnumPrefSetting("lineWrapping.args"), CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeComma.callStmt"), CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterComma.callStmt"));
                } else if (usingExpr != null && currToken.left == usingExpr.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    usingExpr.accept((IASTVisitor)thisVisitor);
                } else if (callbackExpr != null && currToken.left == callbackExpr.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    callbackExpr.accept((IASTVisitor)thisVisitor);
                } else if (errCallbackExpr != null && currToken.left == errCallbackExpr.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    errCallbackExpr.accept((IASTVisitor)thisVisitor);
                } else if (settingsBlock != null && currToken.left == settingsBlock.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(CodeFormatterVisitor.this.getNumOfBlankLinesBeforeCurlyBrace(), CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
                    settingsBlock.accept((IASTVisitor)thisVisitor);
                } else {
                    boolean addSpace = false;
                    int numOfBlankLines = -1;
                    int wrappingPolicy = 1;
                    switch (prevToken.sym) {
                        case 117: 
                        case 137: {
                            addSpace = true;
                        }
                    }
                    if (currToken.sym == 54) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLParen.callStmt");
                    } else if (currToken.sym == 55) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeRParen.callStmt");
                    } else if (currToken.sym == 142) {
                        addSpace = true;
                        wrappingPolicy = CodeFormatterVisitor.this.getEnumPrefSetting("lineWrapping.callStmt");
                        if (usingExpr == null) {
                            CodeFormatterVisitor.this.indent(numOfIndents4Wrapping);
                        }
                    } else if (currToken.sym == 137) {
                        addSpace = true;
                        wrappingPolicy = CodeFormatterVisitor.this.getEnumPrefSetting("lineWrapping.callStmt");
                        CodeFormatterVisitor.this.indent(numOfIndents4Wrapping);
                    } else if (currToken.sym == 168) {
                        addSpace = true;
                        wrappingPolicy = CodeFormatterVisitor.this.getEnumPrefSetting("lineWrapping.callStmt");
                        if (callbackTgt == null) {
                            CodeFormatterVisitor.this.indent(numOfIndents4Wrapping);
                        }
                    } else if (currToken.sym == 60) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                        if (callbackTgt != null || errCallbackTgt != null) {
                            CodeFormatterVisitor.this.unindent(numOfIndents4Wrapping);
                        }
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace, wrappingPolicy);
                }
            }
        };
        this.formatNode((Node)callStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(GotoStatement gotoStatement) {
        this.push2ContextPath((Node)gotoStatement);
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                int numOfBlankLines = -1;
                if (prevToken.sym == 114) {
                    addSpace = true;
                }
                if (currToken.sym == 60) {
                    addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                }
                CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
            }
        };
        this.formatNode((Node)gotoStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(LabelStatement labelStatement) {
        this.push2ContextPath((Node)labelStatement);
        this.unindent();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                int numOfBlankLines = -1;
                if (currToken.sym == 63) {
                    addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeColon.labelStmt");
                }
                CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
            }
        };
        this.formatNode((Node)labelStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.indent();
        this.popContextPath();
        return false;
    }

    public boolean visit(MoveStatement moveStatement) {
        this.push2ContextPath((Node)moveStatement);
        this.printStuffBeforeNode(moveStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression sourceExpr = moveStatement.getSource();
        this.setGlobalFormattingSettings(-1, true, 1);
        sourceExpr.accept((IASTVisitor)this);
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        this.indent(numOfIndents4Wrapping);
        int moveWrappingPolicy = this.getEnumPrefSetting("lineWrapping.moveStmt");
        this.printStuffBeforeToken(117, -1, true, moveWrappingPolicy);
        Expression targetExpr = moveStatement.getTarget();
        this.setGlobalFormattingSettings(-1, true, 1);
        targetExpr.accept((IASTVisitor)this);
        MoveModifier moveModifier = moveStatement.getMoveModifierOpt();
        if (moveModifier != null) {
            this.indent(numOfIndents4Wrapping);
            if (moveModifier.isByName()) {
                this.printStuffBeforeToken(156, -1, true, moveWrappingPolicy);
            } else if (moveModifier.isByPosition()) {
                this.printStuffBeforeToken(157, -1, true, moveWrappingPolicy);
            } else if (moveModifier.isForAll()) {
                this.printStuffBeforeToken(131, -1, true, moveWrappingPolicy);
                this.printStuffBeforeToken(159, -1, true, 1);
            } else if (moveModifier.isFor()) {
                this.printStuffBeforeToken(131, -1, true, moveWrappingPolicy);
                Expression forMoveExpr = moveModifier.getExpression();
                this.setGlobalFormattingSettings(-1, true, 1);
                forMoveExpr.accept((IASTVisitor)this);
            } else if (moveModifier.isWithV60Compat()) {
                this.printStuffBeforeToken(158, -1, true, moveWrappingPolicy);
            }
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.unindent(numOfIndents4Wrapping);
        this.popContextPath();
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.push2ContextPath((Node)returnStatement);
        this.printStuffBeforeNode(returnStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression parenthesizedExpr = returnStatement.getParenthesizedExprOpt();
        if (parenthesizedExpr != null) {
            this.setGlobalFormattingSettings(-1, this.fGlobalAddSpace, 1);
            parenthesizedExpr.accept((IASTVisitor)this);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(SetStatement setStatement) {
        this.push2ContextPath((Node)setStatement);
        this.printStuffBeforeNode(setStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        boolean addSapceAfterComma = this.getBooleanPrefSetting("whiteSpace.afterComma.setStatement");
        boolean addSpaceBeforeComma = this.getBooleanPrefSetting("whiteSpace.beforeComma.setStatement");
        int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.setStmt");
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        List setTargets = setStatement.getSetTargets();
        this.setGlobalFormattingSettings(-1, true, 1);
        this.formatExpressions(setTargets, wrappingPolicy, addSpaceBeforeComma, addSapceAfterComma);
        try {
            int targetsCnt = setTargets.size();
            Expression lastTarget = (Expression)setTargets.get(targetsCnt - 1);
            int lastTargetRight = lastTarget.getOffset() + lastTarget.getLength();
            int setStatementRight = setStatement.getOffset() + setStatement.getLength();
            String strIDs = this.fDocument.get(lastTargetRight, setStatementRight - lastTargetRight);
            Lexer scanner = null;
            scanner = new Lexer((Reader)new BufferedReader(new StringReader(strIDs)));
            Symbol token = scanner.next_token();
            int numOfBlankLines = -1;
            boolean addSpace = false;
            boolean isFirstID = true;
            this.indent(numOfIndents4Wrapping * 2);
            while (token.sym != 0) {
                int idwrappingPolicy = 1;
                switch (token.sym) {
                    case 97: {
                        if (isFirstID) {
                            addSpace = true;
                        } else {
                            addSpace = this.getBooleanPrefSetting("whiteSpace.afterComma.setStatement");
                            idwrappingPolicy = wrappingPolicy;
                        }
                        isFirstID = false;
                        break;
                    }
                    case 64: {
                        addSpace = this.getBooleanPrefSetting("whiteSpace.beforeComma.setStatement");
                        break;
                    }
                    case 60: {
                        addSpace = this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                    }
                }
                this.printStuffBeforeNode(token.left + lastTargetRight, numOfBlankLines, addSpace, idwrappingPolicy);
                token = scanner.next_token();
            }
            this.unindent(numOfIndents4Wrapping * 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.popContextPath();
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.push2ContextPath((Node)emptyStatement);
        this.printStuffBeforeNode(emptyStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace);
        this.popContextPath();
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.push2ContextPath((Node)tryStatement);
        this.printStuffBeforeNode(tryStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.indent();
        List stmts = tryStatement.getStmts();
        if (stmts != null) {
            this.formatStatements(stmts);
        }
        this.unindent();
        List onExcepts = tryStatement.getOnExceptionBlocks();
        if (onExcepts != null && !onExcepts.isEmpty()) {
            for (Node onExceptBlock : onExcepts) {
                this.setGlobalFormattingSettings(0, false, 1);
                onExceptBlock.accept((IASTVisitor)this);
            }
        }
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(OnExceptionBlock onExceptionBlock) {
        this.push2ContextPath((Node)onExceptionBlock);
        this.printStuffBeforeNode(onExceptionBlock.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.onException"));
        Name exceptionName = onExceptionBlock.getExceptionName();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.onException"), 1);
        exceptionName.accept((IASTVisitor)this);
        Type exceptionType = onExceptionBlock.getExceptionType();
        this.setGlobalFormattingSettings(-1, true, 1);
        exceptionType.accept((IASTVisitor)this);
        this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.onException"));
        this.indent();
        List stmts = onExceptionBlock.getStmts();
        this.formatStatements(stmts);
        this.unindent();
        this.popContextPath();
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.push2ContextPath((Node)throwStatement);
        this.printStuffBeforeNode(throwStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = throwStatement.getExpression();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(CaseStatement caseStatement) {
        List whens;
        this.push2ContextPath((Node)caseStatement);
        this.printStuffBeforeNode(caseStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.indent();
        if (caseStatement.hasCriterion()) {
            Expression expr = caseStatement.getCriterion();
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.case"), 1);
            expr.accept((IASTVisitor)this);
        }
        if ((whens = caseStatement.getWhenClauses()) != null) {
            for (Node when : whens) {
                this.setGlobalFormattingSettings(0, false, 1);
                when.accept((IASTVisitor)this);
            }
        }
        if (caseStatement.hasOtherwiseClause()) {
            OtherwiseClause otherwise = caseStatement.getDefaultClause();
            this.setGlobalFormattingSettings(0, false, 1);
            otherwise.accept((IASTVisitor)this);
        }
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(WhenClause whenClause) {
        this.push2ContextPath((Node)whenClause);
        this.printStuffBeforeNode(whenClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.when"));
        List exprs = whenClause.getExpr_plus();
        if (exprs != null && !exprs.isEmpty()) {
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.when"), 1);
            this.formatExpressions(exprs, this.getEnumPrefSetting("lineWrapping.exprs"), this.getBooleanPrefSetting("whiteSpace.beforeComma.when"), this.getBooleanPrefSetting("whiteSpace.afterComma.when"));
        }
        this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.when"));
        this.indent();
        List stmts = whenClause.getStmts();
        if (stmts != null) {
            this.formatStatements(stmts);
        }
        this.unindent();
        this.popContextPath();
        return false;
    }

    public boolean visit(OtherwiseClause otherwiseClause) {
        this.push2ContextPath((Node)otherwiseClause);
        this.printStuffBeforeNode(otherwiseClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.indent();
        List stmts = otherwiseClause.getStatements();
        if (stmts != null) {
            this.formatStatements(stmts);
        }
        this.unindent();
        this.popContextPath();
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        this.push2ContextPath((Node)ifStatement);
        this.printStuffBeforeNode(ifStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.if"));
        Expression expr = ifStatement.getCondition();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.if"), 1);
        expr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.if"));
        this.indent();
        List stmts = ifStatement.getStmts();
        if (stmts != null) {
            this.formatStatements(stmts);
        }
        this.unindent();
        if (ifStatement.hasElse()) {
            ElseBlock elseBlock = ifStatement.getElse();
            this.setGlobalFormattingSettings(0, false, 1);
            elseBlock.accept((IASTVisitor)this);
        }
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(ElseBlock elseBlock) {
        this.push2ContextPath((Node)elseBlock);
        this.printStuffBeforeNode(elseBlock.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.indent();
        List stmts = elseBlock.getStmts();
        if (stmts != null) {
            this.formatStatements(stmts);
        }
        this.unindent();
        this.popContextPath();
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        this.push2ContextPath((Node)whileStatement);
        this.printStuffBeforeNode(whileStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.while"));
        Expression expr = whileStatement.getExpr();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.while"), 1);
        expr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.while"));
        this.indent();
        List stmts = whileStatement.getStmts();
        if (stmts != null) {
            this.formatStatements(stmts);
        }
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        this.push2ContextPath((Node)forStatement);
        this.printStuffBeforeNode(forStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.for"));
        if (forStatement.hasVariableDeclaration()) {
            Name varDeclName = forStatement.getVariableDeclarationName();
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.for"), 1);
            varDeclName.accept((IASTVisitor)this);
            Type varDeclType = forStatement.getVariableDeclarationType();
            this.setGlobalFormattingSettings(-1, true, 1);
            varDeclType.accept((IASTVisitor)this);
        } else {
            Expression lvalue = forStatement.getCounterVariable();
            if (lvalue != null) {
                this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.for"), 1);
                lvalue.accept((IASTVisitor)this);
            }
        }
        if (forStatement.hasFromIndex()) {
            this.printStuffBeforeToken(133, -1, true);
            Expression fromExpr = forStatement.getFromIndex();
            this.setGlobalFormattingSettings(-1, true, 1);
            fromExpr.accept((IASTVisitor)this);
        }
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        this.indent(numOfIndents4Wrapping);
        int forWrappingPolicy = this.getEnumPrefSetting("lineWrapping.forStmt");
        this.printStuffBeforeToken(117, -1, true, forWrappingPolicy);
        Expression endExpr = forStatement.getEndIndex();
        this.setGlobalFormattingSettings(-1, true, 1);
        endExpr.accept((IASTVisitor)this);
        if (forStatement.hasPositiveDelta()) {
            this.printStuffBeforeToken(135, -1, true, forWrappingPolicy);
        } else if (forStatement.hasNegativeDelta()) {
            this.printStuffBeforeToken(136, -1, true, forWrappingPolicy);
            this.printStuffBeforeToken(135, -1, true);
        }
        Expression stepExpr = forStatement.getDeltaExpression();
        if (stepExpr != null) {
            this.setGlobalFormattingSettings(-1, true, 1);
            stepExpr.accept((IASTVisitor)this);
        }
        this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.for"));
        this.unindent(numOfIndents4Wrapping);
        this.indent();
        List stmts = forStatement.getStmts();
        if (stmts != null) {
            this.formatStatements(stmts);
        }
        this.unindent();
        this.printStuffBeforeToken(72, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(ForEachStatement forEachStatement) {
        this.push2ContextPath((Node)forEachStatement);
        final CodeFormatterVisitor thisVisitor = this;
        final List stmts = forEachStatement.getStmts();
        final Node firstStmt = stmts != null && !stmts.isEmpty() ? (Node)stmts.get(0) : null;
        final SimpleName decVariable = forEachStatement.getVariableDeclarationName();
        final Type varDeclType = forEachStatement.getVariableDeclarationType();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (decVariable != null && currToken.left == decVariable.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterLParen.forEach"), 1);
                    decVariable.accept((IASTVisitor)thisVisitor);
                } else if (varDeclType != null && currToken.left == varDeclType.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    varDeclType.accept((IASTVisitor)thisVisitor);
                } else if (firstStmt != null && currToken.left == firstStmt.getOffset()) {
                    CodeFormatterVisitor.this.indent();
                    CodeFormatterVisitor.this.formatStatements(stmts);
                    CodeFormatterVisitor.this.unindent();
                } else {
                    int numOfBlankLines = -1;
                    boolean addSpace = false;
                    switch (prevToken.sym) {
                        case 132: {
                            addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLParen.forEach");
                            break;
                        }
                        case 133: {
                            addSpace = true;
                        }
                    }
                    switch (currToken.sym) {
                        case 133: {
                            addSpace = true;
                            break;
                        }
                        case 55: {
                            addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeRParen.forEach");
                            break;
                        }
                        case 72: {
                            numOfBlankLines = 0;
                            addSpace = false;
                        }
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)forEachStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(IntoClause intoClause) {
        this.push2ContextPath((Node)intoClause);
        this.printStuffBeforeNode(intoClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        List exprs = intoClause.getExpressions();
        this.setGlobalFormattingSettings(-1, true, 1);
        this.formatExpressions(exprs, this.getEnumPrefSetting("lineWrapping.exprs"), this.getBooleanPrefSetting("whiteSpace.beforeComma.forEach"), this.getBooleanPrefSetting("whiteSpace.afterComma.forEach"));
        this.popContextPath();
        return false;
    }

    public boolean visit(ContinueStatement continueStatement) {
        this.push2ContextPath((Node)continueStatement);
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                int numOfBlankLines = -1;
                if (prevToken.sym == 112) {
                    addSpace = true;
                }
                if (currToken.sym == 60) {
                    addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                }
                CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
            }
        };
        this.formatNode((Node)continueStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(ExitStatement exitStatement) {
        this.push2ContextPath((Node)exitStatement);
        final CodeFormatterVisitor thisVisitor = this;
        ExitStatement.ExitModifier exitModifier = exitStatement.getExitModifierOpt();
        final Expression exitExpr = exitModifier instanceof ExitStatement.OptionalExpressionExitModifier ? ((ExitStatement.OptionalExpressionExitModifier)exitModifier).getExpression() : null;
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (exitExpr != null && currToken.left == exitExpr.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLParen.exit"), 1);
                    exitExpr.accept((IASTVisitor)thisVisitor);
                } else {
                    int numOfBlankLines = -1;
                    boolean addSpace = false;
                    switch (prevToken.sym) {
                        case 113: 
                        case 155: {
                            addSpace = true;
                        }
                    }
                    switch (currToken.sym) {
                        case 60: {
                            addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                        }
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)exitStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(UseStatement useStatement) {
        this.push2ContextPath((Node)useStatement);
        final CodeFormatterVisitor thisVisitor = this;
        final List names = useStatement.getNames();
        final Name firstName = names != null && !names.isEmpty() ? (Name)names.get(0) : null;
        final SettingsBlock settingsBlock = useStatement.getSettingsBlock();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (settingsBlock != null && currToken.left == settingsBlock.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(CodeFormatterVisitor.this.getNumOfBlankLinesBeforeCurlyBrace(), CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
                    settingsBlock.accept((IASTVisitor)thisVisitor);
                } else {
                    boolean addSpace = false;
                    int numOfBlankLines = -1;
                    if (prevToken.sym == 87) {
                        addSpace = true;
                    } else if (currToken.sym == 60) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                    }
                    if (firstName != null && currToken.left == firstName.getOffset()) {
                        CodeFormatterVisitor.this.setGlobalFormattingSettings(numOfBlankLines, addSpace, 1);
                        CodeFormatterVisitor.this.formatCommaSeparatedNodeList(names, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeComma.useStatement"), CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterComma.useStatement"), CodeFormatterVisitor.this.getEnumPrefSetting("lineWrapping.useStmt"));
                    } else {
                        CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                    }
                }
            }
        };
        this.formatNode((Node)useStatement, callbackFormatter, 0, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(AddStatement addStatement) {
        this.push2ContextPath((Node)addStatement);
        this.printStuffBeforeNode(addStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        List exprs = addStatement.getIOObjects();
        this.setGlobalFormattingSettings(-1, true, 1);
        this.formatExpressions(exprs);
        List addOptions = addStatement.getIOClauses();
        if (addOptions != null && !addOptions.isEmpty()) {
            int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
            int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
            this.indent(numOfIndents4Wrapping);
            for (Node addOption : addOptions) {
                this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                addOption.accept((IASTVisitor)this);
            }
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(WithExpressionClause withExpressionClause) {
        this.push2ContextPath((Node)withExpressionClause);
        this.printStuffBeforeNode(withExpressionClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = withExpressionClause.getExpression();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(WithInlineSQLClause withInlineSQLClause) {
        this.push2ContextPath((Node)withInlineSQLClause);
        this.printStuffBeforeNode(withInlineSQLClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        InlineSQLStatement inlineSQLStmt = withInlineSQLClause.getSqlStmt();
        this.printStuffBeforeNode(inlineSQLStmt.getOffset(), -1, true, 1);
        this.popContextPath();
        return false;
    }

    public boolean visit(CloseStatement closeStatement) {
        this.push2ContextPath((Node)closeStatement);
        this.printStuffBeforeNode(closeStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = closeStatement.getExpr();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(DeleteStatement deleteStatement) {
        this.push2ContextPath((Node)deleteStatement);
        this.printStuffBeforeNode(deleteStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = deleteStatement.getTarget();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        ArrayList<FromOrToExpressionClause> delOptions = new ArrayList<FromOrToExpressionClause>();
        delOptions.add(deleteStatement.getDataSource());
        delOptions.addAll(deleteStatement.getOptions());
        if (delOptions != null && !delOptions.isEmpty()) {
            int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
            int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
            this.indent(numOfIndents4Wrapping);
            for (Node node : delOptions) {
                this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                node.accept((IASTVisitor)this);
            }
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(FromOrToExpressionClause fromOrToClause) {
        this.push2ContextPath((Node)fromOrToClause);
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                int numOfBlankLines = -1;
                boolean addSpace = false;
                if (prevToken.sym == 133 || prevToken.sym == 117) {
                    addSpace = true;
                }
                CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
            }
        };
        this.formatNode((Node)fromOrToClause, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(NoCursorClause noCursorClause) {
        this.push2ContextPath((Node)noCursorClause);
        this.printStuffBeforeNode(noCursorClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(UsingKeysClause usingKeysClause) {
        this.push2ContextPath((Node)usingKeysClause);
        this.printStuffBeforeNode(usingKeysClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        List exprs = usingKeysClause.getExpressions();
        this.setGlobalFormattingSettings(-1, true, 1);
        this.formatExpressions(exprs);
        this.popContextPath();
        return false;
    }

    public boolean visit(ForwardStatement forwardStatement) {
        List forwardOpts;
        this.push2ContextPath((Node)forwardStatement);
        this.printStuffBeforeNode(forwardStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        List exprs = forwardStatement.getArguments();
        if (exprs != null && !exprs.isEmpty()) {
            this.setGlobalFormattingSettings(-1, true, 1);
            this.formatExpressions(exprs);
        }
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
        this.indent(numOfIndents4Wrapping);
        if (forwardStatement.hasForwardTarget()) {
            this.printStuffBeforeToken(117, -1, true, wrappingPolicy);
            if (forwardStatement.isForwardToLabel()) {
                this.printStuffBeforeToken(162, -1, true);
            } else if (forwardStatement.isForwardToURL()) {
                this.printStuffBeforeToken(161, -1, true);
            }
            Expression forwardTargetExpr = forwardStatement.getForwardTarget();
            this.setGlobalFormattingSettings(-1, true, 1);
            forwardTargetExpr.accept((IASTVisitor)this);
        }
        if ((forwardOpts = forwardStatement.getForwardOptions()) != null && !forwardOpts.isEmpty()) {
            for (Node forwardOpt : forwardOpts) {
                this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                forwardOpt.accept((IASTVisitor)this);
            }
        }
        this.unindent(numOfIndents4Wrapping);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(ReturningToNameClause returningToNameClause) {
        this.push2ContextPath((Node)returningToNameClause);
        this.printStuffBeforeNode(returningToNameClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.printStuffBeforeToken(117, -1, true);
        Name name = returningToNameClause.getName();
        this.setGlobalFormattingSettings(-1, true, 1);
        name.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(ExecuteStatement executeStatement) {
        this.push2ContextPath((Node)executeStatement);
        final CodeFormatterVisitor thisVisitor = this;
        final List executeOptions = executeStatement.getExecuteOptions();
        final Node firstExeOpt = executeOptions != null && !executeOptions.isEmpty() ? (Node)executeOptions.get(0) : null;
        final int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        final int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (firstExeOpt != null && currToken.left == firstExeOpt.getOffset()) {
                    for (Node exeOpt : executeOptions) {
                        CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                        exeOpt.accept((IASTVisitor)thisVisitor);
                    }
                } else {
                    int numOfBlankLines = -1;
                    boolean addSpace = false;
                    int tokenWrappingPolicy = 1;
                    switch (prevToken.sym) {
                        case 97: 
                        case 126: {
                            addSpace = true;
                            CodeFormatterVisitor.this.indent(numOfIndents4Wrapping);
                            break;
                        }
                        case 125: 
                        case 163: 
                        case 164: {
                            addSpace = true;
                        }
                    }
                    if (currToken.sym == 108) {
                        tokenWrappingPolicy = wrappingPolicy;
                    } else if (currToken.sym == 60) {
                        CodeFormatterVisitor.this.unindent(numOfIndents4Wrapping);
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace, tokenWrappingPolicy);
                }
            }
        };
        this.formatNode((Node)executeStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(UsingClause usingClause) {
        this.push2ContextPath((Node)usingClause);
        this.printStuffBeforeNode(usingClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        List exprs = usingClause.getExpressions();
        this.setGlobalFormattingSettings(-1, true, 1);
        this.formatExpressions(exprs);
        this.popContextPath();
        return false;
    }

    public boolean visit(ForExpressionClause forExpressionClause) {
        this.push2ContextPath((Node)forExpressionClause);
        this.printStuffBeforeNode(forExpressionClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = forExpressionClause.getExpression();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(GetByKeyStatement getByKeyStatement) {
        this.push2ContextPath((Node)getByKeyStatement);
        this.printStuffBeforeNode(getByKeyStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        List exprs = getByKeyStatement.getTargets();
        this.setGlobalFormattingSettings(-1, true, 1);
        this.formatExpressions(exprs);
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
        this.indent(numOfIndents4Wrapping);
        List getbyKeyOpts = getByKeyStatement.getGetByKeyOptions();
        if (getbyKeyOpts != null && !getbyKeyOpts.isEmpty()) {
            for (Node getbyKeyOpt : getbyKeyOpts) {
                this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                getbyKeyOpt.accept((IASTVisitor)this);
            }
        }
        this.unindent(numOfIndents4Wrapping);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(ForUpdateClause forUpdateClause) {
        this.push2ContextPath((Node)forUpdateClause);
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                int numOfBlankLines = -1;
                boolean addSpace = false;
                if (prevToken.sym == 139) {
                    addSpace = true;
                }
                CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
            }
        };
        this.formatNode((Node)forUpdateClause, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(SingleRowClause singleRowClause) {
        this.push2ContextPath((Node)singleRowClause);
        this.printStuffBeforeNode(singleRowClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(WithIDClause withIDClause) {
        this.push2ContextPath((Node)withIDClause);
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                int numOfBlankLines = -1;
                boolean addSpace = false;
                if (prevToken.sym == 138) {
                    addSpace = true;
                }
                CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
            }
        };
        this.formatNode((Node)withIDClause, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(GetByPositionStatement getByPositionStatement) {
        this.push2ContextPath((Node)getByPositionStatement);
        final CodeFormatterVisitor thisVisitor = this;
        final int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        final int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
        final Expression exprDirection = getByPositionStatement.getPosition();
        final List exprSources = getByPositionStatement.getTargetRecords();
        final Node firstExprSource = exprSources != null && !exprSources.isEmpty() ? (Node)exprSources.get(0) : null;
        final List getbyPosOpts = getByPositionStatement.getGetByPositionOptions();
        final Node firstGetByPosOpt = getbyPosOpts != null && !getbyPosOpts.isEmpty() ? (Node)getbyPosOpts.get(0) : null;
        final boolean[] hasIndented = new boolean[1];
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (exprDirection != null && currToken.left == exprDirection.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterLParen.getByPos"), 1);
                    exprDirection.accept((IASTVisitor)thisVisitor);
                } else if (firstExprSource != null && currToken.left == firstExprSource.getOffset()) {
                    if (!hasIndented[0]) {
                        CodeFormatterVisitor.this.indent(numOfIndents4Wrapping);
                        hasIndented[0] = true;
                    }
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                    CodeFormatterVisitor.this.formatExpressions(exprSources);
                } else if (firstGetByPosOpt != null && currToken.left == firstGetByPosOpt.getOffset()) {
                    for (Node getByPosOpt : getbyPosOpts) {
                        CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                        getByPosOpt.accept((IASTVisitor)thisVisitor);
                    }
                } else {
                    int numOfBlankLines = -1;
                    boolean addSpace = false;
                    int tokenWrappingPolicy = 1;
                    switch (prevToken.sym) {
                        case 127: 
                        case 133: {
                            addSpace = true;
                            break;
                        }
                        case 149: 
                        case 150: {
                            addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLParen.getByPos");
                        }
                    }
                    if (currToken.sym == 55) {
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeRParen.getByPos");
                    } else if (currToken.sym == 151) {
                        addSpace = true;
                    } else if (currToken.sym == 133) {
                        addSpace = true;
                        if (firstExprSource == null) {
                            if (!hasIndented[0]) {
                                CodeFormatterVisitor.this.indent(numOfIndents4Wrapping);
                                hasIndented[0] = true;
                            }
                            tokenWrappingPolicy = wrappingPolicy;
                        }
                    } else if (currToken.sym == 60) {
                        if (hasIndented[0]) {
                            CodeFormatterVisitor.this.unindent(numOfIndents4Wrapping);
                        }
                        addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace, tokenWrappingPolicy);
                }
            }
        };
        this.formatNode((Node)getByPositionStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(OpenStatement openStatement) {
        this.push2ContextPath((Node)openStatement);
        final CodeFormatterVisitor thisVisitor = this;
        final int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        final int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
        final List openTargets = openStatement.getOpenTargets();
        final Node firstOpenTarget = openTargets != null && !openTargets.isEmpty() ? (Node)openTargets.get(0) : null;
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                if (firstOpenTarget != null && currToken.left == firstOpenTarget.getOffset()) {
                    CodeFormatterVisitor.this.indent(numOfIndents4Wrapping);
                    for (Node openTarget : openTargets) {
                        CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                        openTarget.accept((IASTVisitor)thisVisitor);
                    }
                    CodeFormatterVisitor.this.unindent(numOfIndents4Wrapping);
                } else {
                    int numOfBlankLines = -1;
                    boolean addSpace = false;
                    switch (prevToken.sym) {
                        case 128: {
                            addSpace = true;
                        }
                    }
                    switch (currToken.sym) {
                        case 166: 
                        case 167: {
                            addSpace = true;
                            break;
                        }
                        case 60: {
                            addSpace = CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements");
                        }
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)openStatement, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(PrepareStatement prepareStatement) {
        this.push2ContextPath((Node)prepareStatement);
        this.printStuffBeforeNode(prepareStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
        this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        this.indent(numOfIndents4Wrapping);
        if (prepareStatement.getSqlStmt() != null) {
            prepareStatement.getSqlStmt().accept((IASTVisitor)this);
        }
        if (prepareStatement.getDataSource() != null) {
            prepareStatement.getDataSource().accept((IASTVisitor)this);
        }
        if (prepareStatement.getWithClause() != null) {
            prepareStatement.getWithClause().accept((IASTVisitor)this);
        }
        this.unindent(numOfIndents4Wrapping);
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(FromExpressionClause fromExpressionClause) {
        this.push2ContextPath((Node)fromExpressionClause);
        this.printStuffBeforeNode(fromExpressionClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = fromExpressionClause.getExpression();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(ReplaceStatement replaceStatement) {
        this.push2ContextPath((Node)replaceStatement);
        this.printStuffBeforeNode(replaceStatement.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = replaceStatement.getRecord();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.ioStmt");
        List replaceOpts = replaceStatement.getReplaceOptions();
        if (replaceOpts != null && !replaceOpts.isEmpty()) {
            this.indent(numOfIndents4Wrapping);
            for (Node replaceOpt : replaceOpts) {
                this.setGlobalFormattingSettings(-1, true, wrappingPolicy);
                replaceOpt.accept((IASTVisitor)this);
            }
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    public boolean visit(ReturningToInvocationTargetClause returningToInvocationTargetClause) {
        this.push2ContextPath((Node)returningToInvocationTargetClause);
        this.printStuffBeforeNode(returningToInvocationTargetClause.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.printStuffBeforeToken(117, -1, true);
        Expression expr = returningToInvocationTargetClause.getExpression();
        this.setGlobalFormattingSettings(-1, true, 1);
        expr.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        this.push2ContextPath((Node)classDataDeclaration);
        List names = classDataDeclaration.getNames();
        Type type = classDataDeclaration.getType();
        SettingsBlock settingsBlock = classDataDeclaration.getSettingsBlockOpt();
        Expression initExpr = classDataDeclaration.getInitializer();
        boolean addSpace = false;
        int numOfBlankLines = this.getIntPrefSetting("blankLines.beforePartDataDecl");
        if (classDataDeclaration.isPrivate()) {
            this.printStuffBeforeNode(classDataDeclaration.getOffset(), numOfBlankLines, addSpace);
            addSpace = true;
            numOfBlankLines = -1;
        }
        if (classDataDeclaration.isConstant()) {
            this.printStuffBeforeToken(61, numOfBlankLines, addSpace);
            addSpace = true;
            numOfBlankLines = -1;
        }
        if (classDataDeclaration.isStatic()) {
            this.printStuffBeforeToken(95, numOfBlankLines, addSpace);
            addSpace = true;
            numOfBlankLines = -1;
        }
        this.setGlobalFormattingSettings(numOfBlankLines, addSpace, 1);
        this.formatCommaSeparatedNodeList(names, this.getBooleanPrefSetting("whiteSpace.beforeComma.dataDecl"), this.getBooleanPrefSetting("whiteSpace.afterComma.dataDecl"), this.getEnumPrefSetting("lineWrapping.varDelcaration"));
        this.setGlobalFormattingSettings(-1, true, 1);
        type.accept((IASTVisitor)this);
        if (classDataDeclaration.isNullable()) {
            this.printStuffBeforeToken(42, -1, this.getBooleanPrefSetting("whiteSpace.beforeQuestion.nullableFields"));
        }
        if (settingsBlock != null) {
            this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
            settingsBlock.accept((IASTVisitor)this);
        }
        if (initExpr != null) {
            this.printStuffBeforeToken(62, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.assignment"));
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterOperator.assignment"), this.getEnumPrefSetting("lineWrapping.initExpr"));
            int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
            this.indent(numOfIndents4Wrapping);
            initExpr.accept((IASTVisitor)this);
            this.unindent(numOfIndents4Wrapping);
        }
        this.printStuffBeforeToken(60, -1, this.getBooleanPrefSetting("whiteSpace.beforeSemicolon.statements"));
        this.popContextPath();
        return false;
    }

    private void formatCommaSeparatedNodeList(List nodes, boolean addSpaceBeforeCommaPref, boolean addSpaceAfterCommaPref, int wrappingPolicyFrom2ndName) {
        boolean isFirstName = true;
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        boolean hasIndented4Wrap = false;
        for (Node node : nodes) {
            if (isFirstName) {
                this.setGlobalFormattingSettings(this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, 1);
            } else {
                if (!hasIndented4Wrap) {
                    this.indent(numOfIndents4Wrapping);
                    hasIndented4Wrap = true;
                }
                this.printStuffBeforeToken(64, -1, addSpaceBeforeCommaPref);
                this.setGlobalFormattingSettings(-1, !isFirstName && addSpaceAfterCommaPref, wrappingPolicyFrom2ndName);
            }
            node.accept((IASTVisitor)this);
            isFirstName = false;
        }
        if (hasIndented4Wrap) {
            this.unindent(numOfIndents4Wrapping);
        }
    }

    private void formatParameters(List parameters, boolean addSpaceAfterLParen) {
        this.formatParameters(parameters, addSpaceAfterLParen, this.getBooleanPrefSetting("whiteSpace.beforeComma.funcParms"), this.getBooleanPrefSetting("whiteSpace.afterComma.funcParms"));
    }

    private void formatParameters(List parameters, boolean addSpaceAfterLParen, boolean addSpaceBeforeComma, boolean addSpaceAfterComma) {
        boolean isFirstParameter = true;
        int wrappingPolicy = 1;
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        this.indent(numOfIndents4Wrapping);
        if (parameters != null) {
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                if (!isFirstParameter) {
                    this.printStuffBeforeToken(64, -1, addSpaceBeforeComma);
                }
                Parameter param = (Parameter)it.next();
                if (!isFirstParameter) {
                    wrappingPolicy = this.getEnumPrefSetting("lineWrapping.parameters");
                }
                boolean addSpace = isFirstParameter ? addSpaceAfterLParen : addSpaceAfterComma;
                this.setGlobalFormattingSettings(-1, addSpace, wrappingPolicy);
                param.accept((IASTVisitor)this);
                isFirstParameter = false;
            }
        }
        this.unindent(numOfIndents4Wrapping);
    }

    public boolean visit(final FunctionParameter functionParameter) {
        this.push2ContextPath((Node)functionParameter);
        final CodeFormatterVisitor thisVisitor = this;
        final Type paramType = functionParameter.getType();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                if (currToken.left == paramType.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, true, 1);
                    paramType.accept((IASTVisitor)thisVisitor);
                    if (functionParameter.isNullable()) {
                        CodeFormatterVisitor.this.printStuffBeforeToken(42, -1, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeQuestion.nullableParameters"));
                    }
                } else {
                    switch (currToken.sym) {
                        case 15: 
                        case 61: 
                        case 89: 
                        case 90: {
                            addSpace = true;
                            break;
                        }
                        default: {
                            addSpace = false;
                        }
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, -1, addSpace);
                }
            }
        };
        this.formatNode((Node)functionParameter, callbackFormatter, this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(ArrayType arrayType) {
        this.push2ContextPath((Node)arrayType);
        Type arrayElemType = arrayType.getElementType();
        arrayElemType.accept((IASTVisitor)this);
        this.printStuffBeforeToken(56, -1, this.getBooleanPrefSetting("whiteSpace.beforeLBracket.array"));
        Expression initialSize = arrayType.getInitialSize();
        if (initialSize != null) {
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLBracket.array"), 1);
            initialSize.accept((IASTVisitor)this);
        }
        this.printStuffBeforeToken(57, -1, this.getBooleanPrefSetting("whiteSpace.beforeRBracket.array"));
        this.popContextPath();
        return false;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        this.push2ContextPath((Node)parenthesizedExpression);
        final CodeFormatterVisitor thisVisitor = this;
        final boolean[] addSpaces = new boolean[]{this.getBooleanPrefSetting("whiteSpace.beforeLParen.parentExpr"), this.getBooleanPrefSetting("whiteSpace.afterLParen.parentExpr"), this.getBooleanPrefSetting("whiteSpace.beforeRParen.parentExpr")};
        Node parentNode = parenthesizedExpression.getParent();
        if (parentNode instanceof ReturnStatement) {
            addSpaces[0] = this.getBooleanPrefSetting("whiteSpace.beforeLParen.return");
            addSpaces[1] = this.getBooleanPrefSetting("whiteSpace.afterLParen.return");
            addSpaces[2] = this.getBooleanPrefSetting("whiteSpace.beforeRParen.return");
        } else if (parentNode instanceof CaseStatement) {
            addSpaces[0] = this.getBooleanPrefSetting("whiteSpace.beforeLParen.case");
            addSpaces[1] = this.getBooleanPrefSetting("whiteSpace.afterLParen.case");
            addSpaces[2] = this.getBooleanPrefSetting("whiteSpace.beforeRParen.case");
        } else if (parentNode instanceof ExitStatement) {
            addSpaces[0] = this.getBooleanPrefSetting("whiteSpace.beforeLParen.exit");
            addSpaces[1] = this.getBooleanPrefSetting("whiteSpace.afterLParen.exit");
            addSpaces[2] = this.getBooleanPrefSetting("whiteSpace.beforeRParen.exit");
        }
        final Expression expr = parenthesizedExpression.getExpression();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                int numOfBlankLines = -1;
                if (currToken.left == expr.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(CodeFormatterVisitor.this.fGlobalNumOfBlankLines, addSpaces[1], CodeFormatterVisitor.this.fCurrentWrappingPolicy);
                    expr.accept((IASTVisitor)thisVisitor);
                } else {
                    if (currToken.sym == 55) {
                        addSpace = addSpaces[2];
                    }
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, numOfBlankLines, addSpace);
                }
            }
        };
        this.formatNode((Node)parenthesizedExpression, callbackFormatter, this.fGlobalNumOfBlankLines, addSpaces[0], this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(SuperExpression superExpression) {
        return this.visitTerminalExpression((Expression)superExpression);
    }

    public boolean visit(ThisExpression thisExpression) {
        return this.visitTerminalExpression((Expression)thisExpression);
    }

    public boolean visit(IntegerLiteral integerLiteral) {
        return this.visitTerminalExpression((Expression)integerLiteral);
    }

    public boolean visit(DecimalLiteral decimalLiteral) {
        return this.visitTerminalExpression((Expression)decimalLiteral);
    }

    public boolean visit(FloatLiteral floatLiteral) {
        return this.visitTerminalExpression((Expression)floatLiteral);
    }

    public boolean visit(StringLiteral stringLiteral) {
        return this.visitTerminalExpression((Expression)stringLiteral);
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        return this.visitTerminalExpression((Expression)booleanLiteral);
    }

    public boolean visit(NullLiteral nullLiteral) {
        return this.visitTerminalExpression((Expression)nullLiteral);
    }

    public boolean visit(SQLLiteral sQLLiteral) {
        return this.visitTerminalExpression((Expression)sQLLiteral);
    }

    public boolean visit(BytesLiteral bytesLiteral) {
        return this.visitTerminalExpression((Expression)bytesLiteral);
    }

    private boolean visitTerminalExpression(Expression literalExpression) {
        return this.visitTerminalNode((Node)literalExpression);
    }

    public boolean visit(ArrayLiteral arrayLiteral) {
        this.push2ContextPath((Node)arrayLiteral);
        this.printStuffBeforeToken(56, this.fGlobalNumOfBlankLines, this.getBooleanPrefSetting("whiteSpace.beforeLBracket.array"), this.fCurrentWrappingPolicy);
        int wrappingPolicy = 1;
        List exprs = arrayLiteral.getExpressions();
        if (exprs != null && !exprs.isEmpty()) {
            if (exprs.size() > 1 || this.getEnumPrefSetting("lineWrapping.array") != 0) {
                wrappingPolicy = this.getEnumPrefSetting("lineWrapping.array");
            }
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLBracket.array"), wrappingPolicy);
            this.formatExpressions(exprs, wrappingPolicy, this.getBooleanPrefSetting("whiteSpace.beforeComma.array"), this.getBooleanPrefSetting("whiteSpace.afterComma.array"));
        }
        this.printStuffBeforeToken(57, -1, this.getBooleanPrefSetting("whiteSpace.beforeRBracket.array"), wrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        this.push2ContextPath((Node)arrayAccess);
        Expression primaryOrName = arrayAccess.getArray();
        primaryOrName.accept((IASTVisitor)this);
        this.printStuffBeforeToken(56, -1, this.getBooleanPrefSetting("whiteSpace.beforeLBracket.array"));
        List exprs = arrayAccess.getIndices();
        int wrappingPolicy = this.getEnumPrefSetting("lineWrapping.array");
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLBracket.array"), wrappingPolicy);
        this.formatExpressions(exprs, wrappingPolicy, this.getBooleanPrefSetting("whiteSpace.beforeComma.array"), this.getBooleanPrefSetting("whiteSpace.afterComma.array"));
        this.printStuffBeforeToken(57, -1, this.getBooleanPrefSetting("whiteSpace.beforeRBracket.array"));
        this.popContextPath();
        return false;
    }

    public boolean visit(SubstringAccess substringAccess) {
        this.push2ContextPath((Node)substringAccess);
        Expression primaryOrName = substringAccess.getPrimary();
        primaryOrName.accept((IASTVisitor)this);
        this.printStuffBeforeToken(56, -1, this.getBooleanPrefSetting("whiteSpace.beforeLBracket.array"));
        Expression expr1 = substringAccess.getExpr();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLBracket.array"), 1);
        expr1.accept((IASTVisitor)this);
        this.printStuffBeforeToken(63, -1, this.getBooleanPrefSetting("whiteSpace.beforeColon.subString"));
        Expression expr2 = substringAccess.getExpr2();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterColon.subString"), 1);
        expr2.accept((IASTVisitor)this);
        this.printStuffBeforeToken(57, -1, this.getBooleanPrefSetting("whiteSpace.beforeRBracket.array"));
        this.popContextPath();
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        this.push2ContextPath((Node)fieldAccess);
        Expression primaryOrName = fieldAccess.getPrimary();
        primaryOrName.accept((IASTVisitor)this);
        this.printStuffBeforeToken(41, -1, false);
        this.printStuffBeforeToken(97, -1, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        this.push2ContextPath((Node)functionInvocation);
        Expression targetExpr = functionInvocation.getTarget();
        targetExpr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.funcInvoc"));
        List args = functionInvocation.getArguments();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.funcInvoc"), 1);
        this.formatExpressions(args, this.getEnumPrefSetting("lineWrapping.args"), this.getBooleanPrefSetting("whiteSpace.beforeComma.funcInvoc"), this.getBooleanPrefSetting("whiteSpace.afterComma.funcInvoc"));
        this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.funcInvoc"));
        this.popContextPath();
        return false;
    }

    public boolean visit(AnnotationExpression annotationExpression) {
        this.push2ContextPath((Node)annotationExpression);
        this.printStuffBeforeNode(annotationExpression.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Name annotationName = annotationExpression.getName();
        this.setGlobalFormattingSettings(-1, false, 1);
        annotationName.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(NewExpression newExpression) {
        this.push2ContextPath((Node)newExpression);
        this.printStuffBeforeNode(newExpression.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Type type = newExpression.getType();
        this.setGlobalFormattingSettings(-1, true, 1);
        type.accept((IASTVisitor)this);
        SettingsBlock settingsBlock = newExpression.getSettingsBlock();
        if (settingsBlock != null) {
            this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
            settingsBlock.accept((IASTVisitor)this);
        }
        this.popContextPath();
        return false;
    }

    public boolean visit(SetValuesExpression setValuesExpression) {
        this.push2ContextPath((Node)setValuesExpression);
        Expression primaryOrName = setValuesExpression.getExpression();
        primaryOrName.accept((IASTVisitor)this);
        SettingsBlock settingsBlock = setValuesExpression.getSettingsBlock();
        this.setGlobalFormattingSettings(this.getNumOfBlankLinesBeforeCurlyBrace(), this.getBooleanPrefSetting("whiteSpace.beforeLCurly.settings"), 1);
        settingsBlock.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(TypeLiteralExpression typeLiteralExpression) {
        this.push2ContextPath((Node)typeLiteralExpression);
        Type type = typeLiteralExpression.getType();
        type.accept((IASTVisitor)this);
        this.printStuffBeforeToken(41, -1, false);
        this.printStuffBeforeToken(86, -1, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(UnaryExpression unaryExpression) {
        this.push2ContextPath((Node)unaryExpression);
        this.printStuffBeforeNode(unaryExpression.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        Expression expr = unaryExpression.getExpression();
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterOperator.unary"), 1);
        expr.accept((IASTVisitor)this);
        this.popContextPath();
        return false;
    }

    public boolean visit(BinaryExpression binaryExpression) {
        this.push2ContextPath((Node)binaryExpression);
        Expression firstExpr = binaryExpression.getFirstExpression();
        firstExpr.accept((IASTVisitor)this);
        int numOfBlankLines = -1;
        boolean addSpace = this.getBooleanPrefSetting("whiteSpace.beforeOperator.binary");
        BinaryExpression.Operator binaryOp = binaryExpression.getOperator();
        if (binaryOp == BinaryExpression.Operator.PLUS) {
            this.printStuffBeforeToken(32, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.MINUS) {
            this.printStuffBeforeToken(33, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.TIMES) {
            this.printStuffBeforeToken(35, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.DIVIDE) {
            this.printStuffBeforeToken(36, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.MODULO) {
            this.printStuffBeforeToken(34, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.TIMESTIMES) {
            this.printStuffBeforeToken(37, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.CONCAT) {
            this.printStuffBeforeToken(38, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.NULLCONCAT) {
            this.printStuffBeforeToken(39, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.OR) {
            this.printStuffBeforeToken(8, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.AND) {
            this.printStuffBeforeToken(9, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.BITAND) {
            this.printStuffBeforeToken(11, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.BITOR) {
            this.printStuffBeforeToken(10, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.XOR) {
            this.printStuffBeforeToken(12, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.EQUALS) {
            this.printStuffBeforeToken(17, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.NOT_EQUALS) {
            this.printStuffBeforeToken(18, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.LESS) {
            this.printStuffBeforeToken(19, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.GREATER) {
            this.printStuffBeforeToken(20, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.LESS_EQUALS) {
            this.printStuffBeforeToken(21, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.GREATER_EQUALS) {
            this.printStuffBeforeToken(29, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.LEFT_SHIFT) {
            this.printStuffBeforeToken(23, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.RIGHT_SHIFT_ARITHMETIC) {
            this.printStuffBeforeToken(27, numOfBlankLines, addSpace);
        } else if (binaryOp == BinaryExpression.Operator.RIGHT_SHIFT_LOGICAL) {
            this.printStuffBeforeToken(25, numOfBlankLines, addSpace);
        }
        Expression secondExpr = binaryExpression.getSecondExpression();
        this.format2ndExpressionInBinaryExpression((Node)secondExpr);
        this.popContextPath();
        return false;
    }

    private void format2ndExpressionInBinaryExpression(Node secondExpr) {
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        this.indent(numOfIndents4Wrapping);
        this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterOperator.binary"), this.getEnumPrefSetting("lineWrapping.binaryExpr"));
        secondExpr.accept((IASTVisitor)this);
        this.unindent(numOfIndents4Wrapping);
    }

    public boolean visit(IsAExpression isAExpression) {
        this.push2ContextPath((Node)isAExpression);
        Expression expr = isAExpression.getExpression();
        expr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(31, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.binary"));
        Type type = isAExpression.getType();
        this.format2ndExpressionInBinaryExpression((Node)type);
        this.popContextPath();
        return false;
    }

    public boolean visit(AsExpression asExpression) {
        this.push2ContextPath((Node)asExpression);
        Expression expr = asExpression.getExpression();
        expr.accept((IASTVisitor)this);
        this.printStuffBeforeToken(30, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.binary"));
        if (asExpression.hasType()) {
            Type type = asExpression.getType();
            this.format2ndExpressionInBinaryExpression((Node)type);
        } else if (asExpression.hasStringLiteral()) {
            Expression stringLiteralExpr = asExpression.getStringLiteral();
            this.format2ndExpressionInBinaryExpression((Node)stringLiteralExpr);
        }
        this.popContextPath();
        return false;
    }

    public boolean visit(IsNotExpression isNotExpression) {
        this.push2ContextPath((Node)isNotExpression);
        Expression firstExpr = isNotExpression.getFirstExpression();
        firstExpr.accept((IASTVisitor)this);
        IsNotExpression.Operator isNotOp = isNotExpression.getOperator();
        if (isNotOp == IsNotExpression.Operator.IS) {
            this.printStuffBeforeToken(13, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.binary"));
        } else if (isNotOp == IsNotExpression.Operator.NOT) {
            this.printStuffBeforeToken(14, -1, this.getBooleanPrefSetting("whiteSpace.beforeOperator.binary"));
        }
        Expression secondExpr = isNotExpression.getSecondExpression();
        this.format2ndExpressionInBinaryExpression((Node)secondExpr);
        this.popContextPath();
        return false;
    }

    private void formatExpressions(List exprs) {
        this.formatExpressions(exprs, this.getEnumPrefSetting("lineWrapping.exprs"), this.getBooleanPrefSetting("whiteSpace.beforeComma.exprList"), this.getBooleanPrefSetting("whiteSpace.afterComma.exprList"));
    }

    private void formatExpressions(List exprs, int wrappingPolicy, boolean addSpaceBeforeComma, boolean addSpaceAfterComma) {
        boolean isFirstExpr = true;
        int numOfIndents4Wrapping = this.getIntPrefSetting("lineWrapping.numOfIndent4WrappedLines");
        boolean indentedWrap = false;
        if (this.fGlobalNumOfBlankLines < 0) {
            this.indent(numOfIndents4Wrapping);
            indentedWrap = true;
        }
        if (exprs != null) {
            int cnt = exprs.size();
            if (cnt == 1 && wrappingPolicy != 0) {
                this.setGlobalFormattingSettings(this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, 1);
            }
            Iterator it = exprs.iterator();
            while (it.hasNext()) {
                if (!isFirstExpr) {
                    this.printStuffBeforeToken(64, -1, addSpaceBeforeComma);
                    this.setGlobalFormattingSettings(-1, addSpaceAfterComma, wrappingPolicy);
                }
                Expression expr = (Expression)it.next();
                expr.accept((IASTVisitor)this);
                if (!indentedWrap) {
                    this.indent(numOfIndents4Wrapping);
                    indentedWrap = true;
                }
                isFirstExpr = false;
            }
        }
        if (indentedWrap) {
            this.unindent(numOfIndents4Wrapping);
        }
    }

    public boolean visit(NameType nameType) {
        this.push2ContextPath((Node)nameType);
        Name name = nameType.getName();
        name.accept((IASTVisitor)this);
        if (nameType.hasArguments()) {
            this.printStuffBeforeToken(54, -1, this.getBooleanPrefSetting("whiteSpace.beforeLParen.namedType"));
            List funcArgs = nameType.getArguments();
            this.setGlobalFormattingSettings(-1, this.getBooleanPrefSetting("whiteSpace.afterLParen.namedType"), 1);
            this.formatExpressions(funcArgs, this.getEnumPrefSetting("lineWrapping.args"), this.getBooleanPrefSetting("whiteSpace.beforeComma.namedType"), this.getBooleanPrefSetting("whiteSpace.afterComma.namedType"));
            this.printStuffBeforeToken(55, -1, this.getBooleanPrefSetting("whiteSpace.beforeRParen.namedType"));
        }
        this.popContextPath();
        return false;
    }

    private boolean visitTerminalNode(Node terminalASTNode) {
        this.push2ContextPath(terminalASTNode);
        this.printStuffBeforeNode(terminalASTNode.getOffset(), this.fGlobalNumOfBlankLines, this.fGlobalAddSpace, this.fCurrentWrappingPolicy);
        this.popContextPath();
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        return this.visitTerminalNode((Node)simpleName);
    }

    public boolean visit(QualifiedName qualifiedName) {
        this.push2ContextPath((Node)qualifiedName);
        qualifiedName.getQualifier().accept((IASTVisitor)this);
        this.printStuffBeforeToken(41, -1, false);
        this.printStuffBeforeToken(97, -1, false);
        this.popContextPath();
        return false;
    }

    public boolean visit(final ReturnsDeclaration returnsDeclaration) {
        this.push2ContextPath((Node)returnsDeclaration);
        final CodeFormatterVisitor thisVisitor = this;
        final Type returnType = returnsDeclaration.getType();
        ICallBackFormatter callbackFormatter = new ICallBackFormatter(){

            @Override
            public void format(Symbol prevToken, Symbol currToken) {
                boolean addSpace = false;
                if (currToken.left == returnType.getOffset()) {
                    CodeFormatterVisitor.this.setGlobalFormattingSettings(-1, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.afterLParen.return"), 1);
                    returnType.accept((IASTVisitor)thisVisitor);
                    if (returnsDeclaration.isNullable()) {
                        CodeFormatterVisitor.this.printStuffBeforeToken(42, -1, CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeQuestion.nullableReturns"));
                    }
                } else {
                    addSpace = currToken.sym == 54 ? CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeLParen.return") : (currToken.sym == 55 ? CodeFormatterVisitor.this.getBooleanPrefSetting("whiteSpace.beforeRParen.return") : false);
                    CodeFormatterVisitor.this.printToken(prevToken, currToken, -1, addSpace);
                }
            }
        };
        this.formatNode((Node)returnsDeclaration, callbackFormatter, -1, true);
        this.popContextPath();
        return false;
    }

    private void push2ContextPath(Node node) {
        this.fContextPath.push(node.getClass().getSimpleName());
    }

    private void popContextPath() {
        this.fContextPath.pop();
    }

    private boolean printStuffBeforeNode(int nodeStartingOffset, int numOfBlankLinesBeforeNode, boolean addSpaceBeforeNode) {
        return this.printStuffBeforeNode(nodeStartingOffset, numOfBlankLinesBeforeNode, addSpaceBeforeNode, 1);
    }

    private boolean printStuffBeforeToken(int tokenType, int numOfBlankLinesBeforeNode, boolean addSpaceBeforeNode) {
        return this.printStuffBeforeToken(tokenType, numOfBlankLinesBeforeNode, addSpaceBeforeNode, 1);
    }

    private boolean printStuffBeforeNode(int nodeStartingOffset, int numOfBlankLinesBeforeNode, boolean addSpaceBeforeNode, int wrappingPolicy) {
        return this.printStuffBeforeNodeCommon(true, nodeStartingOffset, numOfBlankLinesBeforeNode, addSpaceBeforeNode, wrappingPolicy);
    }

    private boolean printStuffBeforeToken(int tokenType, int numOfBlankLinesBeforeNode, boolean addSpaceBeforeNode, int wrappingPolicy) {
        return this.printStuffBeforeNodeCommon(false, tokenType, numOfBlankLinesBeforeNode, addSpaceBeforeNode, wrappingPolicy);
    }

    private boolean printStuffBeforeNodeCommon(boolean useAsOffset, int nodeStartingOffset_Or_TokenType, int numOfBlankLinesBeforeNode, boolean addSpaceBeforeNode, int wrappingPolicy) {
        if (this.compareEqual(useAsOffset, this.fCurrToken, nodeStartingOffset_Or_TokenType)) {
            if (!useAsOffset && this.fPrevToken == this.fCurrToken) {
                this.fCurrToken = this.nextToken();
                this.printStuffBeforeNodeCommon(useAsOffset, nodeStartingOffset_Or_TokenType, numOfBlankLinesBeforeNode, addSpaceBeforeNode, wrappingPolicy);
            } else {
                this.printToken(this.fPrevToken, this.fCurrToken, numOfBlankLinesBeforeNode, addSpaceBeforeNode, wrappingPolicy);
                this.fPrevToken = this.fCurrToken;
            }
        }
        while (!this.compareEqual(useAsOffset, this.fCurrToken, nodeStartingOffset_Or_TokenType) && this.fCurrToken.sym != 0) {
            this.fPrevToken = this.fCurrToken;
            this.fCurrToken = this.nextToken();
            boolean addSpace = false;
            int numOfBlankLines = -1;
            if (this.fPrevToken.sym == 67) {
                numOfBlankLines = 0;
            }
            switch (this.fPrevToken.sym) {
                case 94: {
                    addSpace = true;
                }
            }
            if (this.compareEqual(useAsOffset, this.fCurrToken, nodeStartingOffset_Or_TokenType)) {
                if (this.fPrevToken.sym == 67 && wrappingPolicy == 1) {
                    numOfBlankLinesBeforeNode = numOfBlankLinesBeforeNode > 0 ? numOfBlankLinesBeforeNode : 0;
                }
                this.printToken(this.fPrevToken, this.fCurrToken, numOfBlankLinesBeforeNode, addSpaceBeforeNode, wrappingPolicy);
            } else {
                this.printToken(this.fPrevToken, this.fCurrToken, numOfBlankLines, addSpace);
            }
            this.fPrevToken = this.fCurrToken;
        }
        return this.fCurrToken.sym != 0;
    }

    private boolean compareEqual(boolean useAsOffset, Symbol token, int offsetOrTokenType) {
        if (useAsOffset) {
            return token.left == offsetOrTokenType;
        }
        return token.sym == offsetOrTokenType;
    }

    private void printToken(Symbol prevToken, Symbol token, int numOfBlankLines, boolean addSpace) {
        this.printToken(prevToken, token, numOfBlankLines, addSpace, 1);
    }

    private void printToken(Symbol prevToken, Symbol token, int numOfBlankLines, boolean addSpace, int wrappingPolicy) {
        block11: {
            int prevTokenLen = prevToken.right - prevToken.left;
            if (prevToken.sym == 68) {
                try {
                    String blockComments = this.fDocument.get(prevToken.left, prevTokenLen);
                    int lastLineSeparator = blockComments.lastIndexOf(this.fLineSeparator);
                    if (lastLineSeparator != -1) {
                        this.fCurrentColumn = prevTokenLen - 1 - lastLineSeparator - 1;
                        break block11;
                    }
                    this.fCurrentColumn += prevTokenLen;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else if (prevToken.sym == 67) {
                this.fCurrentColumn = 0;
            } else if (prevToken.sym != 69) {
                this.fCurrentColumn += prevTokenLen;
            }
        }
        this.fCurrentColumn += token.left - prevToken.right;
        if (token.sym != 68 && token.sym != 67) {
            this.printFormatToken(prevToken, token, numOfBlankLines, addSpace, wrappingPolicy, this.fEdits);
            this.printKeywordToken(token, this.fEdits);
        } else if (prevToken.sym == 69 || prevToken.sym == 67) {
            this.printFormatToken(prevToken, token, 0, addSpace, wrappingPolicy, this.fEdits);
        }
    }

    private void printFormatToken(Symbol prevToken, Symbol token, int numOfBlankLines, boolean addSpace, int wrappingPolicy, List edits) {
        if (numOfBlankLines >= 0) {
            if (wrappingPolicy == 1) {
                while (!this.fPendingWrapEdits.isEmpty()) {
                    PendingWrapEdit pendingWrapEdit = (PendingWrapEdit)this.fPendingWrapEdits.removeFirst();
                    this.fEdits.addAll(pendingWrapEdit.fNoWrapEdits);
                    this.fIsWrappingNecessary = false;
                }
            }
            this.printSpace(prevToken, token, false, edits);
            this.printBlankLines(prevToken, token, numOfBlankLines, edits);
        } else if (wrappingPolicy != 0) {
            this.printNewLineBasedOnWrappingPolicy(prevToken, token, addSpace, wrappingPolicy);
        }
    }

    private void printNewLineBasedOnWrappingPolicy(Symbol prevToken, Symbol token, boolean addSpace, int wrappingPolicy) {
        ArrayList noWrapEdits = new ArrayList();
        boolean isLineBreaksRemoved = this.printRemoveLineBreaks(prevToken, token, addSpace, 1, noWrapEdits);
        if (isLineBreaksRemoved) {
            this.printSpace(prevToken, token, addSpace, noWrapEdits);
        }
        int tokenLen = token.sym != 69 ? token.right - token.left : 0;
        int maxLineWidth = this.getIntPrefSetting("lineWrapping.maxLineWidth");
        if (wrappingPolicy == 1) {
            this.fEdits.addAll(noWrapEdits);
            if (this.fCurrentColumn + tokenLen >= maxLineWidth) {
                this.fIsWrappingNecessary = true;
                int savedNoWrapCurrentColumn = this.fCurrentColumn;
                while (!this.fPendingWrapEdits.isEmpty()) {
                    PendingWrapEdit pendingWrapEdit = (PendingWrapEdit)this.fPendingWrapEdits.removeFirst();
                    this.fEdits.addAll(pendingWrapEdit.fWrapEdits);
                    this.fCurrentColumn = pendingWrapEdit.fWrapColumn + (savedNoWrapCurrentColumn - pendingWrapEdit.fNoWrapColumn);
                }
            }
        } else {
            ArrayList wrapEdits = new ArrayList();
            int noWrapColumn = this.fCurrentColumn;
            this.wrapToken(prevToken, token, addSpace, wrappingPolicy, wrapEdits);
            int wrapColumn = this.fCurrentColumn;
            switch (wrappingPolicy) {
                case 2: {
                    while (!this.fPendingWrapEdits.isEmpty()) {
                        PendingWrapEdit pendingWrapEdit = (PendingWrapEdit)this.fPendingWrapEdits.removeFirst();
                        this.fEdits.addAll(pendingWrapEdit.fNoWrapEdits);
                        this.fIsWrappingNecessary = false;
                    }
                    if (noWrapColumn + tokenLen >= maxLineWidth) {
                        this.fEdits.addAll(wrapEdits);
                        this.fIsWrappingNecessary = true;
                        break;
                    }
                    this.fPendingWrapEdits.add(new PendingWrapEdit(noWrapEdits, noWrapColumn, wrapEdits, wrapColumn));
                    this.fCurrentColumn = noWrapColumn;
                    break;
                }
                case 4: {
                    if (noWrapColumn + tokenLen >= maxLineWidth || this.fIsWrappingNecessary) {
                        this.fIsWrappingNecessary = true;
                        while (!this.fPendingWrapEdits.isEmpty()) {
                            PendingWrapEdit pendingWrapEdit = (PendingWrapEdit)this.fPendingWrapEdits.removeFirst();
                            this.fEdits.addAll(pendingWrapEdit.fWrapEdits);
                        }
                        this.fEdits.addAll(wrapEdits);
                        break;
                    }
                    this.fPendingWrapEdits.add(new PendingWrapEdit(noWrapEdits, noWrapColumn, wrapEdits, wrapColumn));
                    this.fCurrentColumn = noWrapColumn;
                    break;
                }
                case 3: {
                    this.fEdits.addAll(wrapEdits);
                }
            }
        }
    }

    private void wrapToken(Symbol prevToken, Symbol token, boolean addSpace, int wrappingPolicy, List edits) {
        this.printFormatToken(prevToken, token, 0, addSpace, wrappingPolicy, edits);
    }

    private void printKeywordToken(Symbol token, List edits) {
        try {
            int tokenLen = token.right - token.left;
            String strToken = this.fDocument.get(token.left, tokenLen);
            HashSet eglKeywords = EGLKeywordHandler.getKeywordHashSet();
            String lowerCasedToken = strToken.toLowerCase();
            if (eglKeywords.contains(lowerCasedToken)) {
                String prefToken = "";
                int keywordCasePref = this.getIntPrefSetting("generalSettings.keywordCase");
                switch (keywordCasePref) {
                    case 0: {
                        prefToken = strToken;
                        break;
                    }
                    case 1: {
                        prefToken = strToken.toUpperCase();
                        break;
                    }
                    case 2: {
                        prefToken = lowerCasedToken;
                        break;
                    }
                    case 3: {
                        String[] eglPreferedCaseKeywords = EGLKeywordHandler.getKeywordNames();
                        boolean fFnd = false;
                        int i = 0;
                        while (i < eglPreferedCaseKeywords.length && !fFnd) {
                            String eglPreferedCaseKeyword = eglPreferedCaseKeywords[i];
                            if (strToken.equalsIgnoreCase(eglPreferedCaseKeyword)) {
                                prefToken = eglPreferedCaseKeyword;
                                fFnd = true;
                            }
                            ++i;
                        }
                        break;
                    }
                }
                if (!prefToken.equals(strToken)) {
                    edits.add(new ReplaceEdit(token.left, tokenLen, prefToken));
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void printBlankLines(Symbol prevToken, Symbol token, int numOfBlankLines, List edits) {
        int preserveBlankLines = this.getIntPrefSetting("blankLines.preservExisting");
        int existingBlankLines = CodeFormatterVisitor.getExistingBlankLines(prevToken, this.fDocument);
        StringBuffer lines = new StringBuffer();
        int formatNumOfBlankLines = numOfBlankLines;
        if (existingBlankLines > 0 && preserveBlankLines > numOfBlankLines) {
            formatNumOfBlankLines = Math.min(existingBlankLines, preserveBlankLines);
        }
        int i = 0;
        while (i < formatNumOfBlankLines) {
            lines.append(this.fLineSeparator);
            ++i;
        }
        String strIndentation = this.getIndentationString();
        if (prevToken.sym == 69) {
            int replaceLength = prevToken.right - prevToken.left;
            if (!CodeFormatterVisitor.isOffsetOnABlankLine(prevToken.left, this.fDocument)) {
                lines.append(this.fLineSeparator);
            }
            lines.append(strIndentation);
            edits.add(new ReplaceEdit(prevToken.left, replaceLength, lines.toString()));
        } else if (formatNumOfBlankLines >= 0) {
            if (!CodeFormatterVisitor.isOffsetOnABlankLine(token.left, this.fDocument)) {
                lines.append(this.fLineSeparator);
            }
            lines.append(strIndentation);
            String strLines = lines.toString();
            if (strLines.length() > 0) {
                edits.add(new InsertEdit(token.left, strLines));
            }
        }
        this.fCurrentColumn = 0;
        this.fCurrentColumn += strIndentation.length();
    }

    private static int getExistingBlankLines(Symbol testToken, IDocument document) {
        int existingBlankLines = 0;
        try {
            if (testToken.sym == 69) {
                int startLineNum = document.getLineOfOffset(testToken.left);
                int endLineNum = document.getLineOfOffset(testToken.right);
                existingBlankLines = endLineNum - startLineNum;
                if (!CodeFormatterVisitor.isOffsetOnABlankLine(testToken.left, document) && --existingBlankLines < 0) {
                    existingBlankLines = 0;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return existingBlankLines;
    }

    private static boolean isOffsetOnABlankLine(int offset, IDocument document) {
        try {
            int lineNum = document.getLineOfOffset(offset);
            int lineStartingOffset = document.getLineOffset(lineNum);
            int lineLen = document.getLineLength(lineNum);
            int firstNonWhiteSpaceCharOffset = lineStartingOffset;
            boolean bFnd = false;
            int i = lineStartingOffset;
            while (i < lineStartingOffset + lineLen && !bFnd) {
                char ch = document.getChar(i);
                if (!CodeFormatterVisitor.isEGLSpaceCharacter(ch)) {
                    firstNonWhiteSpaceCharOffset = i;
                    bFnd = true;
                }
                ++i;
            }
            if (firstNonWhiteSpaceCharOffset == offset) {
                return true;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isEGLSpaceCharacter(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\f';
    }

    private void printSpace(Symbol prevToken, Symbol token, boolean isAddSpace, List edits) {
        int spaceInBetweenTokens = token.left - prevToken.right;
        if (isAddSpace) {
            if (spaceInBetweenTokens == 0) {
                edits.add(new InsertEdit(prevToken.right, SPACE));
                ++this.fCurrentColumn;
            } else if (spaceInBetweenTokens > 1) {
                edits.add(new ReplaceEdit(prevToken.right, spaceInBetweenTokens, SPACE));
                this.fCurrentColumn = this.fCurrentColumn + SPACE.length() - spaceInBetweenTokens;
            } else if (spaceInBetweenTokens == 1) {
                try {
                    char whiteSpaceChar = this.fDocument.getChar(prevToken.right);
                    if (whiteSpaceChar != ' ') {
                        edits.add(new ReplaceEdit(prevToken.right, 1, SPACE));
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        } else if (spaceInBetweenTokens > 0) {
            edits.add(new DeleteEdit(prevToken.right, spaceInBetweenTokens));
            this.fCurrentColumn -= spaceInBetweenTokens;
        }
    }

    private boolean printRemoveLineBreaks(Symbol prevToken, Symbol token, boolean addSpace, int wrappingPolicy, List edits) {
        if (prevToken.sym == 69 || prevToken.sym == 67) {
            int preserveBlankLines = this.getIntPrefSetting("blankLines.preservExisting");
            int existingBlankLines = CodeFormatterVisitor.getExistingBlankLines(prevToken, this.fDocument);
            if (existingBlankLines > 0 && preserveBlankLines > 0) {
                int numOfBlankLines = Math.min(existingBlankLines, preserveBlankLines);
                this.printFormatToken(prevToken, token, numOfBlankLines, addSpace, wrappingPolicy, edits);
                return false;
            }
            if (prevToken.sym == 67) {
                this.printFormatToken(prevToken, token, 0, addSpace, wrappingPolicy, edits);
                return false;
            }
            edits.add(new DeleteEdit(prevToken.left, prevToken.right - prevToken.left));
        }
        return true;
    }

    private Symbol nextToken() {
        Symbol nextToken = null;
        try {
            nextToken = this.fScanner.next_token();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nextToken;
    }

    private TextEdit getFinalEdits() {
        MultiTextEdit edit = new MultiTextEdit();
        int i = 0;
        try {
            for (TextEdit editElem : this.fEdits) {
                if (editElem.getExclusiveEnd() >= this.fFormatOffset && editElem.getInclusiveEnd() <= this.fFormatOffset + this.fFormatLength) {
                    edit.addChild(editElem);
                }
                ++i;
            }
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
            TextEdit childEdit = e.getChild();
            System.out.println("index is: " + i);
            System.out.println("cuasing child edit is: " + childEdit.toString());
            try {
                System.out.println("child edit text is: " + this.fDocument.get(childEdit.getOffset(), childEdit.getOffset() + childEdit.getLength()));
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
        return edit;
    }

    private static interface ICallBackFormatter {
        public void format(Symbol var1, Symbol var2);
    }

    private class PendingWrapEdit {
        List fNoWrapEdits;
        int fNoWrapColumn;
        List fWrapEdits;
        int fWrapColumn;

        public PendingWrapEdit(List noWrapEdits, int noWrapCol, List wrapEdits, int wrapCol) {
            this.fNoWrapEdits = noWrapEdits;
            this.fNoWrapColumn = noWrapCol;
            this.fWrapEdits = wrapEdits;
            this.fWrapColumn = wrapCol;
        }
    }
}

