/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.services.wizards;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.edt.ide.ui.wizards.InterfaceListConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class ServiceConfiguration
extends InterfaceListConfiguration {
    private String serviceName;
    private Hashtable<String, IPart> calledPgms;
    private Hashtable calledProgramPgmHash;
    private String originalProgramPackage;
    private boolean genAsWebService;
    private boolean genAsRestService;
    private List superInterfaces;
    private ETemplateType templateType;

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setDefaultAttributes();
    }

    public List getSuperInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public void setFileName(String string) {
        super.setFileName(string);
        this.setServiceName(string);
    }

    public void setSuperInterfaces(List superInterfaces) {
        this.superInterfaces = superInterfaces;
    }

    public String initBasedOnSelectedProgram(IWorkbench workbench, IStructuredSelection selection) {
        this.init(workbench, selection);
        String FQPgmName = "";
        IEGLFile programFile = null;
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof IFile) {
            IEGLElement eglElem = EGLCore.create((IFile)((IFile)selectedElement));
            if (eglElem instanceof IEGLFile) {
                programFile = (IEGLFile)eglElem;
            }
        } else if (selectedElement instanceof IEGLFile) {
            programFile = (IEGLFile)selectedElement;
        }
        if (programFile != null) {
            IEGLElement parentElem = programFile.getParent();
            this.originalProgramPackage = parentElem.getElementName();
            this.setFPackage(this.originalProgramPackage);
            String fileName = programFile.getElementName();
            int dot = fileName.indexOf(46);
            fileName = fileName.substring(0, dot);
            this.setFileName(String.valueOf(fileName) + "CallService");
            this.setServiceName(this.getFileName());
            FQPgmName = this.originalProgramPackage;
            if (this.originalProgramPackage.length() > 0) {
                FQPgmName = String.valueOf(FQPgmName) + '.';
            }
            FQPgmName = String.valueOf(FQPgmName) + fileName;
            IPart programPart = programFile.getPart(fileName);
            this.calledPgms.put(FQPgmName, programPart);
            try {
                File fileast = EGLModelUtility.getEGLFileAST(programFile, EGLUI.getBufferFactory());
                final String FQPgmNameCopy = FQPgmName;
                fileast.accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(File file) {
                        return true;
                    }

                    public boolean visit(Program program) {
                        ServiceConfiguration.this.calledProgramPgmHash.put(FQPgmNameCopy, program);
                        return false;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return FQPgmName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    private void setDefaultAttributes() {
        this.serviceName = "";
        this.calledPgms = new Hashtable();
        this.superInterfaces = new ArrayList();
        this.calledProgramPgmHash = new Hashtable();
        this.genAsWebService = false;
        this.genAsRestService = false;
    }

    public IPart getCalledBasicPgm(String pgmFullyQualifiedName) {
        return this.calledPgms.get(pgmFullyQualifiedName);
    }

    public Program getBoundCalledBasicProgramPgm(String pgmFullyQualifiedName) {
        IPart pgmPart = this.calledPgms.get(pgmFullyQualifiedName);
        IEGLFile eglfile = (IEGLFile)pgmPart.getParent();
        return (Program)ServiceConfiguration.getBoundPart(eglfile, pgmPart.getElementName());
    }

    public BinaryPart getBinaryCalledBasicProgramPgm(String pgmFullyQualifiedName) {
        return (BinaryPart)this.calledProgramPgmHash.get(pgmFullyQualifiedName);
    }

    public void addCalledBasicPgm(String pgmFullyQualifiedName, IPart pgmPart, Program pgmProgramPart) {
        this.calledPgms.put(pgmFullyQualifiedName, pgmPart);
        this.calledProgramPgmHash.put(pgmFullyQualifiedName, pgmProgramPart);
    }

    public void addCalledBasicPgm(String pgmFullyQualifiedName, IPart pgmPart, BinaryPart pgmProgramPart) {
        this.calledPgms.put(pgmFullyQualifiedName, pgmPart);
        this.calledProgramPgmHash.put(pgmFullyQualifiedName, pgmProgramPart);
    }

    public boolean IsGenAsWebService() {
        return this.genAsWebService;
    }

    public void setGenAsWebService(boolean genAsWS) {
        this.genAsWebService = genAsWS;
    }

    public boolean isGenAsRestService() {
        return this.genAsRestService;
    }

    public void setGenAsRestService(boolean genAsRest) {
        this.genAsRestService = genAsRest;
    }

    public ETemplateType getTemplateType() {
        return this.templateType;
    }

    public void setTemplateTypeByTemplateID(String templateID) {
        if (templateID.equals("org.eclipse.edt.ide.ui.service.basic")) {
            this.templateType = ETemplateType.BASIC;
        } else if (templateID.equals("org.eclipse.edt.ide.ui.service.dataaccess")) {
            this.templateType = ETemplateType.DATA_ACCESS;
        }
    }

    public static enum ETemplateType {
        BASIC,
        DATA_ACCESS;

    }
}

