/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.IsAExpression;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.ReturnStatement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class TypeTemplate
extends JavaScriptTemplate {
    public void preGen(Type type, Context ctx) {
    }

    public Boolean isAssignmentArrayMatchingWanted(Type type, Context ctx) {
        return true;
    }

    public Boolean isAssignmentBreakupWanted(Type type, Context ctx, Assignment expr) {
        if (expr.getOperator().equals("**=") || expr.getOperator().equals("?:=") || expr.getOperator().equals("::=")) {
            return true;
        }
        return false;
    }

    public Boolean isListReorganizationWanted(Type type, Context ctx, Expression expr) {
        return true;
    }

    public Boolean isMathLibDecimalBoxingWanted(Type type, Context ctx) {
        return true;
    }

    public Boolean isStringLibFormatBoxingWanted(Type type, Context ctx) {
        return true;
    }

    public void genInstantiation(Type type, Context ctx, TabbedWriter out) {
        out.print("new ");
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptImplementation});
        out.print("(");
        ctx.invoke("genConstructorOptions", type, new Object[]{ctx, out});
        out.print(")");
    }

    public void genInstantiation(Type type, Context ctx, TabbedWriter out, Field arg) {
        ctx.invoke("genInstantiation", type, new Object[]{ctx, out});
    }

    public void genInvocation(Type type, Context ctx, TabbedWriter out, InvocationExpression arg) {
        ctx.invoke("genInvocation", (EObject)arg, new Object[]{ctx, out});
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out, TypedElement arg) {
        if (arg.isNullable()) {
            out.print("null");
        } else {
            ctx.invoke("genDefaultValue", type, new Object[]{ctx, out});
        }
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out, Expression arg) {
        if (arg.isNullable()) {
            out.print("null");
        } else {
            ctx.invoke("genDefaultValue", type, new Object[]{ctx, out});
        }
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out) {
        if (TypeUtils.isReferenceType((Type)type)) {
            ctx.invoke("genInstantiation", type, new Object[]{ctx, out});
        } else {
            out.print("\"Invalid default value\"");
        }
    }

    public void genRuntimeTypeName(Type type, Context ctx, TabbedWriter out) {
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptPrimitive});
    }

    public void genRuntimeTypeName(Type type, Context ctx, TabbedWriter out, JavaScriptTemplate.TypeNameKind arg) {
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptPrimitive && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            out.print(ctx.getPrimitiveMapping((Type)type.getClassifier()));
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptObject && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            String item = ctx.getPrimitiveMapping((Type)type.getClassifier());
            if (ctx.getPrimitiveMapping(item) == null) {
                out.print(item);
            } else {
                out.print(ctx.getPrimitiveMapping(item));
            }
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptImplementation && ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            String item = ctx.getPrimitiveMapping((Type)type.getClassifier());
            if (ctx.getPrimitiveMapping(item) == null) {
                out.print(item);
            } else {
                out.print(ctx.getPrimitiveMapping(item));
            }
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.EGLImplementation && ctx.mapsToNativeType((Type)type.getClassifier())) {
            out.print(ctx.getNativeImplementationMapping((Type)type.getClassifier()));
            return;
        }
        if (arg == JavaScriptTemplate.TypeNameKind.JavascriptImplementation) {
            out.print(ctx.getNativeImplementationMapping((Type)type.getClassifier()));
        } else {
            out.print(ctx.getNativeInterfaceMapping((Type)type.getClassifier()));
        }
    }

    public void genConstructorOptions(Type type, Context ctx, TabbedWriter out) {
    }

    public void genTypeDependentOptions(Type type, Context ctx, TabbedWriter out, AsExpression arg) {
        ctx.invoke("genTypeDependentOptions", type, new Object[]{ctx, out});
    }

    public void genTypeDependentOptions(Type type, Context ctx, TabbedWriter out) {
    }

    public void genTypeDependentPatterns(Type type, Context ctx, TabbedWriter out) {
    }

    public void genInitializeStatement(Type type, Context ctx, TabbedWriter out, Field arg) {
        if (arg.getInitializerStatements() != null) {
            ctx.invoke("genStatementNoBraces", (EObject)arg.getInitializerStatements(), new Object[]{ctx, out});
        }
    }

    public void genAssignment(Type type, Context ctx, TabbedWriter out, Expression arg1, Expression arg2, String arg3) {
        if (!arg1.isNullable() && arg2.isNullable()) {
            ctx.invoke("genExpression", (EObject)arg1, new Object[]{ctx, out});
            out.print(arg3);
            out.print("egl.checkNull(");
            ctx.invoke("genExpression", (EObject)arg2, new Object[]{ctx, out});
            out.print(")");
        } else {
            ctx.invoke("genExpression", (EObject)arg1, new Object[]{ctx, out});
            out.print(arg3);
            ctx.putAttribute((Object)arg2, "recordToAnyAssignment", (Object)true);
            ctx.invoke("genTypeBasedExpression", (EObject)arg2, new Object[]{ctx, out, arg1.getType()});
            ctx.putAttribute((Object)arg2, "recordToAnyAssignment", (Object)false);
        }
    }

    public void genConversionOperation(Type type, Context ctx, TabbedWriter out, AsExpression arg) {
        if (arg.getConversionOperation() != null) {
            Operation op = arg.getConversionOperation();
            out.print("egl.eglx.lang.convert(");
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)((Classifier)op.getContainer()))) + '.');
            out.print(CommonUtilities.getOpName((Context)ctx, (Operation)op));
            out.print(", [");
            Expression objectExpr = arg.getObjectExpr();
            if (objectExpr instanceof BoxingExpression) {
                objectExpr = ((BoxingExpression)objectExpr).getExpr();
            }
            ctx.invoke("genExpression", (EObject)objectExpr, new Object[]{ctx, out});
            if (objectExpr.getType() instanceof Record && ctx.getAttribute((Object)arg, "function parameter is const in") == null) {
                out.print(".eze$$clone()");
            }
            ctx.invoke("genTypeDependentPatterns", arg.getObjectExpr().getType(), new Object[]{ctx, out});
            String typeSignature = arg.getObjectExpr().getType().getClassifier().getTypeSignature();
            if ("asAny".equalsIgnoreCase(op.getCaseSensitiveName())) {
                out.print(",\"");
                ctx.put((Object)"isaSignature", (Object)"true");
                ctx.invoke("genSignature", arg.getObjectExpr().getType(), new Object[]{ctx, out, arg});
                ctx.remove((Object)"isaSignature");
                out.print("\"");
            } else if (ctx.getPrimitiveMapping(typeSignature) == null && !"eglx.lang.ENumber".equalsIgnoreCase(typeSignature) || "eglx.lang.EDecimal".equalsIgnoreCase(typeSignature)) {
                out.print(",\"");
                ctx.invoke("genSignature", arg.getObjectExpr().getType(), new Object[]{ctx, out, arg});
                out.print("\"");
            }
            ctx.invoke("genTypeDependentOptions", arg.getEType(), new Object[]{ctx, out, arg});
            out.print("])");
        } else if (ctx.mapsToPrimitiveType(arg.getEType())) {
            ctx.invoke("genRuntimeTypeName", arg.getEType(), new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.EGLImplementation});
            out.print(".ezeCast(");
            if (arg.getObjectExpr().getType() != TypeUtils.Type_ANY) {
                BoxingExpression boxingExpr = IrFactory.INSTANCE.createBoxingExpression();
                boxingExpr.setExpr(arg.getObjectExpr());
                ctx.invoke("genExpression", (EObject)boxingExpr, new Object[]{ctx, out});
            } else {
                ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
            }
            out.print(", ");
            out.print(arg.getObjectExpr().isNullable());
            ctx.invoke("genTypeDependentOptions", arg.getEType(), new Object[]{ctx, out, arg});
            out.print(")");
        } else {
            if (arg.getType() != TypeUtils.Type_ANY) {
                out.print("egl.eglx.lang.EAny.ezeCast(");
            }
            if (arg.getObjectExpr().getType() != TypeUtils.Type_ANY) {
                BoxingExpression boxingExpr = IrFactory.INSTANCE.createBoxingExpression();
                boxingExpr.setExpr(arg.getObjectExpr());
                ctx.invoke("genExpression", (EObject)boxingExpr, new Object[]{ctx, out});
            } else {
                ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
            }
            if (arg.getType() != TypeUtils.Type_ANY) {
                out.print(", ");
                ctx.invoke("genRuntimeTypeName", arg.getEType(), new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptImplementation});
                out.print(")");
            }
        }
    }

    public void genTypeBasedAssignment(Type type, Context ctx, TabbedWriter out, Assignment arg) {
        String operator = "=";
        if (arg.getOperator() != null && arg.getOperator().length() > 0) {
            operator = arg.getOperator();
        }
        if (operator != null && operator.length() > 1 && operator.endsWith("=")) {
            String op = operator.substring(0, operator.length() - 1);
            BinaryExpression binExpr = IrFactory.INSTANCE.createBinaryExpression();
            binExpr.setLHS((Expression)arg.getLHS());
            binExpr.setOperator(op);
            binExpr.setRHS(arg.getRHS());
            ctx.invoke("genAssignment", (EObject)arg.getLHS(), new Object[]{ctx, out, binExpr, " = "});
        } else {
            ctx.invoke("genAssignment", (EObject)arg.getLHS(), new Object[]{ctx, out, arg.getRHS(), " " + CommonUtilities.getNativeJavaScriptAssignment((String)operator) + " "});
        }
    }

    public void genReturnStatement(Type type, Context ctx, TabbedWriter out, ReturnStatement arg) {
        ctx.invoke("genReturnStatement", (EObject)arg, new Object[]{ctx, out});
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) throws GenerationException {
        if (arg.getLHS().isNullable() || arg.getRHS().isNullable() || arg.getLHS() instanceof ArrayAccess || arg.getRHS() instanceof ArrayAccess || CommonUtilities.getNativeJavaScriptOperation((BinaryExpression)arg, (Context)ctx).length() == 0) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)arg.getOperation().getContainer())) + '.');
            out.print(CommonUtilities.getNativeRuntimeOperationName((BinaryExpression)arg));
            out.print("(");
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out, arg.getOperation().getParameters().get(0)});
            out.print(", ");
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out, arg.getOperation().getParameters().get(1)});
            out.print(")" + CommonUtilities.getNativeRuntimeComparisionOperation((BinaryExpression)arg));
        } else {
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
            out.print(CommonUtilities.getNativeJavaScriptOperation((BinaryExpression)arg, (Context)ctx));
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
        }
    }

    public void genUnaryExpression(Type type, Context ctx, TabbedWriter out, UnaryExpression arg) throws GenerationException {
        if (arg.getExpression().isNullable()) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)arg.getOperation().getContainer())) + ".");
            out.print(CommonUtilities.getNativeRuntimeOperationName((UnaryExpression)arg));
            out.print("(");
            ctx.invoke("genExpression", (EObject)arg.getExpression(), new Object[]{ctx, out, arg.getOperation().getParameters().get(0)});
            out.print(")");
        } else if (arg.getOperator().equals("-") || arg.getOperator().equals("!") || arg.getOperator().equals("~")) {
            out.print(String.valueOf(arg.getOperator()) + "(");
            ctx.invoke("genExpression", (EObject)arg.getExpression(), new Object[]{ctx, out});
            out.print(")");
        } else {
            ctx.invoke("genExpression", (EObject)arg.getExpression(), new Object[]{ctx, out});
        }
    }

    public void genIsaExpression(Type type, Context ctx, TabbedWriter out, IsAExpression arg) {
        Expression lhs = arg.getObjectExpr();
        Type lhsType = lhs.getType();
        Type isaType = arg.getEType();
        String lhsTypeSig = lhsType.getTypeSignature();
        String isaTypeSig = isaType.getTypeSignature();
        if (lhsTypeSig.equals("eglx.lang.AnyException") && isaType instanceof NamedElement || isaType instanceof ExternalType) {
            out.print("(");
            ctx.invoke("genExpression", (EObject)lhs, new Object[]{ctx, out});
            out.print(" instanceof ");
            ctx.invoke("genRuntimeTypeName", isaType, new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptObject});
            out.print(")");
        } else if (lhsTypeSig.equalsIgnoreCase(isaTypeSig)) {
            if (lhs.isNullable()) {
                out.print("(");
                ctx.invoke("genExpression", (EObject)lhs, new Object[]{ctx, out});
                out.print(" == null ? false : true)");
            } else {
                out.print("true");
            }
        } else if (lhsType.getClassifier() != null && lhsType.getClassifier().getTypeSignature().equalsIgnoreCase(isaTypeSig)) {
            if (lhs.isNullable()) {
                out.print("(");
                ctx.invoke("genExpression", (EObject)lhs, new Object[]{ctx, out});
                out.print(" == null ? false : true)");
            } else {
                out.print("true");
            }
        } else if (lhsType.getClassifier() != null && isaType.getClassifier() != null && lhsType.getClassifier().getTypeSignature().equalsIgnoreCase(isaType.getClassifier().getTypeSignature())) {
            out.print("false");
        } else if (lhs instanceof IntegerLiteral) {
            out.print(lhsTypeSig.equalsIgnoreCase(isaTypeSig) ? "true" : "false");
        } else if (ctx.mapsToPrimitiveType(lhs.getType())) {
            out.print("egl.isa(");
            ctx.invoke("genExpression", (EObject)lhs, new Object[]{ctx, out});
            out.print(", ");
            out.print("\"");
            ctx.put((Object)"isaSignature", (Object)"true");
            ctx.invoke("genSignature", isaType, new Object[]{ctx, out});
            ctx.remove((Object)"isaSignature");
            out.print("\", \"");
            ctx.invoke("genSignature", lhsType, new Object[]{ctx, out});
            out.print("\"");
            out.print(")");
        } else {
            out.print("egl.isa(");
            ctx.invoke("genExpression", (EObject)lhs, new Object[]{ctx, out});
            out.print(", ");
            out.print("\"");
            ctx.put((Object)"isaSignature", (Object)"true");
            ctx.invoke("genSignature", isaType, new Object[]{ctx, out});
            ctx.remove((Object)"isaSignature");
            out.print("\"");
            out.print(")");
        }
    }

    public void genSignature(Type type, Context ctx, TabbedWriter out, TypedElement arg) {
        ctx.invoke("genSignature", type, new Object[]{ctx, out});
    }

    public void genSignature(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genSignature", type, new Object[]{ctx, out});
    }

    public void genSignature(Type type, Context ctx, TabbedWriter out) {
        if (ctx.get((Object)"isaSignature") != null) {
            out.print("T");
            out.print(type.getTypeSignature().replaceAll("\\.", "/"));
            out.print(";");
        } else {
            out.print(type.getTypeSignature());
        }
    }

    public void genContainerBasedAccessor(Type type, Context ctx, TabbedWriter out, Function arg) {
    }

    public void genContainerBasedAssignment(Type type, Context ctx, TabbedWriter out, Assignment arg1, Field arg2) {
        ctx.invoke("genAssignment", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedArrayAccess(Type type, Context ctx, TabbedWriter out, ArrayAccess arg1, Field arg2) {
        ctx.invoke("genArrayAccess", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedMemberAccess(Type type, Context ctx, TabbedWriter out, MemberAccess arg1, Member arg2) {
        ctx.invoke("genMemberAccess", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedMemberName(Type type, Context ctx, TabbedWriter out, MemberName arg1, Member arg2) {
        ctx.invoke("genMemberName", (EObject)arg1, new Object[]{ctx, out});
    }

    public void genContainerBasedNewExpression(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genNewExpression", (EObject)arg, new Object[]{ctx, out});
    }

    public void genContainerBasedInvocation(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genInvocation", (EObject)arg, new Object[]{ctx, out});
    }

    public void genFieldInfoTypeName(Type type, Context ctx, TabbedWriter out, JavaScriptTemplate.TypeNameKind arg) {
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, arg});
    }

    public void genCloneMethod(Type type, Context ctx, TabbedWriter out) {
    }

    public Boolean supportsConversion(Type type, Context ctx) {
        return Boolean.TRUE;
    }

    public void genServiceInvocationInParam(Type type, Context ctx, TabbedWriter out, Expression arg) {
        ctx.invoke("genExpression", (EObject)arg, new Object[]{ctx, out});
    }

    public void genServiceCallbackArgType(Type type, Context ctx, TabbedWriter out) {
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.EGLImplementation});
    }
}

