/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.Context;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue;
import org.eclipse.edt.compiler.internal.core.builder.CappedProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2Mof;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.builder.BuilderResources;
import org.eclipse.edt.ide.core.internal.builder.IProcessorRequestor;
import org.eclipse.edt.ide.core.internal.builder.MarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.compiler.Compiler;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraphManager;
import org.eclipse.edt.ide.core.internal.dependency.DependencyInfo;
import org.eclipse.edt.ide.core.internal.generation.IDEContext;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractProcessingQueue
extends org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue {
    protected ProjectInfo projectInfo;
    private static final int MAX_COMPILE_LOOP = 5;
    private IProject project;
    private ProjectEnvironment projectEnvironment;
    private IProcessorRequestor requestor;

    public AbstractProcessingQueue(IProject project, IBuildNotifier notifier) {
        super(notifier, DefaultCompilerOptions.getInstance());
        this.project = project;
        this.projectInfo = ProjectInfoManager.getInstance().getProjectInfo(project);
        this.projectEnvironment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
    }

    protected boolean hasExceededMaxLoop() {
        return this.compileLoop >= 5;
    }

    protected IPartBinding level03Compile(String packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedString = NameUtile.getAsName((String)caseSensitiveInternedPartName);
        String qualifiedName = this.getQualifiedName(packageName, caseInsensitiveInternedString);
        this.notifier.subTask(NLS.bind((String)BuilderResources.buildCompiling, (Object)qualifiedName));
        IFile declaringFile = this.projectInfo.getPartOrigin(packageName, caseInsensitiveInternedString).getEGLFile();
        Node partAST = ASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedString);
        IPartBinding binding = new BindingCreator((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding();
        binding.setEnvironment((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment);
        DependencyInfo dependencyInfo = new DependencyInfo();
        Scope scope = this.createScope(packageName, declaringFile, binding, dependencyInfo);
        CappedProblemRequestor cappedProblemRequestor = new CappedProblemRequestor();
        cappedProblemRequestor.setRequestor((IProblemRequestor)new MarkerProblemRequestor(declaringFile, caseInsensitiveInternedString));
        Compiler.getInstance().compilePart(partAST, binding, scope, dependencyInfo, (IProblemRequestor)cappedProblemRequestor, this.compilerOptions);
        if (binding.getKind() == 16) {
            this.validatePackageDeclaration(packageName, declaringFile, partAST, (FileBinding)binding, (IProblemRequestor)cappedProblemRequestor);
        }
        if (binding.getKind() != 16) {
            this.processCompiledPart(packageName, caseInsensitiveInternedString, qualifiedName, (Part)partAST, binding, declaringFile, dependencyInfo, cappedProblemRequestor);
        } else {
            this.processCompiledFilePart(packageName, caseInsensitiveInternedString, declaringFile);
        }
        DependencyGraphManager.getInstance().getDependencyGraph(this.project).putPart(packageName, caseInsensitiveInternedString, Util.getFilePartName(declaringFile), dependencyInfo);
        return binding;
    }

    private void processCompiledFilePart(String packageName, String caseInsensitiveInternedString, IFile declaringFile) {
        IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(this.project, declaringFile.getProjectRelativePath());
        for (String nextName : fileInfo.getPartNames()) {
            if (NameUtile.equals((String)nextName, (String)caseInsensitiveInternedString)) continue;
            this.addPartFromCompiledFile(packageName, fileInfo.getCaseSensitivePartName(nextName));
        }
    }

    private void processCompiledPart(String packageName, String caseInsensitiveInternedString, String qualifiedName, Part partAST, IPartBinding binding, IFile declaringFile, DependencyInfo dependencyInfo, CappedProblemRequestor cappedProblemRequestor) {
        MofSerializable previousPart;
        this.notifier.subTask(NLS.bind((String)BuilderResources.buildCreatingIR, (Object)qualifiedName));
        File fileAST = ASTManager.getInstance().getFileAST(declaringFile);
        try {
            org.eclipse.edt.mof.egl.Part eobj = ProjectEnvironmentManager.getInstance().getProjectEnvironment(this.project).findPart(packageName, caseInsensitiveInternedString);
            previousPart = eobj instanceof MofSerializable ? (MofSerializable)eobj : null;
        }
        catch (Exception exception) {
            previousPart = null;
        }
        try {
            MofSerializable part = this.createIRFromBoundAST(partAST, declaringFile, fileAST.getImportDeclarations(), (IProblemRequestor)cappedProblemRequestor);
            if (previousPart == null || !TypeUtils.areStructurallyEquivalent((MofSerializable)previousPart, (MofSerializable)part)) {
                this.notifier.subTask(NLS.bind((String)BuilderResources.buildAddingDependentsOf, (Object)qualifiedName));
                if (previousPart != null) {
                    this.addDependents(packageName, caseInsensitiveInternedString);
                }
                if (this.requestor != null) {
                    this.requestor.recordStructuralChange(packageName, caseInsensitiveInternedString, binding.getKind());
                }
            }
            this.notifier.subTask(NLS.bind((String)BuilderResources.buildSavingIR, (Object)qualifiedName));
            if (this.canSave(caseInsensitiveInternedString)) {
                ProjectEnvironmentManager.getInstance().getProjectEnvironment(this.project).getIREnvironment().save(part, true);
            }
        }
        catch (RuntimeException e) {
            cappedProblemRequestor.acceptProblem((Node)partAST.getName(), 3000, new String[]{partAST.getName().getCanonicalName()});
            Compiler.getInstance().logIRCreationException(e);
        }
    }

    private MofSerializable createIRFromBoundAST(Part partAST, IFile declaringFile, List imports, IProblemRequestor problemRequestor) {
        ProjectIREnvironment env = ProjectEnvironmentManager.getInstance().getProjectEnvironment(this.project).getIREnvironment();
        Egl2Mof generator = new Egl2Mof((IEnvironment)env);
        return (MofSerializable)generator.convert(partAST, (Context)new IDEContext(declaringFile, this.projectEnvironment.getCompiler()), problemRequestor);
    }

    protected void addPartFromCompiledFile(String packageName, String partName) {
    }

    protected IPartBinding level02Compile(String packageName, String caseSensitiveInternedPartName) {
        return ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).compileLevel2Binding(packageName, caseSensitiveInternedPartName);
    }

    protected IPartBinding level01Compile(String packageName, String caseSensitiveInternedPartName) {
        return this.projectEnvironment.level01Compile(packageName, caseSensitiveInternedPartName);
    }

    protected IPartBinding getPartBindingFromCache(String packageName, String partName) {
        return ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).getPartBindingFromCache(packageName, partName);
    }

    protected String getQualifiedName(String packageName, String partName) {
        if (packageName.length() == 0 || new Path(partName).segmentCount() > 1) {
            return partName;
        }
        String retVal = String.valueOf(new Path(packageName).addTrailingSeparator().toString()) + partName;
        return retVal.replace('/', '.');
    }

    private Scope createScope(String packageName, IFile declaringFile, IPartBinding binding, DependencyInfo dependencyInfo) {
        EnvironmentScope scope;
        if (binding.getKind() == 16) {
            scope = new EnvironmentScope((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo);
        } else {
            String fileName = Util.getFilePartName(declaringFile);
            IPartBinding fileBinding = this.projectEnvironment.getPartBinding(packageName, fileName);
            scope = new FileScope((Scope)new EnvironmentScope((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)dependencyInfo);
        }
        return scope;
    }

    private void validatePackageDeclaration(String packageName, IFile declaringFile, Node partAST, FileBinding binding, IProblemRequestor problemRequestor) {
        try {
            IPackageBinding declaringPackage = binding.getDeclaringPackage();
            if (declaringPackage != null && !NameUtile.equals((String)declaringPackage.getPackageName(), (String)packageName)) {
                if (packageName.length() == 0) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else if (((File)partAST).hasPackageDeclaration()) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else {
                    IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                    packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - Util.qualifiedNameToStringArray(packageName).length);
                    problemRequestor.acceptProblem(0, 0, 2, 3064, new String[]{packagePath.toString().replace('/', '.')});
                }
            } else if (((File)partAST).hasPackageDeclaration()) {
                String packageDeclName = ((File)partAST).getPackageDeclaration().getName().getCanonicalName();
                IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                if (!packageDeclName.equals((packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - Util.qualifiedNameToStringArray(packageName).length)).toString().replace('/', ".".charAt(0)))) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, 2, new String[0]);
                }
            }
        }
        catch (RuntimeException e) {
            problemRequestor.acceptProblem(0, 0, 2, 3000, new String[]{binding.getName()});
            EDTCoreIDEPlugin.getPlugin().log("Part Validation Failure", e);
        }
    }

    protected abstract void addDependents(String var1, String var2);

    protected abstract void addDependents(String var1);

    public void setProcessorRequestor(IProcessorRequestor requestor) {
        this.requestor = requestor;
    }

    public void removePart(String packageName, String partName) {
        this.pendingUnits.remove(new AbstractProcessingQueue.ProcessingUnitKey((org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue)this, packageName, partName));
    }

    protected void doAddPart(String packageName, String caseInsensitiveInternedPartName) {
        this.addPart(packageName, this.projectInfo.getCaseSensitivePartName(packageName, caseInsensitiveInternedPartName));
    }
}

