/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.ide.core.internal.builder.AbstractProcessingQueue;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraph;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraphManager;
import org.eclipse.edt.ide.core.internal.dependency.IPartRequestor;

public class IncrementalProcessingQueue
extends AbstractProcessingQueue {
    private DependencyGraph dependencyGraph;

    public IncrementalProcessingQueue(IProject project, IBuildNotifier notifier) {
        super(project, notifier);
        this.dependencyGraph = DependencyGraphManager.getInstance().getDependencyGraph(project);
    }

    @Override
    public void addDependents(String packageName, String partName) {
        this.dependencyGraph.findDependents(packageName, partName, new IPartRequestor(){

            @Override
            public void acceptPart(String packageName, String partName) {
                IncrementalProcessingQueue.this.doAddPart(packageName, partName);
            }
        });
    }

    @Override
    protected void addDependents(String qualifiedName) {
        this.dependencyGraph.findDependents(qualifiedName, new IPartRequestor(){

            @Override
            public void acceptPart(String packageName, String partName) {
                IncrementalProcessingQueue.this.doAddPart(packageName, partName);
            }
        });
    }

    @Override
    protected void addPartFromCompiledFile(String packageName, String partName) {
        this.addPart(packageName, partName);
        super.addPartFromCompiledFile(packageName, partName);
    }
}

