/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler.workingcopy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.compiler.PartEnvironmentStack;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.ide.core.internal.builder.AbstractDuplicatePartManager;
import org.eclipse.edt.ide.core.internal.builder.workingcopy.WorkingCopyDuplicatePartManager;
import org.eclipse.edt.ide.core.internal.builder.workingcopy.WorkingCopyUnsavedDuplicatePartRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.CompiledFileUnit;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IProblemRequestorFactory;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.NullProblemRequestorFactory;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyASTManager;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyProcessingQueue;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoDifferencer;
import org.eclipse.edt.ide.core.internal.lookup.IASTFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfoDifferenceNotificationRequestor;
import org.eclipse.edt.ide.core.internal.lookup.ZipFileBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyBuildNotifier;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyCompilerResourceFileInfoCreator;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyFileInfoCreator;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyFileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.search.ICompiledFileUnit;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.utils.NameUtile;

public class WorkingCopyCompiler {
    private static final WorkingCopyCompiler INSTANCE = new WorkingCopyCompiler();
    public static final ILock lock = Job.getJobManager().newLock();

    private WorkingCopyCompiler() {
    }

    public static WorkingCopyCompiler getInstance() {
        return INSTANCE;
    }

    public synchronized void compilePart(IProject project, String packageName, IFile file, IWorkingCopy[] workingCopies, String partName, IWorkingCopyCompileRequestor requestor) {
        this.compilePart(project, packageName, file, workingCopies, partName, requestor, NullProblemRequestorFactory.getInstance());
    }

    public synchronized void compilePart(IProject project, String packageName, IFile file, IWorkingCopy[] workingCopies, String partName, IWorkingCopyCompileRequestor requestor, IProblemRequestorFactory problemRequestorFactory) {
        block12: {
            if (!WorkingCopyFileInfoManager.getInstance().hasValidState()) {
                return;
            }
            WorkingCopyProcessingQueue queue = null;
            try {
                IFile declaringFile;
                lock.acquire();
                this.initialize();
                this.processWorkingCopies(workingCopies, problemRequestorFactory);
                queue = new WorkingCopyProcessingQueue(project, problemRequestorFactory);
                WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
                String internedPackageName = NameUtile.getAsName((String)packageName);
                String internedPartName = NameUtile.getAsName((String)partName);
                if (1 == projectInfo.hasPart(internedPackageName, internedPartName) || !(declaringFile = projectInfo.getPartOrigin(internedPackageName, internedPartName).getEGLFile()).equals((Object)file)) break block12;
                try {
                    try {
                        queue.setCompileRequestor(requestor);
                        queue.addPart(internedPackageName, projectInfo.getCaseSensitivePartName(internedPackageName, internedPartName));
                        queue.process();
                    }
                    catch (CancelledException e) {
                        throw e;
                    }
                    catch (BuildException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                finally {
                    this.cleanup();
                }
            }
            finally {
                if (queue != null && queue.pushedEnvironment()) {
                    Environment.popEnv();
                    PartEnvironmentStack.popEnv();
                }
                lock.release();
            }
        }
    }

    public synchronized void compileAllParts(IProject project, String packageName, IFile file, IWorkingCopy[] workingCopies, IWorkingCopyCompileRequestor requestor) {
        this.compileAllParts(project, packageName, file, workingCopies, requestor, NullProblemRequestorFactory.getInstance());
    }

    public synchronized void compileAllParts(IProject project, String packageName, IFile file, IWorkingCopy[] workingCopies, IWorkingCopyCompileRequestor requestor, IProblemRequestorFactory problemRequestorFactory) {
        if (!WorkingCopyFileInfoManager.getInstance().hasValidState()) {
            return;
        }
        WorkingCopyProcessingQueue queue = null;
        try {
            lock.acquire();
            this.initialize();
            this.processWorkingCopies(workingCopies, problemRequestorFactory);
            this.processBinaryReadOnlyFile(file, packageName, problemRequestorFactory);
            queue = new WorkingCopyProcessingQueue(project, problemRequestorFactory);
            WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
            try {
                try {
                    String internedPackageName = NameUtile.getAsName((String)packageName);
                    if (projectInfo.hasPackage(internedPackageName)) {
                        IFileInfo fileInfo = WorkingCopyFileInfoManager.getInstance().getFileInfo(project, file.getProjectRelativePath());
                        for (String partName : fileInfo.getPartNames()) {
                            IFile declaringFile = projectInfo.getPartOrigin(internedPackageName, partName).getEGLFile();
                            if (!declaringFile.equals((Object)file)) continue;
                            queue.addPart(internedPackageName, fileInfo.getCaseSensitivePartName(partName));
                        }
                        queue.setCompileRequestor(requestor);
                        queue.process();
                    }
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            finally {
                this.cleanup();
            }
        }
        finally {
            if (queue != null && queue.pushedEnvironment()) {
                Environment.popEnv();
                PartEnvironmentStack.popEnv();
            }
            lock.release();
        }
    }

    public synchronized ICompiledFileUnit compileGenPart(IFile file) {
        return this.compileFiles(new IFile[]{file}, true);
    }

    public synchronized ICompiledFileUnit compileFile(IFile file) {
        return this.compileFiles(new IFile[]{file});
    }

    protected synchronized ICompiledFileUnit compileFiles(IFile[] files, boolean compileGeneratable) {
        final CompiledFileUnit searchTarget = new CompiledFileUnit();
        if (WorkingCopyFileInfoManager.getInstance().hasValidState()) {
            try {
                lock.acquire();
                this.initialize();
                WorkingCopyASTManager.getInstance().setPartASTRequestor(searchTarget);
                try {
                    try {
                        int i = 0;
                        while (i < files.length) {
                            final IFile file = files[i];
                            IEGLFile eglFile = (IEGLFile)EGLCore.create(file);
                            if (eglFile != null && eglFile.exists()) {
                                IProject project = file.getProject();
                                WorkingCopyProcessingQueue queue = null;
                                try {
                                    queue = new WorkingCopyProcessingQueue(project, NullProblemRequestorFactory.getInstance());
                                    WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
                                    File fileAST = null;
                                    fileAST = WorkingCopyASTManager.getInstance().getFileAST(file);
                                    searchTarget.setFileAST(fileAST);
                                    String internedPackageName = NameUtile.getAsName((String)Util.stringArrayToQualifiedName(((EGLFile)eglFile).getPackageName()));
                                    if (projectInfo.hasPackage(internedPackageName)) {
                                        for (Part part : fileAST.getParts()) {
                                            IFile declaringFile;
                                            IPartOrigin partOrigin = projectInfo.getPartOrigin(internedPackageName, part.getIdentifier());
                                            if (partOrigin == null || !(declaringFile = partOrigin.getEGLFile()).equals((Object)file)) continue;
                                            if (searchTarget.getFileBinding() == null) {
                                                String fileName = Util.getFilePartName(declaringFile);
                                                IPartBinding fileBinding = WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment(project).getPartBinding(internedPackageName, fileName);
                                                searchTarget.setFileBinding((FileBinding)fileBinding);
                                            }
                                            if (compileGeneratable) {
                                                if (!(part instanceof Program) && !(part instanceof Library) && !(part instanceof Handler) && !(part instanceof Service)) continue;
                                                queue.addPart(internedPackageName, part.getName().getCaseSensitiveIdentifier());
                                                break;
                                            }
                                            queue.addPart(internedPackageName, part.getName().getCaseSensitiveIdentifier());
                                        }
                                        queue.setCompileRequestor(new IWorkingCopyCompileRequestor(){

                                            @Override
                                            public void acceptResult(WorkingCopyCompilationResult result) {
                                                if (result.getDeclaringFile().equals((Object)file)) {
                                                    Part part = (Part)result.getBoundPart();
                                                    searchTarget.addBoundPart(result.getDeclaringFile(), part);
                                                }
                                            }
                                        });
                                        queue.process();
                                    }
                                }
                                finally {
                                    if (queue != null && queue.pushedEnvironment()) {
                                        Environment.popEnv();
                                        PartEnvironmentStack.popEnv();
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    catch (CancelledException e) {
                        throw e;
                    }
                    catch (BuildException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                finally {
                    this.cleanup();
                }
            }
            finally {
                lock.release();
            }
        }
        searchTarget.indexASTs();
        return searchTarget;
    }

    public synchronized ICompiledFileUnit compileFiles(IFile[] files) {
        return this.compileFiles(files, false);
    }

    private void initialize() {
        WorkingCopyProjectEnvironmentManager.getInstance().initialize();
    }

    private void cleanup() {
        ZipFileBuildPathEntryManager.getWCCInstance().clear();
        WorkingCopyProjectBuildPathManager.getInstance().clear();
        WorkingCopyProjectEnvironmentManager.getInstance().clear();
        WorkingCopyProjectBuildPathEntryManager.getInstance().clear();
        WorkingCopyProjectInfoManager.getInstance().resetWorkingCopies();
        WorkingCopyASTManager.getInstance().resetWorkingCopies();
        WorkingCopyFileInfoManager.getInstance().resetWorkingCopies();
        WorkingCopyDuplicatePartManager.getInstance().clearUnsavedDuplicateParts();
        WorkingCopyBuildNotifier.getInstance().setCanceled(false);
    }

    private void processWorkingCopies(IWorkingCopy[] workingCopies, IProblemRequestorFactory problemRequestorFactory) {
        int i = 0;
        while (i < workingCopies.length) {
            IWorkingCopy copy = workingCopies[i];
            if (((IEGLElement)((Object)copy)).exists()) {
                IProject project = (IProject)copy.getOriginalElement().getEGLProject().getResource();
                String packageName = NameUtile.getAsName((String)Util.stringArrayToQualifiedName(((EGLFile)copy.getOriginalElement()).getPackageName()));
                this.addWorkingCopy(project, packageName, copy, problemRequestorFactory);
            }
            ++i;
        }
    }

    private void processBinaryReadOnlyFile(IFile file, String packageName, IProblemRequestorFactory problemRequestorFactory) {
        if ("eglar".equalsIgnoreCase(file.getFullPath().getFileExtension())) {
            String packageNames = NameUtile.getAsName((String)packageName);
            this.addFileInfoForBinaryReadOnlyFile(file.getProject(), file, packageNames, problemRequestorFactory);
        }
    }

    private void addFileInfoForBinaryReadOnlyFile(IProject project, IFile file, String packageName, IProblemRequestorFactory problemRequestorFactory) {
        File fileAST = WorkingCopyASTManager.getInstance().getFileAST(file);
        WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
        IASTFileInfo newFileInfo = new WorkingCopyFileInfoCreator(project, packageName, file, null, fileAST, new WorkingCopyUnsavedDuplicatePartRequestor(project, packageName, file)).getASTInfo();
        newFileInfo.accept(problemRequestorFactory.getFileProblemRequestor(file));
        fileAST.accept(problemRequestorFactory.getSyntaxErrorRequestor(file));
        Set partNames = newFileInfo.getPartNames();
        for (String partName : partNames) {
            projectInfo.workingCopyPartAdded(packageName, partName, newFileInfo.getPartType(partName), file, newFileInfo.getCaseSensitivePartName(partName));
        }
        WorkingCopyFileInfoManager.getInstance().addFileInfo(project, file.getProjectRelativePath(), newFileInfo);
    }

    private void processDuplicateFiles(Set duplicateFilesToProcess, IProblemRequestorFactory problemRequestorFactory) {
        block2: for (DupeFileinfo dupeFileInfo : duplicateFilesToProcess) {
            WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(dupeFileInfo.project);
            try {
                String fileContents = Util.getFileContents(dupeFileInfo.file);
                File fileAST = WorkingCopyASTManager.getInstance().getFileAST(dupeFileInfo.file, fileContents);
                IASTFileInfo fileInfo = new WorkingCopyCompilerResourceFileInfoCreator(projectInfo, dupeFileInfo.packageName, dupeFileInfo.file, fileAST, fileContents, new WorkingCopyUnsavedDuplicatePartRequestor(dupeFileInfo.project, dupeFileInfo.packageName, dupeFileInfo.file), false).getASTInfo();
                if (fileInfo == null) continue;
                Set partNames = fileInfo.getPartNames();
                for (String thisPartName : partNames) {
                    if (!thisPartName.equalsIgnoreCase(dupeFileInfo.partName)) continue;
                    projectInfo.workingCopyPartAdded(dupeFileInfo.packageName, dupeFileInfo.partName, fileInfo.getPartType(dupeFileInfo.partName), dupeFileInfo.file, fileInfo.getCaseSensitivePartName(thisPartName));
                    continue block2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error adding file: " + dupeFileInfo.file.getProjectRelativePath(), e);
            }
        }
    }

    private void addWorkingCopy(final IProject project, final String packageName, IWorkingCopy copy, IProblemRequestorFactory problemRequestorFactory) {
        final HashSet duplicateFilesToProcess = new HashSet();
        final IEGLFile eglFile = (IEGLFile)copy.getOriginalElement();
        try {
            copy.reconcile(true, null);
        }
        catch (EGLModelException eGLModelException) {}
        File fileAST = WorkingCopyASTManager.getInstance().getFileAST(copy);
        final WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
        final IASTFileInfo newFileInfo = new WorkingCopyFileInfoCreator(project, packageName, (IFile)eglFile.getResource(), copy, fileAST, new WorkingCopyUnsavedDuplicatePartRequestor(project, packageName, (IFile)eglFile.getResource())).getASTInfo();
        final IFileInfo cachedFileInfo = WorkingCopyFileInfoManager.getInstance().getFileInfo(project, eglFile.getResource().getProjectRelativePath());
        newFileInfo.accept(problemRequestorFactory.getFileProblemRequestor((IFile)eglFile.getResource()));
        fileAST.accept(problemRequestorFactory.getSyntaxErrorRequestor((IFile)eglFile.getResource()));
        if (cachedFileInfo != null) {
            FileInfoDifferencer differencer = new FileInfoDifferencer(new IFileInfoDifferenceNotificationRequestor(){

                @Override
                public void partAdded(String partName) {
                    projectInfo.workingCopyPartAdded(packageName, partName, newFileInfo.getPartType(partName), (IFile)eglFile.getResource(), newFileInfo.getCaseSensitivePartName(partName));
                }

                @Override
                public void partRemoved(String partName) {
                    projectInfo.workingCopyPartRemoved(packageName, partName, cachedFileInfo.getPartType(partName), (IFile)eglFile.getResource(), cachedFileInfo.getCaseSensitivePartName(partName));
                    WorkingCopyCompiler.this.locateDuplicateFile(duplicateFilesToProcess, project, packageName, partName, cachedFileInfo.getPartType(partName), (IFile)eglFile.getResource());
                }

                @Override
                public void partChanged(String partName) {
                    projectInfo.workingCopyPartChanged(packageName, partName, newFileInfo.getPartType(partName), (IFile)eglFile.getResource(), newFileInfo.getCaseSensitivePartName(partName));
                }
            });
            differencer.findDifferences(cachedFileInfo, newFileInfo);
        } else {
            Set partNames = newFileInfo.getPartNames();
            for (String partName : partNames) {
                projectInfo.workingCopyPartAdded(packageName, partName, newFileInfo.getPartType(partName), (IFile)eglFile.getResource(), newFileInfo.getCaseSensitivePartName(partName));
            }
        }
        WorkingCopyFileInfoManager.getInstance().addFileInfo(project, ((IFile)eglFile.getResource()).getProjectRelativePath(), newFileInfo);
        this.processDuplicateFiles(duplicateFilesToProcess, problemRequestorFactory);
    }

    private void locateDuplicateFile(Set duplicateFilesToProcess, IProject project, String packageName, String partName, int partType, IFile file) {
        Set files;
        Iterator iter;
        AbstractDuplicatePartManager.DuplicatePartList dupeparts = WorkingCopyDuplicatePartManager.getInstance().getDuplicatePartList(project);
        if (dupeparts.isDuplicatePart(packageName, partName) && WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project).getPartOrigin(packageName, partName).getEGLFile().equals((Object)file) && (iter = (files = dupeparts.getFilesForDuplicatePart(packageName, partName)).iterator()).hasNext()) {
            IFile dupeFile = (IFile)iter.next();
            duplicateFilesToProcess.add(new DupeFileinfo(project, dupeFile, packageName, partName));
        }
    }

    private class DupeFileinfo {
        String packageName;
        String partName;
        IFile file;
        IProject project;

        public DupeFileinfo(IProject project, IFile file, String packageName, String partName) {
            this.project = project;
            this.file = file;
            this.packageName = packageName;
            this.partName = partName;
        }
    }
}

