/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import java.util.ArrayList;
import org.eclipse.edt.ide.core.internal.errors.FileReaderUtil;

public class ErrorLineTracker {
    private static final String[] DELIMITERS = new String[]{"\r\n"};
    private String contents;
    private ArrayList lines = new ArrayList();

    public ErrorLineTracker(String contents) {
        this.contents = contents;
        this.createLineInfo();
    }

    public String getLine(int line) {
        if (line >= this.getNumberOfLines()) {
            return null;
        }
        LineInfo lineInfo = (LineInfo)this.lines.get(line);
        return this.contents.substring(lineInfo.start, lineInfo.length + lineInfo.start);
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }

    private void createLineInfo() {
        String delimiter;
        int startPos = 0;
        do {
            delimiter = null;
            int firstDelimiterPos = this.contents.length();
            int i = 0;
            while (i < DELIMITERS.length) {
                int curDelimiterPos = this.contents.indexOf(DELIMITERS[i], startPos);
                if (curDelimiterPos >= 0 && curDelimiterPos < firstDelimiterPos) {
                    delimiter = DELIMITERS[i];
                    firstDelimiterPos = curDelimiterPos;
                }
                ++i;
            }
            int nextStartPos = delimiter == null ? this.contents.length() : firstDelimiterPos + delimiter.length();
            this.lines.add(new LineInfo(startPos, nextStartPos - startPos));
            startPos = nextStartPos;
        } while (delimiter != null);
    }

    public static void main(String[] args) {
        ErrorLineTracker lineTracker = new ErrorLineTracker(FileReaderUtil.readFile("file17.egl"));
        int i = 0;
        while (i < lineTracker.lines.size()) {
            System.out.println(lineTracker.getLine(i));
            ++i;
        }
    }

    private static class LineInfo {
        public int start;
        public int length;

        public LineInfo(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public String toString() {
            return "[" + this.start + "," + this.length + "]";
        }
    }
}

