/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.lookup.ASTFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoError;
import org.eclipse.edt.ide.core.internal.lookup.IASTFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IDuplicatePartRequestor;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;

public abstract class AbstractFileInfoCreator {
    protected AbstractProjectInfo projectInfo;
    protected String packageName;
    protected IFile file;
    protected IDuplicatePartRequestor duplicatePartRequestor;
    protected ASTFileInfo result = new ASTFileInfo();
    protected HashSet addedNames = new HashSet();
    private File fileAST;
    private boolean hasGeneratablePart = false;
    private MessageDigest messageDigest;
    private List errors = new ArrayList();

    public AbstractFileInfoCreator(AbstractProjectInfo projectInfo, String packageName, IFile file, File fileAST, IDuplicatePartRequestor duplicatePartRequestor) {
        this.projectInfo = projectInfo;
        this.packageName = packageName;
        this.file = file;
        this.fileAST = fileAST;
        this.duplicatePartRequestor = duplicatePartRequestor;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException("Error creating AST FileInfo", (Throwable)e);
        }
    }

    protected abstract String getContents() throws CoreException, IOException;

    private void initializeASTInfo() {
        try {
            this.initializeLineNumbers();
            this.initializeParts();
        }
        catch (IOException e) {
            throw new BuildException("Error creating AST FileInfo", (Throwable)e);
        }
        catch (CoreException e) {
            throw new BuildException("Error creating AST FileInfo", (Throwable)e);
        }
        catch (BadLocationException e) {
            throw new BuildException("Error creating AST FileInfo", (Throwable)e);
        }
    }

    private void initializeLineNumbers() throws CoreException, IOException, BadLocationException {
        DefaultLineTracker lineTracker = new DefaultLineTracker();
        lineTracker.set(this.getContents());
        int numberOfLines = lineTracker.getNumberOfLines();
        int[] offsets = new int[numberOfLines];
        int i = 0;
        while (i < numberOfLines) {
            offsets[i] = lineTracker.getLineOffset(i);
            ++i;
        }
        this.result.setLineOffsets(offsets);
    }

    private void initializeParts() throws CoreException, IOException {
        final ASTPartSourceReader reader = new ASTPartSourceReader(new BufferedReader(new StringReader(this.getContents())));
        try {
            this.fileAST.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(File fileNode) {
                    int headerStartOffset = 0;
                    int headerEndOffset = 0;
                    PackageDeclaration packageDeclaration = fileNode.getPackageDeclaration();
                    List importDeclarations = fileNode.getImportDeclarations();
                    headerStartOffset = packageDeclaration != null ? packageDeclaration.getOffset() : (importDeclarations.size() > 0 ? ((ImportDeclaration)importDeclarations.get(0)).getOffset() : 0);
                    if (importDeclarations.size() > 0) {
                        ImportDeclaration lastDecl = (ImportDeclaration)importDeclarations.get(importDeclarations.size() - 1);
                        headerEndOffset = lastDecl.getOffset() + lastDecl.getLength();
                    } else {
                        headerEndOffset = packageDeclaration != null ? packageDeclaration.getOffset() + packageDeclaration.getLength() : 0;
                    }
                    AbstractFileInfoCreator.this.processFilePart(reader, Util.getFilePartName(AbstractFileInfoCreator.this.file), Util.getCaseSensitiveFilePartName(AbstractFileInfoCreator.this.file), 16, headerStartOffset, headerEndOffset - headerStartOffset);
                    return true;
                }

                public boolean visit(Handler handler) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)handler, 10, handler.getOffset(), handler.getLength());
                    return false;
                }

                public boolean visit(DataItem dataItem) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)dataItem, 17, dataItem.getOffset(), dataItem.getLength());
                    return false;
                }

                public boolean visit(Interface interfaceNode) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)interfaceNode, 15, interfaceNode.getOffset(), interfaceNode.getLength());
                    return false;
                }

                public boolean visit(Library library) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)library, 11, library.getOffset(), library.getLength());
                    return false;
                }

                public boolean visit(Program program) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)program, 13, program.getOffset(), program.getLength());
                    return false;
                }

                public boolean visit(Class eglClass) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)eglClass, 30, eglClass.getOffset(), eglClass.getLength());
                    return false;
                }

                public boolean visit(Record record) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)record, 7, record.getOffset(), record.getLength());
                    return false;
                }

                public boolean visit(Service service) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)service, 14, service.getOffset(), service.getLength());
                    return false;
                }

                public boolean visit(Enumeration enumeration) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)enumeration, 19, enumeration.getOffset(), enumeration.getLength());
                    return false;
                }

                public boolean visit(ExternalType externalType) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)externalType, 28, externalType.getOffset(), externalType.getLength());
                    return false;
                }

                public boolean visit(Delegate delegate) {
                    AbstractFileInfoCreator.this.processPart(reader, (Part)delegate, 27, delegate.getOffset(), delegate.getLength());
                    return false;
                }
            });
        }
        finally {
            reader.close();
        }
        this.result.setErrors(this.errors);
    }

    private void processFilePart(ASTPartSourceReader reader, String caseInsensitiveFileName, String caseSensitiveFileName, int partType, int sourceStart, int sourceLength) {
        if (this.checkForDuplicates()) {
            if (!this.isDuplicatePart(caseInsensitiveFileName)) {
                this.addPart(reader, caseInsensitiveFileName, caseSensitiveFileName, partType, sourceStart, sourceLength);
            } else {
                this.duplicatePartRequestor.acceptDuplicatePart(caseInsensitiveFileName);
                this.errors.add(new FileInfoError(sourceStart, sourceLength, 3039, new String[]{caseInsensitiveFileName}));
            }
        } else {
            this.addPart(reader, caseInsensitiveFileName, caseSensitiveFileName, partType, sourceStart, sourceLength);
        }
    }

    private void processPart(ASTPartSourceReader reader, Part part, int partType, int sourceStart, int sourceLength) {
        if (this.partRequiresOnePerFile(part)) {
            this.validateGeneratablePart(part);
        }
        String caseInsensitivePartName = part.getIdentifier();
        if (this.checkForDuplicates()) {
            if (!this.isDuplicatePart(caseInsensitivePartName)) {
                this.addPart(reader, caseInsensitivePartName, part.getName().getCaseSensitiveIdentifier(), partType, sourceStart, sourceLength);
            } else {
                this.duplicatePartRequestor.acceptDuplicatePart(caseInsensitivePartName);
                this.errors.add(new FileInfoError(part.getName().getOffset(), part.getName().getLength(), 3039, new String[]{caseInsensitivePartName}));
            }
        } else {
            this.addPart(reader, caseInsensitivePartName, part.getName().getCaseSensitiveIdentifier(), partType, sourceStart, sourceLength);
        }
    }

    private void addPart(ASTPartSourceReader reader, String caseInsensitivePartName, String caseSensitivePartName, int partType, int sourceStart, int sourceLength) {
        this.addedNames.add(caseInsensitivePartName);
        try {
            this.result.addPart(caseInsensitivePartName, partType, sourceStart, sourceLength, caseSensitivePartName, this.calculateMD5Key(reader, sourceStart, sourceLength));
        }
        catch (IOException e) {
            throw new BuildException("Error creating AST FileInfo", (Throwable)e);
        }
    }

    protected boolean checkForDuplicates() {
        return true;
    }

    protected boolean isDuplicatePart(String caseInsensitivePartName) {
        boolean duplicate = false;
        IFile declaringFile = this.projectInfo.getPartOrigin(this.packageName, caseInsensitivePartName).getEGLFile();
        duplicate = declaringFile != null && !declaringFile.equals((Object)this.file) ? true : this.addedNames.contains(caseInsensitivePartName);
        return duplicate;
    }

    private void validateGeneratablePart(Part part) {
        if (this.hasGeneratablePart) {
            String fileName = this.file.getFullPath().removeFileExtension().lastSegment();
            this.errors.add(new FileInfoError(part.getName().getOffset(), part.getName().getLength(), 3041, new String[]{part.getPartTypeName(), part.getName().getCanonicalName(), fileName}));
        } else {
            String fileName = this.file.getFullPath().removeFileExtension().lastSegment();
            this.hasGeneratablePart = true;
            if (!part.getName().getCanonicalName().equals(fileName)) {
                this.errors.add(new FileInfoError(part.getName().getOffset(), part.getName().getLength(), 3040, new String[]{part.getPartTypeName(), part.getName().getCanonicalName(), fileName}));
            }
        }
    }

    private byte[] calculateMD5Key(ASTPartSourceReader reader, int offset, int length) throws IOException {
        byte[] partBytes = new byte[length];
        reader.seekToElement(offset);
        int i = 0;
        while (i < length) {
            partBytes[i] = (byte)reader.read();
            ++i;
        }
        return this.messageDigest.digest(partBytes);
    }

    public IASTFileInfo getASTInfo() {
        this.initializeASTInfo();
        return this.result;
    }

    private boolean partRequiresOnePerFile(Part part) {
        switch (part.getPartType()) {
            case 0: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    protected class ASTPartSourceReader {
        private Reader stringReader;
        private int currentOffset;

        public ASTPartSourceReader(Reader stringReader) {
            this.stringReader = stringReader;
        }

        /*
         * Unable to fully structure code
         */
        public void seekToElement(int elementOffset) throws IOException {
            if (this.currentOffset <= elementOffset) ** GOTO lbl5
            throw new BuildException("Error seeking to element");
lbl-1000:
            // 1 sources

            {
                this.read();
lbl5:
                // 2 sources

                ** while (this.currentOffset != elementOffset)
            }
lbl6:
            // 1 sources

        }

        public int read() throws IOException {
            ++this.currentOffset;
            return this.stringReader.read();
        }

        public void close() throws IOException {
            this.stringReader.close();
        }
    }
}

