/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue;
import org.eclipse.edt.compiler.internal.core.builder.CircularBuildRequestException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.compiler.BindingCompletor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.NullDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileASTScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.PartBindingCache;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.core.internal.binding.PartRestoreFailedException;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.utils.NameUtile;

public class ProjectBuildPathEntry
implements IBuildPathEntry {
    private ProjectInfo projectInfo;
    private PartBindingCache bindingCache;
    private AbstractProcessingQueue processingQueue;
    private ProjectEnvironment declaringEnvironment;
    private IEnvironment realizingEnvironment;
    private ObjectStore[] stores;
    public static final ObjectStore[] EMPTY_STORES = new ObjectStore[0];

    protected ProjectBuildPathEntry(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.bindingCache = new PartBindingCache();
        this.stores = EMPTY_STORES;
        this.realizingEnvironment = new RealizingEnvironment();
    }

    protected ProjectEnvironment getDeclaringEnvironment() {
        return this.declaringEnvironment;
    }

    protected void setDeclaringEnvironment(ProjectEnvironment projectEnvironment) {
        this.declaringEnvironment = projectEnvironment;
    }

    protected void setObjectStores(ObjectStore[] stores) {
        this.stores = stores == null ? EMPTY_STORES : stores;
    }

    public ObjectStore[] getObjectStores() {
        return this.stores;
    }

    public void setProcessingQueue(AbstractProcessingQueue processingQueue) {
        this.processingQueue = processingQueue;
    }

    public int hasPart(String packageName, String partName) {
        return this.projectInfo.hasPart(packageName, partName);
    }

    public boolean hasPackage(String packageName) {
        return this.projectInfo.hasPackage(packageName);
    }

    public IPartBinding getPartBindingFromCache(String packageName, String partName) {
        return this.bindingCache.get(packageName, partName);
    }

    public IPartBinding getPartBinding(String packageName, String partName) {
        return this.getPartBinding(packageName, partName, false);
    }

    public IPartBinding getPartBinding(String packageName, String partName, boolean force) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isBinary()) {
            return null;
        }
        IPartBinding result = null;
        if (this.processingQueue != null) {
            result = this.processingQueue.requestCompilationFor(packageName, partName, force);
        }
        if (result == null) {
            result = this.bindingCache.get(packageName, partName);
            if (result != null) {
                return result;
            }
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isReadOnly()) {
                return this.readPartBinding(packageName, partName);
            }
            if (this.projectInfo.hasPart(packageName, partName) != 1) {
                IFile declaringFile = this.projectInfo.getPartOrigin(packageName, partName).getEGLFile();
                if (NameUtile.equals((String)Util.getFilePartName(declaringFile), (String)partName) || this.projectInfo.hasPart(packageName, partName) == 20) {
                    try {
                        return this.compileLevel2Binding(packageName, this.projectInfo.getCaseSensitivePartName(packageName, partName));
                    }
                    catch (CircularBuildRequestException e) {
                        this.removePartBindingInvalid(packageName, partName);
                        throw e;
                    }
                }
                return this.readPartBinding(packageName, partName);
            }
            return null;
        }
        return result;
    }

    public IPartBinding getNewPartBinding(String packageName, String caseSensitiveInternedPartName, int kind) {
        String caseInsensitiveInternedPartName = NameUtile.getAsName((String)caseSensitiveInternedPartName);
        IPartBinding partBinding = this.bindingCache.get(packageName, caseInsensitiveInternedPartName);
        if (partBinding == null || partBinding.getKind() != kind) {
            partBinding = BindingUtil.createPartBinding((int)kind, (String)packageName, (String)caseSensitiveInternedPartName);
            this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        } else {
            partBinding.clear();
            partBinding.setValid(false);
        }
        return partBinding;
    }

    private IPartBinding readPartBinding(String packageName, String partName) {
        try {
            IRPartBinding partBinding;
            EObject ir = this.readPart(packageName, partName);
            if (ir != null && (partBinding = BindingUtil.createPartBinding((EObject)ir)) != null) {
                this.bindingCache.put(packageName, partName, (IPartBinding)partBinding);
                return partBinding;
            }
            return null;
        }
        catch (Exception e) {
            throw new PartRestoreFailedException(packageName, partName, e);
        }
    }

    public IPartBinding compileLevel2Binding(String packageName, String caseSensitiveInternedPartName) {
        String fileName;
        IPartBinding fileBinding;
        String caseInsensitiveInternedPartName = NameUtile.getAsName((String)caseSensitiveInternedPartName);
        IFile declaringFile = this.projectInfo.getPartOrigin(packageName, caseInsensitiveInternedPartName).getEGLFile();
        Node partAST = ASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedPartName);
        IPartBinding partBinding = new BindingCreator((IEnvironment)this.declaringEnvironment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding();
        partBinding.setEnvironment((IEnvironment)this.declaringEnvironment);
        Object scope = partBinding.getKind() == 16 ? new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()) : (!(fileBinding = this.getPartBinding(packageName, fileName = Util.getFilePartName(declaringFile), true)).isValid() ? new FileASTScope((Scope)new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (FileBinding)fileBinding, ASTManager.getInstance().getFileAST(declaringFile)) : new FileScope((Scope)new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (FileBinding)fileBinding, (IDependencyRequestor)NullDependencyRequestor.getInstance()));
        BindingCompletor.getInstance().completeBinding(partAST, partBinding, (Scope)scope, DefaultCompilerOptions.getInstance());
        this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        return partBinding;
    }

    protected void markPartBindingInvalid(String packageName, String partName) {
        IPartBinding result = this.bindingCache.get(packageName, partName);
        if (result != null) {
            result.setValid(false);
        }
    }

    public void removePartBindingInvalid(String packageName, String partName) {
        this.bindingCache.remove(packageName, partName);
    }

    public IProject getProject() {
        return this.projectInfo.getProject();
    }

    public IEnvironment getRealizingEnvironment() {
        return this.realizingEnvironment;
    }

    public void clear(boolean clean) {
        this.bindingCache = new PartBindingCache();
        if (clean) {
            ObjectStore[] objectStoreArray = this.stores;
            int n = this.stores.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectStore store = objectStoreArray[n2];
                if (store instanceof CachingObjectStore) {
                    ((CachingObjectStore)store).clearCache();
                }
                ++n2;
            }
        }
    }

    public boolean isZipFile() {
        return false;
    }

    public boolean isProject() {
        return true;
    }

    public String getID() {
        return this.getProject().getName();
    }

    public FileBinding getFileBinding(String packageName, String fileName, File fileAST) {
        String caseInsensitiveInternedFileName = NameUtile.getAsName((String)fileName);
        FileBinding fileBinding = this.getFileBindingFromCache(packageName, caseInsensitiveInternedFileName);
        if (fileBinding != null) {
            return fileBinding;
        }
        fileBinding = (FileBinding)new BindingCreator((IEnvironment)this.declaringEnvironment, packageName, caseInsensitiveInternedFileName, (Node)fileAST).getPartBinding();
        fileBinding.setEnvironment((IEnvironment)this.declaringEnvironment);
        EnvironmentScope scope = new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance());
        BindingCompletor.getInstance().completeBinding((Node)fileAST, (IPartBinding)fileBinding, (Scope)scope, DefaultCompilerOptions.getInstance());
        this.bindingCache.put(packageName, caseInsensitiveInternedFileName, (IPartBinding)fileBinding);
        return fileBinding;
    }

    public FileBinding getFileBindingFromCache(String packageName, String partName) {
        return (FileBinding)this.bindingCache.get(packageName, partName);
    }

    public IPartBinding getCachedPartBinding(String packageName, String partName) {
        return this.getPartBindingFromCache(packageName, partName);
    }

    private EObject readPart(String packageName, String name) throws DeserializationException {
        StringBuilder keyBuf = new StringBuilder(100);
        keyBuf.append(":");
        if (packageName != null && packageName.length() > 0) {
            keyBuf.append(packageName);
            keyBuf.append('.');
        }
        keyBuf.append(name);
        int i = 0;
        while (i < this.stores.length) {
            EObject ir = this.stores[i].get(String.valueOf(this.stores[i].getKeyScheme()) + keyBuf.toString());
            if (ir != null) {
                return ir;
            }
            ++i;
        }
        return null;
    }

    public Part findPart(String packageName, String name) throws PartNotFoundException {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isReadOnly() || this.projectInfo.hasPart(packageName, name) != 1) {
            try {
                EObject ir = this.readPart(packageName, name);
                if (ir instanceof Part) {
                    return (Part)ir;
                }
            }
            catch (DeserializationException e) {
                throw new PartNotFoundException((Throwable)e);
            }
        }
        return null;
    }

    protected ICompiler getCompiler() {
        return ProjectSettingsUtility.getCompiler(this.getProject());
    }

    public IBuildNotifier getNotifier() {
        return this.processingQueue == null ? null : this.processingQueue.getNotifier();
    }

    private class RealizingEnvironment
    implements IEnvironment {
        private RealizingEnvironment() {
        }

        public IPartBinding getPartBinding(String packageName, String partName) {
            return ProjectBuildPathEntry.this.getPartBinding(packageName, partName, true);
        }

        public IPartBinding getNewPartBinding(String packageName, String caseSensitiveInternedPartName, int kind) {
            return ProjectBuildPathEntry.this.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
        }

        public boolean hasPackage(String packageName) {
            return ProjectBuildPathEntry.this.hasPackage(packageName);
        }

        public IPackageBinding getRootPackage() {
            return ProjectBuildPathEntry.this.declaringEnvironment.getRootPackage();
        }

        public ICompiler getCompiler() {
            return ProjectBuildPathEntry.this.getCompiler();
        }
    }
}

