/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyEglarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.utils.NameUtile;

public class WorkingCopyProjectEnvironment
implements IBindingEnvironment {
    private PackageBinding rootPackageBinding = new PackageBinding(ProjectEnvironment.defaultPackage, null, (IEnvironment)this);
    private final IProject project;
    private WorkingCopyProjectBuildPathEntry declaringProjectBuildPathEntry;
    private IWorkingCopyBuildPathEntry[] buildPathEntries;
    private ProjectIREnvironment irEnvironment;
    private boolean initialized;

    public WorkingCopyProjectEnvironment(IProject project) {
        this.project = project;
    }

    public void setIREnvironment(ProjectIREnvironment environment) {
        this.irEnvironment = environment;
    }

    public ProjectIREnvironment getIREnvironment() {
        return this.irEnvironment;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPartOrigin getPartOrigin(String packageName, String partName) {
        IPartOrigin retVal = this.declaringProjectBuildPathEntry.getPartOrigin(packageName, partName);
        return retVal;
    }

    public void setProjectBuildPathEntries(IWorkingCopyBuildPathEntry[] projectBuildPathEntries) {
        this.buildPathEntries = projectBuildPathEntries;
        if (this.buildPathEntries != null) {
            int i = 0;
            while (i < this.buildPathEntries.length) {
                ObjectStore[] stores = this.buildPathEntries[i].getObjectStores();
                int j = 0;
                while (j < stores.length) {
                    this.irEnvironment.registerObjectStore(stores[j].getKeyScheme(), stores[j]);
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void setDeclaringProjectBuildPathEntry(WorkingCopyProjectBuildPathEntry entry) {
        this.declaringProjectBuildPathEntry = entry;
    }

    public IPartBinding getPartBinding(String packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public IPartBinding getNewPartBinding(String packageName, String caseSensitiveInternedPartName, int kind) {
        IPartBinding binding = this.declaringProjectBuildPathEntry.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
        if (binding != null) {
            binding.setEnvironment((IEnvironment)this);
            if (binding instanceof IRPartBinding) {
                BindingUtil.setEnvironment((Element)((IRPartBinding)binding).getIrPart(), (IEnvironment)this);
            }
        }
        return binding;
    }

    public boolean hasPackage(String packageName) {
        int i = 0;
        while (i < this.buildPathEntries.length) {
            if (this.buildPathEntries[i].hasPackage(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public IPartBinding level01Compile(String packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedPartName = NameUtile.getAsName((String)caseSensitiveInternedPartName);
        int i = 0;
        while (i < this.buildPathEntries.length) {
            int partType = this.buildPathEntries[i].hasPart(packageName, caseInsensitiveInternedPartName);
            if (partType != 1) {
                IPartBinding result = BindingUtil.createPartBinding((int)partType, (String)packageName, (String)caseSensitiveInternedPartName);
                result.setEnvironment(this.buildPathEntries[i].getRealizingEnvironment());
                if (result instanceof IRPartBinding) {
                    BindingUtil.setEnvironment((Element)((IRPartBinding)result).getIrPart(), (IEnvironment)this.buildPathEntries[i].getRealizingEnvironment());
                }
                return result;
            }
            ++i;
        }
        return null;
    }

    public void clear() {
        this.initialized = false;
        this.buildPathEntries = null;
        this.rootPackageBinding = new PackageBinding(ProjectEnvironment.defaultPackage, null, (IEnvironment)this);
    }

    public WorkingCopyProjectBuildPathEntry getDeclaringProjectBuildPathEntry() {
        return this.declaringProjectBuildPathEntry;
    }

    public ICompiler getCompiler() {
        return ProjectSettingsUtility.getCompiler(this.getProject());
    }

    public void initIREnvironments() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Bootstrap.initialize((org.eclipse.edt.mof.serialization.IEnvironment)this.irEnvironment);
        IWorkingCopyBuildPathEntry[] iWorkingCopyBuildPathEntryArray = this.buildPathEntries;
        int n = this.buildPathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironment eglarEnvironment;
            IWorkingCopyBuildPathEntry entry = iWorkingCopyBuildPathEntryArray[n2];
            if (entry instanceof WorkingCopyProjectBuildPathEntry) {
                ((WorkingCopyProjectBuildPathEntry)entry).getDeclaringEnvironment().initIREnvironments();
            } else if (entry instanceof WorkingCopyEglarBuildPathEntry && (eglarEnvironment = ((WorkingCopyEglarBuildPathEntry)entry).getEnvironment()) instanceof WorkingCopyProjectEnvironment) {
                ((WorkingCopyProjectEnvironment)eglarEnvironment).initIREnvironments();
            }
            ++n2;
        }
    }
}

