/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ElseBlock;
import org.eclipse.edt.compiler.core.ast.EmptyStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.debug.core.breakpoints.EGLBreakpoint;
import org.eclipse.edt.debug.core.breakpoints.EGLLineBreakpoint;
import org.eclipse.edt.debug.internal.ui.EDTDebugUIPlugin;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.editor.IEGLEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class BreakpointUtils {
    private BreakpointUtils() {
    }

    public static ITextEditor getEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    public static EGLLineBreakpoint eglLineBreakpointExists(IResource resource, String typeName, int lineNumber) throws CoreException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints("org.eclipse.edt.debug.ui.presentation.java");
        int i = 0;
        while (i < breakpoints.length) {
            EGLLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof EGLLineBreakpoint && (marker = (breakpoint = (EGLLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && "org.eclipse.edt.debug.core.eglLineBreakpointMarker".equals(marker.getType()) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource()) && typeName.equals(breakpoint.getTypeName())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static boolean isBreakpointValidForStatement(Statement statement) {
        if (statement instanceof EmptyStatement) {
            return false;
        }
        if (statement instanceof FunctionDataDeclaration) {
            return ((FunctionDataDeclaration)statement).getInitializer() != null;
        }
        return true;
    }

    public static boolean isBreakpointValid(IEGLEditor editor, int line) {
        Statement statement = BreakpointUtils.getStatementNode(editor, line);
        if (statement != null) {
            return BreakpointUtils.isBreakpointValidForStatement(statement);
        }
        return false;
    }

    public static Statement getStatementNode(IEGLEditor editor, int line) {
        int docOffset;
        EGLDocument document = (EGLDocument)editor.getViewer().getDocument();
        if (document == null) {
            return null;
        }
        try {
            docOffset = document.getLineOffset(line);
            int lineEndOffset = docOffset + document.getLineLength(line);
            char thechar = document.getChar(docOffset);
            while ((thechar == ' ' || thechar == '\t') && docOffset <= lineEndOffset) {
                thechar = document.getChar(++docOffset);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            EDTDebugUIPlugin.log(e);
            return null;
        }
        Node node = document.getNewModelNodeAtOffset(docOffset);
        if (node == null) {
            return null;
        }
        final Node[] statementContainerNode = new Node[1];
        final List[] statements = new List[1];
        node.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(ElseBlock visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(NestedFunction visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(OnExceptionBlock visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(WhenClause visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(OtherwiseClause visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStatements();
                return false;
            }
        });
        if (statementContainerNode[0] == null) {
            while (node != null && !(node instanceof Statement)) {
                node = node.getParent();
            }
            return (Statement)node;
        }
        Statement statement = null;
        for (Node nodex : statements[0]) {
            if (!(nodex instanceof Statement)) continue;
            statement = (Statement)nodex;
            try {
                int statementLine = document.getLineOfOffset(statement.getOffset()) + 1;
                if (statementLine <= line || !BreakpointUtils.isBreakpointValidForStatement(statement)) continue;
                return statement;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                EDTDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public static IEGLElement getElement(IResource resource) {
        if (resource instanceof BinaryReadOnlyFile) {
            IProject project = resource.getProject();
            if (project != null) {
                IPackageFragment frag;
                BinaryReadOnlyFile roFile = (BinaryReadOnlyFile)resource;
                IPackageFragmentRoot root = EGLCore.create((IProject)project).getPackageFragmentRoot(roFile.getFullPath().toString());
                if (root != null && root.exists() && (frag = root.getPackageFragment(IRFileNameUtility.toIRFileName((String)roFile.getPackage().replace('/', '.')))).exists()) {
                    return frag.getClassFile(roFile.getIrName());
                }
            }
        } else if (resource instanceof IFile) {
            return EGLCore.create((IFile)((IFile)resource));
        }
        return null;
    }

    public static IResource getResource(IEGLElement element) {
        IResource resource = element.getResource();
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public static String getTypeName(IEGLElement element) {
        if (element.exists()) {
            try {
                IPart[] parts = null;
                if (element instanceof IEGLFile) {
                    parts = ((IEGLFile)element).getParts();
                } else if (element instanceof IClassFile) {
                    parts = ((IClassFile)element).getParts();
                }
                if (parts != null && parts.length > 0) {
                    String name = element.getElementName();
                    int lastDot = name.lastIndexOf(46);
                    if (lastDot != -1) {
                        name = name.substring(0, lastDot);
                    }
                    int i = 0;
                    while (i < parts.length) {
                        if (name.equalsIgnoreCase(parts[i].getElementName())) {
                            return parts[i].getFullyQualifiedName();
                        }
                        ++i;
                    }
                }
            }
            catch (EGLModelException eme) {
                EDTDebugUIPlugin.log(eme);
            }
        }
        return "";
    }

    public static IEGLElement getElement(EGLBreakpoint breakpoint) {
        try {
            String handleId = (String)breakpoint.getMarker().getAttribute("org.eclipse.edt.ide.core.internal.model.EGLModelManager.handleId");
            if (handleId != null) {
                return EGLCore.create((String)handleId);
            }
        }
        catch (CoreException ce) {
            EDTDebugUIPlugin.log(ce);
        }
        return null;
    }

    public static String getRelativeBreakpointPath(IBreakpoint bp) {
        if (bp instanceof EGLBreakpoint) {
            try {
                String typeName = ((EGLBreakpoint)bp).getTypeName();
                if (typeName != null && typeName.length() > 0) {
                    return String.valueOf(typeName.replace('.', '/')) + ".egl";
                }
            }
            catch (CoreException ce) {
                EDTDebugUIPlugin.log(ce);
            }
        }
        return null;
    }
}

