/*******************************************************************************
 * Copyright © 2000, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.edt.compiler.core.ast.NodeTypes;
import org.eclipse.edt.compiler.internal.IEGLConstants;

public class EGLDefinedKeywordCompletions {
	public static final String PRIMITIVE = "PRIMITIVE"; //$NON-NLS-1$
	private static EGLKeywordCompletion[] DEFINED_COMPLETIONS;
	private static EGLKeywordCompletion[] NATIVE_LIBRARY_DEFINED_COMPLETIONS;
	
	public static EGLKeywordCompletion[] getDefinedKeywordCompletions() {
		if (DEFINED_COMPLETIONS == null) {
			List completionList = new ArrayList();
			
			//EGL defined keyword completions
			//Generated :  Wed May 10 10:04:54 EDT 2006
			//These keyword completions should be generated by com.ibm.etools.egl.internal.dev.tools.EGLDefinedKeywordCompletionTool
			completionList.add(new EGLKeywordCompletion(NodeTypes.ABSOLUTE, IEGLConstants.KEYWORD_ABSOLUTE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.ADD, IEGLConstants.KEYWORD_ADD));
			completionList.add(new EGLKeywordCompletion(NodeTypes.ALL, IEGLConstants.KEYWORD_ALL));
			completionList.add(new EGLKeywordCompletion(NodeTypes.AS, IEGLConstants.KEYWORD_AS));
			completionList.add(new EGLKeywordCompletion(NodeTypes.BY, IEGLConstants.KEYWORD_BY));
			completionList.add(new EGLKeywordCompletion(NodeTypes.BYNAME, IEGLConstants.KEYWORD_BYNAME));
			completionList.add(new EGLKeywordCompletion(NodeTypes.BYPOSITION, IEGLConstants.KEYWORD_BYPOSITION));
			completionList.add(new EGLKeywordCompletion(NodeTypes.CALL, IEGLConstants.KEYWORD_CALL));
			completionList.add(new EGLKeywordCompletion(NodeTypes.CASE, IEGLConstants.KEYWORD_CASE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.CLOSE, IEGLConstants.KEYWORD_CLOSE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.CONST, IEGLConstants.KEYWORD_CONST));
			completionList.add(new EGLKeywordCompletion(NodeTypes.CONTINUE, IEGLConstants.KEYWORD_CONTINUE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.CONSTRUCTOR, IEGLConstants.KEYWORD_CONSTRUCTOR));
			completionList.add(new EGLKeywordCompletion(NodeTypes.CURRENT, IEGLConstants.KEYWORD_CURRENT));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.DATAITEM, IEGLConstants.KEYWORD_DATAITEM));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.DATATABLE, IEGLConstants.KEYWORD_DATATABLE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.DECREMENT, IEGLConstants.KEYWORD_DECREMENT));
			completionList.add(new EGLKeywordCompletion(NodeTypes.DELEGATE, IEGLConstants.KEYWORD_DELEGATE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.DELETE, IEGLConstants.KEYWORD_DELETE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.ELSE, IEGLConstants.KEYWORD_ELSE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.END, IEGLConstants.KEYWORD_END));
			completionList.add(new EGLKeywordCompletion(NodeTypes.ENUMERATION, IEGLConstants.KEYWORD_ENUMERATION));
			completionList.add(new EGLKeywordCompletion(NodeTypes.EXECUTE, IEGLConstants.KEYWORD_EXECUTE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.EXIT, IEGLConstants.KEYWORD_EXIT));
			completionList.add(new EGLKeywordCompletion(NodeTypes.EXTENDS, IEGLConstants.KEYWORD_EXTENDS));
			completionList.add(new EGLKeywordCompletion(NodeTypes.EXTERNALTYPE, IEGLConstants.KEYWORD_EXTERNALTYPE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.FIRST, IEGLConstants.KEYWORD_FIRST));
			completionList.add(new EGLKeywordCompletion(NodeTypes.FOR, IEGLConstants.KEYWORD_FOR));
			completionList.add(new EGLKeywordCompletion(NodeTypes.FOREACH, IEGLConstants.KEYWORD_FOREACH));
			completionList.add(new EGLKeywordCompletion(NodeTypes.FORUPDATE, IEGLConstants.KEYWORD_FORUPDATE));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.FREESQL, IEGLConstants.KEYWORD_FREESQL));
			completionList.add(new EGLKeywordCompletion(NodeTypes.FROM, IEGLConstants.KEYWORD_FROM));
			completionList.add(new EGLKeywordCompletion(NodeTypes.FUNCTION, IEGLConstants.KEYWORD_FUNCTION));
			completionList.add(new EGLKeywordCompletion(NodeTypes.GET, IEGLConstants.KEYWORD_GET));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.GOTO, IEGLConstants.KEYWORD_GOTO));
			completionList.add(new EGLKeywordCompletion(NodeTypes.GROUP, IEGLConstants.KEYWORD_GROUP));
			completionList.add(new EGLKeywordCompletion(NodeTypes.HANDLER, IEGLConstants.KEYWORD_HANDLER));
			completionList.add(new EGLKeywordCompletion(NodeTypes.HOLD, IEGLConstants.KEYWORD_HOLD));
			completionList.add(new EGLKeywordCompletion(NodeTypes.IF, IEGLConstants.KEYWORD_IF));
			completionList.add(new EGLKeywordCompletion(NodeTypes.IMPLEMENTS, IEGLConstants.KEYWORD_IMPLEMENTS));
			completionList.add(new EGLKeywordCompletion(NodeTypes.IMPORT, IEGLConstants.KEYWORD_IMPORT));
			completionList.add(new EGLKeywordCompletion(NodeTypes.INSERT, IEGLConstants.KEYWORD_INSERT));
			completionList.add(new EGLKeywordCompletion(NodeTypes.INTERFACE, IEGLConstants.KEYWORD_INTERFACE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.INTO, IEGLConstants.KEYWORD_INTO));
			completionList.add(new EGLKeywordCompletion(NodeTypes.LABEL, IEGLConstants.KEYWORD_LABEL));
			completionList.add(new EGLKeywordCompletion(NodeTypes.LANGUAGEBUNDLE, IEGLConstants.KEYWORD_LANGUAGEBUNDLE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.LAST, IEGLConstants.KEYWORD_LAST));
			completionList.add(new EGLKeywordCompletion(NodeTypes.LIBRARY, IEGLConstants.KEYWORD_LIBRARY));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.MOVE, IEGLConstants.KEYWORD_MOVE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.NEXT, IEGLConstants.KEYWORD_NEXT));
			completionList.add(new EGLKeywordCompletion(NodeTypes.NOCURSOR, IEGLConstants.KEYWORD_NOCURSOR));
			completionList.add(new EGLKeywordCompletion(NodeTypes.OF, IEGLConstants.KEYWORD_OF));
			completionList.add(new EGLKeywordCompletion(NodeTypes.ONEXCEPTION, IEGLConstants.KEYWORD_ONEXCEPTION));
			completionList.add(new EGLKeywordCompletion(NodeTypes.OPEN, IEGLConstants.KEYWORD_OPEN));
			completionList.add(new EGLKeywordCompletion(NodeTypes.OTHERWISE, IEGLConstants.KEYWORD_OTHERWISE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.PACKAGE, IEGLConstants.KEYWORD_PACKAGE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.PREPARE, IEGLConstants.KEYWORD_PREPARE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.PREVIOUS, IEGLConstants.KEYWORD_PREVIOUS));
			completionList.add(new EGLKeywordCompletion(NodeTypes.PRIVATE, IEGLConstants.KEYWORD_PRIVATE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.PROGRAM, IEGLConstants.KEYWORD_PROGRAM));
			completionList.add(new EGLKeywordCompletion(NodeTypes.RECORD, IEGLConstants.KEYWORD_RECORD));
			completionList.add(new EGLKeywordCompletion(NodeTypes.REF, IEGLConstants.KEYWORD_REF));
			completionList.add(new EGLKeywordCompletion(NodeTypes.RELATIVE, IEGLConstants.KEYWORD_RELATIVE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.REPLACE, IEGLConstants.KEYWORD_REPLACE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.RETURN, IEGLConstants.KEYWORD_RETURN));
			completionList.add(new EGLKeywordCompletion(NodeTypes.RETURNING, IEGLConstants.KEYWORD_RETURNING));
			completionList.add(new EGLKeywordCompletion(NodeTypes.RETURNS, IEGLConstants.KEYWORD_RETURNS));
			completionList.add(new EGLKeywordCompletion(NodeTypes.RUNUNIT, IEGLConstants.KEYWORD_RUNUNIT));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.SCROLL, IEGLConstants.KEYWORD_SCROLL));
			completionList.add(new EGLKeywordCompletion(NodeTypes.SERVICE, IEGLConstants.KEYWORD_SERVICE));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.SET, IEGLConstants.KEYWORD_SET));
			completionList.add(new EGLKeywordCompletion(NodeTypes.SINGLEROW, IEGLConstants.KEYWORD_SINGLEROW));
			completionList.add(new EGLKeywordCompletion(NodeTypes.STACK, IEGLConstants.KEYWORD_STACK));
			completionList.add(new EGLKeywordCompletion(NodeTypes.STATIC, IEGLConstants.KEYWORD_STATIC));
			completionList.add(new EGLKeywordCompletion(NodeTypes.THROW, IEGLConstants.KEYWORD_THROW));
			completionList.add(new EGLKeywordCompletion(NodeTypes.TO, IEGLConstants.KEYWORD_TO));
			completionList.add(new EGLKeywordCompletion(NodeTypes.TRANSACTION, IEGLConstants.KEYWORD_TRANSACTION));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.TRANSFER, IEGLConstants.KEYWORD_TRANSFER));
			completionList.add(new EGLKeywordCompletion(NodeTypes.TRY, IEGLConstants.KEYWORD_TRY));
			completionList.add(new EGLKeywordCompletion(NodeTypes.TYPE, IEGLConstants.KEYWORD_TYPE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.UPDATE, IEGLConstants.KEYWORD_UPDATE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.URL, IEGLConstants.KEYWORD_URL));
			completionList.add(new EGLKeywordCompletion(NodeTypes.USE, IEGLConstants.KEYWORD_USE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.USING, IEGLConstants.KEYWORD_USING));
			completionList.add(new EGLKeywordCompletion(NodeTypes.USINGKEYS, IEGLConstants.KEYWORD_USINGKEYS));
			completionList.add(new EGLKeywordCompletion(NodeTypes.WHEN, IEGLConstants.KEYWORD_WHEN));
			completionList.add(new EGLKeywordCompletion(NodeTypes.WHERE, IEGLConstants.KEYWORD_WHERE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.WHILE, IEGLConstants.KEYWORD_WHILE));
			completionList.add(new EGLKeywordCompletion(NodeTypes.WITH, IEGLConstants.KEYWORD_WITH));
//			completionList.add(new EGLKeywordCompletion(NodeTypes.WITHV60COMPAT, IEGLConstants.KEYWORD_WITHV60COMPAT));
			completionList.add(new EGLKeywordCompletion(NodeTypes.WRAP, IEGLConstants.KEYWORD_WRAP));
			
			DEFINED_COMPLETIONS = (EGLKeywordCompletion[]) completionList.toArray(new EGLKeywordCompletion[0]);
		}
		return DEFINED_COMPLETIONS;
	}

	
	public static EGLKeywordCompletion[] getNativeLibraryDefinedKeywordCompletions() {
		if (NATIVE_LIBRARY_DEFINED_COMPLETIONS == null) {
			List completionList = new ArrayList();
			
			completionList.add(new EGLKeywordCompletion(NodeTypes.LIBRARY, IEGLConstants.KEYWORD_LIBRARY));
			completionList.add(new EGLKeywordCompletion(NodeTypes.TYPE, IEGLConstants.KEYWORD_TYPE));
			
			NATIVE_LIBRARY_DEFINED_COMPLETIONS = (EGLKeywordCompletion[]) completionList.toArray(new EGLKeywordCompletion[0]);
		}
		
		return NATIVE_LIBRARY_DEFINED_COMPLETIONS;
	}
	
	public static void reset() {
		DEFINED_COMPLETIONS = null;
		NATIVE_LIBRARY_DEFINED_COMPLETIONS = null;
	}
}
