/*******************************************************************************
 * Copyright © 2011, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.compiler.internal;

/** 
 * @author jshavor
 *
 * Common EGL constants
 */
public interface IEGLConstants {

	//separate the generated constants into an interface by itself
	//and put the rest in another file. 

	public static final String EGL = "egl";  //$NON-NLS-1$

	public static final String PACKAGE_SEPARATOR = "."; //$NON-NLS-1$
	public static final String EGL_CORE_PACKAGE = "egl.core"; //$NON-NLS-1$
	public static final String EGL_UI_CONSOLE_PACKAGE = "egl.ui.console"; //$NON-NLS-1$
	public static final String EGL_REPORTS_JASPER_PACKAGE = "egl.reports.jasper"; //$NON-NLS-1$
	public static final String [] EGLX_LANG_PACKAGE = {"eglx","lang"};

	
	//Content Assist annotation defined in eglx/lang/annotations.egl file
	public static final String ContentAssist = "ContentAssist";


	//EGL keywords
	//Generated :  Tue Jun 13 11:02:51 EDT 2006
	//These keywords should be generated by org.eclipse.edt.compiler.core.dev.tools.EGLKeywordTool
	public static final String KEYWORD_ABSOLUTE = "absolute";  //$NON-NLS-1$
	public static final String KEYWORD_ADD = "add";  //$NON-NLS-1$
	public static final String KEYWORD_ALL = "all";  //$NON-NLS-1$
	public static final String KEYWORD_ANY = "any";  //$NON-NLS-1$
	public static final String KEYWORD_AND = "and";  //$NON-NLS-1$
	public static final String KEYWORD_AS = "as";  //$NON-NLS-1$
	public static final String KEYWORD_ASJAVA = "asjava";  //$NON-NLS-1$
	public static final String KEYWORD_BIGINT = "bigInt";  //$NON-NLS-1$
	public static final String KEYWORD_BIN = "bin";  //$NON-NLS-1$
	public static final String KEYWORD_BIND = "bind";  //$NON-NLS-1$
	public static final String KEYWORD_BLOB = "blob";  //$NON-NLS-1$
	public static final String KEYWORD_BOOLEAN = "boolean";  //$NON-NLS-1$
	public static final String KEYWORD_BY = "by";  //$NON-NLS-1$
	public static final String KEYWORD_BYNAME = "byName";  //$NON-NLS-1$
	public static final String KEYWORD_BYPOSITION = "byPosition";  //$NON-NLS-1$
	public static final String KEYWORD_BYTES = "bytes";  //$NON-NLS-1$
	public static final String KEYWORD_CALL = "call";  //$NON-NLS-1$
	public static final String KEYWORD_CASE = "case";  //$NON-NLS-1$
	public static final String KEYWORD_CHAR = "char";  //$NON-NLS-1$
	public static final String KEYWORD_CLOB = "clob";  //$NON-NLS-1$
	public static final String KEYWORD_CLOSE = "close";  //$NON-NLS-1$
	public static final String KEYWORD_CONST = "const";  //$NON-NLS-1$
	public static final String KEYWORD_CONTINUE = "continue";  //$NON-NLS-1$
	public static final String KEYWORD_CONSTRUCTOR = "constructor";  //$NON-NLS-1$
	public static final String KEYWORD_CONVERSE = "converse";  //$NON-NLS-1$
	public static final String KEYWORD_CURRENT = "current";  //$NON-NLS-1$
	public static final String KEYWORD_DATAITEM = "dataItem";  //$NON-NLS-1$
	public static final String KEYWORD_DATATABLE = "dataTable";  //$NON-NLS-1$
	public static final String KEYWORD_DATE = "date";  //$NON-NLS-1$
	public static final String KEYWORD_DBCHAR = "dbChar";  //$NON-NLS-1$
	public static final String KEYWORD_DECIMAL = "decimal";  //$NON-NLS-1$
	public static final String KEYWORD_DECREMENT = "decrement";  //$NON-NLS-1$
	public static final String KEYWORD_DELEGATE = "delegate";  //$NON-NLS-1$
	public static final String KEYWORD_DELETE = "delete";  //$NON-NLS-1$
	public static final String KEYWORD_DISPLAY = "display";  //$NON-NLS-1$
	public static final String KEYWORD_ELSE = "else";  //$NON-NLS-1$
	public static final String KEYWORD_EMBED = "embed";  //$NON-NLS-1$
	public static final String KEYWORD_END = "end";  //$NON-NLS-1$
	public static final String KEYWORD_ENUMERATION = "enumeration";  //$NON-NLS-1$
	public static final String KEYWORD_ESCAPE = "escape";  //$NON-NLS-1$
	public static final String KEYWORD_EXECUTE = "execute";  //$NON-NLS-1$
	public static final String KEYWORD_EXIT = "exit";  //$NON-NLS-1$
	public static final String KEYWORD_EXTENDS = "extends";  //$NON-NLS-1$
	public static final String KEYWORD_EXTERNALTYPE = "externalType";  //$NON-NLS-1$
	public static final String KEYWORD_FALSE = "false";  //$NON-NLS-1$
	public static final String KEYWORD_FIELD = "field";  //$NON-NLS-1$
	public static final String KEYWORD_FIRST = "first";  //$NON-NLS-1$
	public static final String KEYWORD_FLOAT = "float";  //$NON-NLS-1$
	public static final String KEYWORD_FOR = "for";  //$NON-NLS-1$
	public static final String KEYWORD_FOREACH = "forEach";  //$NON-NLS-1$
	public static final String KEYWORD_FORM = "form";  //$NON-NLS-1$
	public static final String KEYWORD_FORMGROUP = "formGroup";  //$NON-NLS-1$
	public static final String KEYWORD_FORUPDATE = "forUpdate";  //$NON-NLS-1$
	public static final String KEYWORD_FORWARD = "forward";  //$NON-NLS-1$
	public static final String KEYWORD_FREESQL = "freeSql";  //$NON-NLS-1$
	public static final String KEYWORD_FROM = "from";  //$NON-NLS-1$
	public static final String KEYWORD_FUNCTION = "function";  //$NON-NLS-1$
	public static final String KEYWORD_GET = "get";  //$NON-NLS-1$
	public static final String KEYWORD_GOTO = "goto";  //$NON-NLS-1$
	public static final String KEYWORD_GROUP = "group";  //$NON-NLS-1$
	public static final String KEYWORD_HANDLER = "handler";  //$NON-NLS-1$
	public static final String KEYWORD_HEX = "hex";  //$NON-NLS-1$
	public static final String KEYWORD_HOLD = "hold";  //$NON-NLS-1$
	public static final String KEYWORD_IF = "if";  //$NON-NLS-1$
	public static final String KEYWORD_IMPLEMENTS = "implements";  //$NON-NLS-1$
	public static final String KEYWORD_IMPORT = "import";  //$NON-NLS-1$
	public static final String KEYWORD_IN = "in";  //$NON-NLS-1$
	public static final String KEYWORD_INOUT = "inOut";  //$NON-NLS-1$
	public static final String KEYWORD_INPARENT = "inparent";  //$NON-NLS-1$
	public static final String KEYWORD_INSERT = "insert";  //$NON-NLS-1$
	public static final String KEYWORD_INT = "int";  //$NON-NLS-1$
	public static final String KEYWORD_INTERFACE = "interface";  //$NON-NLS-1$
	public static final String KEYWORD_INTERVAL = "interval";  //$NON-NLS-1$
	public static final String KEYWORD_INTO = "into";  //$NON-NLS-1$
	public static final String KEYWORD_IS = "is";  //$NON-NLS-1$
	public static final String KEYWORD_ISA = "isa";  //$NON-NLS-1$
	public static final String KEYWORD_LABEL = "label";  //$NON-NLS-1$
	public static final String KEYWORD_LANGUAGEBUNDLE = "languageBundle";  //$NON-NLS-1$
	public static final String KEYWORD_LAST = "last";  //$NON-NLS-1$
	public static final String KEYWORD_LIBRARY = "library";  //$NON-NLS-1$
	public static final String KEYWORD_LIKE = "like";  //$NON-NLS-1$
	public static final String KEYWORD_MATCHES = "matches";  //$NON-NLS-1$
	public static final String KEYWORD_MBCHAR = "mbChar";  //$NON-NLS-1$
	public static final String KEYWORD_MONEY = "money";  //$NON-NLS-1$
	public static final String KEYWORD_MOVE = "move";  //$NON-NLS-1$
	public static final String KEYWORD_NEW = "new";  //$NON-NLS-1$
	public static final String KEYWORD_NEXT = "next";  //$NON-NLS-1$
	public static final String KEYWORD_NULL = "null";  //$NON-NLS-1$
	public static final String KEYWORD_NO = "no";  //$NON-NLS-1$
	public static final String KEYWORD_NOCURSOR = "noCursor";  //$NON-NLS-1$
	public static final String KEYWORD_NOT = "not";  //$NON-NLS-1$
	public static final String KEYWORD_SQLNULLABLE = "sqlnullable";  //$NON-NLS-1$
	public static final String KEYWORD_NUM = "num";  //$NON-NLS-1$
	public static final String KEYWORD_NUMBER = "number";  //$NON-NLS-1$
	public static final String KEYWORD_NUMC = "numc";  //$NON-NLS-1$
	public static final String KEYWORD_OF = "of";  //$NON-NLS-1$
	public static final String KEYWORD_ONEVENT = "onEvent";  //$NON-NLS-1$
	public static final String KEYWORD_ONEXCEPTION = "onException";  //$NON-NLS-1$
	public static final String KEYWORD_OPEN = "open";  //$NON-NLS-1$
	public static final String KEYWORD_OPENUI = "openUI";  //$NON-NLS-1$
	public static final String KEYWORD_OR = "or";  //$NON-NLS-1$
	public static final String KEYWORD_OTHERWISE = "otherwise";  //$NON-NLS-1$
	public static final String KEYWORD_OUT = "out";  //$NON-NLS-1$
	public static final String KEYWORD_PACF = "pacf";  //$NON-NLS-1$
	public static final String KEYWORD_PACKAGE = "package";  //$NON-NLS-1$
	public static final String KEYWORD_PASSING = "passing";  //$NON-NLS-1$
	public static final String KEYWORD_PREPARE = "prepare";  //$NON-NLS-1$
	public static final String KEYWORD_PREVIOUS = "previous";  //$NON-NLS-1$
	public static final String KEYWORD_PRINT = "print";  //$NON-NLS-1$
	public static final String KEYWORD_PRIVATE = "private";  //$NON-NLS-1$
	public static final String KEYWORD_PROGRAM = "program";  //$NON-NLS-1$
	public static final String KEYWORD_RECORD = "record";  //$NON-NLS-1$
	public static final String KEYWORD_REF = "ref";  //$NON-NLS-1$
	public static final String KEYWORD_RELATIVE = "relative";  //$NON-NLS-1$
	public static final String KEYWORD_REPLACE = "replace";  //$NON-NLS-1$
	public static final String KEYWORD_RETURN = "return";  //$NON-NLS-1$
	public static final String KEYWORD_RETURNING = "returning";  //$NON-NLS-1$
	public static final String KEYWORD_RETURNS = "returns";  //$NON-NLS-1$
	public static final String KEYWORD_RUNUNIT = "rununit";  //$NON-NLS-1$
	public static final String KEYWORD_SCROLL = "scroll";  //$NON-NLS-1$
	public static final String KEYWORD_SELF = "self";  //$NON-NLS-1$
	public static final String KEYWORD_SERVICE = "service";  //$NON-NLS-1$
	public static final String KEYWORD_SET = "set";  //$NON-NLS-1$
	public static final String KEYWORD_SHOW = "show";  //$NON-NLS-1$
	public static final String KEYWORD_SINGLEROW = "singleRow";  //$NON-NLS-1$
	public static final String KEYWORD_SMALLFLOAT = "smallFloat";  //$NON-NLS-1$
	public static final String KEYWORD_SMALLINT = "smallInt";  //$NON-NLS-1$
	public static final String KEYWORD_STACK = "stack";  //$NON-NLS-1$
	public static final String KEYWORD_STATIC = "static";  //$NON-NLS-1$
	public static final String KEYWORD_STRING = "string";  //$NON-NLS-1$
	public static final String KEYWORD_THIS = "this";  //$NON-NLS-1$
	public static final String KEYWORD_THROW = "throw";  //$NON-NLS-1$
	public static final String KEYWORD_TIME = "time";  //$NON-NLS-1$
	public static final String KEYWORD_TIMESTAMP = "timeStamp";  //$NON-NLS-1$
	public static final String KEYWORD_TIMESTAMP_WITH_PATTERN = "timeStamp(\"yyyyMMddHHmmssffffff\")";  //$NON-NLS-1$
	public static final String KEYWORD_TO = "to";  //$NON-NLS-1$
	public static final String KEYWORD_TRANSACTION = "transaction";  //$NON-NLS-1$
	public static final String KEYWORD_TRANSFER = "transfer";  //$NON-NLS-1$
	public static final String KEYWORD_TRUE = "true";  //$NON-NLS-1$
	public static final String KEYWORD_TRY = "try";  //$NON-NLS-1$
	public static final String KEYWORD_TYPE = "type";  //$NON-NLS-1$
	public static final String KEYWORD_UNICODE = "unicode";  //$NON-NLS-1$
	public static final String KEYWORD_UPDATE = "update";  //$NON-NLS-1$
	public static final String KEYWORD_URL = "url";  //$NON-NLS-1$
	public static final String KEYWORD_USE = "use";  //$NON-NLS-1$
	public static final String KEYWORD_USING = "using";  //$NON-NLS-1$
	public static final String KEYWORD_USINGKEYS = "usingKeys";  //$NON-NLS-1$
	public static final String KEYWORD_WHEN = "when";  //$NON-NLS-1$
	public static final String KEYWORD_WHERE = "where";  //$NON-NLS-1$
	public static final String KEYWORD_WHILE = "while";  //$NON-NLS-1$
	public static final String KEYWORD_WITH = "with";  //$NON-NLS-1$
	public static final String KEYWORD_WITHV60COMPAT = "withV60Compat";  //$NON-NLS-1$
	public static final String KEYWORD_WRAP = "wrap";  //$NON-NLS-1$
	public static final String KEYWORD_YES = "yes";  //$NON-NLS-1$

	
	//V6001VALIDATION
	public static final String KEYWORD_MATHLIB = "mathLib";  //$NON-NLS-1$	
	public static final String KEYWORD_STRLIB = "strLib";  //$NON-NLS-1$
	public static final String KEYWORD_STRINGLIB = "stringLib";  //$NON-NLS-1$
	public static final String KEYWORD_SQLLIB = "sqlLib";  //$NON-NLS-1$	
	public static final String KEYWORD_SYSLIB = "sysLib";  //$NON-NLS-1$	
	public static final String KEYWORD_SYSVAR = "sysVar";  //$NON-NLS-1$	
//	public static final String KEYWORD_CONSOLELIB = "consoleLib";  //$NON-NLS-1$	
//	public static final String KEYWORD_REPORTLIB = "reportLib";  //$NON-NLS-1$	
//	public static final String KEYWORD_LOBLIB = "lobLib";  //$NON-NLS-1$
//	public static final String KEYWORD_VGVAR = "vgVar";  //$NON-NLS-1$	
//	public static final String KEYWORD_VGLIB = "vgLib";  //$NON-NLS-1$
	public static final String KEYWORD_CONVERSEVAR = "converseVar";  //$NON-NLS-1$
//	public static final String KEYWORD_JAVALIB = "javaLib";  //$NON-NLS-1$
	public static final String KEYWORD_DATETIMELIB = "dateTimeLib";  //$NON-NLS-1$
//	public static final String KEYWORD_J2EELIB = "j2eeLib";  //$NON-NLS-1$
//	public static final String KEYWORD_CONVERSELIB = "converseLib";  //$NON-NLS-1$
	public static final String KEYWORD_SERVICELIB = "serviceLib";  //$NON-NLS-1$
	public static final String KEYWORD_HTTPLIB = "httpLib";  //$NON-NLS-1$
	public static final String KEYWORD_JSONLIB = "jsonLib";  //$NON-NLS-1$
	public static final String KEYWORD_RUILIB = "ruiLib";  //$NON-NLS-1$
	public static final String KEYWORD_XMLLib = "xmlLib";  //$NON-NLS-1$
	
	// need to rename these constants
	// These do not belong here.  Only official keywords should be prefixed with
	// KWYWORD_  They all should come from EGLKeywordHandler and the String
	// declarations should be generated per the note in EGLKeywordHandler
	// I am leaving them here for now because of M2 builds
	
	
	///!!!!!!!!!!!! These should not be used!!!!!! Use MNEMONICs instead!!!!!!!!!!
	// These will eventually be deleted.

  	public static final String KEYWORD_DOWN = "down"; //$NON-NLS-1$
	public static final String KEYWORD_EVENTKEY = "eventKey"; //$NON-NLS-1$
 	public static final String KEYWORD_DEFAULTCOLOR = "defaultColor"; //$NON-NLS-1$
	public static final String KEYWORD_BLACK = "black"; //$NON-NLS-1$
	public static final String KEYWORD_BLUE = "blue"; //$NON-NLS-1$
	public static final String KEYWORD_GREEN = "green"; //$NON-NLS-1$
	public static final String KEYWORD_PINK = "pink"; //$NON-NLS-1$
	public static final String KEYWORD_RED = "red"; //$NON-NLS-1$
	public static final String KEYWORD_TURQUOISE = "turquoise"; //$NON-NLS-1$
	public static final String KEYWORD_YELLOW = "yellow"; //$NON-NLS-1$
	public static final String KEYWORD_WHITE = "white"; //$NON-NLS-1$
	public static final String KEYWORD_CYAN = "cyan"; //$NON-NLS-1$
	public static final String KEYWORD_MAGENTA = "magenta"; //$NON-NLS-1$
 	public static final String KEYWORD_NOHIGHLIGHT = "noHighlight"; //$NON-NLS-1$
	public static final String KEYWORD_BLINK = "blink"; //$NON-NLS-1$
	public static final String KEYWORD_REVERSE = "reverse"; //$NON-NLS-1$
	public static final String KEYWORD_UNDERLINE = "underline"; //$NON-NLS-1$
 	public static final String KEYWORD_NORMALINTENSITY = "normalIntensity"; //$NON-NLS-1$
	public static final String KEYWORD_BOLD = "bold"; //$NON-NLS-1$
	public static final String KEYWORD_INVISIBLE = "invisible"; //$NON-NLS-1$
	public static final String KEYWORD_NOOUTLINE = "noOutline"; //$NON-NLS-1$
	public static final String KEYWORD_BOX = "box"; //$NON-NLS-1$
	public static final String KEYWORD_RIGHT = "right"; //$NON-NLS-1$
	public static final String KEYWORD_LEFT = "left"; //$NON-NLS-1$
	public static final String KEYWORD_CENTER = "center"; //$NON-NLS-1$
	public static final String KEYWORD_OVER = "over"; //$NON-NLS-1$
	public static final String KEYWORD_UNDER = "under"; //$NON-NLS-1$
 	public static final String KEYWORD_SKIP = "skip"; //$NON-NLS-1$
 	public static final String KEYWORD_NONE = "none"; //$NON-NLS-1$
	public static final String KEYWORD_SYSTEMGREGORIAN = "systemGregorianDateFormat"; //$NON-NLS-1$
	public static final String KEYWORD_SYSTEMJULIAN = "systemJulianDateFormat"; //$NON-NLS-1$
	public static final String KEYWORD_LEADING = "leading"; //$NON-NLS-1$
 	public static final String KEYWORD_TRAILING = "trailing"; //$NON-NLS-1$





	//EGL mnemonics
	//Generated :  Sun Apr 17 16:52:38 EDT 2005
	//These mnemonics should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLMnemonicTool
	public static final String MNEMONIC_ACROSS = "across";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_DELETE = "after_Delete";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_FIELD = "after_Field";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_INSERT = "after_Insert";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_OPENUI = "after_Openui";  //$NON-NLS-1$
	public static final String MNEMONIC_AFTER_ROW = "after_Row";  //$NON-NLS-1$
	public static final String MNEMONIC_AIX = "aix";  //$NON-NLS-1$
	public static final String MNEMONIC_ALARM = "alarm";  //$NON-NLS-1$
	public static final String MNEMONIC_ASKIP = "askip";  //$NON-NLS-1$
	public static final String MNEMONIC_AUTOCOMMIT = "autoCommit";  //$NON-NLS-1$
	public static final String MNEMONIC_AUTOMATIC = "automatic";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_DELETE = "before_Delete";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_FIELD = "before_Field";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_INSERT = "before_Insert";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_OPENUI = "before_Openui";  //$NON-NLS-1$
	public static final String MNEMONIC_BEFORE_ROW = "before_Row";  //$NON-NLS-1$
	public static final String MNEMONIC_BLACK = "black";  //$NON-NLS-1$
	public static final String MNEMONIC_BLANKS = "blanks";  //$NON-NLS-1$
	public static final String MNEMONIC_BLINK = "blink";  //$NON-NLS-1$
	public static final String MNEMONIC_BLUE = "blue";  //$NON-NLS-1$
	public static final String MNEMONIC_BOLD = "bold";  //$NON-NLS-1$
	public static final String MNEMONIC_BOTTOM = "bottom";  //$NON-NLS-1$
	public static final String MNEMONIC_BOX = "box";  //$NON-NLS-1$
	public static final String MNEMONIC_BUTTON = "button";  //$NON-NLS-1$
	public static final String MNEMONIC_BYINSERTION = "byInsertion";  //$NON-NLS-1$
	public static final String MNEMONIC_BYKEY = "byKey";  //$NON-NLS-1$
	public static final String MNEMONIC_BYPASS = "bypass";  //$NON-NLS-1$
	public static final String MNEMONIC_CENTER = "center";  //$NON-NLS-1$
	public static final String MNEMONIC_CHARACTER = "character";  //$NON-NLS-1$
	public static final String MNEMONIC_COLOR = "color";  //$NON-NLS-1$
	public static final String MNEMONIC_COMPRESS = "compress";  //$NON-NLS-1$
	public static final String MNEMONIC_COMMENTLINE = "commentLine";  //$NON-NLS-1$
	public static final String MNEMONIC_CONDITIONAL = "conditional";  //$NON-NLS-1$
	public static final String MNEMONIC_CSV = "csv";  //$NON-NLS-1$
	public static final String MNEMONIC_CURSOR = "cursor";  //$NON-NLS-1$
	public static final String MNEMONIC_CYAN = "cyan";  //$NON-NLS-1$
	public static final String MNEMONIC_DB2TIMESTAMPFORMAT = "db2TimeStampFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTCASE = "defaultCase";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTDATEFORMAT = "defaultDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTHIGHLIGHT = "defaultHighlight";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTINTENSITY = "defaultIntensity";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTTIMEFORMAT = "defaultTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTTIMESTAMPFORMAT = "defaultTimeStampFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_DIM = "dim";  //$NON-NLS-1$
	public static final String MNEMONIC_D1A = "d1a";  //$NON-NLS-1$
	public static final String MNEMONIC_D1C = "d1c";  //$NON-NLS-1$
	public static final String MNEMONIC_D1E = "d1e";  //$NON-NLS-1$
	public static final String MNEMONIC_D2A = "d2a";  //$NON-NLS-1$
	public static final String MNEMONIC_D2C = "d2c";  //$NON-NLS-1$
	public static final String MNEMONIC_D2E = "d2e";  //$NON-NLS-1$
	public static final String MNEMONIC_DALL = "dAll";  //$NON-NLS-1$
	public static final String MNEMONIC_DATA = "data";  //$NON-NLS-1$
	public static final String MNEMONIC_DATABASECONNECTION = "databaseConnection";  //$NON-NLS-1$
	public static final String MNEMONIC_DATASOURCE_DATABASE_CONNECTION = "datasource_database_Connection";  //$NON-NLS-1$
	public static final String MNEMONIC_DATASOURCE_SQL_STATEMENT = "datasource_sql_statement";  //$NON-NLS-1$
	public static final String MNEMONIC_DATASOURCE_REPORT_DATA = "datasource_report_data";  //$NON-NLS-1$
	public static final String MNEMONIC_DB = "DB";  //$NON-NLS-1$
	public static final String MNEMONIC_DCURRENT = "dCurrent";  //$NON-NLS-1$
	public static final String MNEMONIC_DEADLOCK = "deadLock";  //$NON-NLS-1$
	public static final String MNEMONIC_DEBUG = "debug";  //$NON-NLS-1$
	public static final String MNEMONIC_DEFAULTCOLOR = "defaultColor";  //$NON-NLS-1$
	public static final String MNEMONIC_DISC = "disc";  //$NON-NLS-1$
	public static final String MNEMONIC_DOUBLEBYTE = "doubleByte";  //$NON-NLS-1$
	public static final String MNEMONIC_DOWN = "down";  //$NON-NLS-1$
	public static final String MNEMONIC_DUPLICATE = "duplicate";  //$NON-NLS-1$
	public static final String MNEMONIC_EMPTY = "empty";  //$NON-NLS-1$
	public static final String MNEMONIC_ENDOFFILE = "endOfFile";  //$NON-NLS-1$
	public static final String MNEMONIC_ENTER = "enter";  //$NON-NLS-1$
	public static final String MNEMONIC_ERRORLINE = "errorLine";  //$NON-NLS-1$
	public static final String MNEMONIC_EURDATEFORMAT = "eurDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_EURTIMEFORMAT = "eurTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPLICIT = "explicit";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_HTML = "export_html";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_PDF = "export_pdf";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_TEXT = "export_text";  //$NON-NLS-1$
	public static final String MNEMONIC_EXPORT_XML = "export_xml";  //$NON-NLS-1$
	public static final String MNEMONIC_FILENOTAVAILABLE = "fileNotAvailable";  //$NON-NLS-1$
	public static final String MNEMONIC_FILENOTFOUND = "fileNotFound";  //$NON-NLS-1$
	public static final String MNEMONIC_FORM = "form";  //$NON-NLS-1$
	public static final String MNEMONIC_FORMLINE = "formLine";  //$NON-NLS-1$
	public static final String MNEMONIC_FULL = "full";  //$NON-NLS-1$
	public static final String MNEMONIC_GREEN = "green";  //$NON-NLS-1$
	public static final String MNEMONIC_GSAM = "GSAM";  //$NON-NLS-1$
	public static final String MNEMONIC_HARDIOERROR = "hardIoError";  //$NON-NLS-1$
	public static final String MNEMONIC_HIDDEN = "hidden";  //$NON-NLS-1$
	public static final String MNEMONIC_HIGHLIGHT = "highlight";  //$NON-NLS-1$
	public static final String MNEMONIC_HPUX = "hpux";  //$NON-NLS-1$
	public static final String MNEMONIC_HTML = "html";  //$NON-NLS-1$
	public static final String MNEMONIC_HYPERLINK = "hyperlink";  //$NON-NLS-1$
	public static final String MNEMONIC_I4GL = "I4GL";  //$NON-NLS-1$
	public static final String MNEMONIC_IMSBMP = "imsbmp";  //$NON-NLS-1$
	public static final String MNEMONIC_IMSVS = "imsvs";  //$NON-NLS-1$
	public static final String MNEMONIC_INDEX = "index";  //$NON-NLS-1$
	public static final String MNEMONIC_INITIAL = "initial";  //$NON-NLS-1$
	public static final String MNEMONIC_INITIALATTRIBUTES = "initialAttributes";  //$NON-NLS-1$
	public static final String MNEMONIC_INPUT = "input";  //$NON-NLS-1$
	public static final String MNEMONIC_INPUTOUTPUT = "inputOutput";  //$NON-NLS-1$
	public static final String MNEMONIC_INTENSITY = "intensity";  //$NON-NLS-1$
	public static final String MNEMONIC_INVALIDFORMAT = "invalidFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_INVISIBLE = "invisible";  //$NON-NLS-1$
	public static final String MNEMONIC_IOERROR = "ioError";  //$NON-NLS-1$
	public static final String MNEMONIC_ISERIESC = "iseriesc";  //$NON-NLS-1$
	public static final String MNEMONIC_ISERIESJ = "iseriesj";  //$NON-NLS-1$
	public static final String MNEMONIC_ISODATEFORMAT = "isoDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_ISOTIMEFORMAT = "isoTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_JISDATEFORMAT = "jisDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_JISTIMEFORMAT = "jisTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_L = "l";  //$NON-NLS-1$
	public static final String MNEMONIC_LIBRARY = "library";  //$NON-NLS-1$
	public static final String MNEMONIC_LEADING = "leading";  //$NON-NLS-1$
	public static final String MNEMONIC_LEFT = "left";  //$NON-NLS-1$
	public static final String MNEMONIC_LINUX = "linux";  //$NON-NLS-1$
	public static final String MNEMONIC_LOCAL = "local";  //$NON-NLS-1$
	public static final String MNEMONIC_LOWER = "lower";  //$NON-NLS-1$
	public static final String MNEMONIC_MAGENTA = "magenta";  //$NON-NLS-1$
	public static final String MNEMONIC_MAIN = "main";  //$NON-NLS-1$
	public static final String MNEMONIC_MASKED = "masked";  //$NON-NLS-1$
	public static final String MNEMONIC_MENU_ACTION = "menu_Action";  //$NON-NLS-1$
	public static final String MNEMONIC_MESSAGELINE = "messageLine";  //$NON-NLS-1$
	public static final String MNEMONIC_MENULINE = "menuLine";  //$NON-NLS-1$
	public static final String MNEMONIC_MODIFIED = "modified";  //$NON-NLS-1$
	public static final String MNEMONIC_NO = "no";  //$NON-NLS-1$
	public static final String MNEMONIC_NOPROTECT = "noProtect";  //$NON-NLS-1$
	public static final String MNEMONIC_NOAUTOCOMMIT = "noAutoCommit";  //$NON-NLS-1$
	public static final String MNEMONIC_NOCOMMIT = "noCommit";  //$NON-NLS-1$
	public static final String MNEMONIC_NORECORDFOUND = "noRecordFound";  //$NON-NLS-1$
	public static final String MNEMONIC_NORMAL = "normal";  //$NON-NLS-1$
	public static final String MNEMONIC_NOHIGHLIGHT = "nohighlight";  //$NON-NLS-1$
	public static final String MNEMONIC_NONE = "none";  //$NON-NLS-1$
	public static final String MNEMONIC_NOOUTLINE = "noOutline";  //$NON-NLS-1$
	public static final String MNEMONIC_NORMALINTENSITY = "normalIntensity";  //$NON-NLS-1$
	public static final String MNEMONIC_NULL = "null";  //$NON-NLS-1$
	public static final String MNEMONIC_NULLFILL = "nullFill";  //$NON-NLS-1$
	public static final String MNEMONIC_NUMERIC = "numeric";  //$NON-NLS-1$
	public static final String MNEMONIC_ODBCTIMESTAMPFORMAT = "odbcTimeStampFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_ON_KEY = "on_Key";  //$NON-NLS-1$
	public static final String MNEMONIC_OUTPUT = "output";  //$NON-NLS-1$
	public static final String MNEMONIC_PAKEY = "pakey";  //$NON-NLS-1$
	public static final String MNEMONIC_PARENS = "parens";  //$NON-NLS-1$
	public static final String MNEMONIC_PDF = "pdf";  //$NON-NLS-1$
	public static final String MNEMONIC_PFKEY = "pfkey";  //$NON-NLS-1$
	public static final String MNEMONIC_POSITION = "position";  //$NON-NLS-1$
	public static final String MNEMONIC_PROGRAMLINK = "programLink";  //$NON-NLS-1$
	public static final String MNEMONIC_PROMPTLINE = "promptLine";  //$NON-NLS-1$
	public static final String MNEMONIC_PROTECT = "protect";  //$NON-NLS-1$
	public static final String MNEMONIC_R = "r";  //$NON-NLS-1$
	public static final String MNEMONIC_READCOMMITTED = "readCommitted";  //$NON-NLS-1$
	public static final String MNEMONIC_READUNCOMMITTED = "readUncommitted";  //$NON-NLS-1$
	public static final String MNEMONIC_RED = "red";  //$NON-NLS-1$
	public static final String MNEMONIC_REPEATABLEREAD = "repeatableRead";  //$NON-NLS-1$
	public static final String MNEMONIC_REPORTDATA = "reportData";  //$NON-NLS-1$
	public static final String MNEMONIC_REQUEST = "request";  //$NON-NLS-1$
	public static final String MNEMONIC_REVERSE = "reverse";  //$NON-NLS-1$
	public static final String MNEMONIC_RIGHT = "right";  //$NON-NLS-1$
	public static final String MNEMONIC_SECRET = "secret";  //$NON-NLS-1$
	public static final String MNEMONIC_SERIALIZABLETRANSACTION = "serializableTransaction";  //$NON-NLS-1$
	public static final String MNEMONIC_SESSION = "session";  //$NON-NLS-1$
	public static final String MNEMONIC_SET = "set";  //$NON-NLS-1$
	public static final String MNEMONIC_SINGLEBYTE = "singleByte";  //$NON-NLS-1$
	public static final String MNEMONIC_SKIP = "skip";  //$NON-NLS-1$
	public static final String MNEMONIC_SKIPPROTECT = "skipProtect";  //$NON-NLS-1$
	public static final String MNEMONIC_SOFTIOERROR = "softIoError";  //$NON-NLS-1$
	public static final String MNEMONIC_SOLARIS = "solaris";  //$NON-NLS-1$
	public static final String MNEMONIC_SQLSTATEMENT = "sqlStatement";  //$NON-NLS-1$
	public static final String MNEMONIC_SUBMIT = "submit";  //$NON-NLS-1$
	public static final String MNEMONIC_SUBMITBYPASS = "submitBypass";  //$NON-NLS-1$
	public static final String MNEMONIC_SYSTEMGREGORIANDATEFORMAT = "systemGregorianDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_SYSTEMJULIANDATEFORMAT = "systemJulianDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_TABLE = "table";  //$NON-NLS-1$
	public static final String MNEMONIC_TCPIP = "tcpip";  //$NON-NLS-1$
	public static final String MNEMONIC_TEXT = "text";  //$NON-NLS-1$
	public static final String MNEMONIC_TOP = "top";  //$NON-NLS-1$
	public static final String MNEMONIC_TP = "TP";  //$NON-NLS-1$
	public static final String MNEMONIC_TRAILING = "trailing";  //$NON-NLS-1$
	public static final String MNEMONIC_TRUNC = "trunc";  //$NON-NLS-1$
	public static final String MNEMONIC_TWOPHASE = "twoPhase";  //$NON-NLS-1$
	public static final String MNEMONIC_TYPE1 = "type1";  //$NON-NLS-1$
	public static final String MNEMONIC_TYPE2 = "type2";  //$NON-NLS-1$
	public static final String MNEMONIC_UIFORM = "uiForm";  //$NON-NLS-1$
	public static final String MNEMONIC_UNDERLINE = "underline";  //$NON-NLS-1$
	public static final String MNEMONIC_UNIQUE = "unique";  //$NON-NLS-1$
	public static final String MNEMONIC_UNPROTECT = "unprotect";  //$NON-NLS-1$
	public static final String MNEMONIC_UPPER = "upper";  //$NON-NLS-1$
	public static final String MNEMONIC_USADATEFORMAT = "usaDateFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_USATIMEFORMAT = "usaTimeFormat";  //$NON-NLS-1$
	public static final String MNEMONIC_USS = "uss";  //$NON-NLS-1$
	public static final String MNEMONIC_VALUE = "value";  //$NON-NLS-1$
	public static final String MNEMONIC_VSEBATCH = "vsebatch";  //$NON-NLS-1$
	public static final String MNEMONIC_VSECICS = "vsecics";  //$NON-NLS-1$
	public static final String MNEMONIC_WHITE = "white";  //$NON-NLS-1$
	public static final String MNEMONIC_WIN = "win";  //$NON-NLS-1$
	public static final String MNEMONIC_WORD = "word";  //$NON-NLS-1$
	public static final String MNEMONIC_XML = "xml";  //$NON-NLS-1$
	public static final String MNEMONIC_YELLOW = "yellow";  //$NON-NLS-1$
	public static final String MNEMONIC_YES = "yes";  //$NON-NLS-1$
	public static final String MNEMONIC_ZOSBATCH = "zosbatch";  //$NON-NLS-1$
	public static final String MNEMONIC_ZOSCICS = "zoscics";  //$NON-NLS-1$
	public static final String MNEMONIC_JSON = "json";  //$NON-NLS-1$


	//EGL SQL keywords
	//Generated :  Wed Jun 15 10:08:01 EDT 2005
	//These keywords should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLSQLKeywordTool
	public static final String SQLKEYWORD_ABSOLUTE = "absolute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ACTION = "action";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ADD = "add";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALIAS = "alias";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALL = "all";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALLOCATE = "allocate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ALTER = "alter";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AND = "and";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ANY = "any";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ARE = "are";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AS = "as";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ASC = "asc";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ASSERTION = "assertion";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AT = "at";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AUTHORIZATION = "authorization";  //$NON-NLS-1$
	public static final String SQLKEYWORD_AVG = "avg";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BEGIN = "begin";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BETWEEN = "between";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BIGINT = "bigint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BINARYLARGEOBJECT = "binaryLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BIT = "bit";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BIT_LENGTH = "bit_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BLOB = "blob";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BOOLEAN = "boolean";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BOTH = "both";  //$NON-NLS-1$
	public static final String SQLKEYWORD_BY = "by";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CALL = "call";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CASCADE = "cascade";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CASCADED = "cascaded";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CASE = "case";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CAST = "cast";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CATALOG = "catalog";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHAR = "char";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHAR_LENGTH = "char_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTER = "character";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTER_LENGTH = "character_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTERLARGEOBJECT = "characterLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARACTERVARYING = "characterVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARLARGEOBJECT = "charLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHARVARYING = "charVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CHECK = "check";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CLOB = "clob";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CLOSE = "close";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COALESCE = "coalesce";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COLLATE = "collate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COLLATION = "collation";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COLUMN = "column";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COMMENT = "comment";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COMMIT = "commit";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONNECT = "connect";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONNECTION = "connection";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONSTRAINT = "constraint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONSTRAINTS = "constraints";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONTINUE = "continue";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CONVERT = "convert";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COPY = "copy";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CORRESPONDING = "corresponding";  //$NON-NLS-1$
	public static final String SQLKEYWORD_COUNT = "count";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CREATE = "create";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CROSS = "cross";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT = "current";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_DATE = "current_date";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_TIME = "current_time";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_TIMESTAMP = "current_timestamp";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURRENT_USER = "current_user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_CURSOR = "cursor";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATA = "data";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATABASE = "database";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATE = "date";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DATETIME = "dateTime";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DAY = "day";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEALLOCATE = "deallocate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEC = "dec";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DECIMAL = "decimal";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DECLARE = "declare";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEFAULT = "default";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEFERRABLE = "deferrable";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DEFERRED = "deferred";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DELETE = "delete";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DESC = "desc";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DESCRIBE = "describe";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DIAGNOSTICS = "diagnostics";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DISCONNECT = "disconnect";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DISTINCT = "distinct";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DOMAIN = "domain";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DOUBLE = "double";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DOUBLEPRECISION = "doublePrecision";  //$NON-NLS-1$
	public static final String SQLKEYWORD_DROP = "drop";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ELSE = "else";  //$NON-NLS-1$
	public static final String SQLKEYWORD_END = "end";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ENDEXEC = "endExec";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ESCAPE = "escape";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXCEPT = "except";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXCEPTION = "exception";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXEC = "exec";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXECUTE = "execute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXISTS = "exists";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXPLAIN = "explain";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXTERNAL = "external";  //$NON-NLS-1$
	public static final String SQLKEYWORD_EXTRACT = "extract";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FALSE = "false";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FETCH = "fetch";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FIRST = "first";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FLOAT = "float";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FOR = "for";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FOREIGN = "foreign";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FOUND = "found";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FROM = "from";  //$NON-NLS-1$
	public static final String SQLKEYWORD_FULL = "full";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GET = "get";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GETCURRENTCONNECTION = "getCurrentConnection";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GLOBAL = "global";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GO = "go";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GOTO = "goto";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GRANT = "grant";  //$NON-NLS-1$
	public static final String SQLKEYWORD_GROUP = "group";  //$NON-NLS-1$
	public static final String SQLKEYWORD_HAVING = "having";  //$NON-NLS-1$
	public static final String SQLKEYWORD_HOUR = "hour";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IDENTITY = "identity";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IMAGE = "image";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IMMEDIATE = "immediate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IN = "in";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INDEX = "index";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INDICATOR = "indicator";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INITIALLY = "initially";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INNER = "inner";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INPUT = "input";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INSENSITIVE = "insensitive";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INSERT = "insert";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INT = "int";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INTEGER = "integer";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INTERSECT = "intersect";  //$NON-NLS-1$
	public static final String SQLKEYWORD_INTO = "into";  //$NON-NLS-1$
	public static final String SQLKEYWORD_IS = "is";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ISOLATION = "isolation";  //$NON-NLS-1$
	public static final String SQLKEYWORD_JOIN = "join";  //$NON-NLS-1$
	public static final String SQLKEYWORD_KEY = "key";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LANGUAGE = "language";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LAST = "last";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LEADING = "leading";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LEFT = "left";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LEVEL = "level";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LIKE = "like";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LOCAL = "local";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LONG = "long";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LONGINT = "longint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LOWER = "lower";  //$NON-NLS-1$
	public static final String SQLKEYWORD_LTRIM = "ltrim";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MATCH = "match";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MAX = "max";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MIN = "min";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MINUTE = "minute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MODULE = "module";  //$NON-NLS-1$
	public static final String SQLKEYWORD_MONTH = "month";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONAL = "national";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARACTER = "nationalCharacter";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARACTERLARGEOBJECT = "nationalCharacterLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARACTERVARYING = "nationalCharacterVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARLARGEOBJECT = "nationalCharLargeObject";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATIONALCHARVARYING = "nationalCharVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NATURAL = "natural";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NCHAR = "nchar";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NCHARVARYING = "ncharVarying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NCLOB = "nclob";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NEXT = "next";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NO = "no";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NOT = "not";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NULL = "null";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NULLIF = "nullIf";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NUMBER = "number";  //$NON-NLS-1$
	public static final String SQLKEYWORD_NUMERIC = "numeric";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OCTET_LENGTH = "octet_length";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OF = "of";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ON = "on";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ONLY = "only";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OPEN = "open";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OPTION = "option";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OR = "or";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ORDER = "order";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OUTER = "outer";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OUTPUT = "output";  //$NON-NLS-1$
	public static final String SQLKEYWORD_OVERLAPS = "overlaps";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PAD = "pad";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PARTIAL = "partial";  //$NON-NLS-1$
	public static final String SQLKEYWORD_POSITION = "position";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PREPARE = "prepare";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRESERVE = "preserve";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRIMARY = "primary";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRIOR = "prior";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PRIVILEGES = "privileges";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PROCEDURE = "procedure";  //$NON-NLS-1$
	public static final String SQLKEYWORD_PUBLIC = "public";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RAW = "raw";  //$NON-NLS-1$
	public static final String SQLKEYWORD_READ = "read";  //$NON-NLS-1$
	public static final String SQLKEYWORD_REAL = "real";  //$NON-NLS-1$
	public static final String SQLKEYWORD_REFERENCES = "references";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RELATIVE = "relative";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RESTRICT = "restrict";  //$NON-NLS-1$
	public static final String SQLKEYWORD_REVOKE = "revoke";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RIGHT = "right";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ROLLBACK = "rollback";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ROWS = "rows";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RTRIM = "rtrim";  //$NON-NLS-1$
	public static final String SQLKEYWORD_RUNTIMESTATISTICS = "runtimeStatistics";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SCHEMA = "schema";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SCROLL = "scroll";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SECOND = "second";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SECTION = "section";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SELECT = "select";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SESSION = "session";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SESSION_USER = "session_user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SET = "set";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SIGNAL = "signal";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SIZE = "size";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SMALLINT = "smallint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SOME = "some";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SPACE = "space";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQL = "sql";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLCONDITION = "sqlCondition";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLCODE = "sqlcode";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLERROR = "sqlerror";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SQLSTATE = "sqlstate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SUBSTR = "substr";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SUBSTRING = "substring";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SUM = "sum";  //$NON-NLS-1$
	public static final String SQLKEYWORD_SYSTEM_USER = "system_user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TABLE = "table";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TABLESPACE = "tablespace";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TEMPORARY = "temporary";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TERMINATE = "terminate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_THEN = "then";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIME = "time";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIMESTAMP = "timestamp";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIMEZONE_HOUR = "timezone_hour";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TIMEZONE_MINUTE = "timezone_minute";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TINYINT = "tinyint";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TO = "to";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRAILING = "trailing";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRANSACTION = "transaction";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRANSLATE = "translate";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRANSLATION = "translation";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRIM = "trim";  //$NON-NLS-1$
	public static final String SQLKEYWORD_TRUE = "true";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNCATALOG = "uncatalog";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNION = "union";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNIQUE = "unique";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UNKNOWN = "unknown";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UPDATE = "update";  //$NON-NLS-1$
	public static final String SQLKEYWORD_UPPER = "upper";  //$NON-NLS-1$
	public static final String SQLKEYWORD_USAGE = "usage";  //$NON-NLS-1$
	public static final String SQLKEYWORD_USER = "user";  //$NON-NLS-1$
	public static final String SQLKEYWORD_USING = "using";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VALUES = "values";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARBINARY = "varbinary";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARCHAR = "varchar";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARCHAR2 = "varchar2";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VARYING = "varying";  //$NON-NLS-1$
	public static final String SQLKEYWORD_VIEW = "view";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WHEN = "when";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WHENEVER = "whenever";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WHERE = "where";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WITH = "with";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WORK = "work";  //$NON-NLS-1$
	public static final String SQLKEYWORD_WRITE = "write";  //$NON-NLS-1$
	public static final String SQLKEYWORD_YEAR = "year";  //$NON-NLS-1$
	public static final String SQLKEYWORD_ZONE = "zone";  //$NON-NLS-1$
	
	//EGL system words
	//Generated :  Wed Mar 23 15:00:56 EST 2005
	//These system words should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLSystemWordTool
	public static final String SYSTEM_WORD_STORENEW = "StoreNew";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ABS = "abs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACOS = "acos";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVATEWINDOW = "activateWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVATEWINDOWBYNAME = "activateWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVEFORM = "activeForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ACTIVEWINDOW = "activeWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ADDREPORTDATA = "addReportData";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ADDREPORTPARAMETER = "addReportParameter";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_APPENDALL = "appendAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_APPENDELEMENT = "appendElement";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ARRAYINDEX = "arrayIndex";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ASIN = "asin";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATAN = "atan";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATAN2 = "atan2";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHBLOBTOFILE = "attachBlobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHBLOBTOTEMPFILE = "attachBlobToTempFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHCLOBTOFILE = "attachClobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ATTACHCLOBTOTEMPFILE = "attachClobToTempFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_AUDIT = "audit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_BEGINDATABASETRANSACTION = "beginDatabaseTransaction";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_BYTES = "bytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALCULATECHKDIGITMOD10 = "calculateChkDigitMod10";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALCULATECHKDIGITMOD11 = "calculateChkDigitMod11";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALLCMD = "callCmd";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CALLCONVERSIONTABLE = "callConversionTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CANCELARRAYDELETE = "cancelArrayDelete";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CANCELARRAYINSERT = "cancelArrayInsert";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CEILING = "ceiling";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CHARACTERASINT = "characterAsInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CICSCONDITION = "cicsCondition";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CICSERROR = "cicsError";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CICSRESTART = "cicsRestart";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARACTIVEFORM = "clearActiveForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARACTIVEWINDOW = "clearActiveWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARFIELDS = "clearFields";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARFIELDSBYNAME = "clearFieldsByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARFORM = "clearForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARREQUESTATTR = "clearRequestAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARSCREEN = "clearScreen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARSESSIONATTR = "clearSessionAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARWINDOW = "clearWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLEARWINDOWBYNAME = "clearWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLIP = "clip";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLOSEACTIVEWINDOW = "closeActiveWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLOSEWINDOW = "closeWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CLOSEWINDOWBYNAME = "closeWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMMENTLINE = "commentLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMMIT = "commit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMMITONCONVERSE = "commitOnConverse";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMPAREBYTES = "compareBytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMPARENUM = "compareNum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COMPARESTR = "compareStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONCATENATE = "concatenate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONCATENATEBYTES = "concatenateBytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONCATENATEWITHSEPARATOR = "concatenateWithSeparator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONDITIONASINT = "conditionAsInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONNECT = "connect";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONNECTIONSERVICE = "connectionService";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONTAINSKEY = "containsKey";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONVERSATIONID = "conversationId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CONVERT = "convert";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COPYBYTES = "copyBytes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COPYSTR = "copyStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COS = "cos";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_COSH = "cosh";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTARRAYCOUNT = "currentArrayCount";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTARRAYDATALINE = "currentArrayDataLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTARRAYSCREENLINE = "currentArrayScreenLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTDATE = "currentDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTDISPLAYATTRS = "currentDisplayAttrs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTEXCEPTION = "currentException";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTFORMATTEDGREGORIANDATE = "currentFormattedGregorianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTFORMATTEDJULIANDATE = "currentFormattedJulianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTFORMATTEDTIME = "currentFormattedTime";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTGREGORIANDATE = "currentGregorianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTJULIANDATE = "currentJulianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTROWATTRS = "currentRowAttrs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTSHORTGREGORIANDATE = "currentShortGregorianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTSHORTJULIANDATE = "currentShortJulianDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTTIME = "currentTime";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURRENTTIMESTAMP = "currentTimeStamp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_CURSORWRAP = "cursorWrap";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEOF = "dateOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEVALUE = "dateValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEVALUEFROMGREGORIAN = "dateValueFromGregorian";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DATEVALUEFROMJULIAN = "dateValueFromJulian";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DAYOF = "dayOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DB2TIMESTAMPFORMAT = "db2TimeStampFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DBNAME = "dbName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTDATEFORMAT = "defaultDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTDISPLAYATTRIBUTES = "defaultDisplayAttributes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTINPUTATTRIBUTES = "defaultInputAttributes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTMONEYFORMAT = "defaultMoneyFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTNUMERICFORMAT = "defaultNumericFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTTIMEFORMAT = "defaultTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFAULTTIMESTAMPFORMAT = "defaultTimeStampFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFERINTERRUPT = "deferInterrupt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFERQUIT = "deferQuit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFINEDATABASEALIAS = "defineDatabaseAlias";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DEFINEDFIELDORDER = "definedFieldOrder";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISCONNECT = "disconnect";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISCONNECTALL = "disconnectAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYATLINE = "displayAtLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYATPOSITION = "displayAtPosition";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYERROR = "displayError";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFIELDS = "displayFields";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFIELDSBYNAME = "displayFieldsByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFORM = "displayForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYFORMBYNAME = "displayFormByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYLINEMODE = "displayLineMode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYMESSAGE = "displayMessage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DISPLAYMSGNUM = "displayMsgNum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DRAWBOX = "drawBox";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_DRAWBOXWITHCOLOR = "drawBoxWithColor";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORCODE = "errorCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORLINE = "errorLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORLOG = "errorLog";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORWINDOW = "errorWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ERRORWINDOWVISIBLE = "errorWindowVisible";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EURDATEFORMAT = "eurDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EURTIMEFORMAT = "eurTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EVENTKEY = "eventKey";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EXP = "exp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EXPORTREPORT = "exportReport";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_EXTEND = "extend";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FIELDINPUTLENGTH = "fieldInputLength";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FILLREPORT = "fillReport";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FINDSTR = "findStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGASSIGN = "floatingAssign";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGDIFFERENCE = "floatingDifference";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGMOD = "floatingMod";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGPRODUCT = "floatingProduct";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGQUOTIENT = "floatingQuotient";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOATINGSUM = "floatingSum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FLOOR = "floor";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMCONVERSIONTABLE = "formConversionTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMLINE = "formLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATDATE = "formatDate";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATNUMBER = "formatNumber";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATTIME = "formatTime";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FORMATTIMESTAMP = "formatTimeStamp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FREEBLOB = "freeBlob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FREECLOB = "freeClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_FREXP = "frexp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETBLOBLEN = "getBlobLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETCLOBLEN = "getClobLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETCMDLINEARG = "getCmdLineArg";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETCMDLINEARGCOUNT = "getCmdLineArgCount";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETDATACOLUMNBINDING = "getDataColumnBinding";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETFIELD = "getField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETFIELDVALUE = "getFieldValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEY = "getKey";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEYCODE = "getKeyCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEYNAME = "getKeyName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETKEYS = "getKeys";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETMAXSIZE = "getMaxSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETMESSAGE = "getMessage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETNEXTTOKEN = "getNextToken";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETPROPERTY = "getProperty";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREPORTDATA = "getReportData";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREPORTPARAMETER = "getReportParameter";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREPORTVARIABLEVALUE = "getReportVariableValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETREQUESTATTR = "getRequestAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSESSIONATTR = "getSessionAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSIZE = "getSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSTRFROMCLOB = "getStrFromClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETSUBSTRFROMCLOB = "getSubStrFromClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETTCPIPLOCATION = "getTCPIPLocation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETVAGSYSTYPE = "getVAGSysType";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETVALUES = "getValues";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GETWEBENDPOINT = "getWebEndpoint";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOFIELD = "gotoField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOFIELDBYNAME = "gotoFieldByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOMENUITEM = "gotoMenuItem";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_GOTOMENUITEMBYNAME = "gotoMenuItemByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HANDLEHARDIOERRORS = "handleHardIOErrors";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HANDLEOVERFLOW = "handleOverflow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HANDLESYSLIBRARYERRORS = "handleSysLibraryErrors";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEALLMENUITEMS = "hideAllMenuItems";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEERRORWINDOW = "hideErrorWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEMENUITEM = "hideMenuItem";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_HIDEMENUITEMBYNAME = "hideMenuItemByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INSERTALL = "insertAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INSERTELEMENT = "insertElement";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTEGERASCHAR = "integerAsChar";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTERRUPTREQUESTED = "interruptRequested";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTERVALVALUE = "intervalValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INTERVALVALUEWITHPATTERN = "intervalValueWithPattern";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_INVOKE = "invoke";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISCURRENTFIELD = "isCurrentField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISCURRENTFIELDBYNAME = "isCurrentFieldByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISFIELDMODIFIED = "isFieldModified";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISFIELDMODIFIEDBYNAME = "isFieldModifiedByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISNULL = "isNull";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISOBJID = "isObjId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISODATEFORMAT = "isoDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ISOTIMEFORMAT = "isoTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_JISDATEFORMAT = "jisDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_JISTIMEFORMAT = "jisTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEYAREA = "keyArea";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEYAREAHEX = "keyAreaHex";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEYAREALEN = "keyAreaLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_ACCEPT = "key_accept";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_DELETELINE = "key_deleteLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_HELP = "key_help";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_INSERTLINE = "key_insertLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_INTERRUPT = "key_interrupt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_PAGEDOWN = "key_pageDown";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_PAGEUP = "key_pageUp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_KEY_QUIT = "key_quit";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LASTKEYTYPED = "lastKeyTyped";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LDEXP = "ldexp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOADBLOBFROMFILE = "loadBlobFromFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOADCLOBFROMFILE = "loadClobFromFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOADTABLE = "loadTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOG = "log";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOG10 = "log10";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_LOWERCASE = "lowerCase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MAXIMUM = "maximum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MAXIMUMSIZE = "maximumSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MDY = "mdy";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MENULINE = "menuLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MESSAGELINE = "messageLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MESSAGERESOURCE = "messageResource";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MINIMUM = "minimum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MODF = "modf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MONTHOF = "monthOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_MQCONDITIONCODE = "mqConditionCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_NEXTFIELD = "nextField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_NUMSENSITIVESEGS = "numSensitiveSegs";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ODBCTIMESTAMPFORMAT = "odbcTimeStampFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOW = "openWindow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOWBYNAME = "openWindowByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOWWITHFORM = "openWindowWithForm";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OPENWINDOWWITHFORMBYNAME = "openWindowWithFormByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_OVERFLOWINDICATOR = "overflowIndicator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PAGEEJECT = "pageEject";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_POW = "pow";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PRECISION = "precision";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PREVIOUSFIELD = "previousField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PRINTERASSOCIATION = "printerAssociation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PROCOPTIONS = "procOptions";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PROMPTLINE = "promptLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PROMPTLINEMODE = "promptLineMode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_PURGE = "purge";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_QUALIFIEDTYPENAME = "qualifiedTypeName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_QUERYCURRENTDATABASE = "queryCurrentDatabase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_QUITREQUESTED = "quitRequested";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOTESYSTEMID = "remoteSystemId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOVE = "remove";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOVEALL = "removeAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_REMOVEELEMENT = "removeElement";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESETREPORTPARAMETERS = "resetReportParameters";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESIZE = "resize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESIZEALL = "resizeAll";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RESOURCEASSOCIATION = "resourceAssociation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_RETURNCODE = "returnCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ROLLBACK = "rollback";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_ROUND = "round";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCREEN = "screen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLDOWNLINES = "scrollDownLines";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLDOWNPAGE = "scrollDownPage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLUPLINES = "scrollUpLines";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SCROLLUPPAGE = "scrollUpPage";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SEGMENTLEVEL = "segmentLevel";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SEGMENTNAME = "segmentName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SEGMENTEDMODE = "segmentedMode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SESSIONID = "sessionId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETARRAYLINE = "setArrayLine";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETBLANKTERMINATOR = "setBlankTerminator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCLOBFROMSTRING = "setClobFromString";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCLOBFROMSTRINGATPOSITION = "setClobFromStringAtPosition";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCURRENTARRAYCOUNT = "setCurrentArrayCount";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETCURRENTDATABASE = "setCurrentDatabase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETELEMENTSEMPTY = "setElementsEmpty";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETERROR = "setError";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETFIELD = "setField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETLOCALE = "setLocale";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETMAXSIZE = "setMaxSize";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETMAXSIZES = "setMaxSizes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETNULLTERMINATOR = "setNullTerminator";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETREMOTEUSER = "setRemoteUser";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETREPORTVARIABLEVALUE = "setReportVariableValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETREQUESTATTR = "setRequestAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETSESSIONATTR = "setSessionAttr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETSUBSTR = "setSubStr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETTCPIPLOCATION = "setTCPIPLocation";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SETWEBENDPOINT = "setWebEndpoint";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWALLMENUITEMS = "showAllMenuItems";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWHELP = "showHelp";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWMENUITEM = "showMenuItem";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SHOWMENUITEMBYNAME = "showMenuItemByName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SIN = "sin";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SINH = "sinh";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SIZE = "size";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SPACES = "spaces";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLINTERRUPT = "sqlInterrupt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLISOLATIONLEVEL = "sqlIsolationLevel";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLSTATE = "sqlState";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLCA = "sqlca";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLCODE = "sqlcode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLERRD = "sqlerrd";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLERRMC = "sqlerrmc";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQLWARN = "sqlwarn";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SQRT = "sqrt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STARTCMD = "startCmd";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STARTLOG = "startLog";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STARTTRANSACTION = "startTransaction";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STATUSCODE = "statusCode";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STORE = "store";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STORECOPY = "storeCopy";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STOREFIELD = "storeField";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRLEN = "strLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRINGASDECIMAL = "stringAsDecimal";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRINGASFLOAT = "stringAsFloat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_STRINGASINT = "stringAsInt";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SYSTEMGREGORIANDATEFORMAT = "systemGregorianDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SYSTEMJULIANDATEFORMAT = "systemJulianDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_SYSTEMTYPE = "systemType";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TAN = "tan";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TANH = "tanh";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TERMINALID = "terminalId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TEXTLEN = "textLen";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMEOF = "timeOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMESTAMPVALUE = "timeStampValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMESTAMPVALUEWITHPATTERN = "timeStampValueWithPattern";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMEVALUE = "timeValue";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TIMESTAMPFROM = "timestampFrom";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRANSACTIONID = "transactionId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRANSFERNAME = "transferName";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRUNCATEBLOB = "truncateBlob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_TRUNCATECLOB = "truncateClob";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UNLOADTABLE = "unloadTable";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPDATEBLOBTOFILE = "updateBlobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPDATECLOBTOFILE = "updateClobToFile";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPDATEWINDOWATTRIBUTES = "updateWindowAttributes";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_UPPERCASE = "upperCase";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_USADATEFORMAT = "usaDateFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_USATIMEFORMAT = "usaTimeFormat";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_USERID = "userId";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VALIDATIONFAILED = "validationFailed";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VALIDATIONMSGNUM = "validationMsgNum";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VERIFYCHKDIGITMOD10 = "verifyChkDigitMod10";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_VERIFYCHKDIGITMOD11 = "verifyChkDigitMod11";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WAIT = "wait";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WEEKDAYOF = "weekdayOf";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WRITESTDOUT = "writeStdout";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_WRITESTDERR = "writeStderr";	//$NON-NLS-1$
	public static final String SYSTEM_WORD_YEAROF = "yearOf";	//$NON-NLS-1$





	//EGL properties
	//Generated :  Thu Sep 14 15:03:20 EDT 2006
	//These properties should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLPropertiesTool
	public static final String PROPERTY_ACTION = "action";  //$NON-NLS-1$
	public static final String PROPERTY_ADDSPACEFORSOSI = "addSpaceForSOSI";  //$NON-NLS-1$
	public static final String PROPERTY_ALIAS = "alias";  //$NON-NLS-1$
	public static final String PROPERTY_ALIGN = "align";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWAPPEND = "allowAppend";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWDELETE = "allowDelete";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWINSERT = "allowInsert";  //$NON-NLS-1$
	public static final String PROPERTY_ALLOWUNQUALIFIEDITEMREFERENCES = "allowUnqualifiedItemReferences";  //$NON-NLS-1$
	public static final String PROPERTY_BASE = "base";  //$NON-NLS-1$
	public static final String PROPERTY_BINDING = "binding";  //$NON-NLS-1$
	public static final String PROPERTY_BINDINGBYNAME = "bindingByName";  //$NON-NLS-1$
	public static final String PROPERTY_BOTTOMMARGIN = "bottomMargin";  //$NON-NLS-1$
	public static final String PROPERTY_BOUNDS = "bounds";  //$NON-NLS-1$
	public static final String PROPERTY_BYPASSVALIDATION = "bypassValidation";  //$NON-NLS-1$
	public static final String PROPERTY_CALLINGCONVENTION = "callingConvention";  //$NON-NLS-1$
	public static final String PROPERTY_CALLINTERFACE = "callInterface";  //$NON-NLS-1$
	public static final String PROPERTY_CANCELONPAGETRANSITION = "cancelOnPageTransition";  //$NON-NLS-1$
	public static final String PROPERTY_CASESENSITIVE = "caseSensitive";  //$NON-NLS-1$
	public static final String PROPERTY_COLOR = "color";  //$NON-NLS-1$
	public static final String PROPERTY_COLUMN = "column";  //$NON-NLS-1$
	public static final String PROPERTY_COLUMNS = "columns";  //$NON-NLS-1$
	public static final String PROPERTY_COMMANDVALUEITEM = "commandValueItem";  //$NON-NLS-1$
	public static final String PROPERTY_COMMTYPE = "commType";  //$NON-NLS-1$
	public static final String PROPERTY_CONNECTIONNAME = "connectionName";  //$NON-NLS-1$
	public static final String PROPERTY_CONTAINERCONTEXTDEPENDENT = "containerContextDependent";  //$NON-NLS-1$
	public static final String PROPERTY_CONTENTS = "contents";  //$NON-NLS-1$
	public static final String PROPERTY_CURRENCY = "currency";  //$NON-NLS-1$
	public static final String PROPERTY_CURRENCYSYMBOL = "currencySymbol";  //$NON-NLS-1$
	public static final String PROPERTY_CURRENTARRAYCOUNT = "currentArrayCount";  //$NON-NLS-1$
	public static final String PROPERTY_CURSOR = "cursor";  //$NON-NLS-1$
	public static final String PROPERTY_DATA = "data";  //$NON-NLS-1$
	public static final String PROPERTY_DATATYPE = "dataType";  //$NON-NLS-1$
	public static final String PROPERTY_DATEFORMAT = "dateFormat";  //$NON-NLS-1$
	public static final String PROPERTY_DEBUGIMPL = "debugImpl";  //$NON-NLS-1$
	public static final String PROPERTY_DEFAULTSELECTCONDITION = "defaultSelectCondition";  //$NON-NLS-1$
	public static final String PROPERTY_DELETEAFTERUSE = "deleteAfterUse";  //$NON-NLS-1$
	public static final String PROPERTY_DELIMITERS = "delimiters";  //$NON-NLS-1$
	public static final String PROPERTY_DETECTABLE = "detectable";  //$NON-NLS-1$
	public static final String PROPERTY_DEVICETYPE = "deviceType";  //$NON-NLS-1$
	public static final String PROPERTY_DISPLAYNAME = "displayName";  //$NON-NLS-1$
	public static final String PROPERTY_DISPLAYONLY = "displayOnly";  //$NON-NLS-1$
	public static final String PROPERTY_DISPLAYUSE = "displayUse";  //$NON-NLS-1$
	public static final String PROPERTY_DLLNAME = "dllName";  //$NON-NLS-1$
	public static final String PROPERTY_EGLBINDING = "eglBinding";  //$NON-NLS-1$
	public static final String PROPERTY_ELEMENTNAME = "elementName";  //$NON-NLS-1$
	public static final String PROPERTY_ENDPOINT = "endpoint";  //$NON-NLS-1$
	public static final String PROPERTY_ENUMERATION = "enumeration";  //$NON-NLS-1$
	public static final String PROPERTY_EVENTVALUEITEM = "eventValueItem";  //$NON-NLS-1$
	public static final String PROPERTY_FIELDLEN = "fieldLen";  //$NON-NLS-1$
	public static final String PROPERTY_FIELDSMATCHCOLUMNS = "fieldsMatchColumns";  //$NON-NLS-1$
	public static final String PROPERTY_FILENAME = "fileName";  //$NON-NLS-1$
	public static final String PROPERTY_FILL = "fill";  //$NON-NLS-1$
	public static final String PROPERTY_FILLCHARACTER = "fillCharacter";  //$NON-NLS-1$
	public static final String PROPERTY_FORMSIZE = "formSize";  //$NON-NLS-1$
	public static final String PROPERTY_GETINPARENT = "getInParent";  //$NON-NLS-1$
	public static final String PROPERTY_GETOPTIONSRECORD = "getOptionsRecord";  //$NON-NLS-1$
	public static final String PROPERTY_HANDLEHARDIOERRORS = "handleHardIOErrors";  //$NON-NLS-1$
	public static final String PROPERTY_HASCOMMENT = "hasComment";  //$NON-NLS-1$
	public static final String PROPERTY_HELP = "help";  //$NON-NLS-1$
	public static final String PROPERTY_HELPFORM = "helpForm";  //$NON-NLS-1$
	public static final String PROPERTY_HELPGROUP = "helpGroup";  //$NON-NLS-1$
	public static final String PROPERTY_HELPKEY = "helpKey";  //$NON-NLS-1$
	public static final String PROPERTY_HELPMSGKEY = "helpMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_HIERARCHY = "hierarchy";  //$NON-NLS-1$
	public static final String PROPERTY_HIGHLIGHT = "highlight";  //$NON-NLS-1$
	public static final String PROPERTY_HOSTVARQUALIFIER = "hostVarQualifier";  //$NON-NLS-1$
	public static final String PROPERTY_INCLUDEMSGINTRANSACTION = "includeMsgInTransaction";  //$NON-NLS-1$
	public static final String PROPERTY_INCLUDEREFERENCEDFUNCTIONS = "includeReferencedFunctions";  //$NON-NLS-1$
	public static final String PROPERTY_INDEXORIENTATION = "indexOrientation";  //$NON-NLS-1$
	public static final String PROPERTY_INITIALIZED = "initialized";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTFORM = "inputForm";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTUIRECORD = "inputUIRecord";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTRECORD = "inputRecord";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTREQUIRED = "inputRequired";  //$NON-NLS-1$
	public static final String PROPERTY_INPUTREQUIREDMSGKEY = "inputRequiredMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_INTENSITY = "intensity";  //$NON-NLS-1$
	public static final String PROPERTY_ISBOOLEAN = "isBoolean";  //$NON-NLS-1$
	public static final String PROPERTY_ISCONSTRUCT = "isConstruct";  //$NON-NLS-1$
	public static final String PROPERTY_ISDECIMALDIGIT = "isDecimalDigit";  //$NON-NLS-1$
	public static final String PROPERTY_ISHEXDIGIT = "isHexDigit";  //$NON-NLS-1$
	public static final String PROPERTY_ISLASTPARAMRETURNVALUE = "isLastParamReturnValue";  //$NON-NLS-1$
	public static final String PROPERTY_ISREADONLY = "isReadOnly";  //$NON-NLS-1$
	public static final String PROPERTY_JAVANAME = "javaName";  //$NON-NLS-1$
	public static final String PROPERTY_KEYITEM = "keyItem";  //$NON-NLS-1$
	public static final String PROPERTY_KEYITEMS = "keyItems";  //$NON-NLS-1$
	public static final String PROPERTY_LABELANDHELPRESOURCE = "labelAndHelpResource";  //$NON-NLS-1$
	public static final String PROPERTY_LEFTMARGIN = "leftMargin";  //$NON-NLS-1$
	public static final String PROPERTY_LENGTHITEM = "lengthItem";  //$NON-NLS-1$
	public static final String PROPERTY_LINESBETWEENROWS = "linesBetweenRows";  //$NON-NLS-1$
	public static final String PROPERTY_LINEWRAP = "lineWrap";  //$NON-NLS-1$
	public static final String PROPERTY_LINKPARMS = "linkParms";  //$NON-NLS-1$
	public static final String PROPERTY_LINKPARAMETER = "linkParameter";  //$NON-NLS-1$
	public static final String PROPERTY_LOCALSQLSCOPE = "localSQLScope";  //$NON-NLS-1$
	public static final String PROPERTY_LOWERCASE = "lowerCase";  //$NON-NLS-1$
	public static final String PROPERTY_MASKED = "masked";  //$NON-NLS-1$
	public static final String PROPERTY_MAXARRAYCOUNT = "maxArrayCount";  //$NON-NLS-1$
	public static final String PROPERTY_MAXINCLUSIVE = "maxInclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MAXEXCLUSIVE = "maxExclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MAXLENGTH = "maxLength";  //$NON-NLS-1$
	public static final String PROPERTY_MAXLEN = "maxLen";  //$NON-NLS-1$
	public static final String PROPERTY_MAXSIZE = "maxSize";  //$NON-NLS-1$
	public static final String PROPERTY_MINEXCLUSIVE = "minExclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MININCLUSIVE = "minInclusive";  //$NON-NLS-1$
	public static final String PROPERTY_MINLENGTH = "minLength";  //$NON-NLS-1$
	public static final String PROPERTY_MINIMUMINPUT = "minimumInput";  //$NON-NLS-1$
	public static final String PROPERTY_MINIMUMINPUTMSGKEY = "minimumInputMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_MODIFIED = "modified";  //$NON-NLS-1$
	public static final String PROPERTY_MSGDESCRIPTORRECORD = "msgDescriptorRecord";  //$NON-NLS-1$
	public static final String PROPERTY_MSGFIELD = "msgField";  //$NON-NLS-1$
	public static final String PROPERTY_MSGRESOURCE = "msgResource";  //$NON-NLS-1$
	public static final String PROPERTY_MSGTABLEPREFIX = "msgTablePrefix";  //$NON-NLS-1$
	public static final String PROPERTY_NAME = "name";  //$NON-NLS-1$
	public static final String PROPERTY_NAMESPACE = "namespace";  //$NON-NLS-1$
	public static final String PROPERTY_NEEDSSOSI = "needsSOSI";  //$NON-NLS-1$
	public static final String PROPERTY_NEWWINDOW = "newWindow";  //$NON-NLS-1$
	public static final String PROPERTY_NUMELEMENTSITEM = "numElementsItem";  //$NON-NLS-1$
	public static final String PROPERTY_NUMERICSEPARATOR = "numericSeparator";  //$NON-NLS-1$
	public static final String PROPERTY_ONCONSTRUCTIONFUNCTION = "onConstructionFunction";  //$NON-NLS-1$
	public static final String PROPERTY_ONEWAY = "oneway";  //$NON-NLS-1$
	public static final String PROPERTY_ONPRERENDERFUNCTION = "onPreRenderFunction";  //$NON-NLS-1$
	public static final String PROPERTY_ONVALUECHANGEFUNCTION = "onValueChangeFunction";  //$NON-NLS-1$
	public static final String PROPERTY_OPENOPTIONSRECORD = "openOptionsRecord";  //$NON-NLS-1$
	public static final String PROPERTY_OPENQUEUEEXCLUSIVE = "openQueueExclusive";  //$NON-NLS-1$
	public static final String PROPERTY_ORDERING = "ordering";  //$NON-NLS-1$
	public static final String PROPERTY_ORIENTINDEXACROSS = "orientIndexAcross";  //$NON-NLS-1$
	public static final String PROPERTY_OUTLINE = "outline";  //$NON-NLS-1$
	public static final String PROPERTY_PACKAGENAME = "packageName";  //$NON-NLS-1$
	public static final String PROPERTY_PAGESIZE = "pageSize";  //$NON-NLS-1$
	public static final String PROPERTY_PARENTRECORD = "parentRecord";  //$NON-NLS-1$
	public static final String PROPERTY_PATTERN = "pattern";  //$NON-NLS-1$
	public static final String PROPERTY_PERSISTENT = "persistent";  //$NON-NLS-1$
	public static final String PROPERTY_PFKEYEQUATE = "pfKeyEquate";  //$NON-NLS-1$
	public static final String PROPERTY_POSITION = "position";  //$NON-NLS-1$
	public static final String PROPERTY_PRINTFLOATINGAREA = "printFloatingArea";  //$NON-NLS-1$
	public static final String PROPERTY_PROGRAMLINKDATA = "programLinkData";  //$NON-NLS-1$
	public static final String PROPERTY_PROGRAMNAME = "programName";  //$NON-NLS-1$
	public static final String PROPERTY_PROMPT = "prompt";  //$NON-NLS-1$
	public static final String PROPERTY_PROTECT = "protect";  //$NON-NLS-1$
	public static final String PROPERTY_PUTOPTIONSRECORD = "putOptionsRecord";  //$NON-NLS-1$
	public static final String PROPERTY_QUEUEDESCRIPTORRECORD = "queueDescriptorRecord";  //$NON-NLS-1$
	public static final String PROPERTY_QUEUENAME = "queueName";  //$NON-NLS-1$
	public static final String PROPERTY_REDEFINES = "redefines";  //$NON-NLS-1$
	public static final String PROPERTY_RELATIONSHIP = "relationship";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTDESIGNFILE = "reportDesignFile";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTDESTINATIONFILE = "reportDestinationFile";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTEXPORTFILE = "reportExportFile";  //$NON-NLS-1$
	public static final String PROPERTY_REPORTDATA = "reportData";  //$NON-NLS-1$
	public static final String PROPERTY_RESIDENT = "resident";  //$NON-NLS-1$
	public static final String PROPERTY_RIGHTMARGIN = "rightMargin";  //$NON-NLS-1$
	public static final String PROPERTY_RUNVALIDATORFROMPROGRAM = "runValidatorFromProgram";  //$NON-NLS-1$
	public static final String PROPERTY_SCOPE = "scope";  //$NON-NLS-1$
	public static final String PROPERTY_SCREENFLOATINGAREA = "screenFloatingArea";  //$NON-NLS-1$
	public static final String PROPERTY_SCREENSIZE = "screenSize";  //$NON-NLS-1$
	public static final String PROPERTY_SCREENSIZES = "screenSizes";  //$NON-NLS-1$
	public static final String PROPERTY_SECONDARYINDEX = "secondaryIndex";  //$NON-NLS-1$
	public static final String PROPERTY_SECONDARYINDEXITEM = "secondaryIndexItem";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTED = "segmented";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTNAME = "segmentName";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTRECORD = "segmentRecord";  //$NON-NLS-1$
	public static final String PROPERTY_SEGMENTS = "segments";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTEDINDEXITEM = "selectedIndexItem";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTFROMLISTITEM = "selectFromListItem";  //$NON-NLS-1$
	public static final String PROPERTY_SELECTTYPE = "selectType";  //$NON-NLS-1$
	public static final String PROPERTY_SERVICENAME = "serviceName";  //$NON-NLS-1$
	public static final String PROPERTY_SERVICEPACKAGE = "servicePackage";  //$NON-NLS-1$
	public static final String PROPERTY_SERVICEALIAS = "serviceAlias";  //$NON-NLS-1$
	public static final String PROPERTY_SETINITIAL = "setInitial";  //$NON-NLS-1$
	public static final String PROPERTY_SHARED = "shared";  //$NON-NLS-1$
	public static final String PROPERTY_SHOWBRACKETS = "showBrackets";  //$NON-NLS-1$
	public static final String PROPERTY_SIGN = "sign";  //$NON-NLS-1$
	public static final String PROPERTY_SOSITAKEPOSITION = "SOSITakePosition";  //$NON-NLS-1$
	public static final String PROPERTY_SPACESBETWEENCOLUMNS = "spacesBetweenColumns";  //$NON-NLS-1$
	public static final String PROPERTY_SQLDATACODE = "sqlDataCode";  //$NON-NLS-1$
	public static final String PROPERTY_SQLSTATEMENT = "sqlStatement";  //$NON-NLS-1$
	public static final String PROPERTY_SQLVARIABLELEN = "sqlVariableLen";  //$NON-NLS-1$
	public static final String PROPERTY_TABLENAMEVARIABLES = "tableNameVariables";  //$NON-NLS-1$
	public static final String PROPERTY_TABLENAMES = "tableNames";  //$NON-NLS-1$
	public static final String PROPERTY_TCPIPLOCATION = "tcpipLocation";  //$NON-NLS-1$
	public static final String PROPERTY_THROWNRFEOFEXCEPTIONS = "throwNrfEofExceptions";  //$NON-NLS-1$
	public static final String PROPERTY_TIMEFORMAT = "timeFormat";  //$NON-NLS-1$
	public static final String PROPERTY_TIMESTAMPFORMAT = "timeStampFormat";  //$NON-NLS-1$
	public static final String PROPERTY_TITLE = "title";  //$NON-NLS-1$
	public static final String PROPERTY_TOPMARGIN = "topMargin";  //$NON-NLS-1$
	public static final String PROPERTY_TYPECHKMSGKEY = "typeChkMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_UIRECORDNAME = "uiRecordName";  //$NON-NLS-1$
	public static final String PROPERTY_UITYPE = "uiType";  //$NON-NLS-1$
	public static final String PROPERTY_UPPERCASE = "upperCase";  //$NON-NLS-1$
	public static final String PROPERTY_V60EXCEPTIONCOMPATIBILITY = "v60ExceptionCompatibility";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONBYPASSFUNCTIONS = "validationBypassFunctions";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONBYPASSKEYS = "validationBypassKeys";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATIONORDER = "validationOrder";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORDATATABLE = "validatorDataTable";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORDATATABLEMSGKEY = "validatorDataTableMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORFUNCTION = "validatorFunction";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDATORFUNCTIONMSGKEY = "validatorFunctionMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDVALUES = "validValues";  //$NON-NLS-1$
	public static final String PROPERTY_VALIDVALUESMSGKEY = "validValuesMsgKey";  //$NON-NLS-1$
	public static final String PROPERTY_VALUE = "value";  //$NON-NLS-1$
	public static final String PROPERTY_VALUEREF = "valueRef";  //$NON-NLS-1$
	public static final String PROPERTY_VERIFY = "verify";  //$NON-NLS-1$
	public static final String PROPERTY_VIEW = "view";  //$NON-NLS-1$
	public static final String PROPERTY_VIEWROOTVAR = "viewRootVar";  //$NON-NLS-1$
	public static final String PROPERTY_WEBBINDING = "webBinding";  //$NON-NLS-1$
	public static final String PROPERTY_WHITESPACE = "whitespace";  //$NON-NLS-1$
	public static final String PROPERTY_WSDLFILE = "wsdlFile";  //$NON-NLS-1$
	public static final String PROPERTY_WSDLPORT = "wsdlPort";  //$NON-NLS-1$
	public static final String PROPERTY_WSDLSERVICE = "wsdlService";  //$NON-NLS-1$
	public static final String PROPERTY_ZEROFORMAT = "zeroFormat";  //$NON-NLS-1$


	// END Generated words
	
//////////////////
//	 The following block of constants have not been generated.  
//	 They have been copied from DataItem in the old Generation Base Framework plugin.
//	 If a system word is added above, a constant needs to be added to the list below.
//////////////////	  
		
		// EGLTODO - need entries for sysvar.callConversionTable, sysvar.formConversionTable

		/////////
		// Special Function integer constants: Math Functions
		/////////
		public static final int math_functions_lower_bounds = 1;	
		public static final int Special_Function_Abs = 1;	
		public static final int Special_Function_Acos = 2;	
		public static final int Special_Function_Asin = 4;	
		public static final int Special_Function_Atan = 5;	
		public static final int Special_Function_Atan2 = 6;
		public static final int Special_Function_Ceil = 7;
		public static final int Special_Function_CompareNumbers = 8;
		public static final int Special_Function_Cos = 9;
		public static final int Special_Function_Cosh = 10;
		public static final int Special_Function_Exp = 11;
		public static final int Special_Function_FloatingAssign = 12;
		public static final int Special_Function_FloatingDifference = 13;
		public static final int Special_Function_FloatingMod = 14;
		public static final int Special_Function_FloatingProduct = 15;
		public static final int Special_Function_FloatingQuotent = 16;
		public static final int Special_Function_FloatingSum = 17;
		public static final int Special_Function_Floor = 18;
		public static final int Special_Function_Frexp = 19;
		public static final int Special_Function_Ldexp = 20;
		public static final int Special_Function_Log = 21;	
		public static final int Special_Function_Log10 = 22;
		public static final int Special_Function_Max = 23;
		public static final int Special_Function_Min = 24;
		public static final int Special_Function_Modf = 25;
		public static final int Special_Function_Pow = 26;
		public static final int Special_Function_Precision = 27;
		public static final int Special_Function_Round = 28;
		public static final int Special_Function_Sin = 29;
		public static final int Special_Function_Sinh = 30;
		public static final int Special_Function_Sqrt = 31;
		public static final int Special_Function_Tan = 32;
		public static final int Special_Function_Tanh = 33;
		public static final int Special_Function_StringAsInt = 34;
		public static final int Special_Function_StringAsDecimal = 35;
		public static final int Special_Function_StringAsFloat = 36;
		public static final int math_functions_upper_bounds = 45;	

		/////////
		// Special Function integer constants: String Functions
		/////////
		public static final int string_functions_lower_bounds = 50;	
		public static final int Special_Function_CompareStrings = 50;	
		public static final int Special_Function_Concatenate = 51;
		public static final int Special_Function_ConcatenateWithSeparator = 52;	
		public static final int Special_Function_CopyString = 53;
		public static final int Special_Function_FindString = 54;
		public static final int Special_Function_GetNextToken = 55;
		public static final int Special_Function_SetBlankTerminator = 56;
		public static final int Special_Function_SetNullTerminator = 57;
		public static final int Special_Function_SetSubString = 58;
		public static final int Special_Function_StringLength = 59;
		public static final int Special_Function_TextLen = 60;	
		public static final int string_functions_upper_bounds = 70;	
		
		/////////
		// Special Function integer constants: Special Functions
		/////////
		public static final int Special_Function_Bytes = 71;
		public static final int Special_Function_ExitProgram = 72;
		public static final int Special_Function_Commit = 73;
		public static final int Special_Function_Connect = 74;
		public static final int Special_Function_ConnectionService = 75;
		public static final int Special_Function_Convert = 76;
		public static final int Special_Function_VerifyChkDigitMod10 = 77;
		public static final int Special_Function_VerifyChkDigitMod11 = 78;
		public static final int Special_Function_ExitStack = 81;
		public static final int Special_Function_CalculateChkDigitMod10 = 82;
		public static final int Special_Function_Purge = 95;
		public static final int Special_Function_Rollback = 96;
		public static final int Special_Function_Return = 97;
		public static final int Special_Function_Dimension = 98;

		public static final int Special_Function_SetError = 100;
		public static final int Special_Function_SetLocale = 101;
		public static final int Special_Function_Wait = 102;
		public static final int Special_Function_Audit = 103;
		public static final int Special_Function_StartTransaction = 104;
		public static final int Special_Function_CallChartUtility = 105;
		public static final int Special_Function_SetRemoteUser = 106;
		public static final int Special_Function_ClearScreen = 107;
		public static final int Special_Function_DisplayMsgNum = 108;
		public static final int Special_Function_FieldInputLength = 109;
		public static final int Special_Function_ValidationFailed = 110;
		public static final int Special_Function_SetRequestAttr = 111;
		public static final int Special_Function_GetRequestAttr = 112;
		public static final int Special_Function_ClearRequestAttr = 113;
		public static final int Special_Function_SetSessionAttr = 114;
		public static final int Special_Function_GetSessionAttr = 115;
		public static final int Special_Function_ClearSessionAttr = 116;
		public static final int Special_Function_Disconnect = 117;
		public static final int Special_Function_DisconnectAll = 118;
		public static final int Special_Function_QueryCurrentDatabase = 119;
		public static final int Special_Function_SetCurrentDatabase = 120;
		public static final int Special_Function_CalculateChkDigitMod11 = 121; // used to be 82
		public static final int Special_Function_PageEject = 122;
		public static final int Special_Function_Size = 123;
		public static final int Special_Function_MaximumSize = 124;
		public static final int Special_Function_BeginDatabaseTransaction = 125;
		public static final int Special_Function_DefineDatabaseAlias = 126;
		public static final int Special_Function_GetVAGSystemType = 127;
		public static final int Special_Function_GetMessage = 128;
		public static final int Special_Function_ConditionAsInt = 129;
				
		/////////
		// Special Function integer constants: Special Java Functions
		//
		// This category was broken out of special functions on 6/10/03
		// to support the FunctionImplementation.isJavaFunction() method.
		//
		/////////	
		public static final int java_functions_lower_bound = 150;	
		public static final int Special_Function_Invoke = 150;	
		public static final int Special_Function_Store = 151;
		public static final int Special_Function_StoreNew = 152;
		public static final int Special_Function_GetField = 153;
		public static final int Special_Function_SetField = 154;
		public static final int Special_Function_StoreField = 155;
		public static final int Special_Function_QualifiedTypeName = 156;
		public static final int Special_Function_StoreCopy = 157;
		public static final int Special_Function_Remove = 158;
		public static final int Special_Function_JavaRemoveAll = 159;
		public static final int Special_Function_IsNull = 160;
		public static final int Special_Function_IsObjID = 161;
		public static final int java_functions_upper_bound = 169;	

		//Dyanmic Array Functions
		public static final int array_functions_lower_bounds = 170;	
		public static final int Special_Function_AppendElement = 170;	
		public static final int Special_Function_AppendAll = 171;	
		public static final int Special_Function_InsertElement = 172;	
		public static final int Special_Function_RemoveElement = 173;	
		public static final int Special_Function_RemoveAll = 174;	
		public static final int Special_Function_Resize = 175;	
		public static final int Special_Function_ResizeAll = 176;
		public static final int Special_Function_SetMaxSize = 177;	
		public static final int Special_Function_SetMaxSizes = 178;
		public static final int Special_Function_GetSize = 179; 
		public static final int Special_Function_GetMaxSize = 180;
		public static final int Special_Function_SetElementsEmpty= 181;
		public static final int array_functions_upper_bounds = 185;	

		public static final int Special_Function_WriteStdout = 198;
		public static final int Special_Function_WriteStderr = 199;
		public static final int Special_Function_Clip = 200;
		public static final int Special_Function_Column = 201;
		public static final int Special_Function_Format = 202;
		public static final int Special_Function_FormatNum = 203;
		public static final int Special_Function_IntegerAsCharacter = 204;
		public static final int Special_Function_LowerCase = 205;
		public static final int Special_Function_Spaces = 206;
		public static final int Special_Function_UpperCase = 207;
		public static final int Special_Function_CallCmd = 208;
		public static final int Special_Function_CharacterAsInteger = 209;
		public static final int Special_Function_GetCmdLineArgCount = 210;
		public static final int Special_Function_GetCmdLineArg = 211;
		public static final int Special_Function_StartCmd = 212;
		public static final int Special_Function_LoadTable = 213;
		public static final int Special_Function_UnloadTable = 214;
		public static final int Special_Function_SetCurrentWindow = 215;
		public static final int Special_Function_GetProperty = 216;
		
			
		//Date/Time Functions (6.0)
		public static final int date_time_format_lower_bounds = 218;	
		public static final int Special_Function_FormatDate = 218;	
		public static final int Special_Function_FormatTime = 219;	
		public static final int Special_Function_FormatTimeStamp = 220;	
		public static final int date_time_format_upper_bounds = 220;	

		public static final int Special_Function_CurrentGregorianDate = 221;
		public static final int Special_Function_CurrentFormattedGregorianDate = 222;
		public static final int Special_Function_CurrentJulianDate = 223;
		public static final int Special_Function_CurrentFormattedJulianDate = 224;
		public static final int Special_Function_CurrentShortGregorianDate = 225;
		public static final int Special_Function_CurrentShortJulianDate = 226;
		public static final int Special_Function_CurrentTime = 227;
		public static final int Special_Function_CurrentFormattedTime = 228;
		public static final int Special_Function_CurrentDate = 229;
		public static final int Special_Function_DateValue = 230;
		public static final int Special_Function_DateValueFromGregorian = 231;
		public static final int Special_Function_DateValueFromJulian = 232;	
		public static final int Special_Function_TimeValue = 233;
		public static final int Special_Function_IntervalValue = 234;
		public static final int Special_Function_IntervalValueWithPattern = 235;	
		public static final int Special_Function_TimeStampValue = 236;	
		
		public static final int Special_Function_TimeStampValueWithPattern = 237;
		public static final int Special_Function_TimeStampFrom = 238;
		public static final int Special_Function_DayOf = 239;
		public static final int Special_Function_YearOf = 240;	
		public static final int Special_Function_MonthOf = 241;
		public static final int Special_Function_WeekdayOf = 242;
		public static final int Special_Function_Mdy = 243;
		public static final int Special_Function_DateOf = 244;
		public static final int Special_Function_TimeOf = 245;
		public static final int Special_Function_Extend = 246;
		
		// Dictionary functions (6.0.0.1)
		public static final int dictionary_functions_lower_bounds = 250;
		public static final int Special_Function_ContainsKey = 250;
		public static final int Special_Function_GetKeys = 251;
		public static final int Special_Function_GetValues = 252;
		public static final int Special_Function_InsertAll = 253;
		public static final int Special_Function_Dictionary_RemoveElement = 254;
		public static final int Special_Function_Dictionary_RemoveAll = 255;
		public static final int Special_Function_Dictionary_Size = 256;
		public static final int dictionary_functions_upper_bounds = 259;

		// Blob/Clob functions (6.0.0.1)	
		public static final int large_object_functions_lower_bounds = 260;
		public static final int Special_Function_AttachBlobToFile = 260;
		public static final int Special_Function_GetBlobLen = 261;
		public static final int Special_Function_TruncateBlob = 262;
		public static final int Special_Function_LoadBlobFromFile = 263;
		public static final int Special_Function_UpdateBlobToFile = 264;
		public static final int Special_Function_FreeBlob = 265;
		public static final int Special_Function_AttachClobToFile = 266;
		public static final int Special_Function_GetClobLen = 267;
		public static final int Special_Function_GetSubStrFromClob = 268;	
		public static final int Special_Function_GetStrFromClob = 269;
		public static final int Special_Function_SetClobFromStringAtPosition = 270;	
		public static final int Special_Function_SetClobFromString = 271;	
		public static final int Special_Function_TruncateClob = 272;
		public static final int Special_Function_LoadClobFromFile = 273;
		public static final int Special_Function_UpdateClobToFile = 274;
		public static final int Special_Function_FreeClob = 275;
		public static final int Special_Function_AttachBlobToTempFile = 276;
		public static final int Special_Function_AttachClobToTempFile = 277;
		public static final int large_object_functions_upper_bounds = 280;
		
		// ReportHandler functions
		public static final int report_handler_functions_lower_bounds = 300;
		public static final int Special_Function_GetReportParameter = 300;
		public static final int Special_Function_SetReportVariableValue = 301;
		public static final int Special_Function_GetReportVariableValue = 302;
		public static final int Special_Function_GetFieldValue = 303;
		public static final int Special_Function_AddReportData = 304;
		public static final int Special_Function_GetReportData = 305;
		public static final int Special_Function_SetFieldValue = 306;
		public static final int report_handler_functions_upper_bounds = 310;


		// Birt Handler functions
		public static final int Special_Function_GetDataColumnBinding = 330;
		
		// Console UI Functions 6.0.0.1
		public static final int console_functions_lower_bounds = 353;
		public static final int Special_Function_DisplayLineMode = 353;
		public static final int Special_Function_PromptLineMode = 354;
		public static final int Special_Function_ActivateWindow = 355;
		public static final int Special_Function_ActivateWindowByName = 356;
		public static final int Special_Function_ClearActiveWindow = 357;
		public static final int Special_Function_ClearWindow = 358;
		public static final int Special_Function_ClearWindowByName = 359;
		public static final int Special_Function_CloseActiveWindow = 360;
		public static final int Special_Function_CloseWindow = 361;
		public static final int Special_Function_CloseWindowByName = 362;
		public static final int Special_Function_DrawBox = 363;
		public static final int Special_Function_DrawBoxWithColor = 364;
		public static final int Special_Function_DisplayAtLine = 365;
		public static final int Special_Function_DisplayAtPosition = 366;
		public static final int Special_Function_DisplayMessage = 367;
		public static final int Special_Function_DisplayError = 368;
		public static final int Special_Function_HideErrorWindow = 369;
		public static final int Special_Function_OpenWindow = 370;
		public static final int Special_Function_OpenWindowByName = 371;
		public static final int Special_Function_ClearActiveForm = 372;
		public static final int Special_Function_ClearForm = 373;
		public static final int Special_Function_DisplayForm = 375;
		public static final int Special_Function_DisplayFormByName = 376;
		public static final int Special_Function_DisplayFields = 377;
		public static final int Special_Function_GotoField = 378;
		public static final int Special_Function_GotoFieldByName = 379;
		public static final int Special_Function_NextField = 380;
		public static final int Special_Function_PreviousField = 381;
		public static final int Special_Function_IsCurrentField = 382;
		public static final int Special_Function_IsCurrentFieldByName = 383;
		public static final int Special_Function_IsFieldModified = 384;	
		public static final int Special_Function_IsFieldModifiedByName = 385;
		public static final int Special_Function_GetKey = 386;
		public static final int Special_Function_GetKeyCode = 387;
		public static final int Special_Function_LastKeyTyped = 388;
		public static final int Special_Function_CurrentArrayScreenLine = 389;
		public static final int Special_Function_CurrentArrayDataLine = 390;
		public static final int Special_Function_ScrollDownPage = 391;
		public static final int Special_Function_ScrollDownLines = 392;
		public static final int Special_Function_ScrollUpPage = 393;
		public static final int Special_Function_ScrollUpLines = 394;	
		public static final int Special_Function_SetArrayLine = 395;
		public static final int Special_Function_ShowHelp = 396;	

		public static final int Special_Function_OpenWindowWithForm = 398;
		public static final int Special_Function_OpenWindowWithFormByName = 399;
		public static final int Special_Function_ClearFields= 400;
		public static final int Special_Function_ClearFieldsByName = 401;	
		public static final int Special_Function_DisplayFieldsByName = 402;	
		public static final int Special_Function_GetKeyName = 403;
		public static final int Special_Function_CancelArrayDelete = 404;
		public static final int Special_Function_CancelArrayInsert = 405;
		public static final int Special_Function_SetCurrentArrayCount = 406;	
		public static final int Special_Function_GotoMenuItem = 407;
		public static final int Special_Function_GotoMenuItemByName = 408;	
		public static final int Special_Function_HideMenuItem = 409;
		public static final int Special_Function_HideMenuItemByName = 410;	
		public static final int Special_Function_ShowMenuItem = 411;
		public static final int Special_Function_ShowMenuItemByName = 412;	
		public static final int Special_Function_CurrentArrayCount = 415;
		public static final int Special_Function_ShowAllMenuItems = 416;
		public static final int Special_Function_HideAllMenuItems = 417;
		public static final int Special_Function_UpdateWindowAttributes = 418;
		public static final int console_functions_upper_bounds = 429;
		
		// ReportLibrary functions 
		public static final int reportLibrary_functions_lower_bounds = 430;
		public static final int Special_Function_FillReport = 430;
		public static final int Special_Function_ExportReport = 431;
		public static final int Special_Function_AddReportParameter = 432;
		public static final int Special_Function_ResetReportParameters = 433;	
		public static final int reportLibrary_functions_upper_bounds = 439;

		// Log functions 
		public static final int Special_Function_StartLog = 440;
		public static final int Special_Function_ErrorLog = 441;
		
		// Service functions
		public static final int Special_Function_SetWebEndpoint = 450;
		public static final int Special_Function_GetWebEndpoint = 451;
		public static final int Special_Function_SetTCPIPLocation = 452;
		public static final int Special_Function_GetTCPIPLocation = 453;

		///////
		// End system functions
		///////
		
		////////////////
		// System Variabe Words
		///////////////
		
		public static final int Special_Function_TransferName = 715;
		public static final int Special_Function_CommitOnConverse = 716;
		public static final int Special_Function_ConversionTable = 717;
		public static final int Special_Function_HandleHardIOErrors = 718;
		public static final int Special_Function_RemoteSystemID = 719;
		public static final int Special_Function_SessionID = 720;
		public static final int Special_Function_TerminalID = 721;
		public static final int Special_Function_TextMessageNumber = 722;
		public static final int Special_Function_TextMessage = 723;
		public static final int Special_Function_HandleOverflow = 724;
		public static final int Special_Function_OverflowIndicator = 725;
		public static final int Special_Function_ReturnCode = 726;
		public static final int Special_Function_HandleCallErrors = 727;
		public static final int Special_Function_MQConditionCode = 728;
		public static final int Special_Function_ErrorCode = 729;
		public static final int Special_Function_SimulateSegmentation = 730;
		public static final int Special_Function_TransactionID = 731;
		public static final int Special_Function_SqlCode = 732;
		public static final int Special_Function_SqlCa = 733;
		public static final int Special_Function_SqlErrd = 734;
		public static final int Special_Function_SqlErrmc = 735;
		public static final int Special_Function_SqlWarn = 736;
		public static final int Special_Function_SystemType = 738;
		public static final int Special_Function_ConnectionID = 739;
		public static final int Special_Function_UserID = 740;
		public static final int Special_Function_ArrayIndex = 741;
		public static final int Special_Function_EventKey = 742;
		public static final int Special_Function_Destination = 743;
		public static final int Special_Function_PrinterAssociation = 744;
		public static final int Special_Function_ExceptionCode = 745;
		public static final int Special_Function_ExceptionMsgCount = 746;
		public static final int Special_Function_ExceptionMsg = 747;
		public static final int Special_Function_SqlState = 748;
		public static final int Special_Function_HandleSysLibErrors = 749;
		public static final int Special_Function_ValidationMsgNum = 750;
		public static final int Special_Function_SegmentedMode = 751;
		public static final int Special_Function_SystemName = 752;	
		public static final int Special_Function_SqlIsolationLevel = 754;
		public static final int Special_Function_CurrentForm = 758;
		public static final int Special_Function_CurrentTimeStamp = 762;
		public static final int Special_Function_CallConversionTable = 763;	// Jeff 12-17
		public static final int Special_Function_FormConversionTable = 764;	// Jeff 12-17

		public static final int Special_Function_ISODATEFORMAT = 770;	// Jeff 12-17
		public static final int Special_Function_USADATEFORMAT = 771;	// Jeff 12-17
		public static final int Special_Function_EURDATEFORMAT = 772;	// Jeff 12-17
		public static final int Special_Function_JISDATEFORMAT = 773;	// Jeff 12-17
		public static final int Special_Function_ISOTIMEFORMAT = 774;	// Jeff 12-17
		public static final int Special_Function_USATIMEFORMAT = 775;	// Jeff 12-17
		public static final int Special_Function_EURTIMEFORMAT = 776;	// Jeff 12-17
		public static final int Special_Function_JISTIMEFORMAT = 777;	// Jeff 12-17
		public static final int Special_Function_DB2TIMESTAMPFORMAT = 778;	// Jeff 12-17
		public static final int Special_Function_ODBCTIMESTAMPFORMAT = 779;	// Jeff 12-17
		public static final int Special_Function_LocaleDateFormat = 780;
		public static final int Special_Function_LocaleTimeFormat = 781;
		public static final int Special_Function_LocaleTimeStampFormat = 782;
		public static final int Special_Function_DefaultDateFormat = 783;
		public static final int Special_Function_DefaultTimeFormat = 784;
		public static final int Special_Function_DefaultTimeStampFormat = 785;
		public static final int Special_Function_DefaultMoneyFormat = 786;
		public static final int Special_Function_DefaultNumericFormat = 787;
		public static final int Special_Function_SystemGregorianDateFormat = 788;
		public static final int Special_Function_SystemJulianDateFormat = 789;
		
		public static final int Special_Function_CurrentException = 790; 
		
		public static final int Special_Function_ArrayIndexOutOfBounds = 791;
		public static final int Special_Function_IncompatibleTypeException = 792;
		public static final int Special_Function_InvalidReference = 793;
		public static final int Special_Function_NoFieldFoundException = 794;
		public static final int Special_Function_InvocationException = 795;
		public static final int Special_Function_ServiceException = 796;
		public static final int Special_Function_FileIOException = 797;
		public static final int Special_Function_FileNotFoundException = 798;
		public static final int Special_Function_MQIOException = 799;
		public static final int Special_Function_SQLIOException = 800;
		public static final int Special_Function_LOBException = 801;
		
		public static final int Special_Function_Key_Accept = 825;
		public static final int Special_Function_Key_DeleteLine = 826;
		public static final int Special_Function_Key_InsertLine = 827;
		public static final int Special_Function_Key_Pagedown = 828;
		public static final int Special_Function_Key_Pageup = 829;
		public static final int Special_Function_Key_Help = 830;
		public static final int Special_Function_Key_Interrupt = 831;
		public static final int Special_Function_Key_Quit = 832;
		public static final int Special_Function_ActiveForm = 833;
		public static final int Special_Function_ActiveWindow = 834;
		public static final int Special_Function_ErrorWindowVisible = 835;
		public static final int Special_Function_ErrorWindow = 836;
		public static final int Special_Function_ErrorLine = 837;
		public static final int Special_Function_Screen = 838;
		public static final int Special_Function_InterruptRequested = 839;
		public static final int Special_Function_QuitRequested = 840;
		public static final int Special_Function_MessageResource = 841;
		public static final int Special_Function_CursorWrap = 842;
		public static final int Special_Function_DefinedFieldOrder = 843;
		public static final int Special_Function_DeferInterrupt = 844;
		public static final int Special_Function_DeferQuit = 845;
		public static final int Special_Function_SQLInterrupt = 846;
		public static final int Special_Function_DefaultDisplayAttributes = 847;
		public static final int Special_Function_DefaultInputAttributes = 848;
		public static final int Special_Function_CurrentDisplayAttributes = 849;
		public static final int Special_Function_CommentLine = 850;
		public static final int Special_Function_FormLine = 851;
		public static final int Special_Function_MenuLine = 852;
		public static final int Special_Function_MessageLine = 853;
		public static final int Special_Function_PromptLine = 854;
		public static final int Special_Function_CurrentRowAttributes = 855;

		public static final int Special_Function_DBName = 856;
		public static final int Special_Function_SegmentLevel = 857;
		public static final int Special_Function_StatusCode = 858;
		public static final int Special_Function_ProcOptions = 859;
		public static final int Special_Function_SegmentName = 860;
		public static final int Special_Function_KeyAreaLen = 861;
		public static final int Special_Function_KeyArea = 862;
		public static final int Special_Function_NumSensitiveSegs = 863;
		public static final int Special_Function_CICSError = 864;
		public static final int Special_Function_CICSCondition = 865;
		public static final int Special_Function_CICSRestart = 866;
		
		public static final int Special_Function_CopyBytes = 873;
		public static final int Special_Function_CompareBytes = 874;
		public static final int Special_Function_ConcatenateBytes = 875;
		
		public static final int Special_Function_KeyAreaHex = 878;
		
		////////////////
		// End System Variabe Words
		///////////////
	


	// string representations of the primitive types
	public static String EGL_REPORTS_JASPER_EXPORTFORMAT_STRING = "egl.reports.jasper.EXPORTFORMAT";
	public static String EGL_REPORTS_JASPER_DATASOURCE_STRING = "egl.reports.jasper.DATASOURCE";
	public static String EGL_REPORTS_JASPER_REPORT_STRING = "egl.reports.jasper.REPORT";
	public static String EGL_REPORTS_JASPER_DATASOURCE = "DATASOURCE";
	public static String EGL_REPORTS_REPORT = "Report";
	public static String EGL_REPORTS_REPORTDATA = "ReportData";
	public static String EGL_REPORTS_BIRTREPORT = "BirtReport";
	
	public static String EGL_CONSOLE_UI_COLORKIND_STRING = "egl.console.ui.COLORKIND";
	public static String EGL_CONSOLE_UI_PFKEYKIND_STRING = "egl.console.ui.PFKEYKIND";
	public static String EGL_CONSOLE_UI_BOOLEAN_STRING = "egl.console.ui.BOOLEAN";
	public static String EGL_CONSOLE_UI_CONSOLEFORM_STRING = "egl.console.ui.CONSOLEFORM";
	public static String EGL_CONSOLE_UI_CONSOLEFIELD_STRING = "egl.console.ui.CONSOLEFIELD";
	public static String EGL_CONSOLE_UI_WINDOW_STRING = "egl.console.ui.WINDOW";
	public static String EGL_CONSOLE_UI_PRESENTATIONATTRIBUTES_STRING = "egl.console.ui.PRESENTATIONATTRIBUTES";
	public static String EGL_CONSOLE_UI_CONSOLEFIELD = "ConsoleField";
	public static String EGL_CONSOLE_UI_MENU = "Menu";
	public static String EGL_CONSOLE_UI_MENUITEM = "MenuItem";
	public static String EGL_CONSOLE_UI_PRESENTATIONATTRIBUTES = "PresentationAttributes";
	public static String EGL_CONSOLE_UI_PROMPT = "Prompt";
	public static String EGL_CONSOLE_UI_WINDOW = "Window";
	public static String EGL_CONSOLE_UI_WINDOWATTRIBUTEKIND_STRING = "egl.console.ui.WINDOWATTRIBUTEKIND";
	
	public static String BIN_STRING = "BIN"; //$NON-NLS-1$
	public static String BIN9_2_STRING = "BIN9_2"; //$NON-NLS-1$
	public static String CHAR_STRING = "CHAR"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR1_STRING = "CHAR1"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR2_STRING = "CHAR2"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR4_STRING = "CHAR4"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR8_STRING = "CHAR8"; //$NON-NLS-1$			// Was CHA_STRING
	public static String CHAR18_STRING = "CHAR18"; //$NON-NLS-1$			// Was CHA_STRING
	public static String DBCHAR_STRING = "DBCHAR"; //$NON-NLS-1$		// Was DBCS_STRING
	public static String HEX_STRING = "HEX"; //$NON-NLS-1$	
	public static String MBCHAR_STRING = "MBCHAR"; //$NON-NLS-1$		// WAS MIX_STRING
	public static String NUM_STRING = "NUM"; //$NON-NLS-1$
	public static String NUMC_STRING = "NUMC"; //$NON-NLS-1$			// Deprecated
	public static String PACF_STRING = "PACF"; //$NON-NLS-1$			// Deprecated
	public static String UNICODE_STRING = "UNICODE"; //$NON-NLS-1$
	public static String SMALLINT_STRING = "SMALLINT"; //$NON-NLS-1$
	public static String INT_STRING = "INT"; //$NON-NLS-1$
	public static String BIGINT_STRING = "BIGINT"; //$NON-NLS-1$
	public static String FLOAT_STRING = "FLOAT"; //v6.0		
	public static String SMALLFLOAT_STRING = "SMALLFLOAT"; //v6.0			
	public static String MONEY_STRING = "MONEY"; //v6.0	
	public static String DATE_STRING = "DATE"; //v6.0
	public static String TIME_STRING = "TIME"; //v6.0
	public static String TIMESTAMP_STRING = "TIMESTAMP"; //v6.0
	public static String TIMESTAMP_F6_STRING = "TIMESTAMP_F6"; //v6.0
	public static String INTERVAL_STRING = "INTERVAL"; //v6.0
	public static String CLOB_STRING = "CLOB"; //v6.0
	public static String BLOB_STRING = "BLOB"; //v6.0
	public static String NUMBER_STRING = "NUMBER"; //$NON-NLS-1$	
	public static String DECIMAL_STRING = "DECIMAL"; //$NON-NLS-1$
	public static String STRING_STRING = "STRING"; //$NON-NLS-1$
	public static String BOOLEAN_STRING = "BOOLEAN"; //$NON-NLS-1$
	public static String ANY_STRING = "ANY";
	public static String REPORT_DATA_STRING = "REPORTDATA";
	public static String MENU_ITEM_STRING = "MENUITEM";
	
	
	public static String ARRAY_OR_TABLE = "ARRAYORTABLE"; //$NON-NLS-1$
	public static String DYNAMIC_ARRAY = "DYNAMICARRAY"; //$NON-NLS-1$
	public static String DICTIONARY_STRING = "DICTIONARY"; //$NON-NLS-1$
	public static String ARRAYDICTIONARY_STRING = "ARRAYDICTIONARY"; //$NON-NLS-1$
	
	public static String MIXED_ANY_STRING = "any"; //$NON-NLS-1$
	public static String MIXED_ARRAYDICTIONARY_STRING = "arrayDictionary"; //$NON-NLS-1$
	public static String MIXED_BLOB_STRING = "blob";  //$NON-NLS-1$
	public static String MIXED_CLOB_STRING = "clob";  //$NON-NLS-1$
	public static String MIXED_CONSOLEFIELD_STRING = "consoleField";  //$NON-NLS-1$
	public static String MIXED_DICTIONARY_STRING = "dictionary"; //$NON-NLS-1$
	
	//System Service data type
	public static String MIXED_HTTPPROXY_STRING = "HttpProxy";
	public static String MIXED_HTTPREST_STRING = "HttpRest";
	public static String MIXED_HTTPSOAP_STRING = "HttpSoap";
	public static String MIXED_IHTTP_STRING = "IHttp";
	public static String MIXED_REQUEST_STRING = "Request";
	public static String MIXED_RESPONSE_STRING = "Response";
	public static String MIXED_JOB_STRING = "Job";
	public static String MIXED_IRest_STRING = "IRest";
	public static String MIXED_MULTISTATUS_STRING = "MultiStatus";
	
	//System SQL data type
	public static String MIXED_DATASOURCE_STRING = "DataSource";
	public static String MIXED_SQLDATASOURCE_STRING = "SQLDataSource";
	public static String MIXED_SCROLLABLEDATASOURCE_STRING = "ScrollableDataSource";
	public static String MIXED_SQLRESULTSET_STRING = "SQLResultSet";
	
	public static String MIXED_SQLSTATEMENT_STRING = "SQLStatement";
	
	public static int BEGIN_LEVEL = 5;	

	//type
	public static String TYPE = "type"; //$NON-NLS-1$

	//Program subtypes
	public static String PROGRAM_SUBTYPE_BASIC = "BasicProgram"; //$NON-NLS-1$
	public static String PROGRAM_SUBTYPE_TEXT_UI = "TextUIProgram"; //$NON-NLS-1$
	public static String PROGRAM_SUBTYPE_VG_WEB_TRANSACTION = "VGWebTransaction"; //$NON-NLS-1$

	//Record subtypes
	public static String RECORD_SUBTYPE_BASIC = "BasicRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_INDEXED = "IndexedRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_MQ = "MQRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_RELATIVE = "RelativeRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_SERIAL = "SerialRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_SQl = "SQLRecord"; //$NON-NLS-1$
	public static String RECORD_SUBTYPE_EXCEPTION = "exception"; //$NON-NLS-1$
	
	public static String SUBTYPE_ENTITY = "Entity";
	
	//Form subtypes
	public static String FORM_SUBTYPE_TEXT = "TextForm"; //$NON-NLS-1$
	public static String FORM_SUBTYPE_PRINT = "PrintForm"; //$NON-NLS-1$
	
	//Library subtypes
	public static String LIBRARY_SUBTYPE_BASIC = "BasicLibrary"; //$NON-NLS-1$
	public static String LIBRARY_SUBTYPE_NATIVE = "NativeLibrary"; //$NON-NLS-1$
	
	public static String HANDLER_SUBTYPE_JASPER = "JasperReport"; //$NON-NLS-1$
	public static String HANDLER_SUBTYPE_JSF = "JSFHandler"; //$NON-NLS-1$
	
	//DataTable subtypes
	public static String DATATABLE_SUBTYPE_BASIC = "BasicTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_MATCHINVALID = "MatchInvalidTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_MATCHVALID = "MatchvalidTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_MSG = "MsgTable"; //$NON-NLS-1$
	public static String DATATABLE_SUBTYPE_RANGECHK = "RangeChkTable"; //$NON-NLS-1$
	
	public static String EXTERNALTYPE_SUBTYPE_JAVAOBJECT = "JavaObject"; //$NON-NLS-1$
	
	//Contant for printer, which is used by generation in the ResourceAssociation file
	public static String PRINTER_STRING = "printer"; //$NON-NLS-1$
//	Contants used when creating markers
	public static String EGL_PART_NAME = "EGPartName"; //$NON-NLS-1$
	public static String EGL_IS_EGLMESSAGE = "EGLisEGLMessage"; //$NON-NLS-1$
	public static String EGL_NUMBER_OF_INSERTS = "EGLNumberOfInserts"; //$NON-NLS-1$
	public static String EGL_INSERT = "EGLInsert"; //$NON-NLS-1$
	public static String EGL_Build_aborted = "EGBuilAborted"; //$NON-NLS-1$
	
	
	public static int ENUMERATION_BOOLEAN = 1;
	public static int ENUMERATION_COLORKIND = 2;
	public static int ENUMERATION_HIGHLIGHTKIND = 3;
	public static int ENUMERATION_INTENSITYKIND = 4;
	public static int ENUMERATION_LINEWRAPKIND = 5;
	public static int ENUMERATION_ALIGNKIND = 6;
	public static int ENUMERATION_CASEFORMATKIND = 7;
	public static int ENUMERATION_EVENTKIND = 8;
	
	public static int ENUMERATION_EXPORTFORMAT = 10;
	public static int ENUMERATION_DATASOURCE = 11;
	public static int ENUMERATION_DEVICETYPEKIND = 12;
	public static int ENUMERATION_CALLINGCONVENTIONKIND = 13;
	public static int ENUMERATION_DISPLAYUSEKIND = 14;
	public static int ENUMERATION_INDEXORIENTATIONKIND = 15;
	public static int ENUMERATION_OUTLINEKIND = 16;
	public static int ENUMERATION_PROPERTYKIND = 17;
	public static int ENUMERATION_SELECTTYPEKIND = 18;
	public static int ENUMERATION_SIGNKIND = 19;
	public static int ENUMERATION_PFKEYKIND = 20;
	public static int ENUMERATION_UITYPEKIND = 22;
	public static int ENUMERATION_COMMTYPEKIND = 23;
	public static int ENUMERATION_WINDOWATTRIBUTEKIND = 25;
	public static int ENUMERATION_ENCODINGKIND = 26;
	
	public static int BOOLEAN_YES = 1;
	public static int BOOLEAN_NO = 2;
	
	public static int COLORKIND_BLACK = 1;
	public static int COLORKIND_BLUE = 2;
	public static int COLORKIND_GREEN = 3;
	public static int COLORKIND_MAGENTA = 4;
	public static int COLORKIND_RED = 5;
	public static int COLORKIND_CYAN = 6;
	public static int COLORKIND_YELLOW = 7;
	public static int COLORKIND_WHITE = 8;
	public static int COLORKIND_DEFAULTCOLOR = 9;
	
	public static int ENCODINGKIND_XML = 1;
	public static int ENCODINGKIND_JSON = 2;
	
	public static int DISPLAYUSEKIND_BUTTON = 1;
	public static int DISPLAYUSEKIND_HYPERLINK = 2;
	public static int DISPLAYUSEKIND_INPUT = 3;
	public static int DISPLAYUSEKIND_OUTPUT = 4;
	public static int DISPLAYUSEKIND_SECRET = 5;
	public static int DISPLAYUSEKIND_TABLE = 6;
	
	
	public static int CALLINGCONVENTION_I4GL = 1;
	public static int CALLINGCONVENTION_LIBRARY = 2;
	
	public static int HIGHLIGHTKIND_UNDERLINE = 1;
	public static int HIGHLIGHTKIND_REVERSE = 2;
	public static int HIGHLIGHTKIND_BLINK = 3;
	public static int HIGHLIGHTKIND_NOHIGHIGHT = 4;
	public static int HIGHLIGHTKIND_DEFAULTHIGHLIGHT = 5;
		
	public static int INTENSITY_BOLD = 1;
	public static int INTENSITY_INVISIBLE = 2;
	public static int INTENSITY_DIM = 3;
	public static int INTENSITY_NORMALINTENSITY = 4;
	public static int INTENSITY_DEFAULTINTENSITY = 5;
	
	public static int INDEXORIENTATIONKIND_ACROSS = 1;
	public static int INDEXORIENTATIONKIND_DOWN = 2;
	
	public static int LINEWRAP_CHARACTER = 1;
	public static int LINEWRAP_WORD = 2;
	public static int LINEWRAP_COMPRESS = 3;
	
	public static int ALIGN_LEFT = 1;
	public static int ALIGN_RIGHT = 2;
	public static int ALIGN_CENTER = 3;
	public static int ALIGN_NONE = 4;
	
	public static int CASEFORMAT_UPPER = 1;
	public static int CASEFORMAT_LOWER = 2;
	public static int CASEFORMAT_DEFAULTCASE = 3;
	
	public final static int EVENTKIND_AFTERDELETE = 1;
	public final static int EVENTKIND_AFTEROPENUI = 2;
	public final static int EVENTKIND_AFTERINSERT = 3;
	public final static int EVENTKIND_AFTERROW = 4;
	public final static int EVENTKIND_BEFOREDELETE = 5;
	public final static int EVENTKIND_BEFOREOPENUI = 6;
	public final static int EVENTKIND_BEFOREINSERT = 7;
	public final static int EVENTKIND_BEFOREROW = 8;
	public final static int EVENTKIND_AFTERFIELD = 9;
	public final static int EVENTKIND_BEFOREFIELD = 10;
	public final static int EVENTKIND_ONKEY = 11;
	public final static int EVENTKIND_MENUACTION = 12;

	public static final int PFKEYKIND_PF1 = 1;
	public static final int PFKEYKIND_PF2 = 2;
	public static final int PFKEYKIND_PF3 = 3;
	public static final int PFKEYKIND_PF4 = 4;
	public static final int PFKEYKIND_PF5 = 5;
	public static final int PFKEYKIND_PF6 = 6;
	public static final int PFKEYKIND_PF7 = 7;
	public static final int PFKEYKIND_PF8 = 8;
	public static final int PFKEYKIND_PF9 = 9;
	public static final int PFKEYKIND_PF10 = 10;
	public static final int PFKEYKIND_PF11 = 11;
	public static final int PFKEYKIND_PF12 = 12;
	public static final int PFKEYKIND_PF13 = 13;
	public static final int PFKEYKIND_PF14 = 14;
	public static final int PFKEYKIND_PF15 = 15;
	public static final int PFKEYKIND_PF16 = 16;
	public static final int PFKEYKIND_PF17 = 17;
	public static final int PFKEYKIND_PF18 = 18;
	public static final int PFKEYKIND_PF19 = 19;
	public static final int PFKEYKIND_PF20 = 20;
	public static final int PFKEYKIND_PF21 = 21;
	public static final int PFKEYKIND_PF22 = 22;
	public static final int PFKEYKIND_PF23 = 23;
	public static final int PFKEYKIND_PF24 = 24;
	
	public final static int DEVICETYPEKIND_SINGLEBYTE = 1;
	public final static int DEVICETYPEKIND_DOUBLEBYTE = 2;
	
	public static int EXPORTFORMAT_HTML = 1;
	public static int EXPORTFORMAT_PDF = 2;
	public static int EXPORTFORMAT_TEXT = 3;
	public static int EXPORTFORMAT_XML = 4;
	public static int EXPORTFORMAT_CSV = 5;
	
	public static int DATASOURCE_DATABASECONNECTION = 1;
	public static int DATASOURCE_SQLSTATEMENT = 2;
	public static int DATASOURCE_REPORTDATA = 3;
	
	public static int OUTLINEKIND_BOTTOM = 1;
	public static int OUTLINEKIND_LEFT = 2;
	public static int OUTLINEKIND_RIGHT = 3;
	public static int OUTLINEKIND_TOP = 4;

	public static int PROTECTKIND_SKIP = 1;
	public static int PROTECTKIND_NO = 2;
	public static int PROTECTKIND_YES = 3;
	
	public static int SELECTTYPEKIND_INDEX = 1;
	public static int SELECTTYPEKIND_VALUE = 2;
	
	public static int SIGNKIND_LEADING = 1;
	public static int SIGNKIND_NONE = 2;
	public static int SIGNKIND_PARENS = 3;
	public static int SIGNKIND_TRAILING = 4;
	
	public static int UITYPEKIND_UIFORM = 1;
	public static int UITYPEKIND_HIDDEN = 2;
	public static int UITYPEKIND_INPUT = 3;
	public static int UITYPEKIND_INPUTOUTPUT = 4;
	public static int UITYPEKIND_NONE = 5;
	public static int UITYPEKIND_OUTPUT = 6;
	public static int UITYPEKIND_PROGRAMLINK = 7;
	public static int UITYPEKIND_SUBMIT = 8;
	public static int UITYPEKIND_SUBMITBYPASS = 9;
	
	public static int COMMTYPEKIND_LOCAL = 1;
	public static int COMMTYPEKIND_TCPIP = 2;
	
	public static int WINDOWATTRIBUTEKIND_COMMENT_LINE = 1;
	public static int WINDOWATTRIBUTEKIND_ERROR_LINE = 2;
	public static int WINDOWATTRIBUTEKIND_FORM_LINE = 3;
	public static int WINDOWATTRIBUTEKIND_MENU_LINE = 4;
	public static int WINDOWATTRIBUTEKIND_MESSAGE_LINE = 5;
	public static int WINDOWATTRIBUTEKIND_PROMPT_LINE = 6;
	public static int WINDOWATTRIBUTEKIND_COLOR = 7;
	public static int WINDOWATTRIBUTEKIND_INTENSITY = 8;
	public static int WINDOWATTRIBUTEKIND_HIGHLIGHT = 9;
	
	public static final String ATTRIBUTE_REPORTDESIGNFILE = "reportDesignFile";  //$NON-NLS-1$
	public static final String ATTRIBUTE_REPORTDESTINATIONFILE = "reportDestinationFile";  //$NON-NLS-1$
	public static final String ATTRIBUTE_REPORTEXPORTFILE = "reportExportFile";  //$NON-NLS-1$
	public static final String ATTRIBUTE_REPORTDATA = "reportData";  //$NON-NLS-1$
	public static final String ATTRIBUTE_CONNECTIONNAME = "connectionName";  //$NON-NLS-1$
	public static final String ATTRIBUTE_SQLSTATEMENT = "sqlStatement";  //$NON-NLS-1$
	public static final String ATTRIBUTE_DATA = "data";  //$NON-NLS-1$
	public static final String ATTRIBUTE_MENUITEMS = "menuItems";  //$NON-NLS-1$
}
