/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.cfg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.glassfish.main.jul.cfg.LoggingProperties;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class GlassFishLogManagerConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final LoggingProperties properties;
    private final boolean tracingEnabled;

    public GlassFishLogManagerConfiguration(LoggingProperties properties) {
        this.properties = properties.clone();
        this.tracingEnabled = Boolean.parseBoolean(this.properties.getProperty("org.glassfish.main.jul.tracing.enabled"));
    }

    public SortedSet<String> getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String getProperty(String name) {
        GlassFishLoggingTracer.trace(GlassFishLogManagerConfiguration.class, () -> "getProperty(" + name + ")");
        return this.properties.getProperty(name, null);
    }

    public Stream<ConfigurationEntry> toStream() {
        return this.properties.entrySet().stream().map(ConfigurationEntry::new);
    }

    public LoggingProperties toProperties() {
        return this.properties.clone();
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public GlassFishLogManagerConfiguration clone() {
        try {
            return (GlassFishLogManagerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed!", e);
        }
    }

    public String toString() {
        return this.properties.toString();
    }

    public static GlassFishLogManagerConfiguration parse(File file) throws IOException {
        return new GlassFishLogManagerConfiguration(LoggingProperties.loadFrom(file));
    }

    public static GlassFishLogManagerConfiguration parse(InputStream inputStream) throws IOException {
        return new GlassFishLogManagerConfiguration(LoggingProperties.loadFrom(inputStream));
    }

    public static final class ConfigurationEntry {
        private final String key;
        private final String value;

        ConfigurationEntry(Map.Entry<Object, Object> entry) {
            this.key = entry.getKey() == null ? null : entry.getKey().toString();
            this.value = entry.getValue() == null ? null : entry.getValue().toString();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getKey() + ":" + this.getValue();
        }
    }
}

