/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.formatter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.regex.Pattern;
import org.glassfish.main.jul.formatter.ODLLogFormatter;
import org.glassfish.main.jul.formatter.OneLineFormatter;
import org.glassfish.main.jul.formatter.UniformLogFormatter;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class LogFormatDetector {
    private static final String GZIP_EXTENSION = ".gz";
    private static final int ODL_SUBSTRING_LEN = 5;
    private static final String ODL_LINE_BEGIN_REGEX = "\\[[\\-\\:\\d]{4}";
    private static final Pattern ODL_PATTERN = Pattern.compile("\\[[\\-\\:\\d]{4}");
    public static final String P_TIME = "\\d\\d:\\d\\d:\\d\\d\\.[\\d]{3,9}";
    public static final String P_TIMEZONE = "([0-9:+-]{5,8}|Z)";
    public static final String P_TIMESTAMP = "[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T\\d\\d:\\d\\d:\\d\\d\\.[\\d]{3,9}([0-9:+-]{5,8}|Z)";
    public static final String P_LEVEL_NAME = "[A-Z]+";
    public static final String P_LEVEL_VALUE = "[0-9]{3,4}";
    public static final String P_LOGGER_NAME = "[a-z.]*";
    public static final String P_MESSAGE_KEY = "[a-zA-Z0-9.]*";
    public static final String P_PRODUCT_ID = ".*";

    public String detectFormatter(File logFile) {
        String firstLine;
        if (logFile == null || !logFile.canRead()) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
            firstLine = br.readLine();
        }
        catch (Exception e) {
            GlassFishLoggingTracer.error(this.getClass(), e.getMessage(), e);
            return null;
        }
        return this.detectFormatter(firstLine);
    }

    public String detectFormatter(String firstLine) {
        if (firstLine == null || firstLine.isEmpty()) {
            return null;
        }
        if (this.isODLFormatLogHeader(firstLine)) {
            return ODLLogFormatter.class.getName();
        }
        if (this.isUniformFormatLogHeader(firstLine)) {
            return UniformLogFormatter.class.getName();
        }
        if (this.isOneLineLFormatLogHeader(firstLine)) {
            return OneLineFormatter.class.getName();
        }
        return null;
    }

    public boolean isODLFormatLogHeader(String firstLine) {
        return firstLine.length() > 5 && ODL_PATTERN.matcher(firstLine.substring(0, 5)).matches() && this.countOccurrences(firstLine, '[') > 4;
    }

    public boolean isOneLineLFormatLogHeader(String firstLine) {
        return firstLine.matches("\\d\\d:\\d\\d:\\d\\d\\.[\\d]{3,9}\\s+[A-Z]{4,13}\\s+.+\\s+.+\\s+.+");
    }

    public boolean isUniformFormatLogHeader(String firstLine) {
        return firstLine.startsWith("[#|") && this.countOccurrences(firstLine, '|') > 4;
    }

    public boolean isCompressedFile(String filename) {
        return filename.endsWith(GZIP_EXTENSION);
    }

    private int countOccurrences(String firstLine, char typicalCharacter) {
        int count = 0;
        for (int i = 0; i < firstLine.length(); ++i) {
            if (firstLine.charAt(i) != typicalCharacter) continue;
            ++count;
        }
        return count;
    }
}

