/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.zip.ZipOutputStream;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.client.ClientClassWriter;
import org.glassfish.admin.rest.generator.client.ClientGenerator;
import org.glassfish.admin.rest.generator.client.JavaClientClassWriter;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.config.ConfigModel;

public class JavaClientGenerator
extends ClientGenerator {
    private File baseDirectory = Util.createTempDirectory();
    private Map<String, URI> artifacts;
    private static String MSG_INSTALL = "To install the artifacts to maven: mvn install:install-file -DpomFile=pom.xml -Dfile=rest-client-wrapper-VERSION.jar -Dsources=rest-client-wrapper-VERSION-sources.jar";

    public JavaClientGenerator(ServiceLocator habitat) {
        super(habitat);
        try {
            System.out.println("Generating class in " + this.baseDirectory.getCanonicalPath());
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        this.messages.add(MSG_INSTALL.replace("VERSION", this.versionString));
    }

    @Override
    public ClientClassWriter getClassWriter(ConfigModel model, String className, Class parent) {
        return new JavaClientClassWriter(model, className, parent, this.baseDirectory);
    }

    @Override
    public synchronized Map<String, URI> getArtifact() {
        if (this.artifacts == null) {
            this.artifacts = new HashMap<String, URI>();
            this.createJar("rest-client-wrapper-" + this.versionString + "-sources.jar", ".java");
            this.compileSources();
            this.createJar("rest-client-wrapper-" + this.versionString + ".jar", ".class");
            this.addPom(this.versionString);
            Util.deleteDirectory(this.baseDirectory);
        }
        return this.artifacts;
    }

    private void compileSources() {
        try {
            ArrayList<File> files = new ArrayList<File>();
            this.gatherFiles(this.baseDirectory, files);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            ArrayList<String> options = new ArrayList<String>();
            options.add("-cp");
            StringBuilder sb = new StringBuilder();
            sb.append(ASClassLoaderUtil.getModuleClassPath((ServiceLocator)this.habitat, (String)"", null));
            options.add(sb.toString());
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
            if (!compiler.getTask(null, fileManager, null, options, null, compilationUnits).call().booleanValue()) {
                RestLogging.restLogger.log(Level.INFO, "NCLS-REST-00012");
            }
            fileManager.close();
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar(String fileName, String ext) {
        ZipOutputStream target = null;
        try {
            File jarDir = Util.createTempDirectory();
            File jarFile = new File(jarDir, fileName);
            if (!jarFile.createNewFile()) {
                throw new RuntimeException("Unable to create new file");
            }
            jarFile.deleteOnExit();
            target = new JarOutputStream(new FileOutputStream(jarFile));
            this.addFiles(this.baseDirectory, (JarOutputStream)target, ext);
            target.close();
            this.artifacts.put(jarFile.getName(), jarFile.toURI());
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (target != null) {
                    target.close();
                }
            }
            catch (IOException ex) {
                RestLogging.restLogger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void gatherFiles(File file, List<File> list) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null && files.length != 0) {
                for (File f : files) {
                    this.gatherFiles(f, list);
                }
            }
        } else {
            list.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPom(String versionString) {
        OutputStreamWriter writer = null;
        try (Scanner scanner = new Scanner(Thread.currentThread().getContextClassLoader().getResourceAsStream("/client/pom.template.xml"));){
            String pom = scanner.useDelimiter("\\Z").next();
            pom = pom.replace("{{glassfish.version}}", versionString);
            File out = File.createTempFile("pom", "xml");
            out.deleteOnExit();
            writer = new FileWriter(out);
            writer.write(pom);
            writer.close();
            this.artifacts.put("pom.xml", out.toURI());
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void addFiles(File dir, JarOutputStream target, String ext) throws IOException {
        if (dir == null || !dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            File[] f = dir.listFiles();
            if (f != null && f.length != 0) {
                for (File file : f) {
                    this.addFiles(file, target, ext);
                }
            }
        } else if (dir.getName().endsWith(ext)) {
            this.add(dir, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(File source, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            int count;
            String sourcePath = source.getPath().replace("\\\\", "/").substring(this.baseDirectory.getPath().length() + 1);
            JarEntry entry = new JarEntry(sourcePath);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }
}

