/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.MessageTransformer;
import com.sun.messaging.bridge.api.StompDestination;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompMessage;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.api.StompSession;
import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.bridge.api.StompUnrecoverableAckException;
import com.sun.messaging.bridge.service.stomp.StompConnectionImpl;
import com.sun.messaging.bridge.service.stomp.StompDestinationImpl;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandlerImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StompSubscriberSession
implements StompSession,
StompSubscriber,
MessageListener {
    private Logger _logger = null;
    private String _subid = null;
    private Session _session = null;
    private MessageConsumer _subscriber = null;
    private StompOutputHandler _out = null;
    private ArrayList<Message> _unacked = new ArrayList();
    private String _duraName = null;
    private StompConnectionImpl stompconn = null;
    private StompBridgeResources _sbr = null;
    private boolean _clientack = false;
    private boolean _clientack_thismsg = false;
    private int _ackfailureCount = 0;
    private int MAX_CONSECUTIVE_ACK_FAILURES = 3;

    public StompSubscriberSession(String id, StompProtocolHandler.StompAckMode ackMode, StompConnectionImpl sc) throws Exception {
        this.stompconn = sc;
        this._logger = this.stompconn.getProtocolHandler().getLogger();
        this._subid = id;
        this._sbr = StompServer.getStompBridgeResources();
        int jmsackmode = 1;
        if (ackMode != StompProtocolHandler.StompAckMode.AUTO_ACK) {
            if (ackMode == StompProtocolHandler.StompAckMode.CLIENT_ACK) {
                jmsackmode = 2;
                this._clientack = true;
            } else if (ackMode == StompProtocolHandler.StompAckMode.CLIENT_INDIVIDUAL_ACK) {
                jmsackmode = 2;
                this._clientack = true;
                this._clientack_thismsg = true;
            } else {
                throw new StompProtocolException("Unsupported ackMode:" + ackMode);
            }
        }
        this._session = sc.getConnection().createSession(false, jmsackmode);
    }

    public StompSubscriber createSubscriber(StompDestination d, String selector, String duraname, boolean nolocal, StompOutputHandler out) throws Exception {
        Destination dest = ((StompDestinationImpl)d).getJMSDestination();
        if (this._subscriber != null) {
            throw new IllegalStateException("createSubscriber(): Unexpected call");
        }
        this._out = out;
        if (dest instanceof Queue) {
            this._subscriber = this._session.createConsumer(dest, selector);
        } else if (duraname != null) {
            this._subscriber = this._session.createDurableSubscriber((Topic)dest, duraname, selector, nolocal);
            this._duraName = duraname;
        } else {
            this._subscriber = this._session.createConsumer(dest, selector, nolocal);
        }
        return this;
    }

    @Override
    public void startDelivery() throws Exception {
        this._subscriber.setMessageListener((MessageListener)this);
    }

    public Session getJMSSession() {
        return this._session;
    }

    public String getDurableName() {
        return this._duraName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        String msgid = "";
        try {
            if (this._clientack) {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.add(msg);
                }
            }
            msgid = msg.getJMSMessageID();
            this._out.sendToClient(StompSubscriberSession.toStompFrameMessage(msg, this._subid, this._session, this.stompconn.getProtocolHandler()));
        }
        catch (Throwable t) {
            try {
                block16: {
                    Object[] eparam = new String[]{msgid, this._subid, t.getMessage()};
                    if (t instanceof ClosedChannelException) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS2009", eparam));
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.initCause(t);
                        throw re;
                    }
                    this._logger.log(Level.WARNING, this._sbr.getKString("BSS2009", eparam), t);
                    StompFrameMessage err = null;
                    try {
                        err = this.stompconn.getProtocolHandler().toStompErrorMessage("Subscriber[" + this._subid + "].onMessage", t, true);
                    }
                    catch (Throwable tt) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS3004", t.getMessage()), tt);
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.initCause(t);
                        throw re;
                    }
                    try {
                        this._out.sendToClient(err);
                    }
                    catch (Throwable ee) {
                        if (ee instanceof ClosedChannelException) {
                            this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", t.getMessage(), ee.getMessage()));
                            break block16;
                        }
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", t.getMessage(), ee.getMessage()), ee);
                    }
                }
                RuntimeException re = new RuntimeException(t.getMessage());
                re.initCause(t);
                throw re;
            }
            catch (Throwable throwable) {
                try {
                    this.closeSubscriber();
                }
                catch (Exception e) {
                    this._logger.log(Level.FINE, "Close subscriber " + this + " failed:" + e.getMessage(), e);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String msgid) throws Exception {
        if (this._session.getAcknowledgeMode() != 2) {
            throw new JMSException(this._sbr.getKString("BSS4027", msgid, this._subid));
        }
        ArrayList<Message> arrayList = this._unacked;
        synchronized (arrayList) {
            Message msg = null;
            int end = this._unacked.size() - 1;
            boolean found = false;
            int i = 0;
            for (i = end; i >= 0; --i) {
                msg = this._unacked.get(i);
                if (!msgid.equals(msg.getJMSMessageID())) continue;
                try {
                    if (this._clientack_thismsg) {
                        ((MessageImpl)msg).acknowledgeThisMessage();
                        this._unacked.remove(i);
                        break;
                    }
                    ((MessageImpl)msg).acknowledgeUpThroughThisMessage();
                    this._ackfailureCount = 0;
                }
                catch (Exception e) {
                    ++this._ackfailureCount;
                    StompUnrecoverableAckException ex = null;
                    if (e instanceof JMSException && this._session instanceof SessionImpl && ((SessionImpl)this._session)._appCheckRemoteException((JMSException)((Object)e))) {
                        ex = new StompUnrecoverableAckException("An unrecoverable ACK failure has occurred in subscriber " + this, e);
                        throw ex;
                    }
                    if (this._ackfailureCount > this.MAX_CONSECUTIVE_ACK_FAILURES) {
                        ex = new StompUnrecoverableAckException("Maximum consecutive ACK failures " + this.MAX_CONSECUTIVE_ACK_FAILURES + " has occurred in subscriber " + this, e);
                        throw ex;
                    }
                    throw e;
                }
                found = true;
                break;
            }
            if (found && !this._clientack_thismsg) {
                for (int j = 0; j <= i; ++j) {
                    this._unacked.remove(0);
                }
                return;
            }
        }
        throw new JMSException(this._sbr.getKString("BSS4028", msgid, this._subid));
    }

    protected void closeSubscriber() throws Exception {
        if (this._subscriber != null) {
            this._subscriber.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        try {
            this._subscriber.close();
        }
        catch (Exception exception) {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
        finally {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
    }

    protected static StompFrameMessage toStompFrameMessage(Message jmsmsg, final String subid, Session ss, final StompProtocolHandlerImpl sph) throws Exception {
        MessageTransformer mt = sph.getMessageTransformer();
        if (mt != null) {
            mt.init(ss, "STOMP");
            Message oldmsg = jmsmsg;
            jmsmsg = (Message)mt.transform(jmsmsg, true, null, "SUN_MQ", "STOMP", null);
            if (jmsmsg == null) {
                throw new JMSException("null returned from " + mt.getClass().getName() + " transform() method for JMS message " + oldmsg + " in subscription " + subid);
            }
        }
        final Message msg = jmsmsg;
        boolean needAck = ss.getAcknowledgeMode() != 1;
        return sph.toStompFrameMessage(new StompMessage(){

            @Override
            public String getSubscriptionID() throws Exception {
                return subid;
            }

            @Override
            public String getDestination() throws Exception {
                Destination jmsdest = msg.getJMSDestination();
                return sph.toStompFrameDestination(new StompDestinationImpl(jmsdest), false);
            }

            @Override
            public String getReplyTo() throws Exception {
                Destination jmsdest = msg.getJMSReplyTo();
                if (jmsdest == null) {
                    return null;
                }
                return sph.toStompFrameDestination(new StompDestinationImpl(jmsdest), true);
            }

            @Override
            public String getJMSMessageID() throws Exception {
                return msg.getJMSMessageID();
            }

            @Override
            public String getJMSCorrelationID() throws Exception {
                return msg.getJMSCorrelationID();
            }

            @Override
            public String getJMSExpiration() throws Exception {
                return String.valueOf(msg.getJMSExpiration());
            }

            @Override
            public String getJMSRedelivered() throws Exception {
                return String.valueOf(msg.getJMSRedelivered());
            }

            @Override
            public String getJMSPriority() throws Exception {
                return String.valueOf(msg.getJMSPriority());
            }

            @Override
            public String getJMSTimestamp() throws Exception {
                return String.valueOf(msg.getJMSTimestamp());
            }

            @Override
            public String getJMSType() throws Exception {
                return msg.getJMSType();
            }

            @Override
            public Enumeration getPropertyNames() throws Exception {
                return msg.getPropertyNames();
            }

            @Override
            public String getProperty(String name) throws Exception {
                return msg.getObjectProperty(name).toString();
            }

            @Override
            public boolean isTextMessage() throws Exception {
                return msg instanceof TextMessage;
            }

            @Override
            public boolean isBytesMessage() throws Exception {
                return msg instanceof BytesMessage;
            }

            @Override
            public String getText() throws Exception {
                return ((TextMessage)msg).getText();
            }

            @Override
            public byte[] getBytes() throws Exception {
                BytesMessage m = (BytesMessage)msg;
                byte[] data = new byte[(int)m.getBodyLength()];
                m.readBytes(data);
                return data;
            }

            @Override
            public void setText(StompFrameMessage message) throws Exception {
                throw new RuntimeException("Unexpected call: setText()");
            }

            @Override
            public void setBytes(StompFrameMessage message) throws Exception {
                throw new RuntimeException("Unexpected call: setBytes()");
            }

            @Override
            public void setDestination(String stompdest) throws Exception {
                throw new RuntimeException("Unexpected call: setDestination()");
            }

            @Override
            public void setPersistent(String stompdest) throws Exception {
                throw new RuntimeException("Unexpected call: setPersistent()");
            }

            @Override
            public void setReplyTo(String replyto) throws Exception {
                throw new RuntimeException("Unexpected call: setReplyTo()");
            }

            @Override
            public void setJMSCorrelationID(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSCorrelationID()");
            }

            @Override
            public void setJMSExpiration(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSExpiration()");
            }

            @Override
            public void setJMSPriority(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSPriority()");
            }

            @Override
            public void setJMSType(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSType()");
            }

            @Override
            public void setProperty(String name, String value) throws Exception {
                throw new RuntimeException("Unexpected call: setProperty()");
            }
        }, needAck);
    }

    @Override
    public StompDestination createStompDestination(String name, boolean isQueue) throws Exception {
        if (isQueue) {
            return new StompDestinationImpl((Destination)this._session.createQueue(name));
        }
        return new StompDestinationImpl((Destination)this._session.createTopic(name));
    }

    @Override
    public StompDestination createTempStompDestination(boolean isQueue) throws Exception {
        if (isQueue) {
            return new StompDestinationImpl((Destination)this._session.createTemporaryQueue());
        }
        return new StompDestinationImpl((Destination)this._session.createTemporaryTopic());
    }
}

