/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.NotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyIPService;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyService;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocketServiceApp;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketIPServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketProtocolImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public class WebSocketIPService
extends IMQService
implements GrizzlyService,
NotificationInfo {
    private static boolean DEBUG = Globals.getLogger().getLevel() <= 4;
    private BrokerResources br = Globals.getBrokerResources();
    private static final String ALLOWED_ORIGINS_PROP_SUFFIX = ".allowedOrigins";
    private static final String ALL_ORIGIN = "*";
    protected PacketRouter router = null;
    private WebSocketProtocolImpl protocol = null;
    private HttpServer httpServer = null;
    private GrizzlyExecutorService writerPool = null;
    private Object writeLock = new Object();
    private LinkedHashMap<ConnectionUID, WebSocketMQIPConnection> pendingWrites = new LinkedHashMap();
    private boolean dedicatedWriter = Globals.getConfig().getBooleanProperty("imq.websocketIPService.dedicatedWriterThread", false);
    private AtomicInteger readerPoolThreadCnt = new AtomicInteger(0);
    private AtomicInteger writerPoolThreadCnt = new AtomicInteger(0);
    private NetworkListener networkListener = null;
    private List<String> enabledSubServices = new ArrayList<String>();
    private List<URL> allowedOrigins = null;
    private URL myurl = null;

    public WebSocketIPService(String name, int type, PacketRouter router, int min, int max, WebSocketIPServiceFactory parent) throws BrokerException {
        super(name, type);
        this.router = router;
        String key = "imq." + name + ALLOWED_ORIGINS_PROP_SUFFIX;
        this.logger.log(8, key + "=" + Globals.getConfig().getProperty(key));
        List origins = Globals.getConfig().getList(key);
        if (origins != null && !origins.contains(ALL_ORIGIN)) {
            this.allowedOrigins = new ArrayList<URL>();
            Iterator itr = origins.iterator();
            while (itr.hasNext()) {
                try {
                    this.allowedOrigins.add(new URL((String)itr.next()));
                }
                catch (Exception e) {
                    throw new BrokerException(e.getMessage(), e);
                }
            }
        }
        key = "imq." + name + ".services";
        List subservs = Globals.getConfig().getList(key);
        if (subservs == null || subservs.isEmpty()) {
            throw new BrokerException(this.br.getKString("B4451", key));
        }
        Iterator itr = subservs.iterator();
        String val = null;
        String subserv = null;
        while (itr.hasNext()) {
            val = (String)itr.next();
            subserv = val.trim().toLowerCase(Locale.getDefault());
            if (MQWebSocketServiceApp.isSupportedSubService(subserv)) {
                this.enabledSubServices.add(subserv);
                continue;
            }
            Object[] args = new String[]{val, key, "UNKNOWN"};
            String emsg = this.br.getKString("B2262", args);
            this.logger.log(16, emsg);
        }
        if (this.enabledSubServices.isEmpty()) {
            val = Globals.getConfig().getProperty(key);
            throw new BrokerException(this.br.getKString("B4027", key + "=" + val));
        }
        key = "imq." + name + ".protocoltype";
        String p = Globals.getConfig().getProperty(key);
        if (p == null || !p.equals("ws") && !p.equals("wss")) {
            throw new BrokerException(this.br.getKString("B4450", p == null ? "null" : p, name));
        }
        String prefix = "imq.protocol." + p;
        String serviceprefix = "imq." + name + "." + p;
        try {
            String docroot = Globals.getJMQ_INSTANCES_HOME() + File.separator + Globals.getConfigName() + File.separator + "docroot" + File.separator;
            File dir = new File(docroot);
            if (!dir.exists() && !dir.mkdir()) {
                this.logger.log(16, "Unable to make directory " + docroot);
            }
            Map params = parent.getProtocolParams(p, serviceprefix);
            params.put("serviceFactoryHandlerName", parent.getFactoryHandlerName());
            this.protocol = new WebSocketProtocolImpl(this, p);
            this.protocol.checkParameters(params);
            this.protocol.setParameters(params);
            this.protocol.setMinMaxThreads(min, max, this.getName());
            boolean nodelay = Globals.getConfig().getBooleanProperty(prefix + ".nodelay", true);
            this.protocol.setNoDelay(nodelay);
            int inputBufferSize = Globals.getConfig().getIntProperty(prefix + ".inbufsz", 0);
            int outputBufferSize = Globals.getConfig().getIntProperty(prefix + ".outbufsz", 0);
            this.protocol.setInputBufferSize(inputBufferSize);
            this.protocol.setOutputBufferSize(outputBufferSize);
            SSLEngineConfigurator wssServerConfig = null;
            if (p.equals("wss")) {
                wssServerConfig = GrizzlyIPService.initializeSSL(this.getName(), this.protocol);
            }
            String pname = "MQ-writer-thread-pool[" + this.getName() + "]";
            ThreadPoolConfig wpc = ThreadPoolConfig.defaultConfig().copy().setPoolName(pname).setCorePoolSize(this.protocol.getMinThreads()).setMaxPoolSize(this.protocol.getMaxThreads());
            wpc.getInitialMonitoringConfig().addProbes((Object[])new ThreadPoolProbe[]{new ThreadPoolProbeImpl(pname, this.writerPoolThreadCnt)});
            this.writerPool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)wpc);
            pname = "MQ-reader-thread-pool[" + this.getName() + "]";
            ThreadPoolConfig rpc = ThreadPoolConfig.defaultConfig().copy().setPoolName(pname).setCorePoolSize(this.protocol.getMinThreads()).setMaxPoolSize(this.protocol.getMaxThreads());
            rpc.getInitialMonitoringConfig().addProbes((Object[])new ThreadPoolProbe[]{new ThreadPoolProbeImpl(pname, this.readerPoolThreadCnt)});
            GrizzlyExecutorService pool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)rpc);
            PortRange prange = this.protocol.getPortRange();
            String hostn = this.protocol.getHostName();
            if (hostn == null) {
                hostn = "0.0.0.0";
            }
            this.httpServer = new HttpServer();
            ServerConfiguration cf = this.httpServer.getServerConfiguration();
            cf.setName("MQWebSocketService[" + name + "]");
            cf.setMaxFormPostSize(4096);
            cf.setMaxBufferedPostSize(4096);
            StaticHttpHandler hh = new StaticHttpHandler(new String[]{docroot});
            hh.setFileCacheEnabled(false);
            cf.addHttpHandler((HttpHandler)hh, new String[]{"/"});
            this.networkListener = new NetworkListener("MQWebSocketService[" + name + "]", hostn, prange);
            this.httpServer.addListener(this.networkListener);
            TCPNIOTransport transport = this.configureTransport();
            if (wssServerConfig != null) {
                this.networkListener.setSecure(true);
                this.networkListener.setSSLEngineConfig(wssServerConfig);
            }
            transport.setWorkerThreadPool((ExecutorService)pool);
            WebSocketAddOn addon = new WebSocketAddOn();
            this.networkListener.registerAddOn((AddOn)addon);
            MQWebSocketServiceApp app = new MQWebSocketServiceApp(this);
            WebSocketEngine.getEngine().register((WebSocketApplication)app);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4386", name, e.getMessage());
            this.logger.logStack(32, emsg, (Throwable)e);
            if (this.httpServer != null) {
                try {
                    this.httpServer.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.httpServer = null;
            }
            if (this.writerPool != null) {
                this.writerPool.shutdown();
            }
            throw new BrokerException(emsg);
        }
    }

    protected List<URL> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    protected synchronized URL getMyURL() throws Exception {
        if (this.myurl != null) {
            if (this.myurl.getPort() != this.networkListener.getPort()) {
                this.myurl = new URL((this.networkListener.isSecure() ? "https" : "http") + "://" + this.myurl.getHost() + ":" + this.networkListener.getPort());
            }
        } else {
            this.myurl = new URL((this.networkListener.isSecure() ? "https" : "http") + "://" + Globals.getBrokerInetAddress().getCanonicalHostName() + ":" + this.networkListener.getPort());
        }
        return this.myurl;
    }

    protected boolean isSubServiceEnabled(String subserv) {
        return this.enabledSubServices.contains(subserv);
    }

    protected boolean useDedicatedWriter() {
        return this.dedicatedWriter;
    }

    private void unbindTransport() throws Exception {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.unbindTransport() for service " + this.name);
        }
        this.networkListener.getTransport().unbindAll();
        this.logger.log(8, this.br.getKString("B1489", this.getName() + "[" + this.protocol.getType() + "]"));
    }

    private TCPNIOTransport configureTransport() {
        TCPNIOTransport transport = this.networkListener.getTransport();
        transport.setReuseAddress(true);
        transport.setTcpNoDelay(this.protocol.getNoDelay());
        int v = this.protocol.getTimeout();
        if (v > 0) {
            transport.setServerSocketSoTimeout(v * 1000);
        }
        if ((v = this.protocol.getLingerTimeout()) > 0) {
            transport.setLinger(v * 1000);
        }
        int backlog = this.protocol.getBacklog();
        transport.setServerConnectionBackLog(backlog);
        transport.setReadBufferSize(this.protocol.getInputBufferSize());
        transport.setWriteBufferSize(this.protocol.getOutputBufferSize());
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindTransport(boolean checkpause) throws Exception {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.bindTransport(" + checkpause + ") for service " + this.name);
        }
        this.unbindTransport();
        TCPNIOTransport transport = this.configureTransport();
        String hostn = this.protocol.getHostName();
        int portn = this.protocol.getPort();
        this.logger.log(8, this.br.getKString("B1488", this.getName() + "[" + this.protocol.getType() + ", " + (hostn == null ? ALL_ORIGIN : hostn) + ", " + portn + "]"));
        if (this.getState() == 4) {
            transport.resume();
        }
        if (hostn == null) {
            transport.bind((SocketAddress)new InetSocketAddress(portn));
        } else {
            transport.bind(hostn, portn);
            this.addServiceProp("hostname", hostn);
        }
        int lportn = this.getLocalPort();
        this.logger.log(8, this.br.getKString("B1425", this.getName() + "[" + this.protocol.getType() + "]", (hostn == null ? "" : hostn) + ":" + lportn + "(" + portn + ")"));
        if (checkpause && (this.getState() == 4 || this.getState() == 8)) {
            try {
                this.unbindTransport();
            }
            finally {
                if (this.getState() == 4) {
                    this.networkListener.pause();
                }
            }
        }
        Globals.getPortMapper().addService(this.getName(), this.protocol.getType(), Globals.getConfig().getProperty("imq." + this.getName() + ".servicetype"), lportn, this.getServiceProperties());
    }

    @Override
    public int getLocalPort() {
        int port = this.networkListener.getPort();
        return port < 0 ? 0 : port;
    }

    @Override
    public boolean isOpen() {
        return this.httpServer != null;
    }

    @Override
    public synchronized int getMinThreadpool() {
        return this.protocol.getMinThreads() * 2;
    }

    @Override
    public synchronized int getMaxThreadpool() {
        return this.protocol.getMaxThreads() * 2;
    }

    @Override
    public synchronized int getActiveThreadpool() {
        int cntr = this.readerPoolThreadCnt.get();
        int cntw = this.writerPoolThreadCnt.get();
        return cntr + cntw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] setMinMaxThreadpool(int min, int max) {
        if (this.writerPool != null) {
            ThreadPoolConfig pc = this.writerPool.getConfiguration();
            pc.setMaxPoolSize(max);
            pc.setCorePoolSize(min);
            Object object = this.writeLock;
            synchronized (object) {
                if (this.writerPool.isShutdown()) {
                    throw new IllegalStateException("Service " + this.getName() + " is shutting down");
                }
            }
            this.writerPool.reconfigure(pc);
        }
        TCPNIOTransport transport = this.networkListener.getTransport();
        ThreadPoolConfig pc = transport.getWorkerThreadPoolConfig();
        pc.setMaxPoolSize(max);
        pc.setCorePoolSize(min);
        ((GrizzlyExecutorService)transport.getWorkerThreadPool()).reconfigure(pc);
        return null;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public synchronized void startService(boolean startPaused) {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.startService(" + startPaused + ") for service " + this.getName());
        }
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)"unable to start service, already started.");
            return;
        }
        this.setState(2);
        try {
            this.configureTransport();
            if (startPaused) {
                this.networkListener.pause();
            } else if (this.getState() == 4) {
                this.networkListener.resume();
            }
            this.httpServer.start();
            if (startPaused) {
                this.networkListener.pause();
            }
            Object[] args = new String[]{this.getName(), this.getProtocol().toString(), String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
            String msg = this.br.getKString("B1004", args);
            this.logger.log(8, msg + "[Grizzly " + Grizzly.getDotedVersion() + "]");
            try {
                this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), (Object)this.getName());
            }
            catch (BrokerException e) {
                this.logger.log(16, "B2135", (Object)this.getName(), (Object)e.getMessage());
            }
            Globals.getPortMapper().addService(this.name, this.protocol.getType(), Globals.getConfig().getProperty("imq." + this.name + ".servicetype"), this.getLocalPort(), this.getServiceProperties());
            if (startPaused) {
                this.setServiceRunning(false);
                this.setState(4);
            } else {
                this.setServiceRunning(true);
                this.setState(3);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4210", this.name, e.getMessage());
            this.logger.logStack(32, emsg, (Throwable)e);
            try {
                this.stopService(true);
            }
            catch (Exception ee) {
                this.logger.logStack(16, this.br.getKString("B2017", this.name + "[" + this.getProtocol() + "]"), (Throwable)ee);
                this.setServiceRunning(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean all) {
        int i;
        Connection con;
        List<Connection> cons;
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.stopService(" + all + ") for service " + this.getName());
        }
        WebSocketIPService webSocketIPService = this;
        synchronized (webSocketIPService) {
            if (this.isShuttingDown()) {
                return;
            }
            Object[] strings = new String[]{this.getName(), this.getProtocol().toString()};
            if (all) {
                this.logger.log(8, "B1007", strings);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", strings);
            }
            this.setShuttingDown(true);
        }
        try {
            this.networkListener.getTransport().unbindAll();
        }
        catch (Exception e) {
            this.logger.logStack(16, this.br.getKString("B2017", this.name + "[" + this.getProtocol() + "]"), (Throwable)e);
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.stopConnection();
            }
        }
        cons = this;
        synchronized (cons) {
            this.setState(5);
        }
        if (!all) {
            return;
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = cons.get(i);
                con.destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        try {
            this.httpServer.stop();
        }
        catch (Exception e) {
            this.logger.logStack(16, this.br.getKString("B2017", this.name + "[" + this.getProtocol() + "]"), (Throwable)e);
        }
        Object e = this;
        synchronized (e) {
            this.setState(6);
        }
        if (this.writerPool != null) {
            e = this.writeLock;
            synchronized (e) {
                this.writerPool.shutdown();
            }
            long endtime = System.currentTimeMillis() + this.getDestroyWaitTime();
            Object i2 = this.writeLock;
            synchronized (i2) {
                while (this.pendingWrites.size() > 0) {
                    try {
                        this.writeLock.wait(this.getDestroyWaitTime());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < endtime) continue;
                }
            }
            try {
                long remaining = endtime - System.currentTimeMillis();
                if (remaining > 0L) {
                    this.writerPool.awaitTermination(remaining, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e2) {
                this.logger.logStack(8, "Exception in waiting writer thread pool terminate on stopping service " + this.getName(), (Throwable)e2);
            }
        }
        if (DEBUG) {
            this.logger.log(8, "Stopped Service {0} with protocol {1} ", (Object)this.getName(), (Object)this.getProtocol());
        }
    }

    @Override
    public synchronized void stopNewConnections() throws IOException {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.stopNewConnections() for service " + this.getName());
        }
        if (this.getState() != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        try {
            this.unbindTransport();
        }
        catch (Exception e) {
            throw new IOException("Unable to unbind transport for service " + this.name, e);
        }
        this.setState(8);
        Globals.getPortMapper().updateServicePort(this.name, 0);
    }

    @Override
    public synchronized void startNewConnections() throws IOException {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.startNewConnections() for service " + this.getName());
        }
        if (this.getState() != 8 && this.getState() != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        try {
            this.bindTransport(false);
        }
        catch (Exception e) {
            throw new IOException("Unable to bind transport for service " + this.name, e);
        }
        this.setState(3);
        Globals.getPortMapper().updateServicePort(this.name, this.getProtocol().getLocalPort());
    }

    @Override
    public synchronized void pauseService(boolean all) {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.pauseService(" + all + ") for service " + this.getName());
        }
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to pause service " + this.name + ", not running."));
            return;
        }
        Object[] strings = new String[]{this.getName(), this.getProtocol().toString()};
        this.logger.log(4, "B1005", strings);
        try {
            this.stopNewConnections();
            this.networkListener.pause();
        }
        catch (Exception ex) {
            this.logger.logStack(16, Globals.getBrokerResources().getKString("B4384", this.getName() + "[" + this.getProtocol() + "]", ex.getMessage()), (Throwable)ex);
        }
        this.setState(4);
        this.setServiceRunning(false);
    }

    @Override
    public synchronized void resumeService() {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.resumeService() for service " + this.getName());
        }
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to resume service " + this.name + ", already running."));
            return;
        }
        Object[] strings = new String[]{this.getName(), this.getProtocol().toString()};
        this.logger.log(4, "B1006", strings);
        try {
            this.startNewConnections();
            this.networkListener.resume();
        }
        catch (Exception ex) {
            this.logger.logStack(16, Globals.getBrokerResources().getKString("B4385", this.getName() + "[" + this.getProtocol() + "]", ex.getMessage()), (Throwable)ex);
        }
        this.setServiceRunning(true);
        this.setState(3);
    }

    @Override
    public synchronized void updateService(int port, int min, int max) throws IOException, PropertyUpdateException, BrokerException {
        this.updateService(port, min, max, true);
    }

    protected synchronized void updateService(int port, int min, int max, boolean store) throws IOException, PropertyUpdateException, BrokerException {
        if (DEBUG) {
            this.logger.log(8, "WebSocketIPService.updateService(" + port + ", " + min + ", " + max + ", " + store + ") for service " + this.getName());
        }
        Object[] args = new String[]{this.getName(), String.valueOf(port), String.valueOf(min), String.valueOf(max)};
        this.logger.log(8, "B1090", args);
        try {
            if (min > -1 || max > -1) {
                int[] rets = this.protocol.setMinMaxThreads(min, max, this.getName());
                this.setMinMaxThreadpool(this.protocol.getMinThreads(), this.protocol.getMaxThreads());
                if (store && rets != null) {
                    if (rets[0] > -1) {
                        Globals.getConfig().updateProperty("imq." + this.name + ".min_threads", String.valueOf(2 * this.protocol.getMinThreads()));
                    }
                    if (rets[1] > -1) {
                        Globals.getConfig().updateProperty("imq." + this.name + ".max_threads", String.valueOf(2 * this.protocol.getMaxThreads()));
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            String emsg = Globals.getBrokerResources().getKString("B4115", String.valueOf(min), String.valueOf(max)) + ": " + e.getMessage();
            this.logger.logStack(32, emsg, (Throwable)e);
            throw new BrokerException(emsg, e);
        }
        if (port > -1) {
            boolean dostore = store;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("port", String.valueOf(port));
            this.protocol.checkParameters(params);
            Map oldparams = this.protocol.setParameters(params);
            if (oldparams != null) {
                Globals.getPortMapper().removeService(this.name);
                try {
                    this.bindTransport(true);
                }
                catch (Exception e) {
                    dostore = false;
                    String emsg = this.br.getKString("B4388", this.getName(), e.getMessage());
                    this.logger.logStack(32, emsg, (Throwable)e);
                    this.protocol.setParameters(oldparams);
                    Globals.getPortMapper().removeService(this.name);
                    try {
                        this.bindTransport(true);
                    }
                    catch (Exception ee) {
                        emsg = this.br.getKString("B4388", this.getName(), e.getMessage());
                        this.logger.logStack(32, emsg, (Throwable)ee);
                        throw new BrokerException(emsg, ee);
                    }
                }
            }
            if (dostore) {
                Globals.getConfig().updateProperty("imq." + this.name + "." + this.protocol.getType() + ".port", String.valueOf(port));
            }
        }
    }

    public WebSocketMQIPConnection createConnection(MQWebSocket websocket) throws IOException, BrokerException {
        return new WebSocketMQIPConnection(this, this.router, websocket);
    }

    @Override
    public void setReadyToWrite(IMQConnection con, boolean ready) {
        this.setReadyToWrite(con, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReadyToWrite(IMQConnection con, Exception exception) {
        block9: {
            if (this.dedicatedWriter) {
                return;
            }
            WebSocketMQIPConnection pc = (WebSocketMQIPConnection)con;
            boolean submit = false;
            Object object = this.writeLock;
            synchronized (object) {
                this.pendingWrites.put(pc.getConnectionUID(), pc);
                if (pc.assignWriteThread(true)) {
                    this.pendingWrites.remove((Object)pc.getConnectionUID());
                    submit = true;
                    this.writeLock.notifyAll();
                }
            }
            if (!submit) {
                return;
            }
            final WebSocketMQIPConnection c = pc;
            try {
                this.writerPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block32: {
                            int ret = 0;
                            try {
                                ret = c.writeData(false);
                            }
                            catch (Throwable t) {
                                try {
                                    c.handleWriteException(t);
                                }
                                catch (Throwable e) {
                                    int loglevel = c.isValid() ? 16 : 8;
                                    1 v0 = this;
                                    if (!v0.c.getDEBUG()) {
                                        WebSocketIPService.this.logger;
                                        if (loglevel != 16) break block32;
                                    }
                                    WebSocketIPService.this.logger.logStack(loglevel, "Exception in writing data to connection " + c + " for service " + WebSocketIPService.this.getName(), e);
                                }
                            }
                            finally {
                                c.assignWriteThread(false);
                                boolean resubmit = false;
                                switch (ret) {
                                    case 0: {
                                        resubmit = true;
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                }
                                Object object = WebSocketIPService.this.writeLock;
                                synchronized (object) {
                                    if (WebSocketIPService.this.pendingWrites.get((Object)c.getConnectionUID()) != null) {
                                        resubmit = true;
                                    }
                                }
                                if (resubmit) {
                                    WebSocketIPService.this.setReadyToWrite((IMQConnection)c, true);
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                c.assignWriteThread(false);
                if (exception != null) {
                    throw new RuntimeException(e.getMessage(), exception);
                }
                if (this.isShuttingDown()) break block9;
                this.setReadyToWrite((IMQConnection)c, e);
            }
        }
    }

    @Override
    public void assigned(IMQConnection con, int events) throws IllegalAccessException {
        throw new UnsupportedOperationException("Unsupported call WebSocketIPServer.assigned()");
    }

    @Override
    public void released(IMQConnection con, int events) {
        throw new UnsupportedOperationException("Unsupported call WebSocketIPServer.assigned()");
    }

    @Override
    public void destroy(String reason) {
    }

    @Override
    public void dumpState() {
        this.logger.log(8, this.getStateInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStateInfo() {
        Object object = this.writeLock;
        synchronized (object) {
            return "WebSocketIPService[" + this.getName() + "]pendingWriteCount: " + this.pendingWrites.size() + "\nWebSocketIPService[" + this.getName() + "]writerPoolQueueSize: " + this.writerPool.getConfiguration().getQueue().size();
        }
    }

    class ThreadPoolProbeImpl
    implements ThreadPoolProbe {
        private String pname = null;
        private AtomicInteger counter = null;

        ThreadPoolProbeImpl(String pname, AtomicInteger counter) {
            this.pname = pname;
            this.counter = counter;
        }

        public void onThreadPoolStartEvent(AbstractThreadPool threadPool) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] started, " + threadPool);
            }
        }

        public void onThreadPoolStopEvent(AbstractThreadPool threadPool) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] stopped");
            }
        }

        public void onThreadAllocateEvent(AbstractThreadPool threadPool, Thread thread) {
            int cnt = this.counter.getAndIncrement();
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] thread allocated[" + ++cnt + "]");
            }
        }

        public void onThreadReleaseEvent(AbstractThreadPool threadPool, Thread thread) {
            int cnt = this.counter.getAndDecrement();
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] thread released[" + --cnt + "]");
            }
        }

        public void onMaxNumberOfThreadsEvent(AbstractThreadPool threadPool, int maxNumberOfThreads) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] threads max " + maxNumberOfThreads + " reached");
            }
        }

        public void onTaskQueueEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task queue event:" + task);
            }
        }

        public void onTaskDequeueEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task dequeue event:" + task);
            }
        }

        public void onTaskCompleteEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task complete event:" + task);
            }
        }

        public void onTaskQueueOverflowEvent(AbstractThreadPool threadPool) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task queue overflow event");
            }
        }

        public void onTaskCancelEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = WebSocketIPService.this.logger;
                WebSocketIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task cancel event");
            }
        }
    }
}

