/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class SimplePatternMatcher {
    private Pattern regexPattern = null;
    private String pattern;
    private String prepared;
    private Mode mode;
    private static final Collection<SimplePatternMatcher> EMPTY_PATTERN_COLLECTION = Collections.EMPTY_LIST;

    public SimplePatternMatcher(String pattern) {
        this.pattern = pattern.trim();
        if (this.pattern.length() > 0) {
            if (!pattern.contains("?")) {
                if (pattern.lastIndexOf(42) == 0) {
                    this.mode = Mode.SUFFIX;
                    this.prepared = pattern.substring(1);
                } else if (pattern.indexOf(42) == pattern.length() - 1) {
                    this.mode = Mode.PREFIX;
                    this.prepared = pattern.substring(0, pattern.length() - 1);
                } else if (pattern.indexOf(42) == -1) {
                    this.mode = Mode.EXACT;
                }
            }
            if (this.mode == null) {
                this.mode = Mode.SIMPLEREGEX;
                String regex = SimplePatternMatcher.regexify(pattern);
                this.regexPattern = Pattern.compile(regex);
            }
        }
    }

    public static Collection<SimplePatternMatcher> parseMultiPatternString(String multiplePatterns, String delimiter) {
        if (multiplePatterns == null || multiplePatterns.trim().length() == 0) {
            return EMPTY_PATTERN_COLLECTION;
        }
        String[] patterns = multiplePatterns.split(delimiter);
        ArrayList<SimplePatternMatcher> result = new ArrayList<SimplePatternMatcher>();
        for (String pattern : patterns) {
            if ((pattern = pattern.trim()).length() == 0) continue;
            SimplePatternMatcher matcher = new SimplePatternMatcher(pattern);
            result.add(matcher);
        }
        return result;
    }

    public boolean matches(String input) {
        if (input == null) {
            return false;
        }
        if (this.pattern.length() == 0) {
            return true;
        }
        switch (this.mode) {
            case PREFIX: {
                return this.prepared.length() == 0 || input.startsWith(this.prepared);
            }
            case SUFFIX: {
                return input.endsWith(this.prepared);
            }
            case EXACT: {
                return input.equals(this.pattern);
            }
            case SIMPLEREGEX: {
                return this.regexPattern.matcher(input).matches();
            }
        }
        throw new IllegalStateException("Unknown Mode: " + this.mode);
    }

    protected SimplePatternMatcher() {
    }

    public static String regexify(CharSequence pattern) {
        if (pattern == null) {
            throw new NullPointerException("Pattern may not be null");
        }
        StringBuilder sb = new StringBuilder();
        int len = pattern.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                case '*': {
                    sb.append("(.*)");
                    continue block5;
                }
                case '?': {
                    sb.append('.');
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "SimplePatternMatcher: " + this.pattern + " in mode " + this.mode;
    }

    private static enum Mode {
        SIMPLEREGEX,
        PREFIX,
        SUFFIX,
        EXACT;

    }
}

