/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.util.Utility;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ProxyImpl;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.config.Dom;

@Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
@Path(value="domain/proxy/{path:.*}")
public class ManagementProxyResource {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ServiceLocator habitat;
    @Inject
    private ServerContext serverContext;

    @GET
    public ActionReportResult proxyRequest() {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("Proxied Data");
        ar.setSuccess();
        ActionReportResult result = new ActionReportResult(ar);
        Properties proxiedResponse = (Properties)Utility.runWithContextClassLoader((ClassLoader)this.serverContext.getCommonClassLoader(), () -> new ManagementProxyImpl().proxyRequest(this.uriInfo, Util.getJerseyClient(), this.habitat));
        ar.setExtraProperties(proxiedResponse);
        return result;
    }

    public void setEntity(Dom p) {
    }

    private static class ManagementProxyImpl
    extends ProxyImpl {
        private static int TARGET_INSTANCE_NAME_PATH_INDEX = 2;

        private ManagementProxyImpl() {
        }

        @Override
        public UriBuilder constructTargetURLPath(UriInfo sourceUriInfo, URL responseURLReceivedFromTarget) {
            return sourceUriInfo.getBaseUriBuilder().replacePath(responseURLReceivedFromTarget.getFile());
        }

        @Override
        public UriBuilder constructForwardURLPath(UriInfo sourceUriInfo) {
            List sourcePathSegments = sourceUriInfo.getPathSegments();
            List forwardPathSegmentsHead = sourcePathSegments.subList(0, TARGET_INSTANCE_NAME_PATH_INDEX - 1);
            List forwardPathSegmentsTail = sourcePathSegments.subList(TARGET_INSTANCE_NAME_PATH_INDEX + 1, sourcePathSegments.size());
            UriBuilder forwardUriBuilder = sourceUriInfo.getBaseUriBuilder();
            for (PathSegment pathSegment : forwardPathSegmentsHead) {
                forwardUriBuilder.segment(new String[]{pathSegment.getPath()});
            }
            for (PathSegment pathSegment : forwardPathSegmentsTail) {
                forwardUriBuilder.segment(new String[]{pathSegment.getPath()});
            }
            return forwardUriBuilder;
        }

        @Override
        public String extractTargetInstanceName(UriInfo uriInfo) {
            return ((PathSegment)uriInfo.getPathSegments().get(TARGET_INSTANCE_NAME_PATH_INDEX)).getPath();
        }
    }
}

