/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.classfilewriter.AccessFlag;
import org.jboss.classfilewriter.ClassFactory;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.CommonProxiedMethodFilters;
import org.jboss.weld.bean.proxy.DefaultBytecodeMethodResolver;
import org.jboss.weld.bean.proxy.DummyClassFactoryImpl;
import org.jboss.weld.bean.proxy.GroovyMethodFilter;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProtectionDomainCache;
import org.jboss.weld.bean.proxy.ProxiedMethodFilter;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.SecurityActions;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.proxy.WeldConstruct;
import org.jboss.weld.security.GetDeclaredConstructorsAction;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.security.GetProtectionDomainAction;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.ConstructorUtils;
import org.jboss.weld.util.bytecode.DeferredBytecode;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Sets;
import org.jboss.weld.util.reflection.Reflections;

public class ProxyFactory<T>
implements PrivilegedAction<T> {
    public static final String PROXY_SUFFIX = "$Proxy$";
    public static final String WELD_PROXY_PREFIX = "org.jboss.weld.generated.proxies";
    public static final String DEFAULT_PROXY_PACKAGE = "org.jboss.weld.generated.proxies.default";
    public static final String CONSTRUCTED_FLAG_NAME = "constructed";
    protected static final BytecodeMethodResolver DEFAULT_METHOD_RESOLVER = new DefaultBytecodeMethodResolver();
    protected static final String LJAVA_LANG_REFLECT_METHOD = "Ljava/lang/reflect/Method;";
    protected static final String LJAVA_LANG_BYTE = "Ljava/lang/Byte;";
    protected static final String LJAVA_LANG_CLASS = "Ljava/lang/Class;";
    protected static final String LJAVA_LANG_OBJECT = "Ljava/lang/Object;";
    protected static final String LBEAN_IDENTIFIER = "Lorg/jboss/weld/serialization/spi/BeanIdentifier;";
    protected static final String LJAVA_LANG_STRING = "Ljava/lang/String;";
    protected static final String LJAVA_LANG_THREAD_LOCAL = "Ljava/lang/ThreadLocal;";
    protected static final String INIT_METHOD_NAME = "<init>";
    protected static final String INVOKE_METHOD_NAME = "invoke";
    protected static final String METHOD_HANDLER_FIELD_NAME = "methodHandler";
    static final String JAVA = "java";
    static final String JAKARTA = "jakarta";
    static final String NO_PACKAGE = "the class package is null or empty";
    static final String SIGNED = "the class is signed";
    private static final Set<ProxiedMethodFilter> METHOD_FILTERS;
    private final Class<?> beanType;
    private final Set<Class<?>> additionalInterfaces = new LinkedHashSet();
    private final String baseProxyName;
    private final Bean<?> bean;
    private final Class<?> proxiedBeanType;
    private final String contextId;
    private final ProxyServices proxyServices;
    private final WeldConfiguration configuration;
    private final ProxyInstantiator proxyInstantiator;

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        this(contextId, proxiedBeanType, typeClosure, bean, false);
    }

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean, boolean forceSuperClass) {
        this(contextId, proxiedBeanType, typeClosure, ProxyFactory.getProxyName(contextId, proxiedBeanType, typeClosure, bean), bean, forceSuperClass);
    }

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean) {
        this(contextId, proxiedBeanType, typeClosure, proxyName, bean, false);
    }

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean, boolean forceSuperClass) {
        this.bean = bean;
        this.contextId = contextId;
        this.proxiedBeanType = proxiedBeanType;
        this.configuration = Container.instance(contextId).deploymentManager().getServices().get(WeldConfiguration.class);
        this.addInterfacesFromTypeClosure(typeClosure, proxiedBeanType);
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        Class<Object> superClass = typeInfo.getSuperClass();
        Class clazz = superClass = superClass == null ? Object.class : superClass;
        if (forceSuperClass || superClass.equals(Object.class) && this.additionalInterfaces.isEmpty()) {
            superClass = proxiedBeanType;
        }
        this.beanType = superClass;
        this.addDefaultAdditionalInterfaces();
        this.baseProxyName = proxyName;
        this.proxyServices = Container.instance(contextId).services().get(ProxyServices.class);
        if (this.additionalInterfaces.size() > 1) {
            LinkedHashSet<Class<?>> sorted = Proxies.sortInterfacesHierarchy(this.additionalInterfaces);
            this.additionalInterfaces.clear();
            this.additionalInterfaces.addAll(sorted);
        }
        this.proxyInstantiator = Container.instance(contextId).services().get(ProxyInstantiator.class);
    }

    static String getProxyName(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        ProxyNameHolder holder;
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        if (typeInfo.getSuperClass() == Object.class) {
            StringBuilder name = new StringBuilder();
            holder = ProxyFactory.createCompoundProxyName(contextId, bean, typeInfo, name);
        } else {
            boolean typeModified = false;
            for (Class<?> iface : typeInfo.getInterfaces()) {
                if (iface.isAssignableFrom(typeInfo.getSuperClass())) continue;
                typeModified = true;
                break;
            }
            if (typeModified) {
                StringBuilder name = new StringBuilder(typeInfo.getSuperClass().getSimpleName() + "$");
                holder = ProxyFactory.createCompoundProxyName(contextId, bean, typeInfo, name);
            } else {
                holder = new ProxyNameHolder(null, typeInfo.getSuperClass().getSimpleName(), bean);
            }
        }
        String className = holder.getClassName() + PROXY_SUFFIX;
        String proxyPackage = holder.getPackageName();
        if (proxiedBeanType.equals(Object.class)) {
            Class<?> superInterface = typeInfo.getSuperInterface();
            if (superInterface == null) {
                throw new IllegalArgumentException("Proxied bean type cannot be java.lang.Object without an interface");
            }
            String reason = ProxyFactory.getDefaultPackageReason(superInterface);
            if (reason != null) {
                proxyPackage = DEFAULT_PROXY_PACKAGE;
                BeanLogger.LOG.generatingProxyToDefaultPackage(superInterface, DEFAULT_PROXY_PACKAGE, reason);
            }
        } else {
            String reason = ProxyFactory.getDefaultPackageReason(proxiedBeanType);
            if (reason != null && reason.equals(NO_PACKAGE)) {
                proxyPackage = DEFAULT_PROXY_PACKAGE;
                BeanLogger.LOG.generatingProxyToDefaultPackage(proxiedBeanType, DEFAULT_PROXY_PACKAGE, reason);
            } else if (proxyPackage == null) {
                proxyPackage = proxiedBeanType.getPackage().getName();
            }
        }
        return proxyPackage + "." + ProxyFactory.getEnclosingPrefix(proxiedBeanType) + className;
    }

    private static ProxyNameHolder createCompoundProxyName(String contextId, Bean<?> bean, Proxies.TypeInfo typeInfo, StringBuilder name) {
        String proxyPackage = null;
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        if (bean != null && bean instanceof AbstractProducerBean) {
            Class mostSpecificClass = ((AbstractProducerBean)bean).getType();
            proxyPackage = mostSpecificClass.getPackage().getName();
            if (mostSpecificClass.getDeclaringClass() != null) {
                interfaces.add(mostSpecificClass.getDeclaringClass().getSimpleName());
            }
            interfaces.add(mostSpecificClass.getSimpleName());
        }
        if (proxyPackage == null && bean != null && !Modifier.isPublic(bean.getBeanClass().getModifiers()) && !(bean instanceof AbstractBuiltInBean)) {
            proxyPackage = bean.getBeanClass().getPackage().getName();
        }
        HashSet<String> declaringClasses = new HashSet<String>();
        for (Class<?> type : typeInfo.getInterfaces()) {
            Class<?> declaringClass = type.getDeclaringClass();
            if (declaringClass != null && declaringClasses.add(declaringClass.getSimpleName())) {
                interfaces.add(declaringClass.getSimpleName());
            }
            interfaces.add(type.getSimpleName());
            if (proxyPackage != null) continue;
            proxyPackage = typeInfo.getPackageNameForClass(type);
        }
        Iterator iterator = interfaces.iterator();
        while (iterator.hasNext()) {
            name.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            name.append("$");
        }
        if (bean != null && !(bean instanceof AbstractBuiltInBean)) {
            BeanIdentifier id = Container.instance(contextId).services().get(ContextualStore.class).putIfAbsent((Contextual<?>)bean);
            int idHash = id.hashCode();
            name.append("$");
            name.append(Math.abs(idHash == Integer.MIN_VALUE ? 0 : idHash));
        }
        String className = name.toString();
        return new ProxyNameHolder(proxyPackage, className, bean);
    }

    private static String getEnclosingPrefix(Class<?> clazz) {
        Class<?> encl = clazz.getEnclosingClass();
        return encl == null ? "" : ProxyFactory.getEnclosingPrefix(encl) + encl.getSimpleName() + "$";
    }

    public static <T> void setBeanInstance(String contextId, T proxy, BeanInstance beanInstance, Bean<?> bean) {
        if (proxy instanceof ProxyObject) {
            ProxyObject proxyView = (ProxyObject)proxy;
            proxyView.weld_setHandler(new ProxyMethodHandler(contextId, beanInstance, bean));
        }
    }

    private static String getDefaultPackageReason(Class<?> clazz) {
        if (clazz.getPackage() == null || clazz.getPackage().getName().isEmpty()) {
            return NO_PACKAGE;
        }
        if (clazz.getSigners() != null) {
            return SIGNED;
        }
        return null;
    }

    public void addInterfacesFromTypeClosure(Set<? extends Type> typeClosure, Class<?> proxiedBeanType) {
        for (Type type : typeClosure) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterface(c);
        }
    }

    public void addInterface(Class<?> newInterface) {
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException(newInterface + " is not an interface");
        }
        this.additionalInterfaces.add(newInterface);
    }

    public T create(BeanInstance beanInstance) {
        T proxy = System.getSecurityManager() == null ? this.run() : AccessController.doPrivileged(this);
        ((ProxyObject)proxy).weld_setHandler(new ProxyMethodHandler(this.contextId, beanInstance, this.bean));
        return proxy;
    }

    @Override
    public T run() {
        try {
            Class<T> proxyClass = this.getProxyClass();
            boolean hasConstrutedField = SecurityActions.hasDeclaredField(proxyClass, CONSTRUCTED_FLAG_NAME);
            if (hasConstrutedField != this.useConstructedFlag()) {
                ProxyInstantiator newInstantiator = ProxyInstantiator.Factory.create(!hasConstrutedField);
                BeanLogger.LOG.creatingProxyInstanceUsingDifferentInstantiator(proxyClass, newInstantiator, this.proxyInstantiator);
                return newInstantiator.newInstance(proxyClass);
            }
            return this.proxyInstantiator.newInstance(proxyClass);
        }
        catch (InstantiationException e) {
            throw new DefinitionException(BeanLogger.LOG.proxyInstantiationFailed(this), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DefinitionException(BeanLogger.LOG.proxyInstantiationBeanAccessFailed(this), e.getCause());
        }
    }

    public Class<T> getProxyClass() {
        String suffix = "_$$_Weld" + this.getProxyNameSuffix();
        Object proxyClassName = this.getBaseProxyName();
        if (!((String)proxyClassName).endsWith(suffix)) {
            proxyClassName = (String)proxyClassName + suffix;
        }
        if (((String)proxyClassName).startsWith(JAVA)) {
            proxyClassName = ((String)proxyClassName).replaceFirst(JAVA, WELD_PROXY_PREFIX);
        } else if (((String)proxyClassName).startsWith(JAKARTA)) {
            proxyClassName = ((String)proxyClassName).replaceFirst(JAKARTA, WELD_PROXY_PREFIX);
        }
        Class proxyClass = null;
        Class originalClass = this.bean != null ? this.bean.getBeanClass() : this.proxiedBeanType;
        BeanLogger.LOG.generatingProxyClass(proxyClassName);
        try {
            proxyClass = (Class)Reflections.cast(this.proxyServices.loadClass(originalClass, (String)proxyClassName));
        }
        catch (ClassNotFoundException e) {
            try {
                proxyClass = this.createProxyClass(originalClass, (String)proxyClassName);
            }
            catch (Throwable e1) {
                try {
                    proxyClass = (Class)Reflections.cast(this.proxyServices.loadClass(originalClass, (String)proxyClassName));
                }
                catch (ClassNotFoundException e2) {
                    BeanLogger.LOG.catchingDebug(e1);
                    throw BeanLogger.LOG.unableToLoadProxyClass(this.bean, this.proxiedBeanType, e1);
                }
            }
        }
        return proxyClass;
    }

    protected String getBaseProxyName() {
        return this.baseProxyName;
    }

    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private void addDefaultAdditionalInterfaces() {
        this.additionalInterfaces.add(Serializable.class);
        this.additionalInterfaces.add(WeldConstruct.class);
    }

    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
    }

    private Class<T> createProxyClass(Class<?> originalClass, String proxyClassName) throws Exception {
        HashSet<Class<?>> specialInterfaces = Sets.newHashSet(LifecycleMixin.class, TargetInstanceProxy.class, ProxyObject.class);
        this.addAdditionalInterfaces(specialInterfaces);
        this.additionalInterfaces.removeAll(specialInterfaces);
        ClassFile proxyClassType = null;
        int accessFlags = AccessFlag.of((int[])new int[]{1, 32, 4096});
        if (this.getBeanType().isInterface()) {
            proxyClassType = this.newClassFile(proxyClassName, accessFlags, Object.class.getName(), new String[0]);
            proxyClassType.addInterface(this.getBeanType().getName());
        } else {
            proxyClassType = this.newClassFile(proxyClassName, accessFlags, this.getBeanType().getName(), new String[0]);
        }
        for (Class<?> clazz : this.additionalInterfaces) {
            proxyClassType.addInterface(clazz.getName());
        }
        ArrayList<DeferredBytecode> initialValueBytecode = new ArrayList<DeferredBytecode>();
        ClassMethod staticConstructor = proxyClassType.addMethod(AccessFlag.of((int[])new int[]{1, 8}), "<clinit>", "V", new String[0]);
        this.addFields(proxyClassType, initialValueBytecode);
        this.addConstructors(proxyClassType, initialValueBytecode);
        this.addMethods(proxyClassType, staticConstructor);
        staticConstructor.getCodeAttribute().returnInstruction();
        for (Class clazz : specialInterfaces) {
            proxyClassType.addInterface(clazz.getName());
        }
        this.dumpToFile(proxyClassName, proxyClassType.toBytecode());
        ProtectionDomain domain = AccessController.doPrivileged(new GetProtectionDomainAction(this.proxiedBeanType));
        if (this.proxiedBeanType.getPackage() == null || this.proxiedBeanType.getPackage().getName().isEmpty() || this.proxiedBeanType.equals(Object.class)) {
            domain = ProxyFactory.class.getProtectionDomain();
        } else if (System.getSecurityManager() != null) {
            ProtectionDomainCache protectionDomainCache = Container.instance(this.contextId).services().get(ProtectionDomainCache.class);
            domain = protectionDomainCache.getProtectionDomainForProxy(domain);
        }
        Class clazz = (Class)Reflections.cast(this.toClass(proxyClassType, originalClass, this.proxyServices, domain));
        BeanLogger.LOG.createdProxyClass(clazz, Arrays.toString(clazz.getInterfaces()));
        return clazz;
    }

    private ClassFile newClassFile(String name, int accessFlags, String superclass, String ... interfaces) {
        try {
            return new ClassFile(name, accessFlags, superclass, ProxyFactory.class.getClassLoader(), (ClassFactory)DummyClassFactoryImpl.INSTANCE, interfaces);
        }
        catch (Exception e) {
            throw BeanLogger.LOG.unableToCreateClassFile(name, e.getCause());
        }
    }

    private void dumpToFile(String fileName, byte[] data) {
        File proxyDumpFilePath = this.configuration.getProxyDumpFilePath();
        if (proxyDumpFilePath == null) {
            return;
        }
        File dumpFile = new File(proxyDumpFilePath, fileName + ".class");
        try {
            Files.write(dumpFile.toPath(), data, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            BeanLogger.LOG.beanCannotBeDumped(fileName, e);
        }
    }

    protected void addConstructors(ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        try {
            if (this.getBeanType().isInterface()) {
                ConstructorUtils.addDefaultConstructor(proxyClassType, initialValueBytecode, !this.useConstructedFlag());
            } else {
                boolean constructorFound = false;
                for (Constructor<?> constructor : AccessController.doPrivileged(new GetDeclaredConstructorsAction(this.getBeanType()))) {
                    if ((constructor.getModifiers() & 2) != 0) continue;
                    constructorFound = true;
                    String[] exceptions = new String[constructor.getExceptionTypes().length];
                    for (int i = 0; i < exceptions.length; ++i) {
                        exceptions[i] = constructor.getExceptionTypes()[i].getName();
                    }
                    ConstructorUtils.addConstructor("V", DescriptorUtils.parameterDescriptors((Class[])constructor.getParameterTypes()), exceptions, proxyClassType, initialValueBytecode, !this.useConstructedFlag());
                }
                if (!constructorFound) {
                    this.addConstructorsForBeanWithPrivateConstructors(proxyClassType);
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addFields(ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        proxyClassType.addField(2, METHOD_HANDLER_FIELD_NAME, this.getMethodHandlerType());
        if (this.useConstructedFlag()) {
            proxyClassType.addField(2, CONSTRUCTED_FLAG_NAME, "Z");
        }
    }

    protected Class<? extends MethodHandler> getMethodHandlerType() {
        return MethodHandler.class;
    }

    protected void addMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        this.addMethodsFromClass(proxyClassType, staticConstructor);
        this.addSpecialMethods(proxyClassType, staticConstructor);
        this.addSerializationSupport(proxyClassType);
    }

    protected void addSerializationSupport(ClassFile proxyClassType) {
    }

    protected void addMethodsFromClass(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            Class<?> cls;
            this.generateEqualsMethod(proxyClassType);
            this.generateHashCodeMethod(proxyClassType);
            boolean isBeanClassAbstract = Modifier.isAbstract(cls.getModifiers());
            for (cls = this.getBeanType(); cls != null; cls = cls.getSuperclass()) {
                this.addMethods(cls, proxyClassType, staticConstructor);
                if (!isBeanClassAbstract || !Modifier.isAbstract(cls.getModifiers())) continue;
                for (Class<?> implementedInterface : Reflections.getInterfaceClosure(cls)) {
                    if (this.additionalInterfaces.contains(implementedInterface)) continue;
                    this.addMethods(implementedInterface, proxyClassType, staticConstructor);
                }
            }
            for (Class<?> c : this.additionalInterfaces) {
                for (Method method : c.getMethods()) {
                    if (!this.isMethodAccepted(method, this.getProxySuperclass())) continue;
                    try {
                        RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                        ClassMethod classMethod = proxyClassType.addMethod(method);
                        if (Reflections.isDefault(method)) {
                            this.addConstructedGuardToMethodBody(classMethod);
                            this.createForwardingMethodBody(classMethod, methodInfo, staticConstructor);
                        } else {
                            this.createSpecialMethodBody(classMethod, methodInfo, staticConstructor);
                        }
                        BeanLogger.LOG.addingMethodToProxy(method);
                    }
                    catch (DuplicateMemberException duplicateMemberException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void addMethods(Class<?> cls, ClassFile proxyClassType, ClassMethod staticConstructor) {
        for (Method method : AccessController.doPrivileged(new GetDeclaredMethodsAction(cls))) {
            if (!this.isMethodAccepted(method, this.getProxySuperclass())) continue;
            try {
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                ClassMethod classMethod = proxyClassType.addMethod(method);
                this.addConstructedGuardToMethodBody(classMethod);
                this.createForwardingMethodBody(classMethod, methodInfo, staticConstructor);
                BeanLogger.LOG.addingMethodToProxy(method);
            }
            catch (DuplicateMemberException duplicateMemberException) {
                // empty catch block
            }
        }
    }

    protected boolean isMethodAccepted(Method method, Class<?> proxySuperclass) {
        for (ProxiedMethodFilter filter : METHOD_FILTERS) {
            if (filter.accept(method, proxySuperclass)) continue;
            return false;
        }
        return true;
    }

    protected void generateHashCodeMethod(ClassFile proxyClassType) {
    }

    protected void generateEqualsMethod(ClassFile proxyClassType) {
    }

    protected void createSpecialMethodBody(ClassMethod proxyClassType, MethodInformation method, ClassMethod staticConstructor) {
        this.createInterceptorBody(proxyClassType, method, staticConstructor);
    }

    protected void addConstructedGuardToMethodBody(ClassMethod classMethod) {
        this.addConstructedGuardToMethodBody(classMethod, classMethod.getClassFile().getSuperclass());
    }

    protected void addConstructedGuardToMethodBody(ClassMethod classMethod, String className) {
        if (!this.useConstructedFlag()) {
            return;
        }
        CodeAttribute cond = classMethod.getCodeAttribute();
        cond.aload(0);
        cond.getfield(classMethod.getClassFile().getName(), CONSTRUCTED_FLAG_NAME, "Z");
        BranchEnd jumpMarker = cond.ifne();
        cond.aload(0);
        cond.loadMethodParameters();
        cond.invokespecial(className, classMethod.getName(), classMethod.getDescriptor());
        cond.returnInstruction();
        cond.branchEnd(jumpMarker);
    }

    protected void createForwardingMethodBody(ClassMethod classMethod, MethodInformation method, ClassMethod staticConstructor) {
        this.createInterceptorBody(classMethod, method, staticConstructor);
    }

    protected void createInterceptorBody(ClassMethod classMethod, MethodInformation method, ClassMethod staticConstructor) {
        this.invokeMethodHandler(classMethod, method, true, DEFAULT_METHOD_RESOLVER, staticConstructor);
    }

    protected void invokeMethodHandler(ClassMethod classMethod, MethodInformation method, boolean addReturnInstruction, BytecodeMethodResolver bytecodeMethodResolver, ClassMethod staticConstructor) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(classMethod.getClassFile(), b);
        b.aload(0);
        bytecodeMethodResolver.getDeclaredMethod(classMethod, method.getDeclaringClass(), method.getName(), method.getParameterTypes(), staticConstructor);
        b.aconstNull();
        b.iconst(method.getParameterTypes().length);
        b.anewarray("java.lang.Object");
        int localVariableCount = 1;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String typeString = method.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary((CodeAttribute)b, (String)typeString);
            b.aastore();
            if (DescriptorUtils.isWide((String)typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(MethodHandler.class.getName(), INVOKE_METHOD_NAME, LJAVA_LANG_OBJECT, new String[]{LJAVA_LANG_OBJECT, LJAVA_LANG_REFLECT_METHOD, LJAVA_LANG_REFLECT_METHOD, "[Ljava/lang/Object;"});
        if (addReturnInstruction) {
            if (method.getReturnType().equals("V")) {
                b.returnInstruction();
            } else if (DescriptorUtils.isPrimitive((String)method.getReturnType())) {
                Boxing.unbox((CodeAttribute)b, (String)method.getReturnType());
                b.returnInstruction();
            } else {
                b.checkcast(BytecodeUtils.getName(method.getReturnType()));
                b.returnInstruction();
            }
        }
    }

    protected void addSpecialMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            for (Method method : LifecycleMixin.class.getMethods()) {
                BeanLogger.LOG.addingMethodToProxy(method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                ClassMethod classMethod = proxyClassType.addMethod(method);
                this.createInterceptorBody(classMethod, methodInfo, staticConstructor);
            }
            Method getInstanceMethod = TargetInstanceProxy.class.getMethod("weld_getTargetInstance", new Class[0]);
            Method getInstanceClassMethod = TargetInstanceProxy.class.getMethod("weld_getTargetClass", new Class[0]);
            RuntimeMethodInformation getInstanceMethodInfo = new RuntimeMethodInformation(getInstanceMethod);
            this.createInterceptorBody(proxyClassType.addMethod(getInstanceMethod), getInstanceMethodInfo, staticConstructor);
            RuntimeMethodInformation getInstanceClassMethodInfo = new RuntimeMethodInformation(getInstanceClassMethod);
            this.createInterceptorBody(proxyClassType.addMethod(getInstanceClassMethod), getInstanceClassMethodInfo, staticConstructor);
            Method setMethodHandlerMethod = ProxyObject.class.getMethod("weld_setHandler", MethodHandler.class);
            this.generateSetMethodHandlerBody(proxyClassType.addMethod(setMethodHandlerMethod));
            Method getMethodHandlerMethod = ProxyObject.class.getMethod("weld_getHandler", new Class[0]);
            this.generateGetMethodHandlerBody(proxyClassType.addMethod(getMethodHandlerMethod));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void generateSetMethodHandlerBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        b.aload(1);
        b.checkcast(this.getMethodHandlerType());
        b.putfield(method.getClassFile().getName(), METHOD_HANDLER_FIELD_NAME, DescriptorUtils.makeDescriptor(this.getMethodHandlerType()));
        b.returnInstruction();
    }

    protected void generateGetMethodHandlerBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(method.getClassFile(), b);
        b.returnInstruction();
    }

    private void addConstructorsForBeanWithPrivateConstructors(ClassFile proxyClassType) {
        ClassMethod ctor = proxyClassType.addMethod(1, INIT_METHOD_NAME, "V", new String[]{LJAVA_LANG_BYTE});
        CodeAttribute b = ctor.getCodeAttribute();
        b.aload(0);
        b.aconstNull();
        b.aconstNull();
        b.invokespecial(proxyClassType.getName(), INIT_METHOD_NAME, "(Ljava/lang/Byte;Ljava/lang/Byte;)V");
        b.returnInstruction();
        ctor = proxyClassType.addMethod(1, INIT_METHOD_NAME, "V", new String[]{LJAVA_LANG_BYTE, LJAVA_LANG_BYTE});
        b = ctor.getCodeAttribute();
        b.aload(0);
        b.aconstNull();
        b.invokespecial(proxyClassType.getName(), INIT_METHOD_NAME, "(Ljava/lang/Byte;)V");
        b.returnInstruction();
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public Set<Class<?>> getAdditionalInterfaces() {
        return this.additionalInterfaces;
    }

    public Bean<?> getBean() {
        return this.bean;
    }

    public String getContextId() {
        return this.contextId;
    }

    protected Class<?> getProxiedBeanType() {
        return this.proxiedBeanType;
    }

    protected void getMethodHandlerField(ClassFile file, CodeAttribute b) {
        b.getfield(file.getName(), METHOD_HANDLER_FIELD_NAME, DescriptorUtils.makeDescriptor(this.getMethodHandlerType()));
    }

    protected Class<?> getProxySuperclass() {
        return this.getBeanType().isInterface() ? Object.class : this.getBeanType();
    }

    protected boolean isUsingProxyInstantiator() {
        return true;
    }

    private boolean useConstructedFlag() {
        return !this.isUsingProxyInstantiator() || this.proxyInstantiator.isUsingConstructor();
    }

    protected Class<?> toClass(ClassFile ct, Class<?> originalClass, ProxyServices proxyServices, ProtectionDomain domain) {
        try {
            byte[] bytecode = ct.toBytecode();
            Class<?> result = domain == null ? proxyServices.defineClass(originalClass, ct.getName(), bytecode, 0, bytecode.length) : proxyServices.defineClass(originalClass, ct.getName(), bytecode, 0, bytecode.length, domain);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HashSet<ProxiedMethodFilter> filters = new HashSet<ProxiedMethodFilter>();
        filters.add(CommonProxiedMethodFilters.NON_STATIC);
        filters.add(CommonProxiedMethodFilters.NON_FINAL);
        filters.add(CommonProxiedMethodFilters.OBJECT_TO_STRING);
        filters.add(CommonProxiedMethodFilters.NON_JDK_PACKAGE_PRIVATE);
        GroovyMethodFilter groovy = new GroovyMethodFilter();
        if (groovy.isEnabled()) {
            filters.add(groovy);
        }
        METHOD_FILTERS = ImmutableSet.copyOf(filters);
    }

    private static class ProxyNameHolder {
        private String packageName;
        private String className;

        private ProxyNameHolder(String packageName, String className, Bean<?> bean) {
            this.packageName = packageName;
            if (className == null) {
                throw BeanLogger.LOG.tryingToCreateProxyNameHolderWithoutClassName(bean.getBeanClass());
            }
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }
}

