/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnvEntriesValidator {
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private final Map<String, Map<String, Object>> componentNamespaces = new HashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> appNamespaces = new HashMap<String, Map<String, Object>>();
    private final Map<AppModuleKey, Map<String, Object>> moduleNamespaces = new HashMap<AppModuleKey, Map<String, Object>>();
    private final Map<String, Object> globalNameSpace = new HashMap<String, Object>();

    public void validateEnvEntries(JndiNameEnvironment env) {
        LOG.log(Level.FINER, "validateEnvEntries: {0}", env);
        if (env instanceof WebBundleDescriptor) {
            Set<EnvironmentProperty> envEntries = ((WebBundleDescriptor)env).getEnvironmentEntries();
            this.validateSimpleEnvEntries(env, envEntries);
        } else {
            Set<EnvironmentProperty> envProperties = env.getEnvironmentProperties();
            this.validateSimpleEnvEntries(env, envProperties);
        }
        Set<EjbReferenceDescriptor> ejbReferences = env.getEjbReferenceDescriptors();
        this.validateEjbReferences(env, ejbReferences);
        Set<ResourceReferenceDescriptor> resRefs = env.getResourceReferenceDescriptors();
        this.validateResRefs(env, resRefs);
        Set<ResourceEnvReferenceDescriptor> resEnvRefs = env.getResourceEnvReferenceDescriptors();
        this.validateResEnvRefs(env, resEnvRefs);
    }

    private void validateSimpleEnvEntries(JndiNameEnvironment env, Set<EnvironmentProperty> envEntries) {
        for (EnvironmentProperty environmentProperty : envEntries) {
            SimpleEnvEntry simpleEnvEntry = new SimpleEnvEntry(environmentProperty);
            this.validateEnvEntry(env, simpleEnvEntry, simpleEnvEntry.getName());
        }
    }

    private void validateEjbReferences(JndiNameEnvironment env, Set<EjbReferenceDescriptor> ejbReferences) {
        for (EjbReference ejbReference : ejbReferences) {
            this.validateEnvEntry(env, ejbReference, ejbReference.getName());
        }
    }

    private void validateResRefs(JndiNameEnvironment env, Set<ResourceReferenceDescriptor> resRefs) {
        for (ResourceReferenceDescriptor resRef : resRefs) {
            this.validateEnvEntry(env, resRef, resRef.getName());
        }
    }

    private void validateResEnvRefs(JndiNameEnvironment env, Set<ResourceEnvReferenceDescriptor> resEnvRefs) {
        for (ResourceEnvReferenceDescriptor resEnvRef : resEnvRefs) {
            this.validateEnvEntry(env, resEnvRef, resEnvRef.getName());
        }
    }

    private void validateEnvEntry(JndiNameEnvironment env, Object curEntry, String name) {
        String logicalJndiName = this.getLogicalJNDIName(name, env);
        Map<String, Object> namespace = this.getNamespace(logicalJndiName, env);
        Object preObject = namespace.get(logicalJndiName);
        LOG.log(Level.FINE, "Validating logical name: {0}, cached object: {1}, validated object: {2}", new Object[]{logicalJndiName, preObject, curEntry});
        if (preObject == null) {
            namespace.put(logicalJndiName, curEntry);
        } else if (preObject instanceof SimpleEnvEntry && curEntry instanceof SimpleEnvEntry) {
            SimpleEnvEntry preEnvEntry = (SimpleEnvEntry)preObject;
            SimpleEnvEntry curEnvEntry = (SimpleEnvEntry)curEntry;
            if (this.areConflicting(preEnvEntry.getType(), curEnvEntry.getType()) || this.areConflicting(preEnvEntry.getValue(), curEnvEntry.getValue())) {
                this.throwConflictException(name, namespace.toString());
            }
        } else if (preObject instanceof EjbReference && curEntry instanceof EjbReference) {
            EjbReference preRef = (EjbReference)preObject;
            EjbReference curRef = (EjbReference)curEntry;
            if (this.areConflicting(preRef.getType(), curRef.getType()) || this.areConflicting(preRef.getEjbHomeInterface(), curRef.getEjbHomeInterface()) || this.areConflicting(preRef.getEjbInterface(), curRef.getEjbInterface()) || preRef.getLinkName() != null && curRef.getLinkName() != null && !preRef.getLinkName().equals(curRef.getLinkName()) || preRef.isLocal() != curRef.isLocal() || this.areConflicting(preRef.getLookupName(), curRef.getLookupName())) {
                this.throwConflictException(name, namespace.toString());
            }
        } else if (preObject instanceof ResourceReferenceDescriptor && curEntry instanceof ResourceReferenceDescriptor) {
            ResourceReferenceDescriptor preRef = (ResourceReferenceDescriptor)preObject;
            ResourceReferenceDescriptor curRef = (ResourceReferenceDescriptor)curEntry;
            if (this.areConflicting(preRef.getType(), curRef.getType()) || this.areConflicting(preRef.getAuthorization(), curRef.getAuthorization()) || this.areConflicting(preRef.getSharingScope(), curRef.getSharingScope()) || this.areConflicting(preRef.getMappedName(), curRef.getMappedName()) || this.areConflicting(preRef.getLookupName(), curRef.getLookupName())) {
                this.throwConflictException(name, namespace.toString());
            }
        } else if (preObject instanceof ResourceEnvReferenceDescriptor && curEntry instanceof ResourceEnvReferenceDescriptor) {
            ResourceEnvReferenceDescriptor preRef = (ResourceEnvReferenceDescriptor)preObject;
            ResourceEnvReferenceDescriptor curRef = (ResourceEnvReferenceDescriptor)curEntry;
            if (this.areConflicting(preRef.getType(), curRef.getType()) || this.areConflicting(preRef.getRefType(), curRef.getRefType()) || this.areConflicting(preRef.getMappedName(), curRef.getMappedName()) || this.areConflicting(preRef.getLookupName(), curRef.getLookupName())) {
                this.throwConflictException(name, namespace.toString());
            }
        } else {
            this.throwConflictException(name, namespace.toString());
        }
    }

    private Map<String, Object> getNamespace(String logicalJndiName, JndiNameEnvironment env) {
        String appName = DOLUtils.getApplicationName(env);
        LOG.log(Level.FINE, "appName={0}", appName);
        if (logicalJndiName.startsWith("java:comp/")) {
            String componentId = DOLUtils.getComponentEnvId(env);
            LOG.log(Level.FINEST, "Resolved componentId: {0}", componentId);
            Map<String, Object> namespace = this.componentNamespaces.get(componentId);
            if (namespace == null) {
                namespace = new HashMap<String, Object>();
                this.componentNamespaces.put(componentId, namespace);
            }
            return namespace;
        }
        if (logicalJndiName.startsWith("java:module/")) {
            String moduleName = DOLUtils.getModuleName(env);
            AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
            Map<String, Object> namespace = this.moduleNamespaces.get(appModuleKey);
            if (namespace == null) {
                namespace = new HashMap<String, Object>();
                this.moduleNamespaces.put(appModuleKey, namespace);
            }
            return namespace;
        }
        if (logicalJndiName.startsWith("java:app/")) {
            Map<String, Object> namespace = this.appNamespaces.get(appName);
            if (namespace == null) {
                namespace = new HashMap<String, Object>();
                this.appNamespaces.put(appName, namespace);
            }
            return namespace;
        }
        return this.globalNameSpace;
    }

    private void throwConflictException(String jndiName, String namespace) {
        throw new IllegalStateException("Naming binding already exists for " + jndiName + " in namespace " + namespace);
    }

    private <T> boolean areConflicting(T s1, T s2) {
        LOG.log(Level.FINEST, "areConflicting? {0} ||| {1}", new Object[]{s1, s2});
        return s1 != null && !s1.equals(s2) || s2 != null && !s2.equals(s1);
    }

    private String rawNameToLogicalJndiName(String rawName) {
        return rawName.startsWith("java:") ? rawName : "java:comp/env/" + rawName;
    }

    private String logicalCompJndiNameToModule(String logicalCompName) {
        String tail = logicalCompName.substring("java:comp/".length());
        return "java:module/" + tail;
    }

    private String getLogicalJNDIName(String name, JndiNameEnvironment env) {
        String logicalJndiName = this.rawNameToLogicalJndiName(name);
        boolean treatComponentAsModule = DOLUtils.getTreatComponentAsModule(env);
        if (treatComponentAsModule && logicalJndiName.startsWith("java:comp/")) {
            logicalJndiName = this.logicalCompJndiNameToModule(logicalJndiName);
        }
        return logicalJndiName;
    }

    private static class SimpleEnvEntry
    extends EnvironmentProperty {
        private static final long serialVersionUID = 1L;

        SimpleEnvEntry(EnvironmentProperty envEntry) {
            super(envEntry.getName(), envEntry.getValue(), envEntry.getDescription(), envEntry.getType());
        }
    }

    private static class AppModuleKey {
        private final String app;
        private final String module;

        AppModuleKey(String appName, String moduleName) {
            this.app = Objects.requireNonNull(appName, "appName");
            this.module = Objects.requireNonNull(moduleName, "moduleName");
        }

        public boolean equals(Object o) {
            if (o instanceof AppModuleKey) {
                AppModuleKey other = (AppModuleKey)o;
                if (this.app.equals(other.app) && this.module.equals(other.module)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.app, this.module);
        }

        public String toString() {
            return "appName = " + this.app + " , module = " + this.module;
        }
    }
}

