/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.comm;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.MQSQLException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.TableSchema;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class CommDBManager {
    private static final String JDBC_STORE_TYPE = "jdbc";
    private static final String TABLEOPTION_NAME_VARIABLE = "tableoption";
    private static final String TABLE_NAME_VARIABLE = "name";
    private static final String INDEX_NAME_VARIABLE = "index";
    private static final String LOGIN_TIMEOUT_PROP_SUFFIX = ".loginTimeout";
    private static final String TRANSACTION_RETRY_MAX_PROP_SUFFIX = ".transaction.retry.max";
    private static final String TRANSACTION_RETRY_DELAY_PROP_SUFFIX = ".transaction.retry.delay";
    public static final int TRANSACTION_RETRY_MAX_DEFAULT = 5;
    public static final long TRANSACTION_RETRY_DELAY_DEFAULT = 2000L;
    private static final int CONNECTION_RETRY_MAX_DEFAULT = 60;
    private static final long CONNECTION_RETRY_DELAY_DEFAULT = 5000L;
    private static final String CONNECTION_RETRY_MAX_PROP_SUFFIX = ".connection.retry.max";
    private static final String CONNECTION_RETRY_DELAY_PROP_SUFFIX = ".connection.retry.delay";
    private static final String CONNECTION_RETRY_REGEX_PROP_SUFFIX = ".connection.retry.regex";
    private static final String SQL_RETRIABLE_ERROR_CODES_PROP_SUFFIX = ".sqlRetriableErrorCodes";
    protected static final String VENDOR_PROP_SUFFIX = ".dbVendor";
    protected static final String FALLBACK_USER_PROP_SUFFIX = ".user";
    protected static final String FALLBACK_PWD_PROP_SUFFIX = ".password";
    private static final String USE_DERIVEDTABLE_FOR_UNIONSUBQUERIES_SUFFIX = ".useDerivedTableForUnionSubQueries";
    private static final String UNKNOWN_VENDOR = "unknown";
    private static final boolean DEFAULT_NEEDPASSWORD = false;
    private String vendor = null;
    private String vendorPropPrefix = null;
    private String tablePropPrefix = null;
    private String vendorProp = null;
    private String driverProp = null;
    private String openDBUrlProp = null;
    private String createDBUrlProp = null;
    private String closeDBUrlProp = null;
    private String userProp = null;
    private String passwordProp = null;
    private String needPasswordProp = null;
    public int txnRetryMax;
    public long txnRetryDelay;
    public int connRetryMax = 60;
    public long connRetryDelay = 5000L;
    private String driver = null;
    private String openDBUrl = null;
    private String createDBUrl = null;
    protected String closeDBUrl = null;
    private String user = null;
    private String password = null;
    private boolean isDataSource = false;
    private boolean isPoolDataSource = false;
    private Object dataSource = null;
    protected boolean isOracle = false;
    protected boolean isOraDriver = false;
    protected boolean isMysql = false;
    private boolean isDerby = false;
    private boolean isDB2 = false;
    private boolean isPostgreSQL = false;
    private boolean supportBatch = false;
    private boolean supportGetGeneratedKey = false;
    private String dbProductName = null;
    private String dbProductVersion = null;
    private int dbProductMajorVersion = -1;
    private int sqlStateType = 2;
    private boolean useDerivedTableForUnionSubQueries = false;
    protected String tableSuffix = null;
    protected BrokerConfig config = Globals.getConfig();
    protected BrokerResources br = Globals.getBrokerResources();
    protected Logger logger = Globals.getLogger();
    private boolean isJDBC4 = true;
    private boolean isClosing = false;
    protected HashMap tableSchemas = new HashMap();
    private ArrayList<String> reconnectPatterns = new ArrayList();
    private static final String DEFAULT_CONNECTION_RETRY_PATTERN = "(?s).*";
    private ArrayList<Integer> sqlRetriableErrorCodes = new ArrayList();
    private Integer loginTimeout = null;
    private ConfigListener cfgListener = new ConfigListener(){

        @Override
        public void validate(String name, String value) throws PropertyUpdateException {
            if (name.equals(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_DELAY_PROP_SUFFIX)) {
                long v = -1L;
                try {
                    v = Long.parseLong(value);
                }
                catch (Exception e) {
                    throw new PropertyUpdateException(CommDBManager.this.br.getString("B4027", name + "=" + value), e);
                }
                if (v < 0L) {
                    throw new PropertyUpdateException(name + "=" + value);
                }
            }
        }

        @Override
        public boolean update(String name, String value) {
            BrokerConfig cfg = Globals.getConfig();
            if (name.equals(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_DELAY_PROP_SUFFIX)) {
                CommDBManager.this.connRetryDelay = cfg.getLongProperty(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_DELAY_PROP_SUFFIX);
            } else if (name.equals(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_MAX_PROP_SUFFIX)) {
                CommDBManager.this.connRetryMax = cfg.getIntProperty(CommDBManager.this.getJDBCPropPrefix() + CommDBManager.CONNECTION_RETRY_MAX_PROP_SUFFIX);
            }
            return true;
        }
    };
    public static final Class TRANSIENT_SQLEX_CLASS = CommDBManager.GET_TRANSIENT_SQLEX_CLASS();
    public static final Class NON_TRANSIENT_SQLEX_CLASS = CommDBManager.GET_NONTRANSIENT_SQLEX_CLASS();
    public static final Class RECOVERABLE_SQLEX_CLASS = CommDBManager.GET_RECOVERABLE_SQLEX_CLASS();
    public static final Class TRANSIENT_CONNECTION_SQLEX_CLASS = CommDBManager.GET_TRANSIENT_CONNECTION_SQLEX_CLASS();
    public static final Class TIMEOUT_SQLEX_CLASS = CommDBManager.GET_TIMEOUT_SQLEX_CLASS();
    public static final Class TRANSACTION_ROLLBACK_SQLEX_CLASS = CommDBManager.GET_TRANSACTION_ROLLBACK_SQLEX_CLASS();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDBMetaData() throws BrokerException {
        int maxTableNameLength = 0;
        Connection conn = null;
        SQLException myex = null;
        try {
            conn = this.getConnection(true);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            this.dbProductName = dbMetaData.getDatabaseProductName();
            this.dbProductVersion = dbMetaData.getDatabaseProductVersion();
            this.dbProductMajorVersion = dbMetaData.getDatabaseMajorVersion();
            this.supportBatch = dbMetaData.supportsBatchUpdates();
            this.sqlStateType = dbMetaData.getSQLStateType();
            maxTableNameLength = dbMetaData.getMaxTableNameLength();
            String driverv = dbMetaData.getDriverVersion();
            this.supportGetGeneratedKey = dbMetaData.supportsGetGeneratedKeys();
            this.isOraDriver = "oracle".equalsIgnoreCase(this.dbProductName);
            String logMsg = new StringBuilder(256).append(this.getLogStringTag() + "DBManager: database product name=").append(this.dbProductName).append(", database version number=").append(this.dbProductVersion).append(", driver version number=").append(driverv).append(", supports batch updates=").append(this.supportBatch).append(", supports getGeneratedKey=").append(this.supportGetGeneratedKey).toString();
            this.logger.log(64, this.getLogStringTag() + this.dbProductName + ", " + this.dbProductVersion + ", " + driverv);
            this.logger.log(Store.getDEBUG() ? 8 : 4, logMsg);
        }
        catch (SQLException e) {
            myex = e;
            this.logger.log(16, "B4164", e);
        }
        finally {
            this.closeSQLObjects(null, null, conn, myex);
        }
        if (maxTableNameLength > 0) {
            this.checkMaxTableNameLength(maxTableNameLength);
        }
    }

    protected abstract boolean getDEBUG();

    protected abstract boolean isStoreInited();

    protected abstract String getLogStringTag();

    protected abstract String getJDBCPropPrefix();

    protected abstract String getStoreTypeProp();

    protected abstract String getCreateStoreProp();

    protected abstract boolean getCreateStorePropDefault();

    protected abstract void checkMaxTableNameLength(int var1) throws BrokerException;

    public String toString() {
        return "CommDBManager";
    }

    protected boolean isJDBC4() {
        return this.isJDBC4;
    }

    protected void setJDBC4(boolean b) {
        this.isJDBC4 = b;
    }

    public String getOpenDBUrlProp() {
        return this.openDBUrlProp;
    }

    public String getOpenDBUrl() {
        return this.openDBUrl;
    }

    public String getVendorProp() {
        return this.vendorProp;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<String> getReconnectPatterns() {
        return this.reconnectPatterns;
    }

    protected void initDBManagerProps() throws BrokerException {
        String fallbackProp;
        String strv;
        String JDBC_PROP_PREFIX = this.getJDBCPropPrefix();
        String name = JDBC_PROP_PREFIX + USE_DERIVEDTABLE_FOR_UNIONSUBQUERIES_SUFFIX;
        this.useDerivedTableForUnionSubQueries = this.config.getBooleanProperty(name, false);
        if (this.useDerivedTableForUnionSubQueries) {
            this.logger.log(8, name + "=true");
        }
        if ((strv = this.config.getProperty(name = JDBC_PROP_PREFIX + LOGIN_TIMEOUT_PROP_SUFFIX)) != null) {
            try {
                int v = Integer.parseInt(strv);
                if (v < 0) {
                    String emsg = Globals.getBrokerResources().getKString("B4027", name + "=" + strv);
                    throw new BrokerException(emsg);
                }
                this.loginTimeout = v;
                this.logger.log(8, name + "=" + strv);
            }
            catch (Exception e) {
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                String emsg = Globals.getBrokerResources().getKString("B4027", name + "=" + strv) + ": " + e;
                this.logger.log(32, emsg, e);
                throw new BrokerException(emsg);
            }
        }
        this.txnRetryMax = this.config.getIntProperty(JDBC_PROP_PREFIX + TRANSACTION_RETRY_MAX_PROP_SUFFIX, 5);
        this.txnRetryDelay = this.config.getLongProperty(JDBC_PROP_PREFIX + TRANSACTION_RETRY_DELAY_PROP_SUFFIX, 2000L);
        if (this.txnRetryDelay < 0L) {
            this.txnRetryDelay = 2000L;
        }
        this.connRetryMax = this.config.getIntProperty(JDBC_PROP_PREFIX + CONNECTION_RETRY_MAX_PROP_SUFFIX, 60);
        this.logger.log(8, JDBC_PROP_PREFIX + ".connection.retry.max=" + this.connRetryMax);
        this.connRetryDelay = this.config.getLongProperty(JDBC_PROP_PREFIX + CONNECTION_RETRY_DELAY_PROP_SUFFIX, 5000L);
        if (this.connRetryDelay < 0L) {
            this.connRetryDelay = 5000L;
        }
        this.logger.log(8, JDBC_PROP_PREFIX + JDBC_PROP_PREFIX + ".connection.retry.delay=" + this.connRetryDelay);
        Globals.getConfig().addListener(JDBC_PROP_PREFIX + CONNECTION_RETRY_MAX_PROP_SUFFIX, this.cfgListener);
        Globals.getConfig().addListener(JDBC_PROP_PREFIX + CONNECTION_RETRY_DELAY_PROP_SUFFIX, this.cfgListener);
        String type = this.config.getProperty(this.getStoreTypeProp());
        if (type == null || !type.equals(JDBC_STORE_TYPE)) {
            type = type == null ? "" : type;
            throw new BrokerException(this.br.getKString("B3103", this.getStoreTypeProp() + "=" + type, JDBC_STORE_TYPE));
        }
        this.vendorProp = JDBC_PROP_PREFIX + VENDOR_PROP_SUFFIX;
        this.vendor = this.config.getProperty(this.vendorProp, UNKNOWN_VENDOR);
        this.vendorPropPrefix = JDBC_PROP_PREFIX + "." + this.vendor;
        this.tablePropPrefix = this.vendorPropPrefix + ".table";
        this.driverProp = this.vendorPropPrefix + ".driver";
        this.driver = this.config.getProperty(this.driverProp);
        if (this.driver == null || this.driver.length() == 0) {
            fallbackProp = JDBC_PROP_PREFIX + ".driver";
            this.driver = this.config.getProperty(fallbackProp);
            if (this.driver == null || this.driver.length() == 0) {
                throw new BrokerException(this.br.getKString("B3023", this.driverProp));
            }
            this.driverProp = fallbackProp;
        }
        this.logger.log(64, this.driverProp + "=" + this.driver);
        this.openDBUrlProp = this.vendorPropPrefix + ".opendburl";
        this.openDBUrl = this.config.getProperty(this.openDBUrlProp);
        if (this.openDBUrl == null || this.openDBUrl.length() == 0) {
            fallbackProp = JDBC_PROP_PREFIX + ".opendburl";
            this.openDBUrl = this.config.getProperty(fallbackProp);
            if (this.openDBUrl != null && this.openDBUrl.trim().length() > 0) {
                this.openDBUrlProp = fallbackProp;
            }
        }
        this.openDBUrl = StringUtil.expandVariables(this.openDBUrl, this.config);
        if (this.openDBUrl != null) {
            this.logger.log(64, this.openDBUrlProp + "=" + this.openDBUrl);
        }
        this.createDBUrlProp = this.vendorPropPrefix + ".createdburl";
        this.createDBUrl = this.config.getProperty(this.createDBUrlProp);
        if (this.createDBUrl == null || this.createDBUrl.length() == 0) {
            fallbackProp = JDBC_PROP_PREFIX + ".createdburl";
            this.createDBUrl = this.config.getProperty(fallbackProp);
            if (this.createDBUrl != null) {
                this.createDBUrlProp = fallbackProp;
            }
        }
        this.createDBUrl = StringUtil.expandVariables(this.createDBUrl, this.config);
        if (this.createDBUrl != null) {
            this.logger.log(64, this.createDBUrlProp + "=" + this.createDBUrl);
        }
        this.closeDBUrlProp = this.vendorPropPrefix + ".closedburl";
        this.closeDBUrl = this.config.getProperty(this.closeDBUrlProp);
        if (this.closeDBUrl == null || this.closeDBUrl.length() == 0) {
            fallbackProp = JDBC_PROP_PREFIX + ".closedburl";
            this.closeDBUrl = this.config.getProperty(fallbackProp);
            if (this.closeDBUrl != null) {
                this.closeDBUrlProp = fallbackProp;
            }
        }
        this.closeDBUrl = StringUtil.expandVariables(this.closeDBUrl, this.config);
        if (this.closeDBUrl != null) {
            this.logger.log(64, this.closeDBUrlProp + "=" + this.closeDBUrl);
        }
        this.userProp = this.vendorPropPrefix + FALLBACK_USER_PROP_SUFFIX;
        this.user = this.config.getProperty(this.userProp);
        if (this.user == null) {
            this.user = this.config.getProperty(JDBC_PROP_PREFIX + FALLBACK_USER_PROP_SUFFIX);
            if (this.user != null) {
                this.userProp = JDBC_PROP_PREFIX + FALLBACK_USER_PROP_SUFFIX;
            }
        }
        String regex = this.vendorPropPrefix + CONNECTION_RETRY_REGEX_PROP_SUFFIX;
        int i = 1;
        String p = null;
        String v = null;
        while ((v = this.config.getProperty(p = regex + "." + i++)) != null) {
            try {
                "A".matches(v);
                this.reconnectPatterns.add(v);
                this.logger.log(8, p + "=" + v);
            }
            catch (Exception e) {
                throw new BrokerException("[" + p + "=" + v + "]: " + e.toString(), e);
            }
        }
        if (this.reconnectPatterns.size() == 0) {
            this.reconnectPatterns.add(DEFAULT_CONNECTION_RETRY_PATTERN);
            this.logger.log(8, regex + "=(?s).*");
        }
        String sqlRetriablesp = this.vendorPropPrefix + SQL_RETRIABLE_ERROR_CODES_PROP_SUFFIX;
        String sqlRetriablesv = this.config.getProperty(sqlRetriablesp);
        List sqlRetriables = this.config.getList(sqlRetriablesp);
        if (sqlRetriables != null && sqlRetriables.size() > 0) {
            this.logger.log(8, sqlRetriablesp + "=" + sqlRetriablesv);
            Integer val = null;
            for (String ecode : sqlRetriables) {
                try {
                    val = Integer.valueOf(ecode);
                    this.sqlRetriableErrorCodes.add(val);
                }
                catch (Exception e) {
                    Object[] eargs = new String[]{ecode, sqlRetriablesp + "=" + sqlRetriablesv, e.toString()};
                    this.logger.log(16, this.br.getKString("B2262", eargs));
                }
            }
        }
        this.initTableSuffix();
    }

    public boolean isRetriableSQLErrorCode(int errorCode) {
        return this.sqlRetriableErrorCodes.contains(errorCode);
    }

    protected abstract void initTableSuffix() throws BrokerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDBDriver() throws BrokerException {
        String JDBC_PROP_PREFIX = this.getJDBCPropPrefix();
        try {
            Class<?> driverCls = null;
            Object driverObj = null;
            if (Globals.isNucleusManagedBroker()) {
                driverObj = Globals.getHabitat().getService(DataSource.class, this.driver, new Annotation[0]);
                if (driverObj == null) {
                    driverObj = Globals.getHabitat().getService(ConnectionPoolDataSource.class, this.driver, new Annotation[0]);
                }
                if (driverObj == null && this.isMysql()) {
                    driverObj = Globals.getHabitat().getService(Driver.class, "com.mysql.jdbc.Driver", new Annotation[0]);
                }
                if (driverObj == null) {
                    throw new ClassNotFoundException(this.driver);
                }
                driverCls = driverObj.getClass();
            } else {
                driverCls = Class.forName(this.driver);
                driverObj = driverCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (driverObj instanceof ConnectionPoolDataSource) {
                this.isDataSource = true;
                this.isPoolDataSource = true;
            } else if (driverObj instanceof DataSource) {
                this.isDataSource = true;
            } else if (this.openDBUrl == null || this.openDBUrl.length() == 0) {
                throw new BrokerException(this.br.getKString("B3025", this.openDBUrlProp));
            }
            if (this.isDataSource) {
                this.dataSource = driverObj;
                this.initDataSource(driverCls, this.dataSource);
            } else {
                this.initDriverManager();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BrokerException(this.br.getKString("B3024", this.driver), e);
        }
        catch (BrokerException e) {
            throw e;
        }
        this.password = this.getPassword();
        if (UNKNOWN_VENDOR.equals(this.vendor)) {
            Connection conn = null;
            String dbName = null;
            try {
                conn = this.getNewConnection(true);
                DatabaseMetaData dbMetaData = conn.getMetaData();
                dbName = dbMetaData.getDatabaseProductName();
            }
            catch (Exception exception) {
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            if ("oracle".equalsIgnoreCase(dbName)) {
                this.vendor = "oracle";
                this.vendorPropPrefix = JDBC_PROP_PREFIX + "." + this.vendor;
                this.tablePropPrefix = this.vendorPropPrefix + ".table";
            } else {
                throw new BrokerException(this.br.getKString("B3212", this.getJDBCPropPrefix() + VENDOR_PROP_SUFFIX));
            }
        }
        if (this.vendor.equalsIgnoreCase("oracle")) {
            this.isOracle = true;
        } else if (this.vendor.equalsIgnoreCase("mysql")) {
            this.isMysql = true;
        } else if (this.vendor.equalsIgnoreCase("derby")) {
            this.isDerby = true;
        } else if (this.vendor.equalsIgnoreCase("postgresql")) {
            this.isPostgreSQL = true;
        } else if (this.vendor.equalsIgnoreCase("db2")) {
            this.isDB2 = true;
        }
    }

    public boolean isUseDerivedTableForUnionSubQueries() {
        return this.useDerivedTableForUnionSubQueries;
    }

    public boolean isPoolDataSource() {
        return this.isPoolDataSource;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("vendor", this.vendor);
        ht.put("user", this.user);
        ht.put("isDataSource", this.isDataSource);
        ht.put("isPoolDataSource", this.isPoolDataSource);
        ht.put("supportBatch", this.supportBatch);
        ht.put("supportGetGeneratedKey", this.supportGetGeneratedKey);
        ht.put("sqlStateType", String.valueOf(this.sqlStateType));
        ht.put("isJDBC4", this.isJDBC4);
        return ht;
    }

    public TableSchema getTableSchema(String tableName) throws BrokerException {
        HashMap schemas = this.getTableSchemas();
        TableSchema tableSchema = (TableSchema)schemas.get(tableName);
        if (tableSchema == null || tableSchema.tableSQL.length() == 0) {
            throw new BrokerException(this.br.getKString("B3127", tableName, this.getJDBCPropPrefix() + VENDOR_PROP_SUFFIX));
        }
        return tableSchema;
    }

    public abstract boolean hasSupplementForCreateDrop(String var1);

    protected void createTableSupplement(Statement stmt, TableSchema tableSchema, String tableName) throws BrokerException {
        String sql = tableSchema.afterCreateSQL;
        if (sql == null) {
            return;
        }
        this.logger.logToAll(8, this.br.getKString("B1365", sql, tableName));
        try {
            int cnt = CommDBManager.executeUpdateStatement(stmt, sql);
            if (cnt != 0 || stmt.getWarnings() != null) {
                String emsg = "[" + sql + "]: " + stmt.getWarnings() + "(return=" + cnt + ")";
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Throwable t) {
            if (t instanceof BrokerException) {
                throw (BrokerException)t;
            }
            String emsg = "[" + sql + "]: " + t.getMessage();
            this.logger.logStack(32, emsg, t);
            throw new BrokerException(emsg);
        }
    }

    public void dropOldTableSupplement(Statement stmt, String oldTableName, boolean throwException) throws BrokerException {
    }

    public void dropTableSupplement(Statement stmt, TableSchema tableSchema, String tableName, boolean throwException) throws BrokerException {
        String sql = tableSchema.afterDropSQL;
        if (sql == null) {
            return;
        }
        this.logger.logToAll(8, this.br.getKString("B1366", sql, tableName));
        try {
            int cnt = CommDBManager.executeUpdateStatement(stmt, sql);
            if (cnt != 0 || stmt.getWarnings() != null) {
                String emsg = "[" + sql + "]: " + stmt.getWarnings() + "(return=" + cnt + ")";
                throw new BrokerException(emsg);
            }
        }
        catch (Throwable t) {
            BrokerException ex = null;
            if (t instanceof BrokerException) {
                ex = (BrokerException)t;
            } else {
                String emsg = "[" + sql + "]: " + t.getMessage();
                ex = new BrokerException(emsg);
            }
            if (throwException) {
                this.logger.logStack(16, ex.getMessage(), t);
                throw ex;
            }
            this.logger.log(8, ex.getMessage());
        }
    }

    public Connection connectToCreate() throws BrokerException {
        if (this.createDBUrl == null) {
            throw new BrokerException(this.br.getKString("B3025", this.createDBUrlProp));
        }
        Connection conn = null;
        try {
            conn = this.user == null ? DriverManager.getConnection(this.createDBUrl) : DriverManager.getConnection(this.createDBUrl, this.user, this.password);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.logger.logStack(16, "Unable to close JDBC connection: " + sqe + " after SQLException ", e);
                }
            }
            throw new BrokerException(this.br.getKString("B3026", this.createDBUrl), e);
        }
        return conn;
    }

    public Connection getNewConnection(boolean autocommit) throws BrokerException {
        Object c = this.newConnection(true);
        if (c instanceof PooledConnection) {
            final PooledConnection pc = (PooledConnection)c;
            pc.addConnectionEventListener(new ConnectionEventListener(){

                @Override
                public void connectionClosed(ConnectionEvent event) {
                    pc.removeConnectionEventListener(this);
                    try {
                        pc.close();
                    }
                    catch (Exception e) {
                        Logger cfr_ignored_0 = CommDBManager.this.logger;
                        BrokerResources cfr_ignored_1 = CommDBManager.this.br;
                        CommDBManager.this.logger.log(16, CommDBManager.this.br.getKString("B2229", pc.getClass().getName() + "[0x" + pc.hashCode() + "]", e.toString()));
                    }
                }

                @Override
                public void connectionErrorOccurred(ConnectionEvent event) {
                    Logger cfr_ignored_0 = CommDBManager.this.logger;
                    BrokerResources cfr_ignored_1 = CommDBManager.this.br;
                    CommDBManager.this.logger.log(16, CommDBManager.this.br.getKString("B2231", "0x" + pc.hashCode(), "" + event.getSQLException()));
                    pc.removeConnectionEventListener(this);
                    try {
                        pc.close();
                    }
                    catch (Exception e) {
                        Logger cfr_ignored_2 = CommDBManager.this.logger;
                        BrokerResources cfr_ignored_3 = CommDBManager.this.br;
                        CommDBManager.this.logger.log(16, CommDBManager.this.br.getKString("B2229", pc.getClass().getName() + "[0x" + pc.hashCode() + "]", e.toString()));
                    }
                }
            });
        }
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    Connection conn = null;
                    conn = c instanceof PooledConnection ? ((PooledConnection)c).getConnection() : (Connection)c;
                    conn.setAutoCommit(autocommit);
                    return conn;
                }
                catch (Exception e) {
                    BrokerException ex = new BrokerException(e.getMessage(), e);
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this);
                    }
                    retry.assertShouldRetry(ex);
                    continue;
                }
                break;
            }
        }
        catch (BrokerException e) {
            try {
                if (c instanceof PooledConnection) {
                    ((PooledConnection)c).close();
                } else {
                    ((Connection)c).close();
                }
            }
            catch (Throwable t) {
                this.logger.log(16, this.br.getKString("B2229", c.getClass().getName() + "[0x" + c.hashCode() + "]", t.toString()));
            }
            throw e;
        }
    }

    protected Object getNewConnection() throws BrokerException {
        return this.newConnection(false);
    }

    protected Object newConnection(boolean doRetry) throws BrokerException {
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                try {
                    Object conn = null;
                    conn = this.dataSource != null ? (this.isPoolDataSource ? (this.user == null ? ((ConnectionPoolDataSource)this.dataSource).getPooledConnection() : ((ConnectionPoolDataSource)this.dataSource).getPooledConnection(this.user, this.password)) : (this.user == null ? ((DataSource)this.dataSource).getConnection() : ((DataSource)this.dataSource).getConnection(this.user, this.password))) : (this.user == null ? DriverManager.getConnection(this.openDBUrl) : DriverManager.getConnection(this.openDBUrl, this.user, this.password));
                    return conn;
                }
                catch (Exception e) {
                    throw new BrokerException(this.br.getKString("B3026", this.openDBUrl), e);
                }
            }
            catch (BrokerException e) {
                if (!doRetry) {
                    throw e;
                }
                if (retry == null) {
                    retry = new Util.RetryStrategy(this, this.connRetryDelay, this.connRetryMax, true);
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    public Connection getConnection(boolean autocommit) throws BrokerException {
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                Connection conn = this.getConnectionNoRetry(autocommit);
                return conn;
            }
            catch (BrokerException e) {
                if (BrokerStateHandler.isStoreShutdownStage1()) {
                    throw e;
                }
                if (retry == null) {
                    retry = new Util.RetryStrategy(this, this.connRetryDelay, this.connRetryMax, true);
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnectionNoRetry(boolean autocommit) throws BrokerException {
        SQLException exception = null;
        Connection conn = this.getConnection();
        try {
            try {
                conn.setAutoCommit(autocommit);
            }
            catch (SQLException e) {
                exception = e;
                throw new BrokerException(this.br.getKString("B4117", "Unable to set connection's auto-commit mode"), e);
            }
        }
        finally {
            if (exception != null) {
                this.freeConnection(conn, exception);
            }
        }
        return conn;
    }

    protected abstract Connection getConnection() throws BrokerException;

    public abstract void freeConnection(Connection var1, Throwable var2) throws BrokerException;

    protected abstract BaseDAO getFirstDAO() throws BrokerException;

    public void setIsClosing() {
        this.isClosing = true;
    }

    public boolean getIsClosing() {
        return this.isClosing;
    }

    protected void close() {
        if (this.closeDBUrl != null) {
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(this.closeDBUrl);
            }
            catch (SQLException e) {
                if (Store.getDEBUG()) {
                    this.logger.log(4, this.getLogStringTag() + "B1052", (Object)this.closeDBUrl, (Throwable)e);
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public boolean supportsBatchUpdates() {
        return this.supportBatch;
    }

    public boolean supportsGetGeneratedKey() {
        return this.supportGetGeneratedKey;
    }

    public boolean isMysql() {
        return this.isMysql;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public boolean isDB2() {
        return this.isDB2;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isOracleDriver() {
        return this.isOraDriver;
    }

    public int getDBProductMajorVersion() {
        return this.dbProductMajorVersion;
    }

    public int getSQLStateType() {
        return this.sqlStateType;
    }

    public String getOpenDBURL() {
        return this.openDBUrl;
    }

    public String getCreateDBURL() {
        return this.createDBUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getClusterID() {
        return Globals.getClusterID();
    }

    public String getTableName(String tableNamePrefix) {
        if (tableNamePrefix == null || tableNamePrefix.length() == 0) {
            throw new NullPointerException();
        }
        return tableNamePrefix + this.tableSuffix;
    }

    public String getTableSuffix() {
        return this.tableSuffix;
    }

    public String[] getAllOldTableNames() {
        return new String[0];
    }

    public abstract String[] getTableNames(int var1);

    public String getDriver() {
        return this.driver;
    }

    public abstract Iterator allDAOIterator() throws BrokerException;

    HashMap getTableSchemas() {
        return this.tableSchemas;
    }

    public abstract int checkStoreExists(Connection var1) throws BrokerException;

    protected int checkStoreExists(Connection conn, String version) throws BrokerException {
        Map tables = this.getTableNamesFromDB(conn, (String)(version == null ? this.tableSuffix : version + this.tableSuffix), true);
        int total = 0;
        int found = 0;
        Iterator itr = this.allDAOIterator();
        StringBuilder sbuf = new StringBuilder();
        while (itr.hasNext()) {
            ++total;
            String tname = ((BaseDAO)itr.next()).getTableName();
            if (tables.containsKey(tname.toLowerCase())) {
                ++found;
                continue;
            }
            sbuf.append(tname + " ");
        }
        if (found > 0 && found != total) {
            this.logger.log(16, this.br.getKString("B2221", sbuf.toString() + "[" + total + "," + found + ", " + this.tableSuffix + "]"));
            return -1;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTableNamesFromDB(Connection conn, String namePattern, boolean isSuffix) throws BrokerException {
        if (namePattern == null || namePattern.trim().length() == 0) {
            namePattern = this.tableSuffix;
            isSuffix = true;
        }
        namePattern = namePattern.toLowerCase();
        HashMap<String, String> tableNames = new HashMap<String, String>();
        Util.RetryStrategy retry = null;
        while (true) {
            boolean myConn = false;
            ResultSet rs = null;
            Exception myex = null;
            try {
                if (conn == null) {
                    conn = this.getConnection(true);
                    myConn = true;
                }
                DatabaseMetaData dbMetaData = conn.getMetaData();
                String[] tTypes = new String[]{"TABLE"};
                rs = dbMetaData.getTables(null, null, null, tTypes);
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (tableName == null) continue;
                    if ((tableName = tableName.trim()).length() == 0) {
                        throw new BrokerException(this.br.getKString("B4309", "DatabaseMetaData.getTables()"));
                    }
                    if (tableName.length() < 2) continue;
                    char ch1 = tableName.charAt(0);
                    char ch2 = tableName.charAt(1);
                    if (ch1 != 'm' && ch1 != 'M' || ch2 != 'q' && ch2 != 'Q') continue;
                    String key = tableName.toLowerCase();
                    if (isSuffix) {
                        if (!key.endsWith(namePattern)) continue;
                        tableNames.put(key, tableName);
                        continue;
                    }
                    if (key.indexOf(namePattern) <= -1) continue;
                    tableNames.put(key, tableName);
                }
                if (!myConn) break;
            }
            catch (Exception e) {
                try {
                    myex = e;
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this);
                    }
                    retry.assertShouldRetry(e);
                    if (!myConn) continue;
                }
                catch (Throwable throwable) {
                    if (myConn) {
                        this.closeSQLObjects(rs, null, conn, myex);
                    }
                    throw throwable;
                }
                this.closeSQLObjects(rs, null, conn, myex);
                continue;
            }
            this.closeSQLObjects(rs, null, conn, myex);
            break;
        }
        return tableNames;
    }

    public abstract void closeSQLObjects(ResultSet var1, Statement var2, Connection var3, Throwable var4) throws BrokerException;

    public static SQLException wrapSQLException(String msg, SQLException e) {
        MQSQLException e2 = new MQSQLException(msg + ": " + e.getMessage() + "[" + e.getSQLState() + ", " + e.getErrorCode() + "]", e.getSQLState(), e.getErrorCode());
        e2.initCause(e);
        e2.setNextException(e);
        return e2;
    }

    public static IOException wrapIOException(String msg, IOException e) {
        IOException e2 = new IOException(msg + ": " + e.getMessage());
        e2.initCause(e);
        return e2;
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String sql, int autoGeneratedKeys) throws SQLException {
        return conn.prepareStatement(sql, autoGeneratedKeys);
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String sql, String[] columnNames) throws SQLException {
        return conn.prepareStatement(sql, columnNames);
    }

    public static boolean executeStatement(Statement stmt, String sql) throws SQLException {
        return stmt.execute(sql);
    }

    public static int executeUpdateStatement(Statement stmt, String sql) throws SQLException {
        return stmt.executeUpdate(sql);
    }

    public static ResultSet executeQueryStatement(Statement stmt, String sql) throws SQLException {
        return stmt.executeQuery(sql);
    }

    private void initDriverManager() throws BrokerException {
        if (this.loginTimeout != null) {
            try {
                DriverManager.setLoginTimeout(this.loginTimeout);
            }
            catch (Exception e) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4448", this.driver, e.toString()));
            }
        }
    }

    private void initDataSource(Class dsClass, Object dsObject) throws BrokerException {
        String propertyPrefix;
        List list;
        if (this.loginTimeout != null && dsObject != null) {
            try {
                ((CommonDataSource)dsObject).setLoginTimeout(this.loginTimeout);
            }
            catch (Exception e) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4448", this.driver, e.toString()));
            }
        }
        if ((list = this.config.getPropertyNames(propertyPrefix = this.vendorPropPrefix + ".property.")).size() == 0 && Store.getDEBUG()) {
            this.logger.log(4, "DataSource properties not specified!");
        }
        Method[] methods = dsClass.getMethods();
        Object[] arglist = new Object[1];
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            String errorMsg;
            Exception error;
            block17: {
                error = null;
                errorMsg = null;
                String propName = (String)itr.next();
                String propValue = this.config.getProperty(propName).trim();
                if (propValue.length() > 0) {
                    String prop = propName.substring(propertyPrefix.length(), propName.length());
                    if (prop.equalsIgnoreCase("url") || prop.equalsIgnoreCase("serverList")) {
                        this.openDBUrl = propValue;
                    } else {
                        this.logger.log(64, propName + "=" + propValue);
                    }
                    String methodName = ("set" + prop).toLowerCase();
                    Method method = null;
                    Class<?> paramType = null;
                    for (Method m : methods) {
                        Class<?>[] paramTypes = m.getParameterTypes();
                        if (!methodName.equals(m.getName().toLowerCase()) || paramTypes.length != 1) continue;
                        method = m;
                        paramType = paramTypes[0];
                        break;
                    }
                    if (method != null) {
                        try {
                            if (paramType.equals(Boolean.TYPE)) {
                                arglist[0] = Boolean.valueOf(propValue);
                                method.invoke(dsObject, arglist);
                                break block17;
                            }
                            if (paramType.equals(Integer.TYPE)) {
                                arglist[0] = Integer.valueOf(propValue);
                                method.invoke(dsObject, arglist);
                                break block17;
                            }
                            if (paramType.equals(String.class)) {
                                arglist[0] = propValue;
                                method.invoke(dsObject, arglist);
                                break block17;
                            }
                            errorMsg = "Invalid DataSource Property: " + propName + ", value: " + propValue;
                        }
                        catch (Exception e) {
                            error = e;
                            errorMsg = "Unable to initialize DataSource Property: " + propName + ", value: " + propValue;
                        }
                    } else {
                        errorMsg = "Invalid DataSource Property: " + propName + ", value: " + propValue;
                    }
                } else {
                    errorMsg = "Invalid DataSource Property: " + propName + ", value: " + propValue;
                }
            }
            if (errorMsg == null) continue;
            this.logger.log(32, errorMsg, error);
        }
    }

    protected void loadTableSchema() throws BrokerException {
        List list = this.config.getPropertyNames(this.tablePropPrefix);
        if (list.size() == 0) {
            throw new BrokerException("Table definition not found for " + this.vendor);
        }
        Collections.sort(list);
        Properties vars = new Properties();
        Object key = this.vendorPropPrefix + ".tableoption";
        String value = this.config.getProperty((String)key, "").trim();
        if (this.isMysql && value.toUpperCase().matches(".*ENGINE\\s*=\\s*MYISAM.*")) {
            String emsg = Globals.getBrokerResources().getKString("B4293", value, (String)key + "=" + value);
            throw new BrokerException(emsg);
        }
        vars.setProperty(TABLEOPTION_NAME_VARIABLE, value);
        if (!value.equals("")) {
            this.logger.log(64, (String)key + "=" + value);
        }
        ListIterator itr = list.listIterator();
        while (itr.hasNext()) {
            TableSchema schema;
            String sql;
            String tname;
            int n;
            key = ((String)itr.next()).trim();
            value = this.config.getProperty((String)key).trim();
            int i = ((String)key).indexOf(".index.");
            if (i > 0) {
                n = ((String)key).indexOf(".table.");
                tname = ((String)key).substring(n + 7, i) + this.tableSuffix;
                String iname = tname + ((String)key).substring(i + 7);
                vars.setProperty(TABLE_NAME_VARIABLE, tname);
                vars.setProperty(INDEX_NAME_VARIABLE, iname);
                String sql2 = StringUtil.expandVariables(value, vars);
                TableSchema schema2 = (TableSchema)this.tableSchemas.get(tname);
                if (schema2 == null) continue;
                schema2.addIndex(iname, sql2);
                continue;
            }
            i = ((String)key).indexOf(".aftercreate");
            if (i > 0) {
                n = ((String)key).indexOf(".table.");
                tname = ((String)key).substring(n + 7, i) + this.tableSuffix;
                vars.setProperty(TABLE_NAME_VARIABLE, tname);
                sql = StringUtil.expandVariables(value, vars);
                schema = (TableSchema)this.tableSchemas.get(tname);
                if (schema == null) continue;
                schema.setAfterCreateSQL(sql);
                continue;
            }
            i = ((String)key).indexOf(".afterdrop");
            if (i > 0) {
                n = ((String)key).indexOf(".table.");
                tname = ((String)key).substring(n + 7, i) + this.tableSuffix;
                vars.setProperty(TABLE_NAME_VARIABLE, tname);
                sql = StringUtil.expandVariables(value, vars);
                schema = (TableSchema)this.tableSchemas.get(tname);
                if (schema == null) continue;
                schema.setAfterDropSQL(sql);
                continue;
            }
            n = ((String)key).lastIndexOf(46);
            tname = ((String)key).substring(n + 1) + this.tableSuffix;
            vars.setProperty(TABLE_NAME_VARIABLE, tname);
            sql = StringUtil.expandVariables(value, vars);
            schema = new TableSchema(tname, sql);
            this.tableSchemas.put(tname, schema);
        }
        this.checkTables();
    }

    private void checkTables() throws BrokerException {
        Iterator itr = this.allDAOIterator();
        while (itr.hasNext()) {
            BaseDAO dao = (BaseDAO)itr.next();
            String tname = dao.getTableName();
            TableSchema schema = (TableSchema)this.tableSchemas.get(tname);
            if (schema == null || schema.tableSQL.length() == 0) {
                throw new BrokerException(this.br.getKString("B3127", tname, this.getJDBCPropPrefix() + "." + tname));
            }
            if (!Store.getDEBUG()) continue;
            this.logger.log(4, tname + ": '" + schema.tableSQL + "'");
        }
    }

    private String getPassword() {
        String fallbackProp;
        String JDBC_PROP_PREFIX = this.getJDBCPropPrefix();
        this.passwordProp = this.vendorPropPrefix + FALLBACK_PWD_PROP_SUFFIX;
        String dbpw = this.config.getProperty(this.passwordProp);
        if (dbpw == null && (dbpw = this.config.getProperty(JDBC_PROP_PREFIX + FALLBACK_PWD_PROP_SUFFIX)) != null) {
            this.passwordProp = JDBC_PROP_PREFIX + FALLBACK_PWD_PROP_SUFFIX;
        }
        this.needPasswordProp = this.vendorPropPrefix + ".needpassword";
        if (this.config.getProperty(this.needPasswordProp) == null && this.config.getProperty(fallbackProp = JDBC_PROP_PREFIX + ".needpassword") != null) {
            this.needPasswordProp = fallbackProp;
        }
        boolean needPassword = this.config.getBooleanProperty(this.needPasswordProp, false);
        if (dbpw == null && needPassword) {
            int retry = 0;
            Password pw = new Password();
            if (pw.echoPassword()) {
                System.err.println(Globals.getBrokerResources().getString("B2242"));
            }
            while ((dbpw == null || dbpw.trim().equals("")) && retry < 5) {
                System.err.print(this.br.getString("B0039", this.openDBUrl));
                System.err.flush();
                dbpw = pw.getPassword();
                ++retry;
            }
        }
        return dbpw;
    }

    public void lockTables(Connection conn, boolean doLock) throws BrokerException {
        this.lockTables(conn, doLock, null);
    }

    public void lockTables(Connection conn, boolean doLock, Object extra) throws BrokerException {
        LockFile lockFile = LockFile.getCurrentLockFile();
        String lockID = null;
        if (lockFile != null) {
            lockID = lockFile.getInstance() + ":" + lockFile.getHost() + ":" + lockFile.getPort();
        } else {
            String hostName;
            MQAddress mqaddr = Globals.getMQAddress();
            String string = hostName = mqaddr == null ? null : mqaddr.getHostName();
            if (hostName == null) {
                try {
                    InetAddress ia = InetAddress.getLocalHost();
                    hostName = MQAddress.getMQAddress(ia.getCanonicalHostName(), 0).getHostName();
                }
                catch (UnknownHostException e) {
                    hostName = "";
                    Globals.getLogger().log(32, "B3152", e);
                }
                catch (Exception e) {
                    throw new BrokerException(e.getMessage(), e);
                }
            }
            lockID = Globals.getConfigName() + ":" + hostName + ":imqdbmgr";
        }
        String currLck = this.getCurrentTableLock(conn, doLock);
        boolean doUpdate = false;
        String newLockID = null;
        String oldLockID = null;
        TableLock tableLock = new TableLock(currLck, this.getTableLockTableName());
        if (tableLock.isNull) {
            if (doLock) {
                doUpdate = true;
                newLockID = lockID;
            }
        } else if (CommDBManager.isOurLock(lockFile, tableLock)) {
            if (!doLock) {
                doUpdate = true;
                oldLockID = tableLock.lockstr;
            }
        } else if (CommDBManager.validLock(tableLock)) {
            if (!doLock && tableLock.port == 0) {
                doUpdate = true;
                oldLockID = tableLock.lockstr;
            } else {
                this.throwTableLockedException(tableLock);
            }
        } else if (doLock) {
            doUpdate = true;
            newLockID = lockID;
            oldLockID = tableLock.lockstr;
        } else {
            doUpdate = true;
            oldLockID = tableLock.lockstr;
        }
        if (doUpdate) {
            this.updateTableLock(conn, newLockID, oldLockID, extra);
        }
    }

    protected abstract String getTableLockTableName() throws BrokerException;

    protected abstract String getCurrentTableLock(Connection var1, boolean var2) throws BrokerException;

    protected abstract void updateTableLock(Connection var1, String var2, String var3, Object var4) throws BrokerException;

    public abstract void throwTableLockedException(String var1) throws BrokerException;

    protected abstract void throwTableLockedException(TableLock var1) throws BrokerException;

    private static boolean isOurLock(LockFile lf, TableLock lock) {
        if (lf != null) {
            return lf.getPort() == lock.port && LockFile.equivalentHostNames(lf.getHost(), lock.host, false) && lf.getInstance().equals(lock.instance);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validLock(TableLock lock) {
        if (lock.port == 0) {
            return true;
        }
        Socket s = null;
        try {
            s = new Socket(InetAddress.getByName(lock.host), lock.port);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Class GET_TRANSIENT_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTransientException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class GET_RECOVERABLE_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLRecoverableException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class GET_NONTRANSIENT_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLNonTransientException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class GET_TRANSIENT_CONNECTION_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTransientConnectionException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class GET_TRANSACTION_ROLLBACK_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTransactionRollbackException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class GET_TIMEOUT_SQLEX_CLASS() {
        try {
            return Class.forName("java.sql.SQLTimeoutException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static class TableLock {
        public String host;
        public int port = 0;
        String lockstr;
        String instance;
        String portstr;
        boolean isNull = false;

        public TableLock(String str, String tableName) {
            this.lockstr = str;
            if (this.lockstr == null || this.lockstr.length() == 0) {
                this.isNull = true;
            } else {
                StringTokenizer st = new StringTokenizer(this.lockstr, " :\t\n\r\f");
                try {
                    this.instance = st.nextToken();
                    this.host = st.nextToken();
                    this.portstr = st.nextToken();
                    try {
                        this.port = Integer.parseInt(this.portstr);
                    }
                    catch (NumberFormatException e) {
                        this.port = 0;
                    }
                }
                catch (NoSuchElementException e) {
                    Globals.getLogger().log(16, "B2087", (Object)this.lockstr, tableName);
                    this.lockstr = null;
                    this.isNull = true;
                }
            }
        }
    }
}

