/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class MessageAckHandler
extends GPacketHandler {
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG_CLUSTER_TXN;
    private static boolean DEBUG = DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG;
    private FaultInjection fi = FaultInjection.getInjection();
    private HashMap fiackCounts = new HashMap();

    public MessageAckHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == 3) {
            this.handleMessageAck(cb, sender, pkt);
        } else if (pkt.getType() == 4) {
            this.handleMessageAckReply(sender, pkt);
        } else {
            this.logger.log(16, "B3100", (Object)("Cannot handle this packet :" + pkt.toLongString()));
        }
    }

    public void handleMessageAck(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterMessageAckInfo cai = ClusterMessageAckInfo.newInstance(pkt, this.c);
        int ackType = cai.getAckType();
        Long txnID = cai.getTransactionID();
        if (this.fi.FAULT_INJECTION) {
            ClusterMessageAckInfo.CHECKFAULT(this.fiackCounts, ackType, txnID, "msg.remote_ack.home.p.", "1");
        }
        UID ssid = cai.getMessageStoreSessionUID();
        int cnt = 1;
        if (cai.getCount() != null) {
            cnt = cai.getCount();
        }
        SysMessageID[] sysids = new SysMessageID[cnt];
        ConsumerUID[] cuids = new ConsumerUID[cnt];
        if (cnt > 0) {
            cai.initPayloadRead();
            for (int i = 0; i < cnt; ++i) {
                try {
                    sysids[i] = cai.readPayloadSysMessageID();
                    cuids[i] = cai.readPayloadConsumerUID();
                    continue;
                }
                catch (Exception e) {
                    this.logger.logStack(32, this.br.getKString("B3189", pkt.toString(), sender), (Throwable)e);
                    this.sendReply(sender, cai, 500, e.getMessage(), null, null, null);
                    return;
                }
            }
        }
        if (DEBUG) {
            this.logger.log(1, "MessageBus: Received message ack : " + cai.toString(sysids, cuids));
        }
        if (ssid != null != Globals.getHAEnabled()) {
            this.logger.log(32, "B3100", (Object)("HA mode not match for message ack " + cai.toString(sysids, cuids)));
            this.sendReply(sender, cai, 500, "message HA mode not match", null, sysids, cuids);
            return;
        }
        if (this.p.isTakeoverTarget(this.selfAddress)) {
            this.logger.log(32, this.br.getKString("B3191", cai.toString(sysids, cuids), this.selfAddress));
            this.sendReply(sender, cai, 500, this.br.getKString("B4244", cai.toString(sysids, cuids), this.selfAddress), null, sysids, cuids);
            return;
        }
        try {
            if (txnID != null) {
                BrokerAddress from = sender;
                UID ss = cai.getTransactionStoreSessionUID();
                if (ss != null) {
                    from = (BrokerAddress)sender.clone();
                    from.setStoreSessionUID(ss);
                }
                cb.processRemoteAck2P(sysids, cuids, ackType, cai.getOptionalProps(), txnID, from);
            } else {
                if (sysids.length > 1) {
                    throw new BrokerException("Internal Error: Unexpected remote ack count " + sysids.length);
                }
                cb.processRemoteAck(sysids[0], cuids[0], ackType, cai.getOptionalProps());
            }
            if (this.fi.FAULT_INJECTION) {
                ClusterMessageAckInfo.CHECKFAULT(this.fiackCounts, ackType, txnID, "msg.remote_ack.home.p.", "2");
            }
            this.sendReply(sender, cai, 200, null, null, sysids, cuids);
            if (this.fi.FAULT_INJECTION) {
                ClusterMessageAckInfo.CHECKFAULT(this.fiackCounts, ackType, txnID, "msg.remote_ack.home.p.", "3");
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                this.logger.logStack(16, this.br.getKString("B2136", cai.toString(sysids, cuids), sender), (Throwable)e);
            } else {
                this.logger.log(16, this.br.getKString("B2136", cai.toString(sysids, cuids), sender) + ": " + e.getMessage());
            }
            if (e instanceof BrokerException) {
                this.sendReply(sender, cai, (BrokerException)e, sysids, cuids);
            }
            this.sendReply(sender, cai, 500, e.getMessage(), null, sysids, cuids);
        }
    }

    private void sendReply(BrokerAddress sender, ClusterMessageAckInfo cai, BrokerException e, SysMessageID[] sysids, ConsumerUID[] cuids) {
        if (!(e instanceof AckEntryNotFoundException)) {
            this.sendReply(sender, cai, e.getStatusCode(), e.getMessage(), null, sysids, cuids);
            return;
        }
        AckEntryNotFoundException aee = (AckEntryNotFoundException)e;
        this.sendReply(sender, cai, e.getStatusCode(), e.getMessage(), aee.getAckEntries(), sysids, cuids);
    }

    private void sendReply(BrokerAddress sender, ClusterMessageAckInfo cai, int status, String reason, ArrayList[] aes, SysMessageID[] sysids, ConsumerUID[] cuids) {
        if (cai.needReply()) {
            try {
                this.c.unicast(sender, cai.getReplyGPacket(status, reason, aes));
            }
            catch (IOException e) {
                Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(4), sender, cai.toString(sysids, cuids)};
                this.logger.logStack(32, this.br.getKString("B3192", (Object)args), (Throwable)e);
            }
        }
    }

    public void handleMessageAckReply(BrokerAddress sender, GPacket pkt) {
        this.logger.log(4, "MessageBus: Received G_MESSAGE_ACK_REPLY (" + ClusterMessageAckInfo.getAckAckType(pkt) + ")  from " + sender + " : STATUS = " + ClusterMessageAckInfo.getAckAckStatus(pkt));
        this.p.receivedMessageAckReply(sender, pkt);
    }
}

