/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.Local;
import jakarta.ejb.LocalBean;
import jakarta.ejb.LocalHome;
import jakarta.ejb.Remote;
import jakarta.ejb.RemoteHome;
import jakarta.ejb.TimedObject;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.jws.WebService;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.context.AnnotationContext;
import org.glassfish.ejb.deployment.descriptor.DummyEjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.AnnotationTypesProvider;

public abstract class AbstractEjbHandler
extends AbstractHandler {
    private AnnotationTypesProvider provider;
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractEjbHandler.class);

    public AbstractEjbHandler() {
        ServiceLocator h = Globals.getDefaultHabitat();
        if (h != null) {
            this.provider = (AnnotationTypesProvider)h.getService(AnnotationTypesProvider.class, "EJB", new Annotation[0]);
        }
    }

    protected abstract String getAnnotatedName(Annotation var1);

    protected abstract boolean isValidEjbDescriptor(EjbDescriptor var1, Annotation var2);

    protected abstract EjbDescriptor createEjbDescriptor(String var1, AnnotationInfo var2) throws AnnotationProcessorException;

    protected abstract HandlerProcessingResult setEjbDescriptorInfo(EjbDescriptor var1, AnnotationInfo var2) throws AnnotationProcessorException;

    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler;
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        Annotation annotation = ainfo.getAnnotation();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("@ process ejb annotation " + String.valueOf(annotation) + " in " + String.valueOf(ejbClass));
        }
        if ((aeHandler = ainfo.getProcessingContext().getHandler()) != null && aeHandler instanceof EjbContext) {
            EjbContext context = (EjbContext)aeHandler;
            EjbDescriptor desc = (EjbDescriptor)context.getDescriptor();
            if (this.isValidEjbDescriptor(desc, annotation)) {
                return this.getDefaultProcessedResult();
            }
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.notcompsuperclass", "The annotation symbol defined in super-class is not compatible with {0} ejb {1}.", new Object[]{desc.getType(), desc.getName()}));
            return this.getDefaultFailedResult();
        }
        if (aeHandler == null || !(aeHandler instanceof EjbBundleContext)) {
            return this.getInvalidAnnotatedElementHandlerResult(ainfo.getProcessingContext().getHandler(), ainfo);
        }
        EjbBundleContext ctx = (EjbBundleContext)aeHandler;
        logger.log(Level.FINE, "My context is {0}", ctx);
        String elementName = this.getAnnotatedName(annotation);
        if (elementName.isEmpty()) {
            elementName = ejbClass.getSimpleName();
        }
        EjbBundleDescriptorImpl currentBundle = (EjbBundleDescriptorImpl)ctx.getDescriptor();
        EjbDescriptor ejbDesc = null;
        try {
            ejbDesc = currentBundle.getEjbByName(elementName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (ejbDesc != null && !(ejbDesc instanceof DummyEjbDescriptor)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Overriding rules apply for " + ejbClass.getName());
            }
            if (!this.isValidEjbDescriptor(ejbDesc, annotation)) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.wrongejbtype", "Wrong annotation symbol for ejb {0}", new Object[]{ejbDesc}));
                return this.getDefaultFailedResult();
            }
            String descriptorEjbClass = ejbDesc.getEjbClassName();
            if (descriptorEjbClass == null) {
                ejbDesc.setEjbClassName(ejbClass.getName());
                ejbDesc.applyDefaultClassToLifecycleMethods();
            } else if (!descriptorEjbClass.equals(ejbClass.getName())) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.ejbclsmismatch", "", new Object[]{descriptorEjbClass, elementName, ejbClass.getName()}));
                return this.getDefaultFailedResult();
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating a new descriptor for " + ejbClass.getName());
            }
            EjbDescriptor dummyEjbDesc = ejbDesc;
            ejbDesc = this.createEjbDescriptor(elementName, ainfo);
            if (dummyEjbDesc != null) {
                currentBundle.removeEjb((com.sun.enterprise.deployment.EjbDescriptor)dummyEjbDesc);
                ejbDesc.copyEjbDescriptor(dummyEjbDesc);
                ejbDesc.setEjbClassName(ejbClass.getName());
            }
            currentBundle.addEjb((com.sun.enterprise.deployment.EjbDescriptor)ejbDesc);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("New " + this.getAnnotationType().getName() + " bean " + elementName);
            }
        }
        com.sun.enterprise.deployment.EjbDescriptor[] ejbDescs = currentBundle.getEjbByClassName(ejbClass.getName());
        HandlerProcessingResult procResult = null;
        for (com.sun.enterprise.deployment.EjbDescriptor ejb : ejbDescs) {
            procResult = this.setEjbDescriptorInfo((EjbDescriptor)ejb, ainfo);
            this.doTimedObjectProcessing(ejbClass, (EjbDescriptor)ejb);
        }
        Object annContext = ejbDescs.length == 1 ? new EjbContext((com.sun.enterprise.deployment.EjbDescriptor)ejbDesc, ejbClass) : new EjbsContext(ejbDescs, ejbClass);
        ctx.getProcessingContext().pushHandler((AnnotationContext)annContext);
        return procResult;
    }

    private void doTimedObjectProcessing(Class ejbClass, EjbDescriptor ejbDesc) {
        MethodDescriptor timeoutMethodDesc = null;
        block0: for (Class nextClass = ejbClass; nextClass != Object.class && nextClass != null && timeoutMethodDesc == null; nextClass = nextClass.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = nextClass.getDeclaredMethods()) {
                if (m.getAnnotation(Timeout.class) == null) continue;
                timeoutMethodDesc = new MethodDescriptor(m, "Timer");
                continue block0;
            }
        }
        if (timeoutMethodDesc == null && TimedObject.class.isAssignableFrom(ejbClass)) {
            timeoutMethodDesc = new MethodDescriptor("ejbTimeout", "@Timeout method", new String[]{Timer.class.getName()}, "Timer");
        }
        if (timeoutMethodDesc != null) {
            ejbDesc.setEjbTimeoutMethod(timeoutMethodDesc);
        }
    }

    protected HandlerProcessingResult setBusinessAndHomeInterfaces(EjbDescriptor ejbDesc, AnnotationInfo ainfo) throws AnnotationProcessorException {
        LocalHome localHome;
        RemoteHome remoteHomeAnn;
        Local localBusAnn;
        HashSet<Class> localBusIntfs = new HashSet<Class>();
        HashSet<Class> remoteBusIntfs = new HashSet<Class>();
        HashSet<Class> clientInterfaces = new HashSet<Class>();
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        Remote remoteBusAnn = ejbClass.getAnnotation(Remote.class);
        boolean emptyRemoteBusAnn = false;
        if (remoteBusAnn != null) {
            for (Class next : remoteBusAnn.value()) {
                if (next.getAnnotation(Local.class) != null) {
                    AnnotationProcessorException fatalException = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidbusinessinterface", "The interface {0} cannot be both a local and a remote business interface.", new Object[]{next.getName()}));
                    fatalException.setFatal(true);
                    throw fatalException;
                }
                clientInterfaces.add(next);
                remoteBusIntfs.add(next);
            }
            emptyRemoteBusAnn = remoteBusIntfs.isEmpty();
        }
        if ((localBusAnn = ejbClass.getAnnotation(Local.class)) != null) {
            for (Class next : localBusAnn.value()) {
                if (next.getAnnotation(Remote.class) != null) {
                    AnnotationProcessorException fatalException = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidbusinessinterface", "The interface {0} cannot be both a local and a remote business interface.", new Object[]{next.getName()}));
                    fatalException.setFatal(true);
                    throw fatalException;
                }
                clientInterfaces.add(next);
                localBusIntfs.add(next);
            }
        }
        ArrayList imlementingInterfaces = new ArrayList();
        ArrayList implementedDesignatedInterfaces = new ArrayList();
        for (Class<?> clazz : ejbClass.getInterfaces()) {
            if (this.excludedFromImplementsClause(clazz)) continue;
            if (clazz.getAnnotation(Local.class) != null || clazz.getAnnotation(Remote.class) != null) {
                implementedDesignatedInterfaces.add(clazz);
            }
            imlementingInterfaces.add(clazz);
        }
        LocalBean localBeanAnn = ejbClass.getAnnotation(LocalBean.class);
        if (localBeanAnn != null) {
            ejbDesc.setLocalBean(true);
        }
        int designatedInterfaceCount = remoteBusIntfs.size() + localBusIntfs.size() + ejbDesc.getRemoteBusinessClassNames().size() + ejbDesc.getLocalBusinessClassNames().size() + implementedDesignatedInterfaces.size();
        for (Class clazz : imlementingInterfaces) {
            String nextIntfName = clazz.getName();
            if (remoteBusIntfs.contains(clazz) || localBusIntfs.contains(clazz) || ejbDesc.getRemoteBusinessClassNames().contains(nextIntfName) || ejbDesc.getLocalBusinessClassNames().contains(nextIntfName)) continue;
            if (clazz.getAnnotation(Local.class) != null) {
                clientInterfaces.add(clazz);
                localBusIntfs.add(clazz);
                continue;
            }
            if (clazz.getAnnotation(Remote.class) != null) {
                clientInterfaces.add(clazz);
                remoteBusIntfs.add(clazz);
                continue;
            }
            if (designatedInterfaceCount != 0 || ejbDesc.isLocalBean()) continue;
            if (emptyRemoteBusAnn) {
                remoteBusIntfs.add(clazz);
            } else {
                localBusIntfs.add(clazz);
            }
            clientInterfaces.add(clazz);
        }
        for (Class clazz : clientInterfaces) {
            if (!remoteBusIntfs.contains(clazz) || !localBusIntfs.contains(clazz)) continue;
            AnnotationProcessorException fatalException = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidbusinessinterface", "The interface {0} cannot be both a local and a remote business interface.", new Object[]{clazz.getName()}));
            fatalException.setFatal(true);
            throw fatalException;
        }
        if (localBusIntfs.size() > 0) {
            for (Class clazz : localBusIntfs) {
                ejbDesc.addLocalBusinessClassName(clazz.getName());
            }
        }
        if (remoteBusIntfs.size() > 0) {
            for (Class clazz : remoteBusIntfs) {
                ejbDesc.addRemoteBusinessClassName(clazz.getName());
            }
        }
        if ((remoteHomeAnn = ejbClass.getAnnotation(RemoteHome.class)) != null) {
            Class clazz = remoteHomeAnn.value();
            Class remoteIntf = this.getComponentIntfFromHome(clazz);
            if (EJBHome.class.isAssignableFrom(clazz) && remoteIntf != null) {
                clientInterfaces.add(clazz);
                ejbDesc.setHomeClassName(clazz.getName());
                ejbDesc.setRemoteClassName(remoteIntf.getName());
            } else {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidremotehome", "Encountered invalid @RemoteHome interface {0}.", new Object[]{clazz}));
                return this.getDefaultFailedResult();
            }
        }
        if ((localHome = ejbClass.getAnnotation(LocalHome.class)) != null) {
            Class localHome2 = localHome.value();
            Class localIntf = this.getComponentIntfFromHome(localHome2);
            if (EJBLocalHome.class.isAssignableFrom(localHome2) && localIntf != null) {
                clientInterfaces.add(localHome2);
                ejbDesc.setLocalHomeClassName(localHome2.getName());
                ejbDesc.setLocalClassName(localIntf.getName());
            } else {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidlocalhome", "Encountered invalid @LocalHome interface {0}.", new Object[]{localHome2}));
                return this.getDefaultFailedResult();
            }
        }
        boolean canDoWebServiceAnnCheck = false;
        try {
            canDoWebServiceAnnCheck = this.provider.getType("jakarta.jws.WebService") != null;
        }
        catch (Exception e) {
            this.log(Level.FINE, ainfo, e.getMessage());
        }
        if (!(ejbDesc.isLocalBean() || clientInterfaces.size() != 0 || ejbDesc.hasWebServiceEndpointInterface() || canDoWebServiceAnnCheck && ejbClass.getAnnotation(WebService.class) != null)) {
            ejbDesc.setLocalBean(true);
        }
        if (ejbDesc.isLocalBean()) {
            this.addNoInterfaceLocalBeanClasses(ejbDesc, ejbClass);
        }
        return this.getDefaultProcessedResult();
    }

    private void addNoInterfaceLocalBeanClasses(EjbDescriptor ejbDesc, Class ejbClass) {
        for (Class nextClass = ejbClass; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            ejbDesc.addNoInterfaceLocalBeanClass(nextClass.getName());
        }
    }

    private Class getComponentIntfFromHome(Class homeIntf) {
        Method[] methods;
        Class<?> componentIntf = null;
        for (Method m : methods = homeIntf.getMethods()) {
            if (!m.getName().startsWith("create")) continue;
            componentIntf = m.getReturnType();
            break;
        }
        return componentIntf;
    }

    protected boolean excludedFromImplementsClause(Class intf) {
        return intf == Serializable.class || intf == Externalizable.class || intf.getPackage() != null && intf.getPackage().getName().equals("jakarta.ejb");
    }

    protected void doDescriptionProcessing(String description, EjbDescriptor ejbDescriptor) {
        if (description != null && !description.isEmpty()) {
            ejbDescriptor.setDescription(description);
        }
    }

    protected void doMappedNameProcessing(String mappedName, EjbDescriptor ejbDesc) {
        if (ejbDesc.getMappedName().isEmpty() && !mappedName.isEmpty()) {
            ejbDesc.setMappedName(mappedName);
        }
    }
}

