/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices.client;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.glassfish.epicyro.services.AuthConfigRegistrationWrapper;

public class ClientPipeCloser {
    private Map<ServiceReferenceDescriptor, AuthConfigRegistrationWrapper> svcRefListenerMap = Collections.synchronizedMap(new WeakHashMap());
    private static final ClientPipeCloser INSTANCE = new ClientPipeCloser();

    private ClientPipeCloser() {
    }

    public static ClientPipeCloser getInstance() {
        return INSTANCE;
    }

    public void registerListenerWrapper(ServiceReferenceDescriptor desc, AuthConfigRegistrationWrapper wrapper) {
        this.svcRefListenerMap.put(desc, wrapper);
    }

    public AuthConfigRegistrationWrapper lookupListenerWrapper(ServiceReferenceDescriptor desc) {
        AuthConfigRegistrationWrapper listenerWrapper = this.svcRefListenerMap.get(desc);
        return listenerWrapper;
    }

    public void removeListenerWrapper(AuthConfigRegistrationWrapper wrapper) {
        ServiceReferenceDescriptor entryToRemove = null;
        for (ServiceReferenceDescriptor svc : this.svcRefListenerMap.keySet()) {
            AuthConfigRegistrationWrapper wrp = this.svcRefListenerMap.get(svc);
            if (wrp != wrapper) continue;
            entryToRemove = svc;
            break;
        }
        if (entryToRemove != null) {
            this.svcRefListenerMap.remove(entryToRemove);
        }
    }

    public void cleanupClientPipe(ServiceReferenceDescriptor desc) {
        AuthConfigRegistrationWrapper listenerWrapper = this.svcRefListenerMap.get(desc);
        if (listenerWrapper != null) {
            listenerWrapper.disable();
        }
        this.svcRefListenerMap.remove(desc);
    }
}

