/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.main.jul.record.GlassFishLogRecord;

class LogRecordBuffer {
    private final int capacity;
    private final int maxWait;
    private final ArrayBlockingQueue<GlassFishLogRecord> pendingRecords;

    public LogRecordBuffer(int capacity) {
        this(capacity, 0);
    }

    public LogRecordBuffer(int capacity, int maxWait) {
        this.capacity = capacity;
        this.maxWait = maxWait;
        this.pendingRecords = new ArrayBlockingQueue(capacity);
    }

    public boolean isEmpty() {
        return this.pendingRecords.isEmpty();
    }

    public int getSize() {
        return this.pendingRecords.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public GlassFishLogRecord pollOrWait() {
        try {
            return this.pendingRecords.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public GlassFishLogRecord poll() {
        return this.pendingRecords.poll();
    }

    public void add(GlassFishLogRecord record) {
        if (this.maxWait > 0) {
            this.addWithTimeout(record);
        } else {
            this.addWithUnlimitedWaiting(record);
        }
    }

    private void addWithTimeout(GlassFishLogRecord record) {
        try {
            if (this.pendingRecords.offer(record)) {
                return;
            }
            if (this.pendingRecords.offer(record, this.maxWait, TimeUnit.SECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pendingRecords.clear();
        this.pendingRecords.offer(new GlassFishLogRecord(Level.SEVERE, String.valueOf(this) + ": The buffer was forcibly cleared after " + this.maxWait + " s timeout for adding another log record. Log records were lost. It might be caused by a recursive deadlock, you can increase the capacity or the timeout to avoid this.", false));
    }

    private void addWithUnlimitedWaiting(GlassFishLogRecord record) {
        if (this.pendingRecords.offer(record)) {
            return;
        }
        try {
            Thread.yield();
            this.pendingRecords.put(record);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getSize() + "/" + this.getCapacity() + "]";
    }
}

