/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.artifact.proxy.DeciderProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.SplitControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.Property;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.logging.Logger;

public class DecisionControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private RuntimeJobExecution jobExecution;
    private Decision decision;
    private StepExecution[] previousStepExecutions = null;
    private IPersistenceManagerService persistenceService = null;

    public DecisionControllerImpl(RuntimeJobExecution jobExecution, Decision decision) {
        this.jobExecution = jobExecution;
        this.decision = decision;
        this.persistenceService = ServicesManagerImpl.getInstance().getPersistenceManagerService();
    }

    @Override
    public ExecutionStatus execute() {
        DeciderProxy deciderProxy;
        String deciderId = this.decision.getRef();
        List<Property> propList = this.decision.getProperties() == null ? null : this.decision.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecution.getJobContext(), null, propList);
        try {
            deciderProxy = ProxyFactory.createDeciderProxy(deciderId, injectionRef);
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the decider [" + deciderId + "]", e);
        }
        String exitStatus = deciderProxy.decide(this.previousStepExecutions);
        logger.fine("Decider exiting and setting job-level exit status to " + exitStatus);
        this.jobExecution.getJobContext().setExitStatus(exitStatus);
        return new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, exitStatus);
    }

    protected void setPreviousStepExecutions(ExecutionElement previousExecutionElement, IExecutionElementController previousElementController) {
        if (previousExecutionElement != null && previousExecutionElement instanceof Decision) {
            throw new BatchContainerRuntimeException("A decision cannot precede another decision.");
        }
        List<Long> previousStepExecsIds = previousElementController.getLastRunStepExecutions();
        StepExecution[] stepExecArray = new StepExecution[previousStepExecsIds.size()];
        for (int i = 0; i < stepExecArray.length; ++i) {
            StepExecution stepExec;
            stepExecArray[i] = stepExec = this.persistenceService.getStepExecutionByStepExecutionId(previousStepExecsIds.get(i));
        }
        this.previousStepExecutions = stepExecArray;
    }

    @Override
    public void stop() {
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        return null;
    }
}

