/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import org.apache.catalina.connector.RequestFacade;

public class WebSocketFilterWrapper
implements Filter {
    private static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    private final Filter webSocketFilter;

    public WebSocketFilterWrapper(Filter webSocketFilter) {
        this.webSocketFilter = webSocketFilter;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.webSocketFilter.init(filterConfig);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getHeader(SEC_WEBSOCKET_KEY) != null) {
            httpServletRequest = new HttpServletRequestWrapper(httpServletRequest){

                @Override
                public String getRequestURI() {
                    String contextPath;
                    RequestFacade wrappedRequest = (RequestFacade)super.getRequest();
                    String requestURI = wrappedRequest.getRequestURI();
                    if (requestURI.equals(contextPath = wrappedRequest.getContextPath(false)) || requestURI.startsWith(contextPath + "/")) {
                        return requestURI;
                    }
                    return contextPath + requestURI;
                }
            };
        }
        this.webSocketFilter.doFilter(httpServletRequest, response, chain);
    }

    @Override
    public void destroy() {
        this.webSocketFilter.destroy();
    }
}

