/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.util.MetricCounters;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.ConnectionNotification;
import com.sun.messaging.jms.management.server.MQObjectName;
import com.sun.messaging.jms.management.server.ServiceNotification;
import com.sun.messaging.jms.management.server.ServiceState;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ServiceMonitor
extends MQMBeanReadOnly {
    private String service;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] cxnNotificationTypes;
    private static String[] svcNotificationTypes;
    private static MBeanNotificationInfo[] notifs;
    private long numConnectionsOpened = 0L;
    private long numConnectionsRejected = 0L;

    public ServiceMonitor(String service) {
        this.service = service;
    }

    public String getName() {
        return this.service;
    }

    public Integer getState() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        return ServiceUtil.toExternalServiceState(si.state);
    }

    public String getStateLabel() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        return ServiceState.toString(ServiceUtil.toExternalServiceState(si.state));
    }

    public Integer getPort() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        return si.port;
    }

    public Integer getNumActiveThreads() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.threadsActive;
        }
        return -1;
    }

    public Integer getNumConnections() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        return si.nConnections;
    }

    public long getNumConnectionsOpened() {
        return this.numConnectionsOpened;
    }

    public long getNumConnectionsRejected() {
        return this.numConnectionsRejected;
    }

    public Long getNumMsgsIn() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.messagesIn;
        }
        return -1L;
    }

    public Long getNumMsgsOut() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.messagesOut;
        }
        return -1L;
    }

    public Long getMsgBytesIn() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.messageBytesIn;
        }
        return -1L;
    }

    public Long getMsgBytesOut() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.messageBytesOut;
        }
        return -1L;
    }

    public Long getNumPktsIn() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.packetsIn;
        }
        return -1L;
    }

    public Long getNumPktsOut() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.packetsOut;
        }
        return -1L;
    }

    public Long getPktBytesIn() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.packetBytesIn;
        }
        return -1L;
    }

    public Long getPktBytesOut() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metrics = si.metrics;
        if (metrics != null) {
            return metrics.packetBytesOut;
        }
        return -1L;
    }

    public Integer getNumConsumers() {
        List consumerIDs = ServiceUtil.getConsumerIDs(this.service);
        if (consumerIDs == null) {
            return 0;
        }
        return consumerIDs.size();
    }

    public String[] getConsumerIDs() throws MBeanException {
        List consumerIDs = ServiceUtil.getConsumerIDs(this.service);
        if (consumerIDs == null || consumerIDs.size() == 0) {
            return null;
        }
        String[] ids = new String[consumerIDs.size()];
        Iterator iter = consumerIDs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ConsumerUID cid = (ConsumerUID)iter.next();
            long conID = cid.longValue();
            try {
                String id;
                ids[i] = id = Long.toString(conID);
            }
            catch (Exception ex) {
                this.handleOperationException("getConsumerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public Integer getNumProducers() {
        List producerIDs = ServiceUtil.getProducerIDs(this.service);
        if (producerIDs == null) {
            return 0;
        }
        return producerIDs.size();
    }

    public String[] getProducerIDs() throws MBeanException {
        List producerIDs = ServiceUtil.getProducerIDs(this.service);
        if (producerIDs == null || producerIDs.size() == 0) {
            return null;
        }
        String[] ids = new String[producerIDs.size()];
        Iterator iter = producerIDs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ProducerUID pid = (ProducerUID)iter.next();
            long prdID = pid.longValue();
            try {
                String id;
                ids[i] = id = Long.toString(prdID);
            }
            catch (Exception ex) {
                this.handleOperationException("getProducerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public ObjectName[] getConnections() throws MBeanException {
        List connections = ConnectionUtil.getConnectionInfoList(this.service);
        if (connections.size() == 0) {
            return null;
        }
        ObjectName[] oNames = new ObjectName[connections.size()];
        Iterator itr = connections.iterator();
        int i = 0;
        while (itr.hasNext()) {
            ConnectionInfo cxnInfo = (ConnectionInfo)itr.next();
            try {
                ObjectName o = MQObjectName.createConnectionMonitor(Long.toString(cxnInfo.uuid));
                oNames[i++] = o;
            }
            catch (Exception e) {
                this.handleOperationException("getConnections", e);
            }
        }
        return oNames;
    }

    public void resetMetrics() {
        this.numConnectionsOpened = 0L;
        this.numConnectionsRejected = 0L;
    }

    @Override
    public String getMBeanName() {
        return "ServiceMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1219");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyConnectionClose(long id) {
        ConnectionNotification n = new ConnectionNotification("mq.connection.close", this, this.sequenceNumber++);
        n.setConnectionID(Long.toString(id));
        this.sendNotification(n);
    }

    public void notifyConnectionOpen(long id) {
        ConnectionNotification n = new ConnectionNotification("mq.connection.open", this, this.sequenceNumber++);
        n.setConnectionID(Long.toString(id));
        this.sendNotification(n);
        ++this.numConnectionsOpened;
    }

    public void notifyConnectionReject(String serviceName, String userName, String remoteHostString) {
        ConnectionNotification cn = new ConnectionNotification("mq.connection.reject", this, this.sequenceNumber++);
        cn.setServiceName(serviceName);
        cn.setUserName(userName);
        cn.setRemoteHost(remoteHostString);
        this.sendNotification(cn);
        ++this.numConnectionsRejected;
    }

    public void notifyServicePause() {
        ServiceNotification n = new ServiceNotification("mq.service.pause", this, this.sequenceNumber++);
        n.setServiceName(this.getName());
        this.sendNotification(n);
    }

    public void notifyServiceResume() {
        ServiceNotification n = new ServiceNotification("mq.service.resume", this, this.sequenceNumber++);
        n.setServiceName(this.getName());
        this.sendNotification(n);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[18];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MsgBytesIn", Long.class.getName(), mbr.getString("MB1198"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MsgBytesOut", Long.class.getName(), mbr.getString("MB1199"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1195"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("NumActiveThreads", Integer.class.getName(), mbr.getString("MB1200"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("NumConnections", Integer.class.getName(), mbr.getString("MB1201"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("NumConnectionsOpened", Long.class.getName(), mbr.getString("MB1202"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("NumConnectionsRejected", Long.class.getName(), mbr.getString("MB1203"), true, false, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1204"), true, false, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("NumMsgsIn", Long.class.getName(), mbr.getString("MB1205"), true, false, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("NumMsgsOut", Long.class.getName(), mbr.getString("MB1206"), true, false, false);
        mBeanAttributeInfoArray[10] = new MBeanAttributeInfo("NumPktsIn", Long.class.getName(), mbr.getString("MB1207"), true, false, false);
        mBeanAttributeInfoArray[11] = new MBeanAttributeInfo("NumPktsOut", Long.class.getName(), mbr.getString("MB1208"), true, false, false);
        mBeanAttributeInfoArray[12] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1209"), true, false, false);
        mBeanAttributeInfoArray[13] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1221"), true, false, false);
        mBeanAttributeInfoArray[14] = new MBeanAttributeInfo("PktBytesIn", Long.class.getName(), mbr.getString("MB1210"), true, false, false);
        mBeanAttributeInfoArray[15] = new MBeanAttributeInfo("PktBytesOut", Long.class.getName(), mbr.getString("MB1211"), true, false, false);
        mBeanAttributeInfoArray[16] = new MBeanAttributeInfo("State", Integer.class.getName(), mbr.getString("MB1212"), true, false, false);
        mBeanAttributeInfoArray[17] = new MBeanAttributeInfo("StateLabel", String.class.getName(), mbr.getString("MB1213"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConnections", mbr.getString("MB1216"), null, ObjectName[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1217"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1218"), null, String[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
        cxnNotificationTypes = new String[]{"mq.connection.open", "mq.connection.close", "mq.connection.reject"};
        svcNotificationTypes = new String[]{"mq.service.pause", "mq.service.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[2];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(cxnNotificationTypes, ConnectionNotification.class.getName(), mbr.getString("MB1067"));
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(svcNotificationTypes, ServiceNotification.class.getName(), mbr.getString("MB1220"));
        notifs = mBeanNotificationInfoArray;
    }
}

