/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.memory.levels;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.memory.levels.Green;

public class Yellow
extends Green {
    protected static final int DEFAULT_GC_ITR = 1000;
    protected int gcIterationCount = 0;

    public Yellow(String name) {
        super(name);
        this.MEMORY_NAME_KEY = "B0022";
        this.gcIterationCount = Globals.getConfig().getIntProperty("imq." + name + ".gcitr", 1000);
    }

    @Override
    public int getMessageCount(long freeMemory, int producers) {
        if (producers >= 0) {
            producers = 1;
        }
        return super.getMessageCount(freeMemory, producers) / producers;
    }

    @Override
    public long getMemory(long freeMemory, int producers) {
        if (producers >= 0) {
            producers = 1;
        }
        return super.getMemory(freeMemory, producers) / (long)producers / 2L;
    }

    @Override
    public int gcCount() {
        return 1;
    }

    @Override
    public int gcIteration() {
        return this.gcIterationCount;
    }

    @Override
    public boolean cleanup(int cnt) {
        super.cleanup(cnt);
        this.logger.log(8, "B1089");
        this.logger.log(4, "Broker is swapping persistent/sent but un-acked  messages");
        Globals.getConnectionManager().cleanupMemory(true);
        return true;
    }

    @Override
    public boolean enter(boolean fromHigher) {
        super.enter(fromHigher);
        if (fromHigher) {
            return false;
        }
        MemoryGlobals.setMEM_FREE_P_ACKED(true);
        return true;
    }

    @Override
    public boolean leave(boolean toHigher) {
        super.leave(toHigher);
        if (toHigher) {
            return false;
        }
        MemoryGlobals.setMEM_FREE_P_ACKED(false);
        return false;
    }
}

