/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.faults.WsrmRequiredException;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.MessageHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import java.util.List;
import java.util.logging.Level;

class DestinationMessageHandler
implements MessageHandler {
    private static final Logger LOGGER = Logger.getLogger(DestinationMessageHandler.class);
    private volatile SequenceManager sequenceManager;

    DestinationMessageHandler(@Nullable SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    void setSequenceManager(SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    public void registerMessage(@NotNull ApplicationMessage inMessage, boolean storeMessage) throws DuplicateMessageRegistrationException, UnknownSequenceException, WsrmRequiredException {
        assert (this.sequenceManager != null);
        assert (inMessage != null);
        String inboundSequenceId = inMessage.getSequenceId();
        if (inboundSequenceId == null) {
            throw new WsrmRequiredException();
        }
        Sequence inboundSequence = this.sequenceManager.getInboundSequence(inboundSequenceId);
        inboundSequence.registerMessage(inMessage, storeMessage);
        inboundSequence.setAckRequestedFlag();
    }

    public void processAcknowledgements(@Nullable AcknowledgementData acknowledgementData) throws UnknownSequenceException {
        this.processAcknowledgements(acknowledgementData, false);
    }

    void processAcknowledgements(@Nullable AcknowledgementData acknowledgementData, boolean doNotSetAckRequestedFlag) throws UnknownSequenceException {
        Sequence outboundSequence;
        List<Sequence.AckRange> acknowledgedRanges;
        assert (this.sequenceManager != null);
        if (acknowledgementData == null) {
            return;
        }
        if (acknowledgementData.getAcknowledgedSequenceId() != null && !(acknowledgedRanges = acknowledgementData.getAcknowledgedRanges()).isEmpty() && !(outboundSequence = this.sequenceManager.getOutboundSequence(acknowledgementData.getAcknowledgedSequenceId())).isClosed()) {
            outboundSequence.acknowledgeMessageNumbers(acknowledgedRanges);
        }
        if (acknowledgementData.getAckReqestedSequenceId() != null && !doNotSetAckRequestedFlag) {
            Sequence inboundSequence = this.sequenceManager.getInboundSequence(acknowledgementData.getAckReqestedSequenceId());
            inboundSequence.setAckRequestedFlag();
        }
    }

    public AcknowledgementData getAcknowledgementData(String inboundSequenceId) throws UnknownSequenceException {
        return this.getAcknowledgementData(inboundSequenceId, false, false);
    }

    AcknowledgementData getAcknowledgementData(String inboundSequenceId, boolean isRespondingToAckRequested, boolean doNotClearAckRequestedFlag) throws UnknownSequenceException {
        Sequence outboundSequence;
        assert (this.sequenceManager != null);
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        Sequence inboundSequence = this.sequenceManager.getInboundSequence(inboundSequenceId);
        if (isRespondingToAckRequested || inboundSequence.isAckRequested() || inboundSequence.isClosed()) {
            ackDataBuilder.acknowledgements(inboundSequence.getId(), inboundSequence.getAcknowledgedMessageNumbers(), inboundSequence.isClosed());
            if (!doNotClearAckRequestedFlag) {
                inboundSequence.clearAckRequestedFlag();
            }
        }
        if ((outboundSequence = this.sequenceManager.getBoundSequence(inboundSequenceId)) != null && outboundSequence.hasUnacknowledgedMessages()) {
            ackDataBuilder.ackReqestedSequenceId(outboundSequence.getId());
            outboundSequence.updateLastAcknowledgementRequestTime();
        }
        return ackDataBuilder.build();
    }

    public void acknowledgeApplicationLayerDelivery(ApplicationMessage inMessage) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        this.sequenceManager.getInboundSequence(inMessage.getSequenceId()).acknowledgeMessageNumber(inMessage.getMessageNumber());
    }

    @Override
    public void putToDeliveryQueue(ApplicationMessage message) throws RxRuntimeException {
        assert (this.sequenceManager != null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Putting a message with number [ %d ] to the delivery queue of a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
        }
        this.sequenceManager.getInboundSequence(message.getSequenceId()).getDeliveryQueue().put(message);
    }
}

