/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.bridge.api.UpdateOpaqueDataCallback;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.transaction.xa.Xid;

public class JDBCTxLogImpl
extends TxLog {
    private JMSBridgeStore _store = null;
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public void setJDBCStore(JMSBridgeStore store) {
        if (store == null) {
            throw new IllegalArgumentException("null JDBC store");
        }
        this._store = store;
    }

    @Override
    public void init(Properties props, boolean reset) throws Exception {
        if (this._store == null) {
            throw new IllegalStateException("JDBC store is null");
        }
        if (this._logger == null) {
            throw new IllegalArgumentException("logger not set");
        }
        this._jmsbridge = props.getProperty("jmsbridge");
        if (this._jmsbridge == null) {
            throw new IllegalArgumentException("Property 'jmsbridge' not set");
        }
        this._tmname = props.getProperty("tmname");
        if (this._tmname == null) {
            throw new IllegalStateException("Property 'tmname' not set");
        }
        super.init(props, reset);
    }

    @Override
    public void logGlobalDecision(LogRecord lr) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: log global decision  " + lr);
        }
        super.checkClosedAndSetInProgress();
        try {
            this._store.storeTMLogRecord(lr.getGlobalXid().toString(), lr.toBytes(), this._jmsbridge, false, this._logger);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logHeuristicBranch(BranchXid bxid, LogRecord lr) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: log branch heuristic decision  " + lr);
        }
        final GlobalXid gxid = lr.getGlobalXid();
        final BranchXid branchXid = bxid;
        final LogRecord newlr = lr;
        super.checkClosedAndSetInProgress();
        try {
            UpdateOpaqueDataCallback callback = new UpdateOpaqueDataCallback(){

                @Override
                public Object update(Object currlr) throws Exception {
                    FilteringObjectInputStream ois = new FilteringObjectInputStream((InputStream)new ByteArrayInputStream((byte[])currlr));
                    LogRecord oldlr = (LogRecord)ois.readObject();
                    if (oldlr == null) {
                        throw new IllegalArgumentException("Unexpected null current log record for " + gxid);
                    }
                    if (!oldlr.getGlobalXid().equals((Xid)((Object)gxid))) {
                        throw new IllegalArgumentException("Unexpected global xid " + oldlr.getGlobalXid() + " from store, expected:" + gxid);
                    }
                    ois.close();
                    if (oldlr.getBranchDecision(branchXid) == newlr.getBranchDecision(branchXid)) {
                        return currlr;
                    }
                    oldlr.setBranchDecision(branchXid, newlr.getBranchDecision(branchXid));
                    return oldlr;
                }
            };
            this._store.updateTMLogRecord(gxid.toString(), lr.toBytes(), this._jmsbridge, callback, true, true, this._logger);
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void reap(String gxid) throws Exception {
        String key = gxid;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: remove global transaction xid " + key);
        }
        super.checkClosedAndSetInProgress();
        try {
            this._store.removeTMLogRecord(key, this._jmsbridge, true, this._logger);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecord getLogRecord(GlobalXid gxid) throws Exception {
        String key = gxid.toString();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: get log record for  xid " + key);
        }
        super.checkClosedAndSetInProgress();
        try {
            byte[] data = this._store.getTMLogRecord(key, this._jmsbridge, this._logger);
            if (data == null) {
                LogRecord logRecord = null;
                return logRecord;
            }
            FilteringObjectInputStream ois = new FilteringObjectInputStream((InputStream)new ByteArrayInputStream(data));
            LogRecord lr = (LogRecord)ois.readObject();
            ois.close();
            LogRecord logRecord = lr;
            return logRecord;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllLogRecords() throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: get all log records");
        }
        ArrayList<LogRecord> list = new ArrayList<LogRecord>();
        super.checkClosedAndSetInProgress();
        try {
            List abytes = this._store.getTMLogRecordsByName(this._jmsbridge, this._logger);
            if (abytes == null) {
                ArrayList<LogRecord> arrayList = list;
                return arrayList;
            }
            byte[] data2 = null;
            for (byte[] data2 : abytes) {
                FilteringObjectInputStream ois = new FilteringObjectInputStream((InputStream)new ByteArrayInputStream(data2));
                LogRecord lr = (LogRecord)ois.readObject();
                ois.close();
                list.add(lr);
            }
            ArrayList<LogRecord> arrayList = list;
            return arrayList;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void close() throws Exception {
        this._logger.log(Level.INFO, _jbr.getString("BSJ1063"));
        super.setClosedAndWait();
        super.close();
    }
}

